/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.bpm.bpmobject.BpmObjectFactory;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.lang.ArrayTypeDescription;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.ComponentLoadingException;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.EnumTypeDescription;
import oracle.bpm.lang.IllegalConversionException;
import oracle.bpm.lang.IllegalTypeException;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.IntervalFormatException;
import oracle.bpm.lang.IteratorTypeDescription;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.JavaEnumTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.Module;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.TimeFormatException;
import oracle.bpm.lang.TransformTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.AbstractPresentationMigrator;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.Argument;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.DynamicRef;
import oracle.bpm.type.Presentation4Migrator;
import oracle.bpm.type.Presentation5Migrator;
import oracle.bpm.type.SourceCode;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeFinder;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.UnknownType;
import oracle.bpm.type.Validation;
import oracle.bpm.type.Variable;
import oracle.bpm.type.impl.TypeDescriptionImpl;
import oracle.bpm.util.Conversion;
import oracle.bpm.util.DefaultValue;
import oracle.bpm.util.Identifier;
import oracle.bpm.util.Locales;
import oracle.bpm.util.StringCache;
import oracle.bpm.util.StringMap;
import oracle.bpm.util.documentation.DocumentationType;
import oracle.bpm.xml.XmlWriter;
import oracle.bpm.xobject.FuegoObjectConstants;
import oracle.bpm.xobject.XObjectFactory;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;
import oracle.bpm.xobject.presentationmodel.XFormValue;
import oracle.bpm.xobject.xml.XFormXMLObject;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class TypeLoader45
implements ContentHandler {
    private String beginCodeLanguage;
    private boolean beginTransformationStage = false;
    private ComponentCatalog catalog;
    private boolean checkStage = false;
    private Argument currentArgument;
    private AttributeTypeDescription currentAttribute;
    private StringBuffer currentBeginCode;
    private List<Validation> currentCheck = new ArrayList<Validation>();
    private StringBuffer currentCode;
    private String currentComponentName;
    private Locale currentDocLanguage;
    private DocumentationType currentDocType;
    private StringBuffer currentDocumentation;
    private Stack<XFormXMLObject> currentElement;
    private StringBuffer currentEndCode;
    private List<Validation> currentEnsure = new ArrayList<Validation>();
    private StringBuffer currentFieldMappingCode;
    private ObjectTypeDescription currentGroup;
    private String currentLanguage;
    private ArrayList<Variable> currentLocalVars;
    private MethodTypeDescription currentMethod;
    private ObjectTypeDescription currentObject;
    private String currentParentName;
    private StringBuffer currentRead;
    private List<Validation> currentRequire = new ArrayList<Validation>();
    private StringBuffer currentResource;
    private String currentResourceKey;
    private String currentResourceLocale;
    private int currentResourceType;
    private StringBuffer currentTemplate;
    private TransformTypeDescription currentTransformation;
    private TransformTypeDescription.FieldMapping currentTransformationFieldMapping;
    private StringBuffer currentWrite;
    private boolean dataModelStage = false;
    private Map<String, String> defaultExpressions = new HashMap<String, String>();
    private DisplayName displayName;
    private boolean documentationStage;
    private String endCodeLanguage;
    private boolean endTransformationStage = false;
    private boolean ensureStage = false;
    private String fieldMappingLanguage;
    private boolean fieldMappingStage = false;
    private String groupName;
    private boolean hasLegacyValidValuesMethods = false;
    private InputSource inputSrc;
    private boolean isGroupElement = false;
    private MethodTypeDescription lastMethod;
    private String maxOcur = "*";
    private Map<String, String> memberProperties = new TreeMap<String, String>();
    private boolean methodStage = false;
    private Map<String, String> objectProperties = new TreeMap<String, String>();
    private ContentHandler parentHandler;
    private XMLReader parentParser;
    private XMLReader parser;
    private boolean parsing;
    private XFormPresentationModel pModel;
    private Map<String, Field> pModelFieldCache = new HashMap<String, Field>();
    private String predefinedType;
    private Map<String, XFormPresentationModel> presentations;
    private boolean presentationStage = false;
    private String readLanguage;
    private boolean readStage = false;
    private boolean remote = false;
    private StringList requiredAttributes = StringList.create();
    private boolean requireStage = false;
    private boolean resourcesStage = false;
    private SourceCodeBuilder sourceCodeBuilder;
    private StringCache stringCache = new StringCache(300);
    private String superclass;
    private List<SuperType> superclasses = new ArrayList<SuperType>();
    private boolean templateStage = false;
    private String writeLanguage;
    private boolean writeStage = false;
    private static final Map<Character, TypeDescription> signatureToTypeDescription = new HashMap<Character, TypeDescription>();
    private static SAXParserFactory parserFactory;
    private static Pattern arrayReference;
    private static Pattern currentRow;
    private static final String currentPackage = "oracle.bpm.xobject.presentationmodel.XForm";
    private static final StringMap stringMapping;
    private static final int ID_arg = 1;
    private static final int ID_array = 2;
    private static final int ID_attributes = 3;
    private static final int ID_boolean = 5;
    private static final int ID_calculate = 6;
    private static final int ID_className = 7;
    private static final int ID_component = 8;
    private static final int ID_defaultValue = 9;
    private static final int ID_description = 10;
    private static final int ID_dynamic = 11;
    private static final int ID_enumeration = 12;
    private static final int ID_exception = 13;
    private static final int ID_flags = 14;
    private static final int ID_group = 15;
    private static final int ID_implementationName = 16;
    private static final int ID_indexType = 17;
    private static final int ID_inputArguments = 18;
    private static final int ID_int = 19;
    private static final int ID_isVisible = 20;
    private static final int ID_item = 21;
    private static final int ID_iterator = 22;
    private static final int ID_javaType = 23;
    private static final int ID_label = 24;
    private static final int ID_length = 25;
    private static final int ID_map = 26;
    private static final int ID_maxOcur = 27;
    private static final int ID_method = 28;
    private static final int ID_methods = 29;
    private static final int ID_modifiers = 30;
    private static final int ID_name = 31;
    private static final int ID_object = 32;
    private static final int ID_objectProperty = 33;
    private static final int ID_ordered = 34;
    private static final int ID_outputArgument = 35;
    private static final int ID_precision = 36;
    private static final int ID_presentation = 37;
    private static final int ID_primitive = 38;
    private static final int ID_property = 39;
    private static final int ID_readSignature = 40;
    private static final int ID_remote = 41;
    private static final int ID_required = 42;
    private static final int ID_scale = 43;
    private static final int ID_signature = 44;
    private static final int ID_template = 45;
    private static final int ID_type = 46;
    private static final int ID_validValues = 47;
    private static final int ID_validValuesMethodSignature = 48;
    private static final int ID_validate = 49;
    private static final int ID_value = 50;
    private static final int ID_writeSignature = 51;
    private static final int ID_argument = 52;
    private static final int ID_isEditable = 53;
    private static final int ID_timestamp = 54;
    private static final int ID_status = 55;
    private static final int ID_lastCheckinName = 56;
    private static final int ID_procedure = 57;
    private static final int ID_defaultExpression = 58;
    private static final int ID_versionID = 59;
    private static final int ID_superclass = 60;
    private static final int ID_repositoryModifier = 61;
    private static final int ID_transformation = 62;
    private static final int ID_transformationSource = 63;
    private static final int ID_preTransformationCil = 64;
    private static final int ID_postTransformationCil = 65;
    private static final int ID_fieldMapping = 66;
    private static final int ID_targetType = 67;
    private static final int ID_targetName = 68;
    private static final int ID_targetField = 69;
    private static final int ID_isExpression = 70;
    private static final int ID_inherit = 71;
    private static final int ID_transformationLocalVar = 72;
    private static final int ID_transformationLocalVars = 73;
    private static final int ID_transformationLocalVarType = 74;
    private static final int ID_transformationLocalVarName = 75;
    private static final int ID_require = 76;
    private static final int ID_ensure = 77;
    private static final int ID_variable = 78;
    private static final int ID_language = 79;
    private static final int ID_check = 80;
    private static final int ID_elementType = 81;
    private static final int ID_replacement = 82;
    private static final int ID_documentation = 83;
    private static final int ID_position = 84;
    private static final int ID_read = 85;
    private static final int ID_write = 86;
    private static final int ID_native = 86;
    private static final int ID_beginCode = 87;
    private static final int ID_endCode = 88;
    private static final int ID_displayName = 89;
    private static final int ID_sourceCode = 90;
    private static SuperTypeComparator SUPER_TYPE_COMPARATOR;

    public TypeLoader45(ComponentCatalog catalog) {
        this(catalog, null);
    }

    public TypeLoader45(ComponentCatalog catalog, XMLReader oldParser) {
        if (catalog == null) {
            throw new IllegalArgumentException("Attempt to set a null catalog");
        }
        this.catalog = catalog;
        if (oldParser != null) {
            this.parentHandler = oldParser.getContentHandler();
            this.parentParser = oldParser;
        }
        try {
            if (parserFactory == null) {
                parserFactory = SAXParserFactory.newInstance();
            }
            SAXParser sp = parserFactory.newSAXParser();
            this.parser = sp.getXMLReader();
            this.parser.setContentHandler(this);
        }
        catch (ParserConfigurationException e) {
            TypeLoader45.warning(e);
        }
        catch (SAXException e) {
            TypeLoader45.warning(e);
        }
    }

    public static ObjectTypeDescription createFrom(InputStream stream, ComponentCatalog catalog) throws ComponentLoadingException {
        return TypeLoader45.createFrom(stream, catalog, "");
    }

    public static ObjectTypeDescription createFrom(InputStream stream, ComponentCatalog catalog, String parentName) throws ComponentLoadingException {
        TypeLoader45 loader = new TypeLoader45(catalog);
        ObjectTypeDescription object = loader.load(stream, parentName);
        if (object == null) {
            TypeLoader45.warning("Error reading object type description");
        }
        return object;
    }

    public static void migrate(MethodTypeDescription method, ComponentCatalog catalog, TypeDescription context) {
        int index;
        char[] code = method.getCodeText();
        String codeLanguage = method.getCodeLanguage();
        if (codeLanguage == null || !codeLanguage.startsWith("Fuego") || codeLanguage.equals("Fuego2") || code == null || code.length == 0) {
            return;
        }
        char[] newCode = null;
        try {
            newCode = TypeLoader45.migrateMultilineLiteralStrings(code);
            char[] newCode2 = TypeLoader45.migrateMispelledArguments(newCode != null ? newCode : code);
            newCode = newCode2 != null ? newCode2 : newCode;
        }
        catch (Exception unexpected) {
            Log.logSevere(unexpected);
            unexpected.printStackTrace();
        }
        if (newCode != null) {
            code = newCode;
            method.setCode(code, "Fuego1");
        }
        String source = Str.valueOf(code);
        String name = "";
        int length = source == null ? 0 : source.length();
        for (index = 0; index < length; ++index) {
            char ch = source.charAt(index);
            if (Character.isWhitespace(ch)) continue;
            int start = index;
            while (index < length && !Character.isWhitespace(ch = source.charAt(index++)) && ch != '(' && ch != ':' && ch != '\n' && ch != '\t') {
            }
            name = source.substring(start, index - 1);
            break;
        }
        if (name == null || Identifier.belongsToCIL(name) || !Identifier.isValid(name)) {
            return;
        }
        int endIndex = Str.lastIndexOfWord(source, "end");
        if (endIndex == -1) {
            return;
        }
        String afterEnd = source.substring(endIndex + 3).trim();
        if (afterEnd.length() != 0 && !afterEnd.equals(name)) {
            return;
        }
        if (source.indexOf("defaultValidate") != -1 && context != null && context.isBpmObject()) {
            MethodTypeDescription member = new MethodTypeDescription("defaultValidate");
            try {
                member.setReturnArgument(new Argument("result", TypeFactory.getArray(catalog.find("Fuego.Lang.ValidationException")), 16L));
                member.setCode("return null", "Fuego");
            }
            catch (AmbiguousTypeNameException e) {
                // empty catch block
            }
            context.asObject().addMember(member);
        }
        source = source.substring(index, endIndex);
        ArrayList<Variable> variables = null;
        String[] lines = source.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (line.startsWith("do") && (line.length() < 3 || Character.isWhitespace(line.charAt(2)))) {
                lines[i] = line.substring(2);
                StringBuffer body = new StringBuffer();
                for (int j = i; j < lines.length; ++j) {
                    body.append(lines[j]);
                    body.append("\n");
                }
                method.setCode(body.toString(), "Fuego1");
                if (variables == null) break;
                for (Variable variable : variables) {
                    method.addVariable(variable);
                }
                break;
            }
            int colon = line.indexOf(58);
            if (colon != -1) {
                String varName = line.substring(0, colon).trim();
                String varType = line.substring(colon + 1).trim();
                TypeRef type = TypeFactory.getAny();
                try {
                    type = TypeLoader45.typeOf(varType, null, catalog, context);
                }
                catch (IllegalTypeException e) {
                    e.printStackTrace();
                }
                if (variables == null) {
                    variables = new ArrayList<Variable>();
                }
                variables.add(new Variable(varName, type));
                continue;
            }
            if (line.startsWith("//") || line.length() <= 0) continue;
            return;
        }
    }

    public static void setParserFactory(SAXParserFactory factory) {
        parserFactory = factory;
    }

    public static TypeRef typeOf(String text, String javaType, ComponentCatalog catalog, TypeDescription context) {
        try {
            if (text.startsWith("java.")) {
                text = "Java." + text.substring(5);
            }
            if (text.startsWith("fuego.")) {
                text = text.equals("fuego.XObjectBase") ? "Fuego.Lang.Presentable" : "Fuego." + text.substring(6);
            } else if (text.equals("XObjectBase")) {
                text = "Fuego.Lang.Presentable";
            }
            TypeRef type = TypeFactory.forNameLazy(text, catalog, javaType, context);
            if (type == null) {
                type = UnknownType.create(text, catalog);
            }
            return type;
        }
        catch (IllegalTypeException e) {
            return UnknownType.create(text, catalog, e.getMessage());
        }
    }

    @Override
    public void characters(char[] chars, int start, int length) {
        try {
            if (this.presentationStage) {
                this.managePresentationCharacters(chars, start, length);
                return;
            }
            if (this.templateStage) {
                this.currentTemplate.append(chars, start, length);
                return;
            }
            if (this.requireStage) {
                Validation last = this.currentRequire.get(this.currentRequire.size() - 1);
                last.append(chars, start, length);
                return;
            }
            if (this.ensureStage) {
                Validation last = this.currentEnsure.get(this.currentEnsure.size() - 1);
                last.append(chars, start, length);
                return;
            }
            if (this.checkStage) {
                Validation last = this.currentCheck.get(this.currentCheck.size() - 1);
                last.append(chars, start, length);
                return;
            }
            if (this.readStage) {
                this.currentRead.append(chars, start, length);
                return;
            }
            if (this.writeStage) {
                this.currentWrite.append(chars, start, length);
                return;
            }
            if (this.documentationStage) {
                if (this.currentDocumentation == null) {
                    this.currentDocumentation = new StringBuffer();
                }
                this.currentDocumentation.append(chars, start, length);
                return;
            }
            if (this.sourceCodeBuilder != null) {
                this.sourceCodeBuilder.append(chars, start, length);
                return;
            }
            if (this.displayName != null) {
                this.displayName.append(chars, start, length);
            } else if (this.methodStage) {
                if (this.currentCode == null) {
                    this.currentCode = new StringBuffer();
                }
                this.currentCode.append(chars, start, length);
            }
            if (this.beginTransformationStage) {
                if (this.currentBeginCode == null) {
                    this.currentBeginCode = new StringBuffer();
                }
                this.currentBeginCode.append(chars, start, length);
            }
            if (this.endTransformationStage) {
                if (this.currentEndCode == null) {
                    this.currentEndCode = new StringBuffer();
                }
                this.currentEndCode.append(chars, start, length);
            }
            if (this.fieldMappingStage) {
                if (this.currentFieldMappingCode == null) {
                    this.currentFieldMappingCode = new StringBuffer();
                }
                this.currentFieldMappingCode.append(chars, start, length);
            }
            if (this.resourcesStage) {
                if (this.currentResource == null) {
                    this.currentResource = new StringBuffer();
                }
                this.currentResource.append(chars, start, length);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.logSevere(ex);
        }
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void endElement(String uri, String local, String name) {
        try {
            if (this.presentationStage) {
                this.managePresentationEndElement(name);
                if (name.equalsIgnoreCase("presentation")) {
                    this.presentationStage = false;
                }
                return;
            }
            if (this.resourcesStage) {
                if (name.equalsIgnoreCase("resources")) {
                    this.resourcesStage = false;
                } else if (name.equalsIgnoreCase("label")) {
                    if (this.currentResource != null) {
                        ((XObjectTypeDescription)this.currentObject).setResource(this.currentResourceKey, this.currentResourceType, this.currentResource.toString().trim(), this.currentResourceLocale);
                        this.currentResource = null;
                    }
                } else if (name.equalsIgnoreCase("resource")) {
                    this.currentResourceType = 0;
                }
                return;
            }
            switch (stringMapping.get(name)) {
                case 1: 
                case 52: {
                    this.currentArgument = null;
                    break;
                }
                case 29: {
                    if (this.lastMethod != null) {
                        this.addMember(this.currentObject, this.lastMethod);
                        this.lastMethod = null;
                    }
                    assert (this.currentMethod == null);
                    break;
                }
                case 3: {
                    this.dataModelStage = false;
                    return;
                }
                case 90: {
                    this.currentMethod.setCode(this.sourceCodeBuilder.getSourceCode());
                    this.sourceCodeBuilder = null;
                    return;
                }
                case 45: {
                    this.templateStage = false;
                    break;
                }
                case 28: {
                    String code;
                    if (this.currentTemplate != null) {
                        this.currentMethod.setTemplate(this.currentTemplate.toString().trim());
                        this.currentTemplate = null;
                    }
                    if (this.memberProperties != null) {
                        this.currentMethod.setProperties(this.memberProperties);
                        this.memberProperties = null;
                    }
                    String language = this.currentLanguage == null ? "Fuego1" : this.currentLanguage;
                    this.methodStage = false;
                    if (this.currentCode != null && this.currentCode.length() > 0 && this.currentMethod.getCode() == null && (code = this.trimCode(this.currentCode)).length() > 1) {
                        this.currentMethod.setCode(code, language);
                        TypeLoader45.migrate(this.currentMethod, this.catalog, this.currentGroup != null ? this.currentGroup : this.currentObject);
                    }
                    this.currentCode = null;
                    this.setValidations(this.currentMethod);
                    if (this.lastMethod == null) {
                        this.lastMethod = this.currentMethod;
                    } else if (this.lastMethod.getName().equals(this.currentMethod.getName())) {
                        this.lastMethod = MethodTypeDescription.appendMethod(this.lastMethod, this.currentMethod);
                    } else {
                        this.addMember(this.currentObject, this.lastMethod);
                        this.lastMethod = this.currentMethod;
                    }
                    if (!this.hasLegacyValidValuesMethods && this.currentObject instanceof XObjectTypeDescription) {
                        this.hasLegacyValidValuesMethods = this.isArrayOfArrayOfAny(this.currentMethod.getResultArgument().getTypeRef());
                    }
                    this.currentMethod = null;
                    return;
                }
                case 62: {
                    this.currentObject.addMember(this.currentTransformation);
                    this.currentTransformation = null;
                    return;
                }
                case 66: {
                    this.fieldMappingStage = false;
                    this.currentTransformationFieldMapping.setCode(SourceCode.create(this.currentFieldMappingCode.toString().trim(), this.fieldMappingLanguage));
                    this.currentTransformationFieldMapping = null;
                    this.currentFieldMappingCode.setLength(0);
                    return;
                }
                case 73: {
                    this.currentTransformation.setVariables(this.currentLocalVars);
                    return;
                }
                case 64: 
                case 87: {
                    this.beginTransformationStage = false;
                    this.currentTransformation.setBeginCode(SourceCode.create(this.trimCode(this.currentBeginCode), this.beginCodeLanguage));
                    return;
                }
                case 65: 
                case 88: {
                    this.endTransformationStage = false;
                    this.currentTransformation.setEndCode(SourceCode.create(this.trimCode(this.currentEndCode), this.endCodeLanguage));
                    return;
                }
                case 15: {
                    this.groupName = null;
                    String groupName = Identifier.attribute(this.currentGroup.getName());
                    ArrayTypeDescription arrayType = TypeFactory.getArray(this.currentGroup);
                    arrayType.setJavaType("oracle.bpm.util.LegacyGroupArray");
                    AttributeTypeDescription groupAttr = new AttributeTypeDescription(groupName, arrayType, 32776L);
                    this.addMember(this.currentObject, groupAttr);
                    for (MethodTypeDescription member : this.currentGroup.getAttributes()) {
                        if (member.getName().equals("currentRow")) continue;
                        AttributeTypeDescription attr = new AttributeTypeDescription(member.getName(), member.getResultType());
                        attr.setType(TypeFactory.getArray(attr.getResultType()));
                        attr.addModifiers(0x20000000000L);
                        attr.makeReadWrite();
                        attr.addModifiers(0x100000L);
                        String msg = "'" + attr.getName() + "' was replaced by '" + groupName + "[]." + attr.getName() + "'";
                        attr.setProperty("deprecatedMessage", msg);
                        String warning = "// this code was autogenerated to provide compatibility with Fuego 4\n";
                        StringBuffer code = new StringBuffer("// this code was autogenerated to provide compatibility with Fuego 4\n");
                        code.append("return ");
                        code.append(groupName);
                        code.append("[].");
                        code.append(attr.getName());
                        code.append("\n");
                        SourceCode read = SourceCode.create(code.toString(), "Fuego");
                        attr.setCode(read);
                        code.setLength(0);
                        code.append("// this code was autogenerated to provide compatibility with Fuego 4\n");
                        attr.addWriteVariable(new Variable("newArray", attr.getResultArgument().getTypeRef()));
                        code.append("newArray = this.");
                        code.append(groupName);
                        code.append("[].");
                        code.append(attr.getName());
                        code.append("\n");
                        code.append("clear newArray\n\n");
                        code.append("for each element in value do\n");
                        code.append("    newArray[] = element\n");
                        code.append("end \n");
                        SourceCode write = SourceCode.create(code.toString(), "Fuego");
                        attr.setWriteCode(write);
                        this.addMember(this.currentObject, attr);
                        member.asAttribute().setJavaType(null);
                    }
                    this.currentGroup.setComponentType(this.currentObject.getComponentType());
                    XObjectFactory.addCurrentRowAttribute(this.currentGroup, (this.currentParentName != null ? this.currentParentName + "." : "") + this.currentObject.getName());
                    this.currentObject.addInnerType(this.currentGroup);
                    XObjectTypeDescription.addConstructors(this.currentGroup);
                    TypeLoader45.addExpressionsToConstructor(this.defaultExpressions, this.currentGroup);
                    this.defaultExpressions.clear();
                    this.currentGroup = null;
                    return;
                }
                case 2: 
                case 22: 
                case 26: 
                case 32: {
                    if (this.currentAttribute != null) {
                        this.currentAttribute.setProperties(this.memberProperties);
                    }
                    this.setValidations(this.currentAttribute);
                    this.memberProperties = null;
                    this.currentAttribute = null;
                    return;
                }
                case 39: {
                    return;
                }
                case 37: {
                    this.presentationStage = false;
                    return;
                }
                case 8: {
                    if ("jndi".equals(this.currentObject.getComponentType()) && this.currentObject.getVersionID().startsWith("Version 5.7") && this.objectProperties.containsKey("javaClassName")) {
                        this.objectProperties.remove("javaClassName");
                    }
                    this.currentObject.setProperties(this.objectProperties);
                    this.objectProperties = new TreeMap<String, String>();
                    if (this.superclasses.size() > 0) {
                        if (this.currentObject.isBpmObject()) {
                            Collections.sort(this.superclasses, SUPER_TYPE_COMPARATOR);
                        }
                        this.currentObject.setSuperTypes(this.superclasses.toArray(new SuperType[this.superclasses.size()]));
                        this.superclasses.clear();
                    }
                    if (this.parentHandler != null) {
                        this.parentParser.setContentHandler(this.parentHandler);
                        this.parentHandler.endElement(uri, local, name);
                    }
                    this.checkComIterators(this.currentObject);
                    this.checkSqlType(this.currentObject);
                    this.checkEjbType(this.currentObject);
                    if (!this.defaultExpressions.isEmpty()) {
                        TypeLoader45.addExpressionsToConstructor(this.defaultExpressions, this.currentObject);
                        this.defaultExpressions.clear();
                    }
                    return;
                }
                case 76: {
                    this.requireStage = false;
                    return;
                }
                case 77: {
                    this.ensureStage = false;
                    return;
                }
                case 80: {
                    this.checkStage = false;
                    break;
                }
                case 85: {
                    this.readStage = false;
                    break;
                }
                case 86: {
                    this.writeStage = false;
                    break;
                }
                case 12: {
                    this.currentObject.setProperties(this.objectProperties);
                    this.objectProperties = new TreeMap<String, String>();
                    break;
                }
                case 89: {
                    this.getCurrentType().setDisplayName(this.displayName.getLocale(), this.displayName.getDisplayName());
                    this.displayName = null;
                    break;
                }
                case 83: {
                    this.documentationStage = false;
                    String docXML = this.currentDocumentation != null ? this.currentDocumentation.toString() : "";
                    docXML = XmlWriter.replaceCDATA(docXML);
                    if (this.methodStage) {
                        this.currentMethod.setDocumentation(this.currentDocType, this.currentDocLanguage, docXML);
                    } else if (this.currentAttribute != null) {
                        this.currentAttribute.setDocumentation(this.currentDocType, this.currentDocLanguage, docXML);
                    } else {
                        this.currentObject.setDocumentation(this.currentDocType, this.currentDocLanguage, docXML);
                    }
                    this.currentDocumentation = null;
                }
            }
            if (this.predefinedType != null && name.equals(this.predefinedType)) {
                if (this.currentAttribute != null) {
                    this.currentAttribute.setProperties(this.memberProperties);
                }
                this.setValidations(this.currentAttribute);
                this.memberProperties = null;
                this.currentAttribute = null;
                return;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.logSevere(ex);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) {
    }

    public ObjectTypeDescription getObject() {
        if (this.currentObject != null) {
            this.currentObject.setCatalog(this.catalog);
        }
        return this.currentObject;
    }

    @Override
    public void ignorableWhitespace(char[] chars, int start, int end) {
    }

    public synchronized ObjectTypeDescription load(InputStream stream, String parentName) throws ComponentLoadingException {
        return this.load(stream, parentName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ObjectTypeDescription load(InputStream stream, String parentName, String componentNane) throws ComponentLoadingException {
        if (this.parsing) {
            throw new IllegalStateException("This instance of TypeParser45 is already parsing this component: '" + this.currentComponentName + "'. Maybe TypeParser45 is forcing the load of " + "members of '" + this.currentComponentName + "'");
        }
        try {
            this.currentComponentName = componentNane;
            this.currentParentName = parentName != null && parentName.length() > 0 ? parentName : null;
            this.parsing = true;
            ObjectTypeDescription objectTypeDescription = this.loadImpl(stream);
            return objectTypeDescription;
        }
        finally {
            this.parsing = false;
        }
    }

    public void manageComponentInfo(Attributes amap) throws SAXException {
        String name = "";
        String type = "";
        String signature = "";
        String description = "";
        String modifiers = "";
        String versionID = "Version 4";
        boolean dynamic = false;
        String elementType = null;
        block16: for (int i = 0; i < amap.getLength(); ++i) {
            String attname = amap.getQName(i);
            String value = amap.getValue(i);
            switch (stringMapping.get(attname)) {
                case 31: {
                    this.currentComponentName = name = value;
                    continue block16;
                }
                case 10: {
                    description = value;
                    continue block16;
                }
                case 46: {
                    type = value;
                    if ("automation".equals(type)) {
                        type = "COM";
                    }
                    Module.ModuleFactory factory = Module.getFactory(type);
                    if (this.currentObject != null) continue block16;
                    this.currentObject = factory == null || type.equals(ComponentType.SQL.getText()) ? new ObjectTypeDescription("") : factory.createEmptyObjectTypeDescription(type);
                    this.currentObject.setComponentType(type);
                    this.currentObject.setCatalog(this.catalog);
                    continue block16;
                }
                case 81: {
                    elementType = value;
                    continue block16;
                }
                case 44: {
                    signature = value;
                    continue block16;
                }
                case 14: 
                case 30: {
                    modifiers = value;
                    continue block16;
                }
                case 16: {
                    continue block16;
                }
                case 41: {
                    this.remote = Boolean.parseBoolean(value);
                    continue block16;
                }
                case 11: {
                    dynamic = Boolean.parseBoolean(value);
                    continue block16;
                }
                case 60: {
                    this.superclass = value;
                    continue block16;
                }
                case 54: {
                    continue block16;
                }
                case 56: {
                    continue block16;
                }
                case 59: {
                    versionID = value;
                    continue block16;
                }
                case 61: {
                    continue block16;
                }
            }
        }
        if (this.currentObject == null) {
            throw new SAXException("Invalid object type " + type);
        }
        this.currentObject.setName(name);
        this.currentObject.setDescription(description);
        this.currentObject.setSignature(signature);
        this.currentObject.setModifiers(Modifier.getModifiers(modifiers));
        this.currentObject.setModifiers(Modifier.setDynamic(this.currentObject.getModifiers(), dynamic));
        if (this.superclass != null && !this.superclass.equals("fuego.XObjectBase") && !this.superclass.equals("XObjectBase")) {
            if (this.superclass.equals("Any")) {
                this.currentObject.setSuperTypes(SuperType.getAnySuperTypeList());
            } else {
                TypeRef superType = this.typeOf(this.superclass, null);
                this.currentObject.setSuperTypes(new SuperType[]{new SuperType(superType, 32768L)});
            }
            String componentType = this.currentObject.getComponentType();
            if (ComponentType.JAVA.getText().equals(componentType) && (this.superclass.endsWith("Exception") || "java.Throwable".equals(this.superclass) || this.currentObject.getName().endsWith("Exception"))) {
                this.currentObject.setModifiers(this.currentObject.getModifiers() | 0x40000L | 0x1000000000000L);
            }
        }
        if (elementType != null) {
            this.currentObject.setElementType(this.typeOf(elementType, null));
        }
        this.currentObject.setVersionID(versionID);
        this.currentObject.setCatalog(this.catalog);
    }

    @Override
    public void processingInstruction(String target, String data) {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) {
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void startElement(String uri, String local, String name, Attributes amap) throws SAXException {
        try {
            if (name.equalsIgnoreCase("presentation")) {
                this.presentationStage = true;
                if (this.currentElement == null) {
                    this.currentElement = new Stack();
                }
            }
            if (this.presentationStage) {
                this.managePresentationStartElement(name, amap);
                return;
            }
            if (name.equalsIgnoreCase("resources")) {
                this.resourcesStage = true;
            }
            if (this.resourcesStage) {
                this.manageResourceStart(name, amap);
                return;
            }
            switch (stringMapping.get(name)) {
                case 8: {
                    this.manageComponentInfo(amap);
                    return;
                }
                case 57: {
                    this.manageComponentInfo(amap);
                    return;
                }
                case 12: {
                    this.manageEnumerationInfo(amap);
                    return;
                }
                case 21: {
                    if (!(this.currentObject instanceof EnumTypeDescription)) break;
                    TypeLoader45.manageEnumerationItem(amap, (EnumTypeDescription)((Object)this.currentObject));
                    return;
                }
                case 33: {
                    this.objectProperties = TypeLoader45.managePropertyInfo(amap, this.objectProperties);
                    return;
                }
                case 39: {
                    if (this.currentArgument != null) {
                        String pname = amap.getValue("name");
                        String pvalue = amap.getValue("value");
                        this.currentArgument.setProperty(pname, pvalue);
                    } else {
                        this.memberProperties = TypeLoader45.managePropertyInfo(amap, this.memberProperties);
                    }
                    return;
                }
                case 3: {
                    this.dataModelStage = true;
                    return;
                }
                case 28: {
                    this.methodStage = true;
                    this.manageMethodInfo(amap);
                    return;
                }
                case 78: {
                    this.manageVariableInfo(amap);
                    return;
                }
                case 62: {
                    this.currentTransformation = new TransformTypeDescription();
                    this.manageTransformationInfo(amap);
                    return;
                }
                case 63: {
                    this.manageTransformationSourceInfo(amap);
                    return;
                }
                case 66: {
                    this.fieldMappingStage = true;
                    this.currentFieldMappingCode = new StringBuffer();
                    this.manageTransformationFieldMappingInfo(amap);
                    return;
                }
                case 73: {
                    this.currentLocalVars = new ArrayList();
                    return;
                }
                case 72: {
                    this.manageTransformationLocalVarsInfo(amap);
                    return;
                }
                case 64: 
                case 87: {
                    this.beginTransformationStage = true;
                    this.currentBeginCode = new StringBuffer();
                    this.beginCodeLanguage = this.getLanguage(amap);
                    return;
                }
                case 65: 
                case 88: {
                    this.endTransformationStage = true;
                    this.currentEndCode = new StringBuffer();
                    this.endCodeLanguage = this.getLanguage(amap);
                    return;
                }
                case 13: {
                    if (this.methodStage) {
                        this.manageExceptionInfo(amap);
                    }
                    return;
                }
                case 45: {
                    this.templateStage = true;
                    this.currentTemplate = new StringBuffer("");
                    break;
                }
                case 15: {
                    if (!this.defaultExpressions.isEmpty()) {
                        TypeLoader45.addExpressionsToConstructor(this.defaultExpressions, this.currentObject);
                        this.defaultExpressions.clear();
                    }
                    this.groupName = amap.getValue("name");
                    this.maxOcur = amap.getValue("maxOcur");
                    if (this.maxOcur == null) {
                        this.maxOcur = "*";
                    }
                    this.groupName = Identifier.attribute(this.groupName);
                    this.currentGroup = XObjectFactory.createGroupElement(this.groupName, this.catalog);
                    return;
                }
                case 1: 
                case 52: {
                    if (!this.methodStage) {
                        return;
                    }
                    this.manageInputArgument(amap);
                    return;
                }
                case 35: {
                    if (!this.methodStage) {
                        return;
                    }
                    this.manageOutputArgument(amap);
                    return;
                }
                case 32: {
                    this.manageObjectData(amap);
                    return;
                }
                case 2: {
                    this.manageArrayOrIteratorInfo(amap, true);
                    return;
                }
                case 26: {
                    this.manageMapInfo(amap);
                    return;
                }
                case 22: {
                    this.manageArrayOrIteratorInfo(amap, false);
                    return;
                }
                case 29: {
                    return;
                }
                case 18: {
                    return;
                }
                case 71: {
                    this.manageInheritInfo(amap);
                    return;
                }
                case 76: {
                    if (this.methodStage || this.dataModelStage) {
                        this.requireStage = true;
                        if (this.currentRequire == null) {
                            this.currentRequire = new ArrayList<Validation>();
                        }
                        Validation validation = new Validation();
                        validation.setLanguage(this.getLanguage(amap));
                        validation.setMessage(amap.getValue("message"));
                        this.currentRequire.add(validation);
                    }
                    return;
                }
                case 77: {
                    if (this.methodStage || this.dataModelStage) {
                        this.ensureStage = true;
                        if (this.currentEnsure == null) {
                            this.currentEnsure = new ArrayList<Validation>();
                        }
                        Validation validation = new Validation();
                        validation.setLanguage(this.getLanguage(amap));
                        validation.setMessage(amap.getValue("message"));
                        this.currentEnsure.add(validation);
                    }
                    return;
                }
                case 80: {
                    if (this.methodStage || this.dataModelStage) {
                        this.checkStage = true;
                        if (this.currentCheck == null) {
                            this.currentCheck = new ArrayList<Validation>();
                        }
                        Validation validation = new Validation();
                        validation.setLanguage(this.getLanguage(amap));
                        validation.setMessage(amap.getValue("message"));
                        this.currentCheck.add(validation);
                    }
                    return;
                }
                case 85: {
                    this.readStage = true;
                    if (this.currentRead == null) {
                        this.currentRead = new StringBuffer("");
                    } else {
                        this.currentRead.setLength(0);
                    }
                    this.readLanguage = this.getLanguage(amap);
                    return;
                }
                case 86: {
                    this.writeStage = true;
                    if (this.currentWrite == null) {
                        this.currentWrite = new StringBuffer("");
                    } else {
                        this.currentWrite.setLength(0);
                    }
                    this.writeLanguage = this.getLanguage(amap);
                    return;
                }
                case 83: {
                    this.documentationStage = true;
                    this.manageDocumentation(amap);
                    return;
                }
                case 89: {
                    this.manageDisplayName(amap);
                    return;
                }
                case 90: {
                    this.manageSourceCode(amap);
                    return;
                }
            }
            if (!this.dataModelStage) {
                return;
            }
            TypeRef td = null;
            String componentType = this.currentObject.getComponentType();
            String versionID = this.currentObject.getVersionID();
            if ((versionID.startsWith("Version 4.5") || versionID.startsWith("Version 4.2")) && ("Int".equalsIgnoreCase(name) || "Real".equalsIgnoreCase(name)) && ComponentType.JAVA.getText().equals(componentType)) {
                String readSignature = null;
                boolean primitive = false;
                int length = amap.getLength();
                block45: for (int i = 0; i < length; ++i) {
                    String attname = amap.getQName(i);
                    String value = amap.getValue(i);
                    switch (stringMapping.get(attname)) {
                        case 38: {
                            primitive = Boolean.parseBoolean(value);
                            continue block45;
                        }
                        case 40: {
                            readSignature = value;
                        }
                    }
                }
                if (primitive && readSignature != null) {
                    char javaReturnType = readSignature.charAt(readSignature.length() - 1);
                    td = TypeLoader45.getSignature(javaReturnType);
                    name = td.getName();
                }
            }
            if (td == null) {
                td = this.typeOf(name, null);
            }
            if (td == null) {
                TypeLoader45.warning("Invalid type description " + name);
                return;
            }
            this.predefinedType = name;
            this.managePredefinedData(null, td, amap);
        }
        catch (SAXException saxe) {
            throw saxe;
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.logSevere(e);
            throw new SAXException(e.getMessage());
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
    }

    private static TypeDescription getSignature(char type) {
        if (signatureToTypeDescription.isEmpty()) {
            TypeLoader45.initializeSignatures();
        }
        return signatureToTypeDescription.get(Character.valueOf(type));
    }

    private static void addExpressionsToConstructor(Map expressions, ObjectTypeDescription otd) {
        Set fields = TypeLoader45.getAttributesForType(otd);
        for (MethodTypeDescription constructor = otd.findMethod(otd.getName(), TypeFinder.Scope.CURRENT); constructor != null && !expressions.isEmpty(); constructor = constructor.getNextMethod()) {
            char[] text = constructor.getCodeText();
            StringBuffer code = new StringBuffer();
            Iterator it = expressions.entrySet().iterator();
            String groupName = Identifier.attribute(otd.getName());
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                code.append(entry.getKey());
                code.append(" = ");
                String expr = (String)entry.getValue();
                if (otd.isInnerType()) {
                    expr = TypeLoader45.migrateExpr(expr, fields, groupName);
                }
                code.append(expr);
                code.append('\n');
            }
            if (text != null) {
                code.append(text, 0, text.length);
            }
            constructor.setCode(code.toString(), "Fuego1");
        }
        expressions.clear();
    }

    private static StringBuffer buildValidValuesListFBLCode(AttributeTypeDescription att, List vvalues, List descriptions) {
        StringBuffer result = new StringBuffer();
        Iterator it = vvalues.iterator();
        result.append("return [");
        TypeRef typeRef = att.getTypeRef();
        if (typeRef instanceof TypeDescription) {
            int kind = att.getType().getKind();
            int currentRow = 0;
            while (it.hasNext()) {
                String current = (String)it.next();
                switch (kind) {
                    case 7: {
                        try {
                            Interval interval = Interval.valueOf(current.trim());
                            result.append("'");
                            result.append(interval.toString());
                            result.append("'");
                        }
                        catch (IntervalFormatException ife) {
                            TypeLoader45.warning("Error parsing Interval value for valid values: " + current);
                        }
                        break;
                    }
                    case 6: {
                        try {
                            Time t = Time.valueOf(current.trim());
                            result.append("'");
                            result.append(t.toString());
                            result.append("'");
                        }
                        catch (TimeFormatException tfe) {
                            TypeLoader45.warning("Error parsing Time value for valid values: " + current);
                        }
                        break;
                    }
                    case 5: {
                        result.append("\"");
                        result.append(current);
                        result.append("\"");
                        break;
                    }
                    default: {
                        result.append(current);
                    }
                }
                if (descriptions != null && descriptions.size() > 0 && descriptions.size() > currentRow) {
                    String desc = (String)descriptions.get(currentRow++);
                    result.append(":\"");
                    result.append(desc);
                    result.append("\"");
                }
                if (!it.hasNext()) continue;
                result.append(", ");
            }
        }
        result.append("]\n");
        return result;
    }

    private static MethodTypeDescription createDynamicMethod(MethodTypeDescription userMethod, String vvMethodName) {
        MethodTypeDescription methodTD = new MethodTypeDescription(vvMethodName, 32768L);
        methodTD.setResultType(userMethod.getResultArgument().getTypeRef());
        methodTD.setCode("return " + userMethod.getName() + (userMethod.isAttribute() ? "" : "()") + "\n", "Fuego");
        return methodTD;
    }

    private static MethodTypeDescription createListValidValuesMethod(AttributeTypeDescription att, String vvMethodName, List vvalues, List descriptions) {
        TypeDescription returnType = descriptions != null ? TypeFactory.getMap(TypeFactory.getString(), att.getResultArgument().getTypeRef()) : TypeFactory.getArray(att.getResultArgument().getTypeRef());
        MethodTypeDescription methodTD = new MethodTypeDescription(vvMethodName, 32768L);
        methodTD.setResultType(returnType);
        methodTD.setCode(TypeLoader45.buildValidValuesListFBLCode(att, vvalues, descriptions).toString(), "Fuego");
        return methodTD;
    }

    private static Set getAttributesForType(ObjectTypeDescription innerType) {
        HashSet<String> attributes = new HashSet<String>();
        int count = innerType.getMemberCount();
        for (int i = 0; i < count; ++i) {
            MethodTypeDescription member = innerType.getMemberType(i);
            if (!member.isAttribute()) continue;
            attributes.add(member.getName());
            attributes.add("this.".concat(member.getName()));
        }
        return attributes;
    }

    private static void manageEnumerationItem(Attributes amap, EnumTypeDescription enumType) {
        String label = null;
        String value = null;
        block4: for (int i = 0; i < amap.getLength(); ++i) {
            String attname = amap.getQName(i);
            switch (stringMapping.get(attname)) {
                case 24: {
                    label = amap.getValue(i);
                    continue block4;
                }
                case 50: {
                    value = amap.getValue(i);
                    continue block4;
                }
                default: {
                    TypeLoader45.warning("Invalid attribute " + attname + " in method declaration");
                }
            }
        }
        enumType.addItem(label, value == null ? null : Integer.valueOf(Integer.parseInt(value)));
    }

    private static Map<String, String> managePropertyInfo(Attributes amap, Map<String, String> props) {
        String name = amap.getValue("name");
        String value = amap.getValue("value");
        if (name != null) {
            if (props == null) {
                props = new TreeMap<String, String>();
            }
            props.put(name, value);
        }
        return props;
    }

    private static String migrateArgumentName(String code, String method, String component, String oldArgName, String newName) {
        if (code.indexOf(oldArgName) != -1) {
            String regexp = "(" + method + ".*" + component + ".*using.*)" + oldArgName + "(\\s*=)";
            Pattern pattern = Pattern.compile(regexp, 40);
            Matcher matcher = pattern.matcher(code);
            StringBuffer result = null;
            while (matcher.find()) {
                String group1 = matcher.group(1);
                String group2 = matcher.group(2);
                if (result == null) {
                    result = new StringBuffer(code.length());
                }
                matcher.appendReplacement(result, group1 + newName + group2);
            }
            if (result != null) {
                matcher.appendTail(result);
            }
            return result != null ? result.toString() : null;
        }
        return null;
    }

    private static String migrateExpr(String expr, Set fields, String groupName) {
        String array;
        if (arrayReference == null) {
            String id = "[a-zA-Z]\\w*";
            String reference = "\\b([a-zA-Z]\\w*)(\\.[a-zA-Z]\\w*)*";
            String spaces = "\\s*";
            String regexp = "(\\b([a-zA-Z]\\w*)(\\.[a-zA-Z]\\w*)*)\\s*\\[\\s*currentRow\\s*\\]";
            currentRow = Pattern.compile(regexp);
            regexp = "(\\b([a-zA-Z]\\w*)(\\.[a-zA-Z]\\w*)*)\\s*\\[\\s*(.*?)\\s*\\]";
            arrayReference = Pattern.compile(regexp);
        }
        Matcher matcher = currentRow.matcher(expr);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            array = matcher.group(1);
            if (!fields.contains(array)) {
                matcher.appendReplacement(result, matcher.group(0));
                continue;
            }
            matcher.appendReplacement(result, array);
        }
        matcher.appendTail(result);
        expr = result.toString();
        result.setLength(0);
        matcher = arrayReference.matcher(expr);
        while (matcher.find()) {
            array = matcher.group(1);
            String index = matcher.group(4);
            if (array.indexOf(91) != -1 || !fields.contains(array)) {
                matcher.appendReplacement(result, matcher.group(0));
                continue;
            }
            matcher.appendReplacement(result, groupName + "[" + index + "]." + array);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private static void migrateExpressions(ObjectTypeDescription innerType) {
        Set attributes = TypeLoader45.getAttributesForType(innerType);
        int count = innerType.getMemberCount();
        String groupName = Identifier.attribute(innerType.getName());
        for (int i = 0; i < count; ++i) {
            Validation[] check;
            MethodTypeDescription member = innerType.getMemberType(i);
            if (!member.isAttribute()) continue;
            AttributeTypeDescription attr = member.asAttribute();
            SourceCode expr = attr.getCode();
            if (expr != null) {
                expr.setText(TypeLoader45.migrateExpr(new String(expr.getText()), attributes, groupName).toCharArray());
            }
            if ((check = attr.getCheckCode()) == null) continue;
            for (Validation sourceCode : check) {
                sourceCode.setText(TypeLoader45.migrateExpr(new String(sourceCode.getText()), attributes, groupName).toCharArray());
            }
        }
    }

    private static char[] migrateMispelledArguments(char[] code) {
        boolean migrated = false;
        String text = new String(code);
        String newCode = TypeLoader45.migrateArgumentName(text, "create", "Participant", "telefone", "telephone");
        if (newCode != null) {
            text = newCode;
            migrated = true;
        }
        if ((newCode = TypeLoader45.migrateArgumentName(text, "send", "Notification", "instanceDN", "instanceId")) != null) {
            text = newCode;
            migrated = true;
        }
        if ((newCode = TypeLoader45.migrateArgumentName(text, "create", "ProcessInstance", "processDN", "processId")) != null) {
            text = newCode;
            migrated = true;
        }
        if ((newCode = TypeLoader45.migreateClone(text)) != null) {
            text = newCode;
            migrated = true;
        }
        return migrated ? text.toCharArray() : null;
    }

    private static char[] migrateMultilineLiteralStrings(char[] code) {
        StringBuffer newCode = null;
        for (int i = 0; i < code.length; ++i) {
            char c = code[i];
            switch (c) {
                case '\"': {
                    if (newCode != null) {
                        newCode.append(c);
                    }
                    ++i;
                    while (i < code.length && (c = code[i]) != '\"') {
                        if (c == '\n') {
                            if (newCode == null) {
                                newCode = new StringBuffer(code.length + 2);
                                newCode.append(code, 0, i);
                            }
                            newCode.append("\\n");
                            newCode.append('\"');
                            newCode.append("\n");
                            newCode.append('\"');
                        } else if (c == '\\') {
                            if (newCode != null) {
                                newCode.append(c);
                            }
                            if (newCode != null && ++i < code.length) {
                                newCode.append(code[i]);
                            }
                        } else if (newCode != null) {
                            newCode.append(c);
                        }
                        ++i;
                    }
                    break;
                }
                case '\'': {
                    if (newCode != null) {
                        newCode.append(c);
                    }
                    ++i;
                    boolean escaped = false;
                    while (i < code.length && (c = code[i]) != '\'' || escaped) {
                        if (newCode != null) {
                            newCode.append(c);
                        }
                        ++i;
                        escaped = c == '\\';
                    }
                    break;
                }
                case '/': {
                    if (i + 1 < code.length && code[i + 1] == '/') {
                        while (i < code.length && (c = code[i]) != '\n') {
                            if (newCode != null) {
                                newCode.append(c);
                            }
                            ++i;
                        }
                    } else {
                        if (i + 1 >= code.length || code[i + 1] != '*') break;
                        while (i < code.length && ((c = code[i]) != '/' || i == 0 || code[i - 1] != '*')) {
                            if (newCode != null) {
                                newCode.append(c);
                            }
                            ++i;
                        }
                    }
                    break;
                }
            }
            if (newCode == null) continue;
            newCode.append(c);
        }
        return newCode != null ? newCode.toString().toCharArray() : null;
    }

    private static String migreateClone(String code) {
        Pattern pattern = Pattern.compile("(\\w+\\.)clone([^(])");
        Matcher matcher = pattern.matcher(code);
        StringBuffer result = null;
        while (matcher.find()) {
            String group1 = matcher.group(1);
            String group2 = matcher.group(2);
            if (result == null) {
                result = new StringBuffer(code.length());
            }
            matcher.appendReplacement(result, group1 + "clone()" + group2);
        }
        if (result != null) {
            matcher.appendTail(result);
        }
        return result != null ? result.toString() : null;
    }

    private static boolean mustMigrateVersion4(ObjectTypeDescription otd) {
        return otd.getVersionID().startsWith("Version 4");
    }

    private static boolean mustMigrateVersion5(ObjectTypeDescription otd) {
        String versionId = otd.getVersionID();
        return versionId.startsWith("Version 5") || versionId.startsWith("Version LANIN");
    }

    private static void warning(Throwable t) {
        Log.logWarning(t);
    }

    private static void warning(String s) {
        Log.logWarning(new Exception(s));
    }

    private static TypeRef extractTypeFromMethodSignature(String methodSignature, int argIndex) {
        int as = methodSignature.indexOf(40);
        int af = methodSignature.indexOf(41);
        assert (as > 0 && af != -1) : "Invalid Signature:" + methodSignature;
        String signature = methodSignature.substring(as + 1, af);
        ArrayList<TypeDescription> arguments = TypeLoader45.paramSignatureToType(signature);
        assert (argIndex < arguments.size()) : "Invalid arg index";
        return arguments.get(argIndex);
    }

    private static String extractArgument(int beginIndex, String signature) {
        char elemType = signature.charAt(beginIndex);
        String elemSignature = String.valueOf(elemType);
        if (elemType == '[') {
            elemSignature = elemSignature + TypeLoader45.extractArgument(beginIndex + 1, signature);
        } else if (elemType == 'L') {
            int endSignatureIndex = signature.indexOf(59, beginIndex);
            assert (0 <= endSignatureIndex && endSignatureIndex < signature.length());
            elemSignature = signature.substring(beginIndex, endSignatureIndex + 1);
        }
        return elemSignature;
    }

    private static ArrayList<TypeDescription> paramSignatureToType(String signature) {
        String argumentSignature;
        ArrayList<TypeDescription> argumentSignatured = new ArrayList<TypeDescription>();
        for (int index = 0; index < signature.length(); index += argumentSignature.length()) {
            argumentSignature = TypeLoader45.extractArgument(index, signature);
            char elemType = argumentSignature.charAt(0);
            TypeDescription type = elemType == '[' ? TypeFactory.getArray(TypeFactory.getAny()) : (elemType == 'L' ? TypeFactory.getAny() : TypeLoader45.getSignature(elemType));
            argumentSignatured.add(type);
        }
        return argumentSignatured;
    }

    private static void initializeSignatures() {
        signatureToTypeDescription.put(Character.valueOf('B'), TypeFactory.getPrimitiveBool());
        signatureToTypeDescription.put(Character.valueOf('S'), TypeFactory.getPrimitiveInt(16));
        signatureToTypeDescription.put(Character.valueOf('I'), TypeFactory.getPrimitiveInt(32));
        signatureToTypeDescription.put(Character.valueOf('J'), TypeFactory.getPrimitiveInt(64));
        signatureToTypeDescription.put(Character.valueOf('F'), TypeFactory.getPrimitiveReal(32));
        signatureToTypeDescription.put(Character.valueOf('D'), TypeFactory.getPrimitiveReal(64));
    }

    private static Object convert(TypeDescription type, String value) {
        Class<?> targetClass = type.getJavaClass();
        return value == null || value.equals("") || !type.isPredefined() ? DefaultValue.forClass(targetClass) : Conversion.convertTo(value, targetClass);
    }

    private void manageSourceCode(Attributes amap) throws SAXException {
        String language = amap.getValue("language");
        if (language == null) {
            throw new SAXException("The attribute 'language' is mandatory for the sourceCode tag");
        }
        this.sourceCodeBuilder = new SourceCodeBuilder(language);
    }

    private TypeDescription getCurrentType() {
        TypeDescriptionImpl type = this.methodStage ? this.currentMethod : (this.currentAttribute != null ? this.currentAttribute : this.currentObject);
        return type;
    }

    private void addMember(ObjectTypeDescription object, MethodTypeDescription member) {
        try {
            if (member.isAttribute()) {
                AttributeTypeDescription prev;
                this.replaceInOutModifiers(member);
                int position = member.getPosition();
                if (position != -1 && (prev = object.findAttributeByPosition(position)) != null) {
                    member.asAttribute().setPosition(-1);
                }
            }
            object.addMember(member);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private String cachedString(String string) {
        return string != null ? this.stringCache.getString(string) : null;
    }

    private void changeDecimalAttributes(ObjectTypeDescription otd) {
        int count = otd.getMemberCount();
        for (int i = 0; i < count; ++i) {
            TypeDescription elementType;
            ArrayTypeDescription array;
            TypeRef elementRef;
            Argument arg;
            TypeRef ref;
            MethodTypeDescription member = otd.getMemberType(i);
            if (!member.isAttribute() || !((ref = (arg = member.getResultArgument()).getTypeRef()) instanceof TypeDescription)) continue;
            TypeDescription resultType = ref.get();
            if (resultType.isDecimal() && resultType.getScale() < 0) {
                member.setResultType(TypeFactory.getDecimal());
            }
            if (!resultType.isArray() || !((elementRef = (array = (ArrayTypeDescription)resultType).getElementTypeRef()) instanceof TypeDescription) || !(elementType = elementRef.get()).isDecimal() || elementType.getScale() >= 0) continue;
            array.setElementType(TypeFactory.getDecimal());
        }
    }

    private void checkComIterators(ObjectTypeDescription otd) {
        if ("COM".equals(otd.getComponentType())) {
            boolean isIterable = otd.findMember("_NewEnum", TypeFinder.Scope.CURRENT) != null;
            TypeRef elementType = TypeFactory.getAny();
            MethodTypeDescription getItem = otd.findMember("getItem", TypeFinder.Scope.CURRENT);
            if (getItem != null && otd.findMember("count", TypeFinder.Scope.CURRENT) != null) {
                isIterable = true;
                elementType = getItem.getResultArgument().getTypeRef();
            }
            if (isIterable) {
                otd.setModifiers(otd.getModifiers() | 0x800000000L);
                otd.setElementType(elementType);
            }
        }
    }

    private void checkEjbType(ObjectTypeDescription currentObject) {
        String interfaces;
        if ("ejb".equals(currentObject.getComponentType()) && (interfaces = currentObject.getProperty("implementedInterfaces")) != null && interfaces.indexOf("javax.ejb.EJBHome") != -1) {
            currentObject.addMember(currentObject.createConstructor());
            currentObject.setModifiers(currentObject.getModifiers() & 0xFFFFFFFFFFFFFBFFL);
            currentObject.addModifier(0x10000000L);
        }
    }

    private void checkSqlType(ObjectTypeDescription currentObject) {
        if (currentObject.getSignature().indexOf("ProcedureSQLObject") != -1) {
            return;
        }
        if (ComponentType.SQL.getText().equals(currentObject.getComponentType()) && !"SqlObject".equals(currentObject.getName())) {
            TypeRef type = this.typeOf("Fuego.Sql.SqlObject", null);
            boolean found = false;
            for (SuperType superType : currentObject.getSuperTypes()) {
                if (!"Fuego.Sql.SqlObject".equals(superType.getText())) continue;
                found = true;
                break;
            }
            if (found) {
                return;
            }
            currentObject.addSuperType(new SuperType(type, 32768L));
            ArrayList<MethodTypeDescription> membersToRemove = null;
            int count = currentObject.getMemberCount();
            for (int i = 0; i < count; ++i) {
                MethodTypeDescription member = currentObject.getMember(i);
                if (member.isAttribute()) {
                    String pk;
                    AttributeTypeDescription attribute = member.asAttribute();
                    String position = member.getProperty("position");
                    if (position != null) {
                        attribute.setPosition(Integer.parseInt(position.trim()));
                    }
                    if ("true".equals(pk = member.getProperty("primaryKey"))) {
                        attribute.setPrimaryKey(true);
                    }
                    if (member.getResultType().isPrimitive()) {
                        member.setResultType(member.getResultType().primitiveEquivalent(false));
                    }
                }
                if (!member.isMethod() || member.isConstructor()) continue;
                if (membersToRemove == null) {
                    membersToRemove = new ArrayList<MethodTypeDescription>();
                }
                membersToRemove.add(member);
            }
            if (membersToRemove != null) {
                for (MethodTypeDescription method : membersToRemove) {
                    currentObject.removeMember(method);
                }
            }
        }
    }

    private MethodTypeDescription createGroupMethod(AttributeTypeDescription att, ObjectTypeDescription inner, MethodTypeDescription userMethod, String vvMethodName) {
        String methodCode = "return " + userMethod.getName() + "(currentRow)";
        MethodTypeDescription listMethodTD = new MethodTypeDescription(userMethod.getName() + "List", 32768L);
        listMethodTD.setResultType(userMethod.getResultArgument().getTypeRef());
        listMethodTD.setSignature(listMethodTD.getJavaSignature());
        listMethodTD.setCode(methodCode, "Fuego");
        this.addMember(inner, listMethodTD);
        att.setValidValuesMethod(listMethodTD.getName());
        return TypeLoader45.createDynamicMethod(listMethodTD, vvMethodName);
    }

    private Field getFieldForName(Class cl, String qName) throws NoSuchFieldException {
        Field field;
        try {
            field = cl.getField(qName);
        }
        catch (NoSuchFieldException nsfe) {
            field = cl.getField(qName + "_d");
        }
        return field;
    }

    private String getLanguage(Attributes amap) {
        String language = amap.getValue("language");
        return language != null ? language : "Fuego";
    }

    private String[] getValuesAsArray(String val) {
        int fistComma = val.indexOf(44) + 1;
        val = val.substring(fistComma, val.length() - 1);
        return val.split(",");
    }

    private boolean isArrayOfArrayOfAny(TypeRef typeRef) {
        return typeRef.getKind() == 12 && typeRef.getText().equals("Any[][]");
    }

    private boolean isType(TypeRef type) {
        return type instanceof TypeDescription && !(type instanceof DynamicRef) && !(type instanceof UnknownType);
    }

    private ObjectTypeDescription loadImpl(InputStream stream) throws ComponentLoadingException {
        this.reset();
        this.inputSrc = new InputSource(stream);
        try {
            ObjectTypeDescription result;
            Object migrator;
            this.parser.parse(this.inputSrc);
            if (this.currentObject != null) {
                this.currentObject.setRemote(this.remote);
                this.migrateXObject(this.currentObject);
            }
            if (this.currentObject instanceof XObjectTypeDescription) {
                ((XObjectTypeDescription)this.currentObject).setPresentations(this.presentations);
                this.presentations = null;
                XObjectTypeDescription xotd = (XObjectTypeDescription)this.currentObject;
                if (TypeLoader45.mustMigrateVersion4(xotd)) {
                    XObjectFactory.setXOPresentable(xotd, true);
                    BpmObjectFactory.setProperties(xotd);
                    xotd.setProperty("legacy", "true");
                    this.migrateAttributes(xotd);
                    this.migrateDecimalAttributes(xotd);
                    this.migrateValidValues(xotd);
                    migrator = new Presentation4Migrator(xotd, this.currentParentName, this.requiredAttributes);
                    xotd = ((AbstractPresentationMigrator)migrator).migrate();
                    xotd.setVersionID("");
                } else if (this.hasLegacyValidValuesMethods) {
                    this.migrateLegacyValidValues(xotd);
                }
                if (TypeLoader45.mustMigrateVersion5(xotd)) {
                    migrator = new Presentation5Migrator(xotd, this.currentParentName, this.requiredAttributes);
                    xotd = ((AbstractPresentationMigrator)migrator).migrate();
                }
            }
            if ((result = this.getObject()) == null) {
                throw new SAXException("XCDL file seems not to be valid. Component name:" + this.currentComponentName);
            }
            migrator = result;
            return migrator;
        }
        catch (SAXParseException parseExc) {
            Msg msg = CoreMsg.PARSE_ERROR(String.valueOf(parseExc.getLineNumber()), String.valueOf(parseExc.getColumnNumber()), parseExc.getSystemId());
            TypeLoader45.warning(msg.toString());
            if (parseExc.getException() != null) {
                TypeLoader45.warning(parseExc.getException());
            } else {
                TypeLoader45.warning(parseExc);
            }
            throw new ComponentLoadingException(this.getObject(), msg.toString());
        }
        catch (SAXException e) {
            TypeLoader45.warning(e);
            throw new ComponentLoadingException(this.getObject(), (Throwable)e);
        }
        catch (Exception e) {
            TypeLoader45.warning(e);
            throw new ComponentLoadingException(this.getObject(), (Throwable)e);
        }
        finally {
            this.reset();
        }
    }

    private void manageArrayOrIteratorInfo(Attributes amap, boolean isArray) {
        TypeDescription type;
        AttributeTypeDescription m = new AttributeTypeDescription(amap.getValue("name"), TypeFactory.getAny());
        String elementType = "";
        String modifiers = "";
        String javaType = null;
        boolean primitive = false;
        String calculateExpr = null;
        block20: for (int i = 0; i < amap.getLength(); ++i) {
            String attname = amap.getQName(i);
            String value = amap.getValue(i);
            switch (stringMapping.get(attname)) {
                case 46: {
                    elementType = value;
                    continue block20;
                }
                case 31: 
                case 42: {
                    continue block20;
                }
                case 45: {
                    m.setTemplate(value);
                    continue block20;
                }
                case 10: {
                    m.setDescription(value);
                    continue block20;
                }
                case 82: {
                    m.setReplacement(value);
                    continue block20;
                }
                case 14: 
                case 30: {
                    modifiers = value;
                    continue block20;
                }
                case 38: {
                    primitive = Boolean.parseBoolean(value);
                    continue block20;
                }
                case 20: {
                    m.setVisible(Boolean.parseBoolean(value));
                    continue block20;
                }
                case 25: 
                case 36: {
                    continue block20;
                }
                case 51: {
                    m.setWriteSignature(value);
                    continue block20;
                }
                case 40: {
                    m.setReadSignature(value);
                    continue block20;
                }
                case 23: {
                    javaType = value;
                    continue block20;
                }
                case 6: {
                    calculateExpr = value;
                    continue block20;
                }
                case 84: {
                    try {
                        m.setPosition(Integer.parseInt(value));
                    }
                    catch (NumberFormatException e) {
                        TypeLoader45.warning("Invalid primary key value: '" + value + "' for attribute " + m);
                    }
                    continue block20;
                }
                default: {
                    TypeLoader45.warning("Invalid attribute " + attname + " in array or iterator");
                }
            }
        }
        if (isArray) {
            type = ArrayTypeDescription.valueOf("", elementType, javaType, this.catalog, true, this.currentGroup != null ? this.currentGroup : this.currentObject);
            type = type.get().primitiveEquivalent(primitive);
        } else {
            try {
                type = IteratorTypeDescription.createLazyIterator(elementType, this.catalog);
            }
            catch (IllegalTypeException e) {
                type = TypeFactory.getNone();
            }
        }
        m.setModifiers(Modifier.getModifiers(modifiers) & 0xFFFFFFFFFFFFFFDFL);
        if (calculateExpr != null) {
            m.setCode(SourceCode.create("return " + calculateExpr, "Fuego"));
            m.setCalculated(true);
        }
        m.setJavaType(javaType);
        m.setType(type);
        if (this.currentGroup != null) {
            this.addMember(this.currentGroup, m);
        } else {
            this.addMember(this.currentObject, m);
        }
        this.currentAttribute = m;
    }

    private void manageDocumentation(Attributes amap) {
        this.currentDocType = DocumentationType.valueOf(amap.getValue("type"));
        this.currentDocLanguage = Locales.valueOf(amap.getValue("language"));
    }

    private void manageDisplayName(Attributes amap) {
        this.displayName = new DisplayName(amap.getValue("language"));
    }

    private void manageEnumerationInfo(Attributes amap) {
        String name = "";
        String description = "";
        String className = null;
        String componentType = null;
        String versionID = "";
        boolean nativeEnum = false;
        block11: for (int i = 0; i < amap.getLength(); ++i) {
            String attname = amap.getQName(i);
            String value = amap.getValue(i);
            switch (stringMapping.get(attname)) {
                case 31: {
                    name = value;
                    continue block11;
                }
                case 7: {
                    className = value;
                    continue block11;
                }
                case 16: {
                    continue block11;
                }
                case 10: {
                    description = value;
                    continue block11;
                }
                case 46: {
                    componentType = value;
                    continue block11;
                }
                case 54: {
                    continue block11;
                }
                case 56: {
                    continue block11;
                }
                case 59: {
                    versionID = value;
                }
                case 86: {
                    nativeEnum = Boolean.parseBoolean(value);
                    continue block11;
                }
            }
        }
        if (this.currentObject == null) {
            JavaEnumTypeDescription enumTypeDescription = JavaEnumTypeDescription.create(name, description);
            enumTypeDescription.setNativeEnum(nativeEnum);
            this.currentObject = enumTypeDescription;
        }
        this.currentObject.setName(name);
        this.currentObject.setDescription(description);
        ((JavaEnumTypeDescription)this.currentObject).setOriginalClass(className);
        if (componentType != null && !componentType.equals("object")) {
            this.currentObject.setComponentType(componentType);
        }
        this.currentObject.setVersionID(versionID);
        this.currentObject.setCatalog(this.catalog);
    }

    private void manageExceptionInfo(Attributes amap) {
        String className = amap.getValue("type");
        if (className == null || this.currentMethod == null) {
            return;
        }
        this.currentMethod.addException(this.typeOf(className, null));
    }

    private void manageInheritInfo(Attributes amap) {
        String superclass = amap.getValue("class");
        long flags = Modifier.getModifiers(amap.getValue("flags"));
        if (!Modifier.isPrivate(flags) && !Modifier.isProtected(flags)) {
            flags |= 0x8000L;
        }
        if (superclass == null) {
            TypeLoader45.warning("Missing attribute 'class' for tag 'inherit'. Current type: " + this.currentObject);
        } else {
            if (superclass.equals("Fuego.Internal.GroupElement")) {
                this.isGroupElement = true;
                return;
            }
            SuperType cl = superclass.equals("Any") ? new SuperType(TypeFactory.getAny(), flags) : new SuperType(this.typeOf(superclass, null), flags);
            this.superclasses.add(cl);
        }
    }

    private void manageInputArgument(Attributes amap) {
        TypeRef type;
        String name = "";
        String description = "";
        String javaType = null;
        long modifiers = 0L;
        String typeText = null;
        String defaultValue = null;
        boolean primitive = false;
        int length = amap.getLength();
        block9: for (int i = 0; i < length; ++i) {
            String attname = amap.getQName(i);
            String value = amap.getValue(i);
            switch (stringMapping.get(attname)) {
                case 31: {
                    name = value.intern();
                    continue block9;
                }
                case 10: {
                    description = value;
                    continue block9;
                }
                case 14: 
                case 30: {
                    modifiers = Modifier.getModifiers(value);
                    continue block9;
                }
                case 23: {
                    javaType = value;
                    continue block9;
                }
                case 38: {
                    primitive = Boolean.parseBoolean(value);
                    continue block9;
                }
                case 46: {
                    typeText = value;
                    continue block9;
                }
                case 9: {
                    defaultValue = value;
                    continue block9;
                }
                default: {
                    TypeLoader45.warning("Invalid attribute " + attname + " in input argument declaration method " + this.currentMethod.getName());
                }
            }
        }
        String componentType = this.currentObject.getComponentType();
        String signature = this.currentMethod.getSignature();
        boolean methodSignature = signature != null && (signature.charAt(0) == 'M' || signature.charAt(0) == 'K');
        String versionID = this.currentObject.getVersionID();
        if (methodSignature && (versionID.startsWith("Version 4.5") || versionID.startsWith("Version 4.2")) && "Int".equals(typeText) && primitive && componentType != null && componentType.equals("java")) {
            int argIndex = this.currentMethod.getArguments().length;
            type = TypeLoader45.extractTypeFromMethodSignature(signature, argIndex);
        } else if (typeText.indexOf(46) == -1 && typeText.equals(this.currentObject.getName())) {
            type = this.currentObject;
        } else {
            type = this.typeOf(typeText, javaType);
            if (this.isType(type)) {
                type = type.get().primitiveEquivalent(primitive);
            }
        }
        Argument arg = new Argument(this.cachedString(name), type, modifiers);
        arg.setJavaType(this.cachedString(javaType));
        arg.setDefaultValue(defaultValue);
        arg.setDescription(description);
        this.currentMethod.addArgument(arg);
        this.currentArgument = arg;
    }

    private void manageMapInfo(Attributes amap) {
        TypeRef indexType = null;
        String typeText = null;
        String name = "";
        String description = "";
        String modifiers = "";
        String writeSignature = null;
        String readSignature = null;
        String javaType = null;
        boolean ordered = false;
        boolean isVisible = true;
        String replacement = null;
        int pkOrder = -1;
        block18: for (int i = 0; i < amap.getLength(); ++i) {
            String attname = amap.getQName(i);
            String value = amap.getValue(i);
            switch (stringMapping.get(attname)) {
                case 46: {
                    typeText = value;
                    continue block18;
                }
                case 17: {
                    indexType = this.typeOf(value, null);
                    continue block18;
                }
                case 31: {
                    name = value;
                    continue block18;
                }
                case 42: {
                    continue block18;
                }
                case 34: {
                    ordered = Boolean.parseBoolean(value);
                    continue block18;
                }
                case 20: {
                    isVisible = Boolean.parseBoolean(value);
                    continue block18;
                }
                case 10: {
                    description = value;
                    continue block18;
                }
                case 51: {
                    writeSignature = value;
                    continue block18;
                }
                case 40: {
                    readSignature = value;
                    continue block18;
                }
                case 82: {
                    replacement = value;
                    continue block18;
                }
                case 23: {
                    javaType = value;
                    continue block18;
                }
                case 14: 
                case 30: {
                    modifiers = value;
                    continue block18;
                }
                case 25: 
                case 36: {
                    continue block18;
                }
                case 84: {
                    try {
                        pkOrder = Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        TypeLoader45.warning("Invalid primary key value: '" + value + "' for attribute " + name);
                    }
                    continue block18;
                }
                default: {
                    TypeLoader45.warning("Invalid attribute " + attname + " in map");
                }
            }
        }
        TypeRef type = this.typeOf(typeText, javaType);
        AttributeTypeDescription m = new AttributeTypeDescription(name, ordered ? TypeFactory.getSortedMap(type, indexType) : TypeFactory.getMap(type, indexType));
        m.setVisible(isVisible);
        m.setDescription(description);
        m.setModifiers(Modifier.getModifiers(modifiers) & 0xFFFFFFFFFFFFFFDFL);
        m.setWriteSignature(writeSignature);
        m.setReadSignature(readSignature);
        m.setJavaType(javaType);
        m.setPosition(pkOrder);
        if (replacement != null) {
            m.setReplacement(replacement);
        }
        this.addMember(this.currentObject, m);
        this.currentAttribute = m;
    }

    private void manageMethodInfo(Attributes amap) throws SAXException {
        String name = amap.getValue("name");
        if (name == null) {
            throw new SAXException("The attribute 'name' is null");
        }
        this.currentLanguage = null;
        this.currentMethod = new MethodTypeDescription(name);
        int length = amap.getLength();
        block11: for (int i = 0; i < length; ++i) {
            String attname = amap.getQName(i);
            String value = amap.getValue(i);
            switch (stringMapping.get(attname)) {
                case 44: {
                    this.currentMethod.setSignature(value);
                    continue block11;
                }
                case 10: {
                    this.currentMethod.setDescription(value);
                    continue block11;
                }
                case 82: {
                    this.currentMethod.setReplacement(value);
                    continue block11;
                }
                case 45: {
                    this.currentMethod.setTemplate(value);
                    continue block11;
                }
                case 14: 
                case 30: {
                    this.currentMethod.setModifiers(Modifier.getModifiers(value));
                    continue block11;
                }
                case 25: 
                case 31: 
                case 43: {
                    continue block11;
                }
                case 20: {
                    this.currentMethod.setVisible(Boolean.parseBoolean(value));
                    continue block11;
                }
                case 53: {
                    continue block11;
                }
                case 79: {
                    this.currentLanguage = value;
                    continue block11;
                }
                default: {
                    TypeLoader45.warning("Invalid attribute " + attname + " in method declaration");
                }
            }
        }
    }

    private void manageObjectData(Attributes amap) {
        String type = amap.getValue("type");
        this.managePredefinedData(type, null, amap);
    }

    private void manageOutputArgument(Attributes amap) {
        TypeRef type;
        String typeText = null;
        String javaType = null;
        String name = "return";
        String description = "";
        String modifiers = null;
        boolean primitive = false;
        block8: for (int i = 0; i < amap.getLength(); ++i) {
            String attname = amap.getQName(i);
            String value = amap.getValue(i);
            switch (stringMapping.get(attname)) {
                case 46: {
                    typeText = value;
                    continue block8;
                }
                case 23: {
                    javaType = value;
                    continue block8;
                }
                case 14: 
                case 30: {
                    modifiers = value;
                    continue block8;
                }
                case 31: {
                    name = value;
                    continue block8;
                }
                case 10: {
                    description = value;
                    continue block8;
                }
                case 38: {
                    primitive = Boolean.parseBoolean(value);
                    continue block8;
                }
                default: {
                    TypeLoader45.warning("Invalid attribute " + attname + " in output argument declaration method " + this.currentMethod.getName());
                }
            }
        }
        if ("Fuego.XObjectValidationException[]".equalsIgnoreCase(typeText)) {
            typeText = "Fuego.Lang.ValidationException[]";
        }
        if (this.isType(type = this.typeOf(typeText, javaType))) {
            type = type.get().primitiveEquivalent(primitive);
        }
        this.currentMethod.setResultType(type);
        this.currentMethod.getResultArgument().setJavaType(javaType);
        this.currentMethod.getResultArgument().setName(name);
        this.currentMethod.getResultArgument().setDescription(description);
        this.currentMethod.getResultArgument().setModifiers(Modifier.getModifiers(modifiers) | 0x10L);
    }

    private void managePredefinedData(String typeText, TypeRef type, Attributes amap) {
        this.memberProperties = null;
        AttributeTypeDescription m = new AttributeTypeDescription(amap.getValue("name"), type == null ? TypeFactory.getAny() : type);
        m.setModifiers(32L);
        String defaultValue = null;
        Boolean required = null;
        String validValues = null;
        boolean primitive = false;
        String calculateExpr = null;
        boolean hasDefaultExpression = false;
        int precision = type != null && this.isType(type) && type.get().getKind() == 6 ? 2 : -1;
        int length = -1;
        block28: for (int i = 0; i < amap.getLength(); ++i) {
            String attname = amap.getQName(i);
            String value = amap.getValue(i);
            switch (stringMapping.get(attname)) {
                case 31: {
                    continue block28;
                }
                case 10: {
                    m.setDescription(value);
                    continue block28;
                }
                case 49: {
                    m.addCheckCode(new Validation(value, "Fuego2"));
                    continue block28;
                }
                case 82: {
                    m.setReplacement(value);
                    continue block28;
                }
                case 48: {
                    if (this.memberProperties == null) {
                        this.memberProperties = new TreeMap<String, String>();
                    }
                    this.memberProperties.put("validValuesMethodName", JavaClass.getMethodNameFromSignature(value));
                    continue block28;
                }
                case 51: {
                    m.setWriteSignature(value);
                    continue block28;
                }
                case 40: {
                    m.setReadSignature(value);
                    continue block28;
                }
                case 23: {
                    m.setJavaType(value);
                    continue block28;
                }
                case 38: {
                    primitive = Boolean.parseBoolean(value);
                    continue block28;
                }
                case 6: {
                    calculateExpr = value;
                    continue block28;
                }
                case 46: {
                    continue block28;
                }
                case 9: {
                    defaultValue = value;
                    continue block28;
                }
                case 58: {
                    this.defaultExpressions.put(m.getName(), value);
                    hasDefaultExpression = true;
                    continue block28;
                }
                case 43: {
                    continue block28;
                }
                case 47: {
                    validValues = value;
                    continue block28;
                }
                case 14: 
                case 30: {
                    long modif = Modifier.getModifiers(value);
                    if (!Modifier.hasAccessModifiers(modif &= 0xFFFFFFFFFFFFFFDFL)) {
                        modif |= 0x8000L;
                    }
                    m.setModifiers(modif);
                    continue block28;
                }
                case 42: {
                    required = Boolean.valueOf(value);
                    continue block28;
                }
                case 20: {
                    m.setVisible(Boolean.parseBoolean(value));
                    continue block28;
                }
                case 36: {
                    precision = Integer.parseInt(value);
                    continue block28;
                }
                case 25: {
                    length = Integer.parseInt(value);
                    continue block28;
                }
                case 45: {
                    m.setTemplate(value);
                    continue block28;
                }
                case 84: {
                    try {
                        m.setPosition(Integer.parseInt(value));
                    }
                    catch (NumberFormatException e) {
                        TypeLoader45.warning("Invalid primary key value: '" + value + "' for attribute " + m);
                    }
                    continue block28;
                }
                default: {
                    TypeLoader45.warning("XObject type description attribute '" + attname + "' not valid while processing Predefined attributes");
                }
            }
        }
        if (type != null) {
            block46: {
                TypeDescription td = type.get();
                if (length != -1) {
                    td = td.setLength(length);
                }
                td = td.primitiveEquivalent(primitive);
                type = td;
                try {
                    if (defaultValue == null && this.currentObject.isBpmObject() && TypeLoader45.mustMigrateVersion4(this.currentObject) && calculateExpr == null && !hasDefaultExpression) {
                        defaultValue = td.isNumber() ? "0" : "";
                    }
                    if (defaultValue != null && !defaultValue.equals("") && TypeLoader45.convert(td, defaultValue) == null) {
                        defaultValue = null;
                    }
                }
                catch (IllegalConversionException ite) {
                    defaultValue = null;
                    if (!this.currentObject.isBpmObject() || !TypeLoader45.mustMigrateVersion4(this.currentObject) || calculateExpr != null) break block46;
                    defaultValue = td.isNumber() ? "0" : "";
                }
            }
            if (required != null && required.booleanValue() && this.currentObject.isBpmObject() && TypeLoader45.mustMigrateVersion4(this.currentObject)) {
                this.requiredAttributes.add(m.getName());
                required = null;
            }
        }
        StringList valuesList = null;
        if (validValues != null) {
            StringTokenizer st = new StringTokenizer(validValues, "|");
            valuesList = StringList.create();
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                valuesList.add(s);
            }
        }
        if (type != null) {
            m.setType(type);
            if (required != null) {
                m.setRequired(required);
            }
            m.setDefaultValue(defaultValue);
            m.setValidValues(valuesList);
            m.setPrecision(precision);
            if (length != -1) {
                m.setMemberLength(length);
            }
        } else {
            m.setType(this.typeOf(typeText, null));
        }
        if (this.currentGroup != null) {
            this.addMember(this.currentGroup, m);
        } else {
            if (this.isGroupElement && "currentRow".equals(m.getName()) && Modifier.isHidden(m.getModifiers())) {
                int position = m.getPosition();
                m = XObjectFactory.createCurrentRow(this.currentObject, this.currentParentName != null ? this.currentParentName : "");
                m.setPosition(position);
            }
            this.addMember(this.currentObject, m);
        }
        if (calculateExpr != null) {
            m.setCode(SourceCode.create("return " + calculateExpr, "Fuego"));
            m.setCalculated(true);
        }
        this.currentAttribute = m;
    }

    private void managePresentationCharacters(char[] ch, int start, int length) {
        if (!this.presentationStage) {
            return;
        }
        String content = new String(ch, start, length);
        XFormXMLObject poped = this.currentElement.peek();
        if (poped instanceof XFormValue) {
            try {
                Field field = poped.getClass().getField("value_d");
                String tmp = (String)field.get(poped);
                field.set(poped, tmp + content.trim());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void managePresentationEndElement(String name) {
        if (!this.presentationStage) {
            return;
        }
        XFormXMLObject poped = this.currentElement.pop();
        if (name.equalsIgnoreCase("presentation")) {
            String id;
            if (this.presentations == null) {
                this.presentations = new HashMap<String, XFormPresentationModel>();
            }
            if ((id = this.pModel.presentation_d.id) == null) {
                throw new IllegalStateException("Presentation without id in component : " + this.currentComponentName);
            }
            this.pModel.migrate();
            this.pModel.name_d = id;
            this.presentations.put(id, this.pModel);
            this.pModel = null;
            this.currentElement = new Stack();
        } else {
            poped.init();
        }
    }

    private void manageResourceStart(String name, Attributes atts) {
        if (!this.resourcesStage) {
            return;
        }
        if (name.equals("resource")) {
            this.currentResourceKey = atts.getValue("default");
            String value = atts.getValue("type");
            if (value != null) {
                this.currentResourceType = Integer.parseInt(value);
            }
        } else if (name.equals("label")) {
            this.currentResourceLocale = atts.getValue("language");
        }
    }

    private void managePresentationStartElement(String name, Attributes amap) {
        if (!this.presentationStage) {
            return;
        }
        if (name.equalsIgnoreCase("presentation")) {
            this.pModel = new XFormPresentationModel(this.currentObject);
        }
        String newClass = currentPackage + name.substring(0, 1).toUpperCase() + name.substring(1, name.length());
        try {
            Class<?> newOneClass = Class.forName(newClass);
            XFormXMLObject newOne = (XFormXMLObject)newOneClass.newInstance();
            if (this.currentElement.empty()) {
                this.currentElement.push(newOne);
                Field field = this.pModelFieldCache.get(name);
                if (field == null) {
                    field = this.getFieldForName(this.pModel.getClass(), name);
                    this.pModelFieldCache.put(name, field);
                }
                field.set(this.pModel, newOne);
                newOne.setParent(this.pModel);
            } else {
                Field field;
                XFormXMLObject lastElement = this.currentElement.peek();
                this.currentElement.push(newOne);
                newOne.setParent(lastElement);
                Class<?> lastElementClass = lastElement.getClass();
                try {
                    field = this.getFieldForName(lastElementClass, name);
                }
                catch (NoSuchFieldException nsfe) {
                    try {
                        field = lastElement.getClass().getField(name + "_entities_d");
                    }
                    catch (NoSuchFieldException nsfe3) {
                        field = lastElement.getClass().getField(name + "_entity_d");
                    }
                }
                if (field.getType().isArray()) {
                    if (field.getType().getComponentType().equals(newOneClass)) {
                        XFormXMLObject[] val = (XFormXMLObject[])field.get(lastElement);
                        if (val == null) {
                            val = (XFormXMLObject[])Array.newInstance(field.getType().getComponentType(), 0);
                        }
                        Object newArray = Array.newInstance(field.getType().getComponentType(), val.length + 1);
                        System.arraycopy(val, 0, newArray, 0, val.length);
                        Array.set(newArray, val.length, newOne);
                        field.set(lastElement, newArray);
                    }
                } else {
                    field.set(lastElement, newOne);
                }
            }
            for (int i = 0; i < amap.getLength(); ++i) {
                Field field;
                String qname = amap.getQName(i);
                try {
                    field = this.getFieldForName(newOne.getClass(), qname);
                }
                catch (NoSuchFieldException nsfe) {
                    Log.logDebug(nsfe.getMessage());
                    continue;
                }
                Class<?> fieldType = field.getType();
                String fieldName = fieldType.toString();
                String[] eachValue = amap.getValue(i);
                if (eachValue.trim().length() == 0) continue;
                if ("int".equals(fieldName)) {
                    field.setInt(newOne, Integer.parseInt((String)eachValue));
                    continue;
                }
                if ("boolean".equals(fieldName)) {
                    field.setBoolean(newOne, Boolean.parseBoolean((String)eachValue));
                    continue;
                }
                if ("double".equals(fieldName)) {
                    field.setDouble(newOne, Double.parseDouble((String)eachValue));
                    continue;
                }
                if (Enum.class.isAssignableFrom(fieldType)) {
                    Field aField = null;
                    try {
                        aField = fieldType.getField((String)eachValue);
                    }
                    catch (NoSuchFieldException e) {
                        aField = fieldType.getField(this.migrateFontStyle((String)eachValue));
                    }
                    field.set(newOne, aField.get(null));
                    continue;
                }
                Object[] objectValue = eachValue;
                if (fieldType.isArray()) {
                    Class<?> type = fieldType.getComponentType();
                    if (String.class.equals(type)) {
                        objectValue = this.getValuesAsArray((String)eachValue);
                    } else if (Integer.TYPE.equals(type)) {
                        String[] stringValues = this.getValuesAsArray((String)eachValue);
                        int[] values = new int[stringValues.length];
                        for (int j = 0; j < values.length; ++j) {
                            values[j] = Integer.parseInt(stringValues[j]);
                        }
                        objectValue = values;
                    }
                }
                field.set(newOne, objectValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String migrateFontStyle(String eachValue) {
        String f = "PLAIN";
        String lowerValue = eachValue.toLowerCase();
        boolean isBold = lowerValue.contains("bold");
        boolean isItalic = lowerValue.contains("italic");
        if (isBold && isItalic) {
            f = "BOLD_ITALIC";
        } else if (isBold) {
            f = "BOLD";
        } else if (isItalic) {
            f = "ITALIC";
        }
        return f;
    }

    private void manageTransformationFieldMappingInfo(Attributes amap) {
        String name = null;
        boolean isExpression = false;
        block4: for (int i = 0; i < amap.getLength(); ++i) {
            String attname = amap.getQName(i);
            switch (stringMapping.get(attname)) {
                case 69: {
                    name = amap.getValue(i);
                    continue block4;
                }
                case 70: {
                    isExpression = Boolean.parseBoolean(amap.getValue(i));
                }
            }
        }
        this.fieldMappingLanguage = this.getLanguage(amap);
        this.currentTransformationFieldMapping = new TransformTypeDescription.FieldMapping();
        this.currentTransformationFieldMapping.setTargetField(name);
        this.currentTransformationFieldMapping.setExpression(isExpression);
        this.currentTransformation.addFieldMapping(this.currentTransformationFieldMapping);
    }

    private void manageTransformationInfo(Attributes amap) {
        String type = null;
        String name = null;
        String targetName = null;
        block5: for (int i = 0; i < amap.getLength(); ++i) {
            String attname = amap.getQName(i);
            switch (stringMapping.get(attname)) {
                case 67: {
                    type = amap.getValue(i);
                    continue block5;
                }
                case 68: {
                    targetName = amap.getValue(i);
                    continue block5;
                }
                case 31: {
                    name = amap.getValue(i);
                }
            }
        }
        this.currentTransformation.setName(name);
        this.currentTransformation.setTarget(this.typeOf(type, null));
        this.currentTransformation.setTargetName(targetName);
    }

    private void manageTransformationLocalVarsInfo(Attributes amap) {
        String type = null;
        String name = null;
        for (int i = 0; i < amap.getLength(); ++i) {
            String attname = amap.getQName(i);
            switch (stringMapping.get(attname)) {
                case 74: {
                    type = amap.getValue(i);
                    break;
                }
                case 75: {
                    name = amap.getValue(i);
                }
            }
            if (type == null || name == null) continue;
            TypeRef varType = this.typeOf(type, null);
            Variable localVar = new Variable(name, varType);
            this.currentLocalVars.add(localVar);
            name = null;
            type = null;
        }
    }

    private void manageTransformationSourceInfo(Attributes amap) {
        String type = null;
        String name = null;
        block4: for (int i = 0; i < amap.getLength(); ++i) {
            String attname = amap.getQName(i);
            switch (stringMapping.get(attname)) {
                case 46: {
                    type = amap.getValue(i);
                    continue block4;
                }
                case 31: {
                    name = amap.getValue(i);
                }
            }
        }
        this.currentTransformation.addSource(name, this.typeOf(type, null));
    }

    private void manageVariableInfo(Attributes amap) {
        String type = null;
        String name = null;
        for (int i = 0; i < amap.getLength(); ++i) {
            String attname = amap.getQName(i);
            switch (stringMapping.get(attname)) {
                case 46: {
                    type = amap.getValue(i);
                    break;
                }
                case 31: {
                    name = amap.getValue(i);
                }
            }
            if (type == null || name == null) continue;
            TypeRef varType = this.typeOf(type, null);
            Variable localVar = new Variable(name, varType);
            if (this.readStage) {
                this.currentAttribute.addVariable(localVar);
            } else if (this.writeStage) {
                this.currentAttribute.addWriteVariable(localVar);
            } else {
                this.currentMethod.addVariable(localVar);
            }
            name = null;
            type = null;
        }
    }

    private void migrateAttributes(XObjectTypeDescription xotd) {
        this.migratePrimitiveAttributes(xotd);
        for (int i = 0; i < xotd.getInnerTypeCount(); ++i) {
            this.migratePrimitiveAttributes(xotd.getInnerType(i));
        }
    }

    private void migrateDecimalAttributes(XObjectTypeDescription xotd) {
        this.changeDecimalAttributes(xotd);
        for (int i = 0; i < xotd.getInnerTypeCount(); ++i) {
            this.changeDecimalAttributes(xotd.getInnerType(i));
        }
    }

    private void migrateLegacyValidValues(ObjectTypeDescription otd) {
        int count = otd.getMemberCount();
        for (int i = 0; i < count; ++i) {
            MethodTypeDescription member = otd.getMemberType(i);
            if (!member.isAttribute()) continue;
            AttributeTypeDescription att = member.asAttribute();
            String userMethodName = att.getValidValuesMethod();
            StringList vvalues = att.getValidValues();
            String validValuesDescList = att.getProperty("validValuesDescriptionList");
            StringList descriptions = null;
            if (validValuesDescList != null) {
                descriptions = StringList.createTokenizing(validValuesDescList, ",");
            }
            String vvMethodName = att.getName() + "ValidValues";
            MethodTypeDescription oldMember = otd.findMethod(vvMethodName, TypeFinder.Scope.CURRENT);
            if (userMethodName != null) {
                String userAttributeNaem;
                MethodTypeDescription userMethod = otd.findMethod(userMethodName, TypeFinder.Scope.CURRENT);
                if (userMethod == null && (userAttributeNaem = att.getProperty("validValuesMethodName")) != null) {
                    userMethod = otd.findAttribute(userAttributeNaem, TypeFinder.Scope.CURRENT);
                }
                if (userMethod == null) continue;
                att.setValidValuesMethod(userMethod.getName());
                MethodTypeDescription methodTD = TypeLoader45.createDynamicMethod(userMethod, vvMethodName);
                if (oldMember != null) {
                    otd.removeMember(oldMember);
                }
                this.addMember(otd, methodTD);
                continue;
            }
            if (vvalues == null) continue;
            MethodTypeDescription methodTD = TypeLoader45.createListValidValuesMethod(att, vvMethodName, vvalues, descriptions);
            if (oldMember != null) {
                otd.removeMember(oldMember);
            }
            this.addMember(otd, methodTD);
        }
        int innerTypeCount = otd.getInnerTypeCount();
        for (int i = 0; i < innerTypeCount; ++i) {
            ObjectTypeDescription inner = otd.getInnerType(i);
            this.migrateLegacyValidValues(inner);
        }
    }

    private void migratePrimitiveAttributes(ObjectTypeDescription otd) {
        int count = otd.getMemberCount();
        for (int i = 0; i < count; ++i) {
            TypeDescription type;
            TypeRef resultRef;
            MethodTypeDescription member = otd.getMemberType(i);
            if (!member.isAttribute() || !((resultRef = member.getResultArgument().getTypeRef()) instanceof TypeDescription) || member.getName().equals("currentRow") || !(type = resultRef.get()).isPredefined() || !type.isPrimitive()) continue;
            type = type.primitiveEquivalent(false);
            member.setResultType(type);
        }
    }

    private void migrateValidValues(XObjectTypeDescription xotd) {
        int count = xotd.getMemberCount();
        for (int i = 0; i < count; ++i) {
            MethodTypeDescription member = xotd.getMemberType(i);
            if (!member.isAttribute()) continue;
            AttributeTypeDescription att = member.asAttribute();
            String userMethodName = att.getValidValuesMethod();
            StringList vvalues = att.getValidValues();
            String vvMethodName = att.getName() + "ValidValues";
            MethodTypeDescription oldMember = xotd.findMethod(vvMethodName, TypeFinder.Scope.CURRENT);
            if (userMethodName != null) {
                MethodTypeDescription userMethod = xotd.findMethod(userMethodName, TypeFinder.Scope.CURRENT);
                if (userMethod == null) continue;
                att.setValidValuesMethod(userMethod.getName());
                MethodTypeDescription methodTD = TypeLoader45.createDynamicMethod(userMethod, vvMethodName);
                if (oldMember != null) {
                    xotd.removeMember(oldMember);
                }
                this.addMember(xotd, methodTD);
                continue;
            }
            if (vvalues == null) continue;
            MethodTypeDescription methodTD = TypeLoader45.createListValidValuesMethod(att, vvMethodName, vvalues, null);
            if (oldMember != null) {
                xotd.removeMember(oldMember);
            }
            this.addMember(xotd, methodTD);
            String defaultValue = att.getDefaultValue();
            if (vvalues.contains(defaultValue)) continue;
            if (att.isRequired()) {
                att.setDefaultValue((String)vvalues.get(0));
                continue;
            }
            att.setDefaultValue(null);
        }
        for (int j = 0; j < xotd.getInnerTypeCount(); ++j) {
            ObjectTypeDescription inner = xotd.getInnerType(j);
            for (MethodTypeDescription innmtd : inner.getAttributes()) {
                AttributeTypeDescription att = innmtd.asAttribute();
                String userMethodName = att.getValidValuesMethod();
                StringList vvalues = att.getValidValues();
                String vvMethodName = att.getName() + "ValidValues";
                MethodTypeDescription oldMember = xotd.findMethod(vvMethodName, TypeFinder.Scope.CURRENT);
                if (userMethodName != null) {
                    MethodTypeDescription userMethod = xotd.findMethod(userMethodName, TypeFinder.Scope.CURRENT);
                    if (userMethod == null) continue;
                    MethodTypeDescription methodTD = this.createGroupMethod(att, inner, userMethod, vvMethodName);
                    if (oldMember != null) {
                        xotd.removeMember(oldMember);
                    }
                    this.addMember(inner, methodTD);
                    continue;
                }
                if (vvalues == null) continue;
                MethodTypeDescription methodTD = TypeLoader45.createListValidValuesMethod(att, vvMethodName, vvalues, null);
                if (oldMember != null) {
                    xotd.removeMember(oldMember);
                }
                this.addMember(inner, methodTD);
            }
        }
    }

    private void migrateXObject(ObjectTypeDescription otd) {
        if (!otd.isBpmObject()) {
            return;
        }
        int count = otd.getInnerTypeCount();
        for (int i = 0; i < count; ++i) {
            TypeLoader45.migrateExpressions(otd.getInnerType(i));
        }
    }

    private void replaceInOutModifiers(MethodTypeDescription member) {
        long modifiers = member.getModifiers();
        if (Modifier.isIn(modifiers)) {
            modifiers |= 4L;
        }
        if (Modifier.isOut(modifiers)) {
            modifiers |= 8L;
        }
        member.setModifiers(modifiers & 0xFFFFFFFFFFFFFFFCL);
    }

    private void reset() {
        this.currentObject = null;
        this.currentMethod = null;
        this.lastMethod = null;
        this.currentAttribute = null;
        this.superclasses.clear();
        this.memberProperties = null;
        this.objectProperties.clear();
        this.defaultExpressions.clear();
        this.requiredAttributes.clear();
        this.hasLegacyValidValuesMethods = false;
        this.isGroupElement = false;
        this.requireStage = false;
        this.ensureStage = false;
        this.checkStage = false;
        this.presentationStage = false;
        this.currentResource = null;
        this.currentResourceKey = null;
        this.currentResourceLocale = null;
        this.resourcesStage = false;
        this.remote = false;
        this.currentCode = null;
        this.currentGroup = null;
        this.isGroupElement = false;
        this.currentMethod = null;
        this.currentAttribute = null;
        this.inputSrc = null;
        if (this.currentElement != null) {
            this.currentElement.clear();
        }
    }

    private void setValidations(MethodTypeDescription member) {
        for (Validation validation : this.currentRequire) {
            if (validation.isEmpty()) continue;
            member.addRequireCode(validation);
        }
        this.currentRequire.clear();
        for (Validation validation : this.currentEnsure) {
            if (validation.isEmpty()) continue;
            member.addEnsureCode(validation);
        }
        this.currentEnsure.clear();
        for (Validation validation : this.currentCheck) {
            if (validation.isEmpty()) continue;
            member.addCheckCode(validation);
        }
        this.currentCheck.clear();
        if (this.currentRead != null) {
            member.setCode(this.trimCode(this.currentRead), this.readLanguage);
        }
        this.currentRead = null;
        if (this.currentWrite != null) {
            member.asAttribute().setWriteCode(this.trimCode(this.currentWrite), this.writeLanguage);
        }
        this.currentWrite = null;
    }

    private String trimCode(StringBuffer code) {
        String newCode = code.toString().replaceAll("\\s+$", "");
        if (newCode.length() > 0 && newCode.charAt(0) == '\n') {
            newCode = newCode.substring(1);
        }
        if (newCode.length() == 0 || newCode.charAt(newCode.length() - 1) != '\n') {
            newCode = newCode.concat("\n");
        }
        return newCode;
    }

    private TypeRef typeOf(String text, String javaType) {
        return TypeLoader45.typeOf(text, javaType, this.catalog, this.currentGroup != null ? this.currentGroup : this.currentObject);
    }

    static {
        stringMapping = new StringMap(1000);
        SUPER_TYPE_COMPARATOR = new SuperTypeComparator();
        stringMapping.put("arg", 1);
        stringMapping.put("argument", 52);
        stringMapping.put("array", 2);
        stringMapping.put("attributes", 3);
        stringMapping.put("boolean", 5);
        stringMapping.put("calculate", 6);
        stringMapping.put("className", 7);
        stringMapping.put("component", 8);
        stringMapping.put("defaultValue", 9);
        stringMapping.put("description", 10);
        stringMapping.put("dynamic", 11);
        stringMapping.put("enumeration", 12);
        stringMapping.put("exception", 13);
        stringMapping.put("flags", 14);
        stringMapping.put("group", 15);
        stringMapping.put("implementationName", 16);
        stringMapping.put("indexType", 17);
        stringMapping.put("inputArguments", 18);
        stringMapping.put("int", 19);
        stringMapping.put("isVisible", 20);
        stringMapping.put("item", 21);
        stringMapping.put("iterator", 22);
        stringMapping.put("javaType", 23);
        stringMapping.put("label", 24);
        stringMapping.put("length", 25);
        stringMapping.put("map", 26);
        stringMapping.put("maxOcur", 27);
        stringMapping.put("method", 28);
        stringMapping.put("methods", 29);
        stringMapping.put("modifiers", 30);
        stringMapping.put("name", 31);
        stringMapping.put("native", 86);
        stringMapping.put("object", 32);
        stringMapping.put("objectProperty", 33);
        stringMapping.put("ordered", 34);
        stringMapping.put("outputArgument", 35);
        stringMapping.put("precision", 36);
        stringMapping.put("presentation", 37);
        stringMapping.put("primitive", 38);
        stringMapping.put("property", 39);
        stringMapping.put("readSignature", 40);
        stringMapping.put("remote", 41);
        stringMapping.put("required", 42);
        stringMapping.put("scale", 43);
        stringMapping.put("signature", 44);
        stringMapping.put("superclass", 60);
        stringMapping.put("template", 45);
        stringMapping.put("timestamp", 54);
        stringMapping.put("type", 46);
        stringMapping.put("validValues", 47);
        stringMapping.put("validValuesMethodSignature", 48);
        stringMapping.put("validate", 49);
        stringMapping.put("value", 50);
        stringMapping.put("writeSignature", 51);
        stringMapping.put("isEditable", 53);
        stringMapping.put("status", 55);
        stringMapping.put("lastCheckinName", 56);
        stringMapping.put("procedure", 57);
        stringMapping.put("defaultExpression", 58);
        stringMapping.put("versionID", 59);
        stringMapping.put("repositoryModifier", 61);
        stringMapping.put("transformation", 62);
        stringMapping.put("transformationSource", 63);
        stringMapping.put("preTransformationCil", 64);
        stringMapping.put("postTransformationCil", 65);
        stringMapping.put("fieldMapping", 66);
        stringMapping.put("targetType", 67);
        stringMapping.put("targetName", 68);
        stringMapping.put("targetField", 69);
        stringMapping.put("isExpression", 70);
        stringMapping.put("inherit", 71);
        stringMapping.put("variable", 78);
        stringMapping.put("localVars", 73);
        stringMapping.put("localVar", 72);
        stringMapping.put("varType", 74);
        stringMapping.put("varName", 75);
        stringMapping.put("require", 76);
        stringMapping.put("ensure", 77);
        stringMapping.put("check", 80);
        stringMapping.put("language", 79);
        stringMapping.put("elementType", 81);
        stringMapping.put("replacement", 82);
        stringMapping.put("documentation", 83);
        stringMapping.put("position", 84);
        stringMapping.put("read", 85);
        stringMapping.put("write", 86);
        stringMapping.put("beginCode", 87);
        stringMapping.put("endCode", 88);
        stringMapping.put("displayName", 89);
        stringMapping.put("sourceCode", 90);
    }

    private static class SuperTypeComparator
    implements Comparator<SuperType> {
        private SuperTypeComparator() {
        }

        @Override
        public int compare(SuperType o1, SuperType o2) {
            int b1 = FuegoObjectConstants.isFuegoSuperType(o1.getText()) ? 0 : 1;
            int b2 = FuegoObjectConstants.isFuegoSuperType(o2.getText()) ? 0 : 1;
            return b1 - b2;
        }
    }

    private static class SourceCodeBuilder {
        private StringBuilder codeText;
        private String language;

        public SourceCodeBuilder(String language) {
            this.language = language;
            this.codeText = new StringBuilder();
        }

        public void append(char[] chars, int start, int length) {
            this.codeText.append(chars, start, length);
        }

        public SourceCode getSourceCode() {
            int length = this.codeText.length();
            char[] text = new char[length];
            this.codeText.getChars(0, length, text, 0);
            return new SourceCode(text, 0, text.length, this.language);
        }
    }

    private static class DisplayName {
        private StringBuilder displayName;
        private Locale locale;

        public DisplayName(String localeId) {
            this.locale = Locales.valueOf(localeId);
            this.displayName = new StringBuilder();
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String getDisplayName() {
            return XmlWriter.replaceCDATA(this.displayName.toString());
        }

        public void append(char[] chars, int start, int length) {
            this.displayName.append(chars, start, length);
        }
    }
}

