/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.type.PropertyProvider;
import oracle.bpm.type.PropertyVisitor;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.xml.XMLParser;
import org.jetbrains.annotations.NotNull;

public final class TypeInfo
implements Serializable,
PropertyProvider {
    private long flags;
    private Map<String, String> properties;
    private String signature;
    private static final String PROPERTY_IS_ENUM = "isEnum";
    static final long serialVersionUID = -4277036227202514057L;
    private static final int COMPONENT = 0;
    private static final int NAME = 1;
    private static final int VALUE = 2;
    private static final int TYPE = 3;
    private static final int OBJECT_PROPERTY = 4;
    private static final int ATTRIBUTES = 5;
    private static final int METHODS = 6;
    private static final int ENUMERATION = 7;
    private static final int FLAGS = 8;
    private static final int SIGNATURE = 9;
    private static final int REMOTE = 10;
    static final long serialCheck = 7457708391534394774L;
    private static final String PROPERTY_REMOTE = "REMOTE";

    public TypeInfo() {
    }

    public TypeInfo(ObjectTypeDescription root) {
        this.properties = new TreeMap<String, String>(root.getProperties());
        if (root.isEnum()) {
            this.setIsEnum();
        }
        this.setType(root.getComponentType());
        this.setRemote(root.isRemote());
        this.setSignature(root.getSignature());
        this.setFlags(root.getModifiers());
    }

    @Override
    public void visitProperties(@NotNull PropertyVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/TypeInfo.visitProperties must not be null");
        }
        if (this.properties != null) {
            TypeUtils.visitProperties(this.properties, visitor);
        }
    }

    public boolean isEnum() {
        return Boolean.valueOf(this.getProperty(PROPERTY_IS_ENUM));
    }

    public long getFlags() {
        return this.flags;
    }

    public void setId(String id) {
        this.setProperty("typeId", id);
    }

    public String getId() {
        return this.getProperty("typeId");
    }

    public String getProperty(String name) {
        return this.properties != null ? this.properties.get(name) : null;
    }

    public void setRemote(boolean remote) {
        this.setProperty(PROPERTY_REMOTE, String.valueOf(remote));
    }

    public boolean isRemote() {
        return Boolean.valueOf(this.getProperty(PROPERTY_REMOTE));
    }

    public String getSignature() {
        return this.signature;
    }

    public String getType() {
        return this.getProperty("componentType");
    }

    public String toString() {
        return this.properties != null ? this.properties.toString() : "";
    }

    public void setProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new TreeMap<String, String>();
        }
        if (value != null) {
            this.properties.put(name, value);
        } else {
            this.properties.remove(name);
        }
    }

    public void setType(String type) {
        assert (type != null) : "Null type";
        this.setProperty("componentType", type);
    }

    public void setFlags(long modifiers) {
        this.flags = modifiers;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    private void setIsEnum() {
        this.setProperty(PROPERTY_IS_ENUM, Boolean.toString(true));
    }

    static final class InterruptedException
    extends RuntimeException {
        static final long serialVersionUID = -2275202500103076144L;
        static final long serialCheck = 528555149105082446L;

        InterruptedException() {
        }
    }

    public static final class Parser
    extends XMLParser {
        private TypeInfo info;

        public Parser() {
            super(16);
            this.put("component", 0);
            this.put("name", 1);
            this.put("value", 2);
            this.put("type", 3);
            this.put("objectProperty", 4);
            this.put("attributes", 5);
            this.put("methods", 6);
            this.put("enumeration", 7);
            this.put("flags", 8);
            this.put("signature", 9);
            this.put("remote", 10);
        }

        public synchronized TypeInfo parse(Reader reader) throws IOException {
            this.info = new TypeInfo();
            this.setInput(reader);
            try {
                super.parse();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.info.getType() == null) {
                this.info.setType("object");
            }
            return this.info;
        }

        @Override
        protected void endElement(int id) {
        }

        @Override
        protected void processCDATA() {
        }

        @Override
        protected void startElement(int id) {
            switch (id) {
                case 0: 
                case 7: {
                    int argc = this.getAttributeCount();
                    for (int i = 0; i < argc; ++i) {
                        if (this.getAttributeID(i) == 3) {
                            this.info.setType(this.getAttributeValue(i).intern());
                            break;
                        }
                        if (this.getAttributeID(i) == 8) {
                            this.info.setFlags(Modifier.getModifiers(this.getAttributeValue(i)));
                            continue;
                        }
                        if (this.getAttributeID(i) == 9) {
                            this.info.setSignature(this.getAttributeValue(i));
                            continue;
                        }
                        if (this.getAttributeID(i) != 10) continue;
                        this.info.setRemote("true".equals(this.getAttributeValue(i)));
                    }
                    if (id != 7) break;
                    this.info.setProperty(TypeInfo.PROPERTY_IS_ENUM, "true");
                    break;
                }
                case 4: {
                    int argc = this.getAttributeCount();
                    String name = null;
                    String value = null;
                    for (int i = 0; i < argc; ++i) {
                        if (this.getAttributeID(i) == 1) {
                            name = this.getAttributeValue(i);
                            continue;
                        }
                        if (this.getAttributeID(i) != 2) continue;
                        value = this.getAttributeValue(i);
                    }
                    if (name == null || value == null) break;
                    name = name.intern();
                    value = value.intern();
                    this.info.setProperty(name, value);
                    break;
                }
                case 5: 
                case 6: {
                    throw new InterruptedException();
                }
            }
        }
    }
}

