/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Function;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.DefaultComponentCatalog;
import oracle.bpm.type.DuplicatedComponentTypeException;
import oracle.bpm.type.LoadingCanceledException;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.SimplePropertyIndex;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeCatalogRuntimeException;
import oracle.bpm.type.TypeHandle;
import oracle.bpm.type.TypeInfo;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.type.catalog.ComponentBundle;
import oracle.bpm.util.ProgressMonitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TypeCache {
    private Map<String, Long> cachedBundles;
    private List<TypeRef> moduleCollisions;
    private final SimplePropertyIndex propertyIndex;
    private final DefaultComponentCatalog repository;
    private RootRef root;
    private Map<String, TypeHandle> typesById;
    private SortedMap<String, TypeHandle> typesByName = new TreeMap<String, TypeHandle>();

    TypeCache(DefaultComponentCatalog repository) {
        this.root = new RootRef(this);
        this.cachedBundles = new HashMap<String, Long>();
        this.propertyIndex = new SimplePropertyIndex();
        this.repository = repository;
    }

    public void dispose() {
        for (TypeHandle handle : this.allTypes()) {
            handle.invalidate();
        }
    }

    public boolean needsUpdate(ComponentBundle bundle) {
        return !this.containsCachedBundle(bundle) || bundle.hasChangedFrom(this.lastModifiedForPath(bundle.getUniqueId()));
    }

    public Changes reload(@NotNull List<ComponentBundle> bundles, ProgressMonitor monitor) {
        if (bundles == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/TypeCache.reload must not be null");
        }
        HashSet<TypeHandle> oldTypeHandles = new HashSet<TypeHandle>();
        for (ComponentBundle bundle : bundles) {
            try {
                oldTypeHandles.addAll(this.deepRemove(bundle));
                this.addComponentBundle(bundle);
            }
            catch (Throwable unexpected) {
                Log.logSevere(unexpected);
                monitor.error(Msg.QUOTE(unexpected.toString()));
            }
        }
        HashSet<TypeHandle> newTypeHandles = new HashSet<TypeHandle>();
        for (ComponentBundle bundle : bundles) {
            try {
                newTypeHandles.addAll(this.reloadFromBundle(bundle, oldTypeHandles));
            }
            catch (TypeCatalogException e) {
                throw new TypeCatalogRuntimeException(LibMsg.CANNOT_LOAD_BUNDLE(bundle.getDisplayName()), (Throwable)e);
            }
        }
        Changes result = new Changes();
        result.added.addAll(newTypeHandles);
        result.removed.addAll(oldTypeHandles);
        return result;
    }

    public Changes sync(Collection<ComponentBundle> bundles, ProgressMonitor monitor) {
        ArrayList<ComponentBundle> scan = new ArrayList<ComponentBundle>();
        for (ComponentBundle bundle : bundles) {
            if (scan.contains(bundle) || !this.needsUpdate(bundle)) continue;
            scan.add(bundle);
        }
        Changes changes = this.reload(scan, monitor);
        this.removeUnusedVirtualTypes();
        return changes;
    }

    public Set<TypeHandle> findByBundleId(String bundleId) {
        HashSet<TypeHandle> result = new HashSet<TypeHandle>();
        for (TypeHandle handle : this.typesByName.values()) {
            handle.findByBundleId(bundleId, result);
        }
        return result;
    }

    public void deepRemove(TypeHandle handle) {
        for (TypeHandle handleToRemove : this.getTypesToRemove(handle)) {
            TypeDescription type = handleToRemove.getIfLoaded();
            this.remove(handleToRemove.getText());
            if (type == null || !type.isObject()) continue;
            ObjectTypeDescription otd = type.asObject();
            otd.setCatalog(null);
            otd.setRef(null);
        }
    }

    public List<TypeHandle> getTypesToRemove(TypeHandle handle) {
        ArrayList<TypeHandle> typesToRemove = new ArrayList<TypeHandle>();
        typesToRemove.add(handle);
        int current = 0;
        while (current < typesToRemove.size()) {
            TypeHandle type = (TypeHandle)typesToRemove.get(current++);
            List<TypeHandle> children = this.findByModule(type.getText(), false);
            for (TypeHandle aChildren : children) {
                typesToRemove.add(aChildren);
            }
        }
        return typesToRemove;
    }

    public void assertNotContains(@NotNull ObjectTypeDescription otd, @Nullable String module) throws DuplicatedComponentTypeException {
        if (otd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/TypeCache.assertNotContains must not be null");
        }
        String typeName = this.getQualifiedName(otd, module);
        TypeHandle old = this.getExactMatch(typeName);
        if (old != null) {
            throw new DuplicatedComponentTypeException((ComponentCatalog)this.repository, "Cannot add duplicated component: " + typeName);
        }
    }

    public List<TypeRef> findBySubstring(String partialName) {
        String lowerCaseName = partialName.toLowerCase();
        ArrayList<TypeRef> result = new ArrayList<TypeRef>();
        for (Map.Entry<String, TypeHandle> entry : this.typesByName.entrySet()) {
            if (!entry.getKey().toLowerCase().contains(lowerCaseName)) continue;
            for (TypeHandle handle = entry.getValue(); handle != null; handle = handle.getNext()) {
                if (!handle.isValid()) continue;
                result.add(handle);
            }
        }
        return result;
    }

    TypeRef getById(String componentType, String id) {
        TypeRef result = this.getTypesById().get(TypeUtils.buildTypeId(componentType, id));
        if (result == null && this.getParent() != null) {
            result = this.getParent().getById(componentType, id);
        }
        return result;
    }

    @Nullable
    TypeHandle getExactMatch(String qname) {
        if ("".equals(qname)) {
            return this.root;
        }
        TypeHandle handle = this.getExactMatch(TypeUtils.shortName(qname), TypeUtils.moduleName(qname, ""));
        if (handle == null && this.getParent() != null) {
            handle = this.getParent().getExactMatch(qname);
        }
        if (handle != null && !handle.isValid()) {
            handle = null;
        }
        return handle;
    }

    TypeHandle getExactMatch(String name, String module) {
        TypeHandle handle = this.get(name);
        return handle != null ? handle.getForModule(module) : null;
    }

    ProgressMonitor getMonitor() {
        return this.repository != null ? this.repository.getMonitor() : null;
    }

    TypeCache getParent() {
        if (this.getRepository() != null && this.getRepository().getParentCatalog() != null) {
            return (TypeCache)this.getRepository().getParentCatalog().getCache();
        }
        return null;
    }

    SortedMap<String, TypeRef> findByPrefix(String prefix) {
        TreeMap<String, TypeRef> result = new TreeMap<String, TypeRef>();
        SortedMap<String, TypeHandle> partialMatches = this.typesByName.subMap(prefix, prefix + "z");
        for (Map.Entry<String, TypeHandle> entry : partialMatches.entrySet()) {
            TypeHandle valid = entry.getValue().findFirstValid();
            if (valid == null) continue;
            result.put(entry.getKey(), valid);
        }
        return result;
    }

    MutableComponentCatalog getRepository() {
        return this.repository;
    }

    TypeHandle addOrUpdate(ObjectTypeDescription root, ComponentBundle bundle, String module, String name, boolean virtual) {
        TypeHandle duplicated;
        TypeHandle result = null;
        TypeHandle old = (TypeHandle)this.typesByName.get(name);
        if (old != null && (duplicated = old.getForModule(module)) != null) {
            duplicated.revalidate(root, bundle, this, virtual);
            result = duplicated;
        }
        if (result == null) {
            result = new TypeHandle(root, bundle, module, name, this, virtual);
            result.setNext(old);
            this.typesByName.put(name, result);
        }
        this.typesById = null;
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    TypeHandle addAll(ComponentBundle bundle, String module, String name, boolean virtual) {
        ArrayList<TypeHandle> typeHandles = new ArrayList<TypeHandle>();
        this.addAll(bundle, module, name, virtual, typeHandles);
        TypeHandle typeHandle = (TypeHandle)typeHandles.get(0);
        if (typeHandle == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/type/TypeCache.addAll must not return null");
        }
        return typeHandle;
    }

    void addComponentBundle(ComponentBundle bundle) {
        this.addComponentBundle(bundle, bundle.lastModified());
    }

    void addComponentBundle(ComponentBundle bundle, long lastModified) {
        this.cachedBundles.put(bundle.getUniqueId(), lastModified);
    }

    Sequence<TypeHandle> allTypes() {
        return this.allHandles().select(new Predicate<TypeHandle>(){

            @Override
            public boolean check(@Nullable TypeHandle value) {
                return value != null && value.isValid();
            }
        });
    }

    boolean containsCachedBundle(ComponentBundle bundle) {
        return this.cachedBundles.containsKey(bundle.getUniqueId());
    }

    List<TypeHandle> findByModule(String module) {
        return this.findByModule(module, true, new ArrayList<TypeHandle>());
    }

    List<TypeHandle> findByModule(String module, boolean findInParent) {
        return this.findByModule(module, findInParent, new ArrayList<TypeHandle>());
    }

    List<TypeHandle> findByModule(String module, boolean findInParent, List<TypeHandle> types) {
        for (TypeHandle ref : this.typesByName.values()) {
            ref.findByModule(module, types);
        }
        if (findInParent && this.getParent() != null) {
            types = this.getParent().findByModule(module, findInParent, types);
        }
        return types;
    }

    void free() {
        for (TypeHandle handle : this.allHandles()) {
            handle.free();
        }
    }

    TypeHandle get(String name) {
        if ("".equals(name)) {
            return this.root;
        }
        return (TypeHandle)this.typesByName.get(name);
    }

    boolean hasChildren(@NotNull String type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/TypeCache.hasChildren must not be null");
        }
        boolean hasChildren = false;
        for (TypeHandle ref : this.allTypes()) {
            if (!type.equals(ref.getModule())) continue;
            hasChildren = true;
            break;
        }
        if (this.getParent() != null && !hasChildren) {
            hasChildren = this.getParent().hasChildren(type);
        }
        return hasChildren;
    }

    long lastModifiedForPath(String bundleId) {
        Long lastModified = this.cachedBundles.get(bundleId);
        return lastModified != null ? lastModified : -1L;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    SimplePropertyIndex getPropertyIndex() {
        SimplePropertyIndex simplePropertyIndex = this.propertyIndex;
        if (simplePropertyIndex == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/type/TypeCache.getPropertyIndex must not return null");
        }
        return simplePropertyIndex;
    }

    TypeHandle remove(String type) {
        TypeHandle current;
        String name = TypeUtils.shortName(type);
        String module = TypeUtils.moduleName(type, "");
        for (current = this.get(name); current != null; current = current.getNext()) {
            if (!current.getModule().equals(module)) continue;
            current.invalidate();
            break;
        }
        if (current != null) {
            current.free();
        }
        this.typesById = null;
        return current;
    }

    void removeBundle(String bundleId) {
        this.cachedBundles.remove(bundleId);
    }

    Set<TypeHandle> removeTypesForBundle(String bundleId) {
        Set<TypeHandle> oldTypes = this.findByBundleId(bundleId);
        for (TypeHandle element : oldTypes) {
            this.remove(element.getText());
        }
        return oldTypes;
    }

    void removeUnusedVirtualTypes() {
    }

    List<TypeRef> getModuleCollisions() {
        List<TypeRef> result = this.moduleCollisions;
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    void addAll(ComponentBundle bundle, String module, String name, boolean virtual, @NotNull List<TypeHandle> typeHandles) {
        if (typeHandles == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of oracle/bpm/type/TypeCache.addAll must not be null");
        }
        TypeHandle newHandle = this.addOrUpdate(null, bundle, module, name, virtual);
        TypeHandle path = this.getExactMatch(module);
        typeHandles.add(newHandle);
        if (path == null) {
            name = TypeUtils.shortName(module);
            module = TypeUtils.moduleName(module, "");
            this.addAll(bundle, module, name, true, typeHandles);
        } else if (path == this.root) {
            this.root.type = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private String getQualifiedName(@NotNull ObjectTypeDescription otd, @Nullable String module) {
        if (otd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/TypeCache.getQualifiedName must not be null");
        }
        String result = Str.isEmpty(module) ? otd.getText() : module + "." + otd.getName();
        String string = result;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/type/TypeCache.getQualifiedName must not return null");
        }
        return string;
    }

    private Sequence<TypeHandle> allHandles() {
        return CollectionUtils.asSequence(this.typesByName.values()).flatten(new Function<TypeHandle, Iterator<TypeHandle>>(){

            @Override
            public Iterator<TypeHandle> eval(TypeHandle value) {
                return value.getNext() != null ? CollectionUtils.singletonSequence(value.getNext()).iterator() : null;
            }
        });
    }

    private Map<String, TypeHandle> getTypesById() {
        if (this.typesById == null) {
            this.typesById = new HashMap<String, TypeHandle>();
            for (TypeHandle handle : this.allTypes()) {
                TypeInfo info = handle.getInfo();
                if (info == null) continue;
                String key = TypeUtils.buildTypeId(info.getType(), info.getId());
                this.typesById.put(key, handle);
            }
        }
        return this.typesById;
    }

    private Set<TypeHandle> deepRemove(ComponentBundle bundle) {
        Set<Object> removed = this.containsCachedBundle(bundle) ? this.deepRemove(bundle.getUniqueId()) : new HashSet();
        return removed;
    }

    private Set<TypeHandle> deepRemove(@NotNull String componentBundleUniqueId) {
        if (componentBundleUniqueId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/TypeCache.deepRemove must not be null");
        }
        Set<TypeHandle> result = this.removeTypesForBundle(componentBundleUniqueId);
        this.removeBundle(componentBundleUniqueId);
        return result;
    }

    private Set<TypeHandle> reloadFromBundle(@NotNull ComponentBundle bundle, @NotNull Set<TypeHandle> oldTypeHandles) throws TypeCatalogException {
        if (bundle == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/TypeCache.reloadFromBundle must not be null");
        }
        if (oldTypeHandles == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/type/TypeCache.reloadFromBundle must not be null");
        }
        TreeSet<String> newTypesNames = new TreeSet<String>();
        HashSet<TypeHandle> newTypesHandles = new HashSet<TypeHandle>();
        try {
            newTypesNames.addAll(bundle.loadTypeNames());
        }
        catch (LoadingCanceledException e) {
            // empty catch block
        }
        for (String newTypeName : newTypesNames) {
            boolean exists;
            String name = TypeUtils.shortName(newTypeName);
            String module = TypeUtils.moduleName(newTypeName, "");
            TypeHandle newTypeHandle = this.getExactMatch(name, module);
            long lastModified = bundle.getLastModifiedTime(newTypeName);
            boolean bl = exists = newTypeHandle != null && newTypeHandle.isValid() && oldTypeHandles.contains(newTypeHandle);
            if (exists && !newTypeHandle.isVirtual()) {
                if (lastModified != newTypeHandle.getLastModifiedTime()) {
                    newTypeHandle.loadInfo();
                    newTypeHandle.setLastModifiedTime(lastModified);
                }
                newTypesHandles.add(newTypeHandle);
                continue;
            }
            ArrayList<TypeHandle> typeHandles = new ArrayList<TypeHandle>();
            this.addAll(bundle, module, name, false, typeHandles);
            TypeHandle compTypeHandle = (TypeHandle)typeHandles.get(0);
            compTypeHandle.loadInfo();
            compTypeHandle.setLastModifiedTime(lastModified);
            newTypesHandles.addAll(typeHandles);
        }
        return newTypesHandles;
    }

    final class RootRef
    extends TypeHandle {
        private transient ObjectTypeDescription type;
        static final long serialVersionUID = -4349956317880599452L;
        static final long serialCheck = 3028176526211513891L;

        RootRef(TypeCache cache) {
            super(null, null, null, "", cache, true);
        }

        @Override
        public String getModule() {
            return null;
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public TypeDescription get() {
            if (this.type == null) {
                this.type = new ObjectTypeDescription("");
                this.type.setComponentType(ComponentType.OBJECT.getText());
                this.type.setCatalog(TypeCache.this.repository);
                this.type.setRef(this);
                this.buildInnerTypes();
            }
            return this.type;
        }

        public void rebuild() {
            if (this.type != null) {
                this.type.removeAllInnerTypes();
                this.buildInnerTypes();
            }
        }

        private void buildInnerTypes() {
            TypeCache.this.moduleCollisions = null;
            for (TypeHandle ref : this.cache.findByModule("")) {
                try {
                    this.type.addInnerType(ref);
                }
                catch (IllegalArgumentException e) {
                    if (TypeCache.this.moduleCollisions == null) {
                        TypeCache.this.moduleCollisions = new ArrayList();
                    }
                    TypeCache.this.moduleCollisions.add(ref);
                }
            }
        }
    }

    static class Changes {
        final Comparator<TypeHandle> comparator = new Comparator<TypeHandle>(){

            @Override
            public int compare(TypeHandle o1, TypeHandle o2) {
                return o1.getText().compareTo(o2.getText());
            }
        };
        final Set<TypeHandle> added = new TreeSet<TypeHandle>(this.comparator);
        final Set<TypeHandle> removed = new TreeSet<TypeHandle>(this.comparator);

        Changes() {
        }
    }
}

