/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.lang.IllegalConversionException;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.UUIDFactory;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.lang.XmlUUID;
import oracle.bpm.log.Log;
import oracle.bpm.type.TypeToXsdMapping;
import oracle.bpm.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class SchemaObjectFactory {
    public static SchemaObject createForSimpleType(final TypeDescription td) {
        if (!td.isSchemaObject() && TypeToXsdMapping.getTypeMapping(td) == null) {
            throw new IllegalConversionException(((Object)td).toString(), "SchemaObject");
        }
        return new SchemaObject(){

            @Override
            @NotNull
            public String getNamespace() {
                return "http://www.w3.org/2001/XMLSchema";
            }

            @Override
            public VFile getResourceLocation() {
                return null;
            }

            @Override
            public String getLocation() {
                return null;
            }

            @Override
            public URI getResourceUri() {
                return null;
            }

            @Override
            @NotNull
            public String getName() {
                String xsdTypeName = TypeToXsdMapping.getTypeMapping(td);
                assert (xsdTypeName != null) : "Missing XSD type mapping for basic type " + td.getText();
                return xsdTypeName;
            }

            @Override
            @NotNull
            public String getId() {
                return UUIDFactory.createXmlId(XmlElementType.TYPE, this.getNamespace(), this.getName()).getId();
            }

            @Override
            public boolean isElement() {
                return false;
            }

            @Override
            public boolean isType() {
                return true;
            }

            @Override
            public XmlElementType getXmlElementType() {
                return XmlElementType.TYPE;
            }

            @Override
            public boolean isMessage() {
                return false;
            }

            @Override
            public boolean isFault() {
                return false;
            }

            @Override
            public boolean isElementsQualified() {
                return false;
            }

            @Override
            public boolean isAttributesQualified() {
                return false;
            }

            @Override
            public boolean isBasicType() {
                return true;
            }

            @Override
            public boolean isFromSchema() {
                return false;
            }

            @Override
            public boolean isFromWsdl() {
                return false;
            }

            @Override
            public boolean isBpmObjectNamespace() {
                return false;
            }

            @Override
            public QName getElementTypeQName() {
                return null;
            }

            @Override
            public String getElementTypeId() {
                return null;
            }

            @Override
            public QName getQName() {
                return new QName(this.getNamespace(), this.getName());
            }
        };
    }

    public static SchemaObject createForXmlType(final XmlTypeDescription xmlotd) {
        return new SchemaObject(){

            @Override
            @NotNull
            public String getNamespace() {
                return xmlotd.getNamespace();
            }

            @Override
            public VFile getResourceLocation() {
                Object o = xmlotd.getTransientProperty("files");
                if (o != null) {
                    VFile[] files = (VFile[])o;
                    assert (files.length == 1) : "More than 1 file found for: " + xmlotd.getText();
                    return files[0];
                }
                return null;
            }

            @Override
            public String getLocation() {
                return xmlotd.getLocation();
            }

            @Override
            public URI getResourceUri() {
                URI result;
                block9: {
                    result = null;
                    VFile vFile = this.getResourceLocation();
                    if (vFile != null) {
                        try {
                            result = vFile.toURL().toURI();
                        }
                        catch (URISyntaxException e) {
                            if (Log.isDebugging()) {
                                Log.logDebug(e);
                            }
                            break block9;
                        }
                        catch (IOException e) {
                            if (Log.isDebugging()) {
                                Log.logDebug(e);
                            }
                            break block9;
                        }
                    }
                    String location = this.getLocation();
                    assert (location != null);
                    try {
                        result = new URI(location);
                    }
                    catch (URISyntaxException e) {
                        if (!Log.isDebugging()) break block9;
                        Log.logDebug(e);
                    }
                }
                return result;
            }

            @Override
            @NotNull
            public String getName() {
                return xmlotd.getNativeName();
            }

            @Override
            public boolean isElement() {
                return xmlotd.getXmlElementType() == XmlElementType.ELEMENT;
            }

            @Override
            @NotNull
            public String getId() {
                return xmlotd.getId();
            }

            @Override
            public boolean isType() {
                return xmlotd.getXmlElementType() == XmlElementType.TYPE;
            }

            @Override
            public XmlElementType getXmlElementType() {
                return xmlotd.getXmlElementType();
            }

            @Override
            public boolean isMessage() {
                return xmlotd.getXmlElementType() == XmlElementType.MESSAGE;
            }

            @Override
            public boolean isFault() {
                return xmlotd.getXmlElementType() == XmlElementType.FAULT;
            }

            @Override
            public boolean isElementsQualified() {
                return xmlotd.isElementsAreQualified();
            }

            @Override
            public boolean isAttributesQualified() {
                return xmlotd.isAttributesAreQualified();
            }

            @Override
            public boolean isBasicType() {
                return false;
            }

            @Override
            public boolean isFromSchema() {
                return !this.isFromWsdl();
            }

            @Override
            public boolean isFromWsdl() {
                return Boolean.valueOf(xmlotd.getProperty("wsdl.inline.object"));
            }

            @Override
            public boolean isBpmObjectNamespace() {
                return this.getNamespace().startsWith("http://xmlns.oracle.com/bpm/bpmobject/");
            }

            @Override
            public QName getElementTypeQName() {
                String typeId = this.getElementTypeId();
                if (typeId != null) {
                    XmlUUID xmlUUID = UUIDFactory.parseXmlId(typeId);
                    return xmlUUID.getQName();
                }
                return null;
            }

            @Override
            public String getElementTypeId() {
                return xmlotd.getProperty("element.type.id");
            }

            @Override
            public QName getQName() {
                return new QName(this.getNamespace(), this.getName());
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static SchemaObject createForBpmObjectType(@NotNull XObjectTypeDescription xotd) {
        if (xotd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/SchemaObjectFactory.createForBpmObjectType must not be null");
        }
        XmlTypeDescription xmlotd = TypeUtils.getModelObject(xotd);
        SchemaObject result = xmlotd != null ? SchemaObjectFactory.createForXmlType(xmlotd) : SchemaObjectFactory.createFromId(xotd);
        SchemaObject schemaObject = result;
        if (schemaObject == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/type/SchemaObjectFactory.createForBpmObjectType must not return null");
        }
        return schemaObject;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static SchemaObject createFromId(final @NotNull XObjectTypeDescription xotd) {
        if (xotd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/SchemaObjectFactory.createFromId must not be null");
        }
        String schemaId = xotd.getProperty("attributes.schema.id");
        final XmlUUID xmlUUID = UUIDFactory.parseXmlId(schemaId);
        SchemaObject schemaObject = new SchemaObject(){

            @Override
            @NotNull
            public String getNamespace() {
                return xmlUUID.getNamespace();
            }

            @Override
            public VFile getResourceLocation() {
                throw this.buildException();
            }

            @Override
            public String getLocation() {
                throw this.buildException();
            }

            @Override
            public URI getResourceUri() {
                throw this.buildException();
            }

            @Override
            @NotNull
            public String getName() {
                return xmlUUID.getNativeName();
            }

            @Override
            public boolean isElement() {
                return xmlUUID.getElemType() == XmlElementType.ELEMENT;
            }

            @Override
            @NotNull
            public String getId() {
                return xmlUUID.getId();
            }

            @Override
            public boolean isType() {
                return xmlUUID.getElemType() == XmlElementType.TYPE;
            }

            @Override
            public XmlElementType getXmlElementType() {
                return xmlUUID.getElemType();
            }

            @Override
            public boolean isMessage() {
                return xmlUUID.getElemType() == XmlElementType.MESSAGE;
            }

            @Override
            public boolean isFault() {
                return xmlUUID.getElemType() == XmlElementType.FAULT;
            }

            @Override
            public boolean isElementsQualified() {
                throw this.buildException();
            }

            @Override
            public boolean isAttributesQualified() {
                throw this.buildException();
            }

            @Override
            public boolean isBasicType() {
                return false;
            }

            @Override
            public boolean isFromSchema() {
                String location = this.getLocation();
                assert (location != null);
                return location.endsWith(".xsd");
            }

            @Override
            public boolean isFromWsdl() {
                throw this.buildException();
            }

            @Override
            public boolean isBpmObjectNamespace() {
                return this.getNamespace().startsWith("http://xmlns.oracle.com/bpm/bpmobject/");
            }

            @Override
            public QName getElementTypeQName() {
                return xmlUUID.getQName();
            }

            @Override
            public String getElementTypeId() {
                throw this.buildException();
            }

            @Override
            public QName getQName() {
                return new QName(this.getNamespace(), this.getName());
            }

            private IllegalStateException buildException() {
                return new IllegalStateException("Not supported operation for business object:" + xotd.getText());
            }
        };
        if (schemaObject == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/type/SchemaObjectFactory.createFromId must not return null");
        }
        return schemaObject;
    }
}

