/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.type.Diff;
import oracle.bpm.type.TypeDiff;

public class MethodDiff
extends TypeDiff {
    public static MethodDiff create(MethodTypeDescription oldMethod, MethodTypeDescription newMethod) {
        MethodDiff diff = new MethodDiff();
        if (oldMethod == null) {
            diff.description = newMethod.toString();
        } else if (newMethod == null) {
            diff.description = oldMethod.toString();
        } else if (!oldMethod.getName().equals(newMethod.getName())) {
            diff.description = "Name has changed from " + oldMethod.getName() + " to " + newMethod.getName();
        }
        return diff;
    }

    static void dump(Diff diff, String indent) {
        Diff[] modified;
        Diff[] removed;
        System.out.println(diff.getDescription());
        indent = indent + "\t";
        Diff[] added = diff.getAdded();
        if (added != null) {
            for (int i = 0; i < added.length; ++i) {
                System.out.print(indent + "+");
                MethodDiff.dump(added[i], indent);
            }
        }
        if ((removed = diff.getRemoved()) != null) {
            for (int i = 0; i < removed.length; ++i) {
                System.out.print(indent + "-");
                MethodDiff.dump(removed[i], indent);
            }
        }
        if ((modified = diff.getModified()) != null) {
            for (int i = 0; i < modified.length; ++i) {
                System.out.print(indent + "*");
                MethodDiff.dump(modified[i], indent);
            }
        }
    }
}

