/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.UUIDFactory;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.lang.XmlUUID;
import oracle.bpm.lang.exception.ProgramException;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.BundleCatalogView;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.DynamicRef;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.NoSuchComponentTypeException;
import oracle.bpm.type.PropertyIndex;
import oracle.bpm.type.ReadOnlyCatalogException;
import oracle.bpm.type.ReadOnlyRepositoryException;
import oracle.bpm.type.SimplePropertyIndex;
import oracle.bpm.type.TypeCache;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeHandle;
import oracle.bpm.type.TypeInfo;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.type.catalog.CatalogListener;
import oracle.bpm.type.catalog.CatalogListeners;
import oracle.bpm.type.catalog.ComponentBundle;
import oracle.bpm.type.catalog.ComponentBundleListener;
import oracle.bpm.type.catalog.MemoryMutableComponentBundle;
import oracle.bpm.type.catalog.MutableComponentBundle;
import oracle.bpm.util.ProgressMonitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DefaultComponentCatalog
implements MutableComponentCatalog,
ComponentBundleListener,
BundleCatalogView {
    private PendingEvents adding = new PendingEvents();
    private Set<ComponentBundle> bundles = new LinkedHashSet<ComponentBundle>();
    @Nullable
    private volatile TypeCache cache;
    private ComponentBundle defaultStorageBundle;
    private String description = "";
    private boolean disposed = false;
    private Map<String, DynamicRef> lazyRefs = new HashMap<String, DynamicRef>();
    private final CatalogListeners listeners = new CatalogListeners();
    private ProgressMonitor monitor = ProgressMonitor.NULL_INSTANCE;
    private Object owner;
    private MutableComponentCatalog parentCatalog;
    private boolean readOnly;
    private PendingEvents removing = new PendingEvents();
    private TypeCache.Changes transientChanges;
    private boolean workingInMemory;

    DefaultComponentCatalog() {
    }

    DefaultComponentCatalog(MutableComponentCatalog parent) {
        this();
        this.setParent(parent);
    }

    public static void assertNotNullArgument(Object notNull, String message) {
        if (notNull == null) {
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public void addComponentBundle(ComponentBundle bundle) {
        DefaultComponentCatalog.assertNotNullArgument(bundle, "Attempt to add 'null' to component bundle");
        this.assertNotDisposed();
        this.putBundleIfAbsent(bundle);
    }

    @Override
    public void setDefaultStorageBundle(ComponentBundle primaryBundle) {
        if (this.defaultStorageBundle != null) {
            throw new IllegalArgumentException("Attempt to set two paths as primary storage.");
        }
        this.putBundleIfAbsent(primaryBundle);
        this.defaultStorageBundle = primaryBundle;
    }

    @Override
    public ComponentBundle getComponentBundleForType(String typeName) throws NoSuchComponentTypeException {
        return this.getExactMatchHandle(typeName).getBundle();
    }

    @Override
    public MutableComponentBundle getDefaultStorageBundle() {
        return this.defaultStorageBundle.asMutable();
    }

    @Override
    public List<TypeRef> getModuleCollisions() {
        return this.getCache().getModuleCollisions();
    }

    @Override
    public ObjectTypeDescription getRoot() {
        this.assertNotDisposed();
        return (ObjectTypeDescription)this.getRootRef().get();
    }

    @Override
    public TypeRef find(String typeName) throws AmbiguousTypeNameException {
        return this.findType(typeName, null, null, true);
    }

    @Override
    public TypeRef find(String typeName, TypeDescription context) throws AmbiguousTypeNameException {
        return this.findType(typeName, context, null, true);
    }

    @Override
    public TypeRef find(String typeName, TypeDescription context, Map<String, String> usages) throws AmbiguousTypeNameException {
        return this.findType(typeName, context, usages, true);
    }

    @Override
    public TypeRef findType(String typeName, TypeDescription context, Map<String, String> usages, boolean useExactMaching) throws AmbiguousTypeNameException {
        String type;
        DefaultComponentCatalog.assertNotNullArgument(typeName, "Invalid type name (null value)");
        this.assertNotDisposed();
        if ("".equals(typeName)) {
            return this.getCache().get("");
        }
        String name = TypeUtils.shortName(typeName);
        String module = TypeUtils.moduleName(typeName, "");
        if (module.equals("") && usages != null && (type = usages.get(name)) != null) {
            return this.getCache().getExactMatch(type);
        }
        TypeRef result = null;
        ArrayList<TypeRef> additionalResults = null;
        boolean foundExact = false;
        for (TypeHandle handle = this.getCache().get(name); handle != null; handle = handle.getNext()) {
            String handleModule = handle.getModule();
            if (!handle.isValid() || (handleModule == null || !handleModule.equals(module) && !"".equals(module) && !handleModule.startsWith(module + '.')) && (handleModule != null || !module.equals(""))) continue;
            if (handleModule == null || handleModule.equals(module) && useExactMaching && (!"".equals(module) && context != null || context == null)) {
                result = handle;
                additionalResults = null;
                foundExact = true;
                break;
            }
            if (result == null) {
                result = handle;
                continue;
            }
            if (additionalResults == null) {
                additionalResults = new ArrayList(2);
            }
            additionalResults.add(handle);
        }
        if (this.parentCatalog != null && !foundExact) {
            try {
                TypeRef ref = this.parentCatalog.findType(typeName, context, usages, useExactMaching);
                if (ref != null) {
                    if (useExactMaching && ref.getText().equals(typeName)) {
                        result = null;
                        additionalResults = null;
                    }
                    if (result == null) {
                        result = ref;
                    } else {
                        if (additionalResults == null) {
                            additionalResults = new ArrayList(2);
                        }
                        additionalResults.add(ref);
                    }
                }
            }
            catch (AmbiguousTypeNameException e) {
                TypeRef[] possibleTypes = e.getPossibleTypes();
                if (additionalResults == null) {
                    additionalResults = new ArrayList<TypeRef>(possibleTypes.length);
                }
                additionalResults.addAll(Arrays.asList(possibleTypes));
            }
        }
        if (additionalResults != null) {
            TypeRef parent;
            if (result != null) {
                additionalResults.add(result);
            }
            if (context != null && module.equals("") && (parent = context.getParentRef()) != null) {
                String parentText = parent.getText();
                for (TypeRef ref : additionalResults) {
                    if (!Any.equals(((TypeHandle)ref).getModule(), parentText)) continue;
                    result = ref;
                    additionalResults = null;
                    break;
                }
            }
            if (additionalResults != null) {
                throw new AmbiguousTypeNameException((ComponentCatalog)this, typeName, (List<TypeRef>)additionalResults);
            }
        }
        if (!foundExact && useExactMaching) {
            result = null;
        }
        return result;
    }

    public SortedMap<String, TypeRef> findByPartialName(String partialName) {
        DefaultComponentCatalog.assertNotNullArgument(partialName, "Attempt to find invalid type name: '" + partialName + '\'');
        this.assertNotDisposed();
        return this.getCache().findByPrefix(partialName);
    }

    @Override
    public List<TypeRef> findBySubstring(String partialName) {
        DefaultComponentCatalog.assertNotNullArgument(partialName, "Attempt to find invalid type name: '" + partialName + '\'');
        this.assertNotDisposed();
        return this.getCache().findBySubstring(partialName);
    }

    public SortedMap<String, TypeRef> findByPartialName(String partialName, boolean findInParent) {
        this.assertNotDisposed();
        SortedMap<String, TypeRef> matches = this.findByPartialName(partialName);
        if (findInParent && this.getParentCatalog() != null) {
            matches.putAll(this.getParentCatalog().findByPartialName(partialName, findInParent));
        }
        return matches;
    }

    @Override
    @Nullable
    public synchronized TypeRef findBpmObjectBySchemaId(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/DefaultComponentCatalog.findBpmObjectBySchemaId must not be null");
        }
        return this.findMatchingBpmObject(id, false);
    }

    @Override
    @Nullable
    public synchronized TypeRef findExceptionObjectBySchemaId(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/DefaultComponentCatalog.findExceptionObjectBySchemaId must not be null");
        }
        return this.findMatchingBpmObject(id, true);
    }

    @Override
    public synchronized TypeRef findById(@NotNull String componentType, @NotNull String id) {
        if (componentType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/DefaultComponentCatalog.findById must not be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/type/DefaultComponentCatalog.findById must not be null");
        }
        DefaultComponentCatalog.assertNotNullArgument(componentType, "Invalid null component type");
        DefaultComponentCatalog.assertNotNullArgument(id, "Invalid null id");
        this.assertNotDisposed();
        return this.getCache().getById(componentType, id);
    }

    @Override
    public TypeRef findById(@NotNull ComponentType componentType, @NotNull String nativeId) {
        if (componentType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/DefaultComponentCatalog.findById must not be null");
        }
        if (nativeId == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/type/DefaultComponentCatalog.findById must not be null");
        }
        return this.findById(componentType.getText(), nativeId);
    }

    @Override
    public Iterable<TypeRef> allComponents() {
        return (Iterable)Cast.force(this.getCache().allTypes());
    }

    @Override
    public synchronized void update(ObjectTypeDescription type) throws TypeCatalogException {
        ComponentBundle storageBundle;
        DefaultComponentCatalog.assertNotNullArgument(type, "Invalid null type");
        this.assertNotDisposed();
        TypeHandle handle = this.getCache().getExactMatch(type.getText());
        if (handle != null) {
            storageBundle = handle.getBundle();
            handle.updateInfo(type);
        } else {
            storageBundle = this.getDefaultStorageBundle();
        }
        this.store(type, storageBundle);
    }

    @Override
    public void remove(String qualifiedName) throws TypeCatalogException {
        this.removeInternal(qualifiedName, true);
    }

    @Override
    public void removeNoStore(@NotNull String qualifiedName) throws TypeCatalogException {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/DefaultComponentCatalog.removeNoStore must not be null");
        }
        this.removeInternal(qualifiedName, false);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public VFile getFileForType(String qname) throws TypeCatalogException {
        VFile[] files = null;
        TypeRef typeRef = this.find(qname);
        if (typeRef != null) {
            files = (VFile[])typeRef.get().asObject().getTransientProperty("files");
        }
        return files != null ? files[0] : null;
    }

    @Override
    public TypeInfo getInfo(TypeRef ref) {
        TypeInfo info = null;
        if (ref != null) {
            TypeHandle handle = this.getTypeHandle(ref);
            info = handle != null ? handle.getInfo() : null;
        }
        return info;
    }

    @Override
    public Object getOwner() {
        return this.owner;
    }

    @Override
    public boolean hasChildren(TypeRef ref) {
        TypeHandle typeHandle = this.getTypeHandle(ref);
        return typeHandle != null && typeHandle.hasChildren();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public synchronized boolean isReadOnly(TypeRef type) {
        ComponentBundle bundle = this.safeGetBundle(type);
        return !bundle.isMutable() || bundle.asMutable().isReadOnly(type);
    }

    @Override
    public boolean isWorkingInMemory() {
        return this.workingInMemory;
    }

    @Override
    public TypeRef reload(TypeRef type) {
        try {
            this.getDefaultStorageBundle().reloadType(type);
            return this.find(type.getText());
        }
        catch (AmbiguousTypeNameException e) {
            return null;
        }
        catch (TypeCatalogException e) {
            return null;
        }
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setMonitor(ProgressMonitor monitor) {
        this.monitor = monitor != null ? monitor : ProgressMonitor.NULL_INSTANCE;
    }

    @Override
    public void setOwner(Object owner) {
        this.owner = owner;
    }

    @Override
    public void setReadOnly(boolean ro) {
        if (this.isLoaded()) {
            throw new IllegalStateException("Read only cannot be called after loading.");
        }
        this.readOnly = ro;
    }

    @Override
    public void setWorkingInMemory(boolean workingInMemory) {
        this.workingInMemory = workingInMemory;
        if (this.workingInMemory) {
            this.setDefaultStorageBundle(new MemoryMutableComponentBundle("fuego.memory.volatile"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void sync() {
        if (this.isWorkingInMemory()) {
            return;
        }
        try {
            this.monitor.progress(0);
            this.transientChanges = new TypeCache.Changes();
            this.listeners.firePreSync();
            TypeCache.Changes changes = this.getCache().sync(this.bundles, this.monitor);
            changes.removed.addAll(this.transientChanges.removed);
            changes.added.addAll(this.transientChanges.added);
            this.fireTypesRemoved(changes.removed);
            this.fireTypesAdded(changes.added);
        }
        finally {
            this.transientChanges = null;
            this.listeners.firePostSync();
            this.monitor.progress(100);
        }
    }

    public String toString() {
        return "DefaultComponentCatalog(description: " + this.description + (this.parentCatalog == null ? "" : " extends \n" + this.parentCatalog);
    }

    @Override
    public void unloadTypes() {
        this.getCache().free();
    }

    public void printDump() {
        System.out.println("Catalog " + this.toString() + " created at: ");
        System.out.println("bundles: " + this.bundles);
        if (this.parentCatalog != null && this.parentCatalog instanceof DefaultComponentCatalog) {
            ((DefaultComponentCatalog)this.parentCatalog).printDump();
        }
    }

    public void dumpTypes() {
        ObjectTypeDescription root = this.getRoot();
        StringBuffer buffer = this.dumpType(root);
        System.out.print(buffer);
    }

    public void dump() {
        StringBuilder builder = new StringBuilder();
        builder.append("Catalog: ").append(this.getDescription()).append('\n');
        builder.append("Catalog.Parent: ").append(this.parentCatalog).append('\n');
        builder.append("Bundles:\n");
        for (ComponentBundle bundle : this.bundles) {
            builder.append('\t').append(bundle).append('\n');
        }
        builder.append('\n');
        System.out.println(builder.toString());
        if (this.parentCatalog != null && this.parentCatalog instanceof DefaultComponentCatalog) {
            ((DefaultComponentCatalog)this.parentCatalog).dump();
        }
    }

    @Override
    public void typeAdded(String typeName, ComponentBundle bundle) {
        if (!this.adding.wasExpected(typeName)) {
            try {
                TypeRef typeRef = this.find(typeName);
                if (typeRef != null) {
                    return;
                }
            }
            catch (AmbiguousTypeNameException e) {
                // empty catch block
            }
            TypeHandle addedType = this.getCache().addAll(bundle, TypeUtils.moduleName(typeName, ""), TypeUtils.shortName(typeName), false);
            if (this.transientChanges != null) {
                this.transientChanges.added.add(addedType);
            } else {
                this.listeners.fireTypeAdded(typeName);
            }
        }
    }

    @Override
    public void typeRemoved(String typeName, ComponentBundle bundle) {
        if (!this.removing.wasExpected(typeName)) {
            try {
                TypeRef typeRef = this.find(typeName);
                if (typeRef != null) {
                    TypeHandle typeHandle = this.getTypeHandle(typeRef);
                    String parentName = typeHandle.getModule();
                    TypeDescription parent = null;
                    if (parentName != null && parentName.length() > 0) {
                        TypeRef parentRef = this.find(parentName);
                        if (parentRef != null) {
                            TypeHandle parentHandle = this.getTypeHandle(parentRef);
                            parent = parentHandle.getIfLoaded();
                        }
                    } else {
                        parent = this.getRoot();
                    }
                    List<TypeHandle> typesToRemove = this.getCache().getTypesToRemove(typeHandle);
                    this.getCache().deepRemove(typeHandle);
                    this.fireTypesRemoved(typesToRemove);
                    if (parent != null) {
                        parent.asObject().removeInnerType(typeRef);
                    }
                }
            }
            catch (AmbiguousTypeNameException e) {
                throw ProgramException.wrap("Catalog was notified of removed type '" + typeName + "' but this is ambiguous", e);
            }
        }
    }

    @Override
    public MutableComponentCatalog getParentCatalog() {
        return this.parentCatalog;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public void dispose() {
        for (ComponentBundle bundle : this.bundles) {
            bundle.removeBundleListener(this);
            bundle.dispose();
        }
        this.bundles.clear();
        this.removeListeners();
        this.disposed = true;
    }

    @Override
    public void redefineParent(MutableComponentCatalog parentCatalog) {
        this.setParent(parentCatalog);
        ((TypeCache.RootRef)this.getRootRef()).rebuild();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public SortedSet<String> findByPropertyValue(@NotNull String property, @NotNull String value) {
        if (property == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/DefaultComponentCatalog.findByPropertyValue must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/type/DefaultComponentCatalog.findByPropertyValue must not be null");
        }
        SortedSet<String> sortedSet = this.getCache().getPropertyIndex().findByPropertyValue(property, value);
        if (sortedSet == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/type/DefaultComponentCatalog.findByPropertyValue must not return null");
        }
        return sortedSet;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PropertyIndex getPropertyIndex() {
        SimplePropertyIndex simplePropertyIndex = this.getCache().getPropertyIndex();
        if (simplePropertyIndex == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/type/DefaultComponentCatalog.getPropertyIndex must not return null");
        }
        return simplePropertyIndex;
    }

    @Override
    public DynamicRef getLazyRef(String text) {
        return this.lazyRefs.get(text);
    }

    @Override
    public void putLazyRef(String text, DynamicRef type) {
        this.lazyRefs.put(text, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public TypeCache getCache() {
        this.assertNotDisposed();
        TypeCache result = this.cache;
        if (result == null) {
            DefaultComponentCatalog defaultComponentCatalog = this;
            synchronized (defaultComponentCatalog) {
                result = this.cache;
                if (result == null) {
                    this.cache = result = new TypeCache(this);
                }
            }
        }
        TypeCache typeCache = result;
        if (typeCache == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/type/DefaultComponentCatalog.getCache must not return null");
        }
        return typeCache;
    }

    @Override
    public void addListener(CatalogListener listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public void removeListeners() {
        this.listeners.removeListeners();
    }

    @Override
    public TypeRef add(ObjectTypeDescription type) throws TypeCatalogException {
        return this.addInternal(type, TypeUtils.moduleName(type.getText(), ""), true, true);
    }

    @Override
    public TypeRef addNoStore(@NotNull ObjectTypeDescription type, @NotNull String module) throws TypeCatalogException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/DefaultComponentCatalog.addNoStore must not be null");
        }
        if (module == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/type/DefaultComponentCatalog.addNoStore must not be null");
        }
        return this.addInternal(type, module, false, true);
    }

    @Override
    public boolean containsType(String qualifiedTypeName) {
        return this.getCache().getExactMatch(qualifiedTypeName) != null;
    }

    synchronized void removeInternal(String qualifiedName, boolean remove) throws TypeCatalogException {
        ComponentBundle bundle;
        DefaultComponentCatalog.assertNotNullArgument(qualifiedName, "Invalid null type");
        if (this.isReadOnly()) {
            throw new ReadOnlyRepositoryException(this);
        }
        if ("".equals(qualifiedName)) {
            throw new TypeCatalogException((ComponentCatalog)this, CoreMsg.CANNOTREMOVEROOT);
        }
        TypeHandle handle = this.getExactMatchHandle(qualifiedName);
        List<TypeHandle> types = this.getCache().getTypesToRemove(handle);
        this.getCache().deepRemove(handle);
        if (remove && !this.isWorkingInMemory() && !handle.isStrong() && (bundle = handle.getBundle()).isMutable()) {
            for (int i = types.size() - 1; i >= 0; --i) {
                TypeHandle typeHandle = types.get(i);
                bundle.asMutable().remove(typeHandle.getText());
            }
        }
        if (this.transientChanges != null) {
            this.transientChanges.removed.addAll(types);
        } else {
            this.fireTypesRemoved(types);
        }
    }

    ProgressMonitor getMonitor() {
        return this.monitor;
    }

    synchronized TypeRef addInternal(ObjectTypeDescription type, String module, boolean store, boolean fireEvents) throws TypeCatalogException {
        TypeRef result;
        DefaultComponentCatalog.assertNotNullArgument(type, "Attempt to add null type");
        this.assertNotDisposed();
        TypeRef parentRef = null;
        ArrayList<TypeHandle> newTypes = new ArrayList<TypeHandle>();
        try {
            this.getCache().assertNotContains(type, module);
            parentRef = type.getParentRef();
            if (parentRef == null) {
                TypeCache typeCache = this.getCache();
                parentRef = typeCache.getExactMatch(module);
                if (parentRef == null) {
                    typeCache.addAll(this.getDefaultStorageBundle(), TypeUtils.moduleName(module, ""), TypeUtils.shortName(module), true, newTypes);
                    parentRef = (TypeRef)newTypes.get(0);
                }
                ObjectTypeDescription obj = parentRef.get().asObject();
                obj.incrLoading();
                obj.addInnerType(type);
                obj.decrLoading();
            }
            String parentModule = parentRef.getText();
            ComponentBundle storageBundle = this.safeGetBundle(parentRef);
            result = this.addRecursive(type, parentModule, storageBundle, store);
            if (store) {
                this.storeRecursive(type, parentModule, storageBundle);
            }
            parentRef.get().asObject().replaceInnerWithSameText(result);
        }
        catch (TypeCatalogException e) {
            if (parentRef != null) {
                parentRef.get().asObject().removeInnerType(type);
            }
            throw e;
        }
        newTypes.add((TypeHandle)result);
        if (fireEvents) {
            if (this.transientChanges != null) {
                this.transientChanges.added.addAll(newTypes);
            } else {
                this.fireTypesAdded(newTypes);
            }
        }
        return result;
    }

    private synchronized TypeRef findMatchingBpmObject(@NotNull String id, boolean exception) {
        XmlUUID xmlUUID;
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/DefaultComponentCatalog.findMatchingBpmObject must not be null");
        }
        DefaultComponentCatalog.assertNotNullArgument(id, "Invalid null id");
        this.assertNotDisposed();
        TypeRef found = this.findBpmObjectBySchemaId(id, exception);
        if (found != null) {
            return found;
        }
        char c = id.charAt(0);
        if ((c == XmlElementType.ELEMENT.getCharCode() || c == XmlElementType.TYPE.getCharCode()) && (xmlUUID = UUIDFactory.parseXmlId(id)).getNamespace().startsWith("http://xmlns.oracle.com/bpm/bpmobject/")) {
            XmlElementType elemType = xmlUUID.getElemType();
            String name = xmlUUID.getNativeName();
            if (elemType == XmlElementType.TYPE) {
                if (name.endsWith("Type")) {
                    String elementName = name.substring(0, name.length() - "Type".length());
                    String searchId = UUIDFactory.createXmlId(XmlElementType.ELEMENT, xmlUUID.getNamespace(), elementName).getId();
                    TypeRef ref = this.findBpmObjectBySchemaId(searchId, exception);
                    if (ref != null) {
                        return ref;
                    }
                }
            } else {
                String complexTypeName = name + "Type";
                String searchId = UUIDFactory.createXmlId(XmlElementType.TYPE, xmlUUID.getNamespace(), complexTypeName).getId();
                TypeRef ref = this.findBpmObjectBySchemaId(searchId, exception);
                if (ref != null) {
                    return ref;
                }
            }
        }
        return null;
    }

    private TypeRef findBpmObjectBySchemaId(@NotNull String id, boolean exception) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/DefaultComponentCatalog.findBpmObjectBySchemaId must not be null");
        }
        DefaultComponentCatalog.assertNotNullArgument(id, "Invalid null id");
        this.assertNotDisposed();
        TypeRef result = null;
        SortedSet<String> delegatedFromSet = this.findByPropertyValue("attributes.schema.id", id);
        for (String typeName : delegatedFromSet) {
            try {
                TypeRef ref = this.find(typeName);
                assert (ref.getComponentType().equals(ComponentType.XOBJECT.getText())) : "Type '" + ref.getText() + "' is not a Business Object";
                if (exception) {
                    if (!Modifier.isException(ref.getModifiers())) continue;
                    if (result != null) {
                        throw new IllegalStateException("There is more than one Exception Object modelling schema '" + id + "'");
                    }
                    result = ref;
                    continue;
                }
                if (result != null) {
                    throw new IllegalStateException("There is more than one Business Object modelling schema '" + id + "'");
                }
                result = ref;
            }
            catch (AmbiguousTypeNameException e) {
                if (!Log.isDebugging()) continue;
                Log.logDebug(e);
            }
        }
        return result;
    }

    private StringBuffer dumpType(@NotNull ObjectTypeDescription type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/DefaultComponentCatalog.dumpType must not be null");
        }
        StringBuffer result = new StringBuffer();
        int typeCount = type.getInnerTypeCount();
        result.append(type.getText());
        result.append("(");
        result.append(type.getComponentType());
        result.append(")\n");
        for (int i = 0; i < typeCount; ++i) {
            result.append(this.dumpType(type.getInnerType(i)));
        }
        return result;
    }

    private boolean isLoaded() {
        return this.cache != null;
    }

    private void fireTypesRemoved(Iterable<TypeHandle> typesToRemove) {
        for (TypeHandle handle : typesToRemove) {
            this.listeners.fireTypeRemoved(handle);
        }
    }

    private void fireTypesAdded(Iterable<TypeHandle> typeHandles) {
        for (TypeHandle handle : typeHandles) {
            this.listeners.fireTypeAdded(handle.getText());
        }
    }

    private void assertNotDisposed() {
        if (this.isDisposed()) {
            // empty if block
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private TypeHandle getExactMatchHandle(String typeQualifiedName) throws NoSuchComponentTypeException {
        TypeHandle type = this.getCache().getExactMatch(typeQualifiedName);
        if (type == null) {
            throw new NoSuchComponentTypeException((ComponentCatalog)this, typeQualifiedName);
        }
        TypeHandle typeHandle = type;
        if (typeHandle == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/type/DefaultComponentCatalog.getExactMatchHandle must not return null");
        }
        return typeHandle;
    }

    private synchronized void store(ObjectTypeDescription type, ComponentBundle componentBundle) throws TypeCatalogException {
        DefaultComponentCatalog.assertNotNullArgument(type, "Invalid null type");
        if (type.isSynthesized() || type.isModule() && type.getParentRef() == null) {
            return;
        }
        if (componentBundle == null) {
            throw new IllegalArgumentException("Missing target bundle for component '" + type + "' in catalog: " + this);
        }
        if (!componentBundle.isMutable()) {
            return;
        }
        componentBundle.asMutable().store(type);
    }

    private void setParent(MutableComponentCatalog parentCatalog) {
        this.parentCatalog = parentCatalog;
    }

    private void putBundleIfAbsent(ComponentBundle bundle) {
        if (!this.bundles.contains(bundle)) {
            this.bundles.add(bundle);
            bundle.addBundleListener(this);
        }
    }

    private void storeRecursive(ObjectTypeDescription type, String module, ComponentBundle bundle) throws TypeCatalogException {
        if (!this.isWorkingInMemory()) {
            this.store(type, bundle);
            String qname = TypeUtils.qualifiedName(module, type.getName());
            for (int i = 0; i < type.getInnerTypeCount(); ++i) {
                this.storeRecursive(type.getInnerType(i), qname, bundle);
            }
        }
    }

    private void checkExistingBpmObjectFromSchema(ObjectTypeDescription root) {
        XObjectTypeDescription bpmo;
        TypeRef ref;
        if (root instanceof XObjectTypeDescription && (ref = this.findMatchingBpmObject(TypeUtils.getAttributesObjectId(root), Modifier.isException(root.getModifiers()))) != null && !(bpmo = ref.get().asBpmObject()).isSynthesized() && !bpmo.equals(root)) {
            String qname = bpmo.asSchemaObject().getQName().toString();
            throw new IllegalArgumentException(LibMsg.BPMO_FROM_SCHEMA_ALREADY_EXISTS(qname, bpmo).toString());
        }
    }

    private TypeRef addRecursive(ObjectTypeDescription type, String module, ComponentBundle bundle, boolean store) throws ReadOnlyRepositoryException, ReadOnlyCatalogException {
        if (this.isReadOnly()) {
            throw new ReadOnlyRepositoryException(this);
        }
        if (store) {
            this.checkExistingBpmObjectFromSchema(type);
        }
        type.setCatalog(this);
        TypeHandle ref = null;
        TypeCache typeCache = this.getCache();
        try {
            String qname = TypeUtils.qualifiedName(module, type.getName());
            ref = typeCache.addOrUpdate(type, bundle, module, type.getName(), false);
            ref.set(type);
            for (int i = 0; i < type.getInnerTypeCount(); ++i) {
                type.replaceInnerAt(i, this.addRecursive(type.getInnerType(i), qname, bundle, store));
            }
        }
        catch (ReadOnlyCatalogException e) {
            typeCache.remove(type.getText());
            throw e;
        }
        catch (TypeCatalogException e) {
            Log.logSevere(e);
            this.monitor.error(LibMsg.COULDNT_STORE_TYPE(type.getText()));
        }
        catch (Throwable unexpected) {
            Log.logSevere(unexpected);
            this.monitor.error(LibMsg.COULDNT_STORE_TYPE(type.getText()));
        }
        type.setRef(ref);
        return ref;
    }

    private TypeRef getRootRef() {
        try {
            return this.find("");
        }
        catch (AmbiguousTypeNameException e) {
            assert (false) : e;
            return null;
        }
    }

    private TypeHandle getTypeHandle(TypeRef ref) {
        if (ref instanceof TypeHandle) {
            return (TypeHandle)ref;
        }
        String text = ref.getText();
        return this.getCache().getExactMatch(text);
    }

    private ComponentBundle safeGetBundle(TypeRef typeRef) {
        TypeHandle handle = this.getCache().getExactMatch(typeRef.getText());
        if (handle != null && handle.getBundle() != null) {
            return handle.getBundle();
        }
        return this.getDefaultStorageBundle();
    }

    static class PendingEvents
    extends HashMap<String, PendingEvent> {
        private static final long serialVersionUID = 6946138375704479393L;

        PendingEvents() {
        }

        public PendingEvent waitFor(String typeName) {
            PendingEvent pendingEvent = new PendingEvent(typeName, this);
            this.put(typeName, pendingEvent);
            return pendingEvent;
        }

        public boolean wasExpected(String qualifiedName) {
            return this.remove(qualifiedName) != null;
        }
    }

    static class PendingEvent {
        String typeName;
        private PendingEvents all;

        PendingEvent(String typeName, PendingEvents all) {
            this.typeName = typeName;
            this.all = all;
        }

        void cancel() {
            this.all.remove(this.typeName);
        }
    }
}

