/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.extension.ExtensionService;
import oracle.bpm.extensionpoint.metadata.ComponentRendererMetadata;
import oracle.bpm.extensionpoint.metadata.IntrospectorMetadata;
import oracle.bpm.lang.Platform;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;

public interface ComponentRenderer {
    public Msg getIcon(@NotNull TypeRef var1);

    public Msg getLabel(@NotNull TypeRef var1);

    public Msg getMsg();

    public static abstract class Default
    implements ComponentRenderer {
        @Override
        public abstract Msg getMsg();

        @Override
        public Msg getIcon(@NotNull TypeRef typeRef) {
            if (typeRef == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/ComponentRenderer$Default.getIcon must not be null");
            }
            return this.getLabel(typeRef);
        }

        @Override
        public Msg getLabel(@NotNull TypeRef typeRef) {
            if (typeRef == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/ComponentRenderer$Default.getLabel must not be null");
            }
            return this.getMsg();
        }
    }

    public static class Extension {
        private static Map<String, ComponentRenderer> cache = Collections.synchronizedMap(new HashMap());

        public static ComponentRenderer find(String type) {
            ComponentRenderer result = cache.get(type);
            if (result == null) {
                ExtensionService extensionService = Platform.getExtensionService();
                List<oracle.bpm.extension.Extension<ComponentRendererMetadata>> extensions = extensionService.getExtensionsByPoint(ComponentRendererMetadata.class);
                for (oracle.bpm.extension.Extension<ComponentRendererMetadata> extension : extensions) {
                    ComponentRendererMetadata metadata = extension.getMetadata();
                    if (!metadata.type().equals(type)) continue;
                    try {
                        result = extension.instantiateAs(ComponentRenderer.class);
                        break;
                    }
                    catch (InstantiationException e) {
                        throw new RuntimeException(e);
                    }
                }
                cache.put(type, result);
            }
            return result;
        }

        public static ComponentRenderer find(oracle.bpm.extension.Extension<IntrospectorMetadata> extension) {
            String type = extension.getMetadata().type();
            return Extension.find(type);
        }
    }
}

