/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.extension.Extension;
import oracle.bpm.extensionpoint.metadata.IntrospectorMetadata;
import oracle.bpm.lang.JavaIntrospector;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.IntrospectionException;
import oracle.bpm.type.IntrospectionRules;
import oracle.bpm.type.Introspector;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeBeautifier;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.type.catalog.DirectoryComponentBundle;
import oracle.bpm.util.FileUtils;
import oracle.bpm.util.FuegoDirectories;
import oracle.bpm.util.Identifier;
import oracle.bpm.util.ProgressMonitor;

public class CommandLineIntrospector
implements ProgressMonitor {
    private String componentType;
    private String moduleName;
    private Map<String, String> properties;
    private String repositoryPath;
    private File rulesFile;

    public static void main(String[] args) {
        CommandLineIntrospector cli = new CommandLineIntrospector();
        int argc = args.length;
        if (argc < 3) {
            System.out.println("Usage: CommandLineIntrospector <repository-path> <component-type> <rules> [argName=argValue]*");
            System.exit(1);
        }
        cli.setRepositoryPath(args[0]);
        cli.setComponentType(args[1]);
        cli.setRulesFile(new File(args[2]));
        HashMap<String, String> properties = new HashMap<String, String>();
        for (int i = 2; i < argc; ++i) {
            String arg = args[i];
            int eq = arg.indexOf(61);
            if (eq == -1) continue;
            String name = arg.substring(0, eq);
            String value = arg.substring(eq + 1);
            properties.put(name, value);
        }
        System.out.println("properties: " + properties);
        cli.setProperties(properties);
        try {
            cli.introspect();
        }
        catch (IntrospectionException e) {
            System.err.println(e.getMessage());
        }
        catch (TypeCatalogException e) {
            System.err.println(e.getMessage());
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setRepositoryPath(String repositoryPath) {
        this.repositoryPath = repositoryPath;
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    @Override
    public void error(Msg message) {
        System.err.println("error: " + message);
    }

    @Override
    public void info(Msg message) {
        System.err.println("info: " + message);
    }

    @Override
    public void info(int logLevel, Msg message) {
        if (logLevel != 2) {
            System.err.println("info: " + message);
        }
    }

    public void setRulesFile(File rulesFile) {
        this.rulesFile = rulesFile;
    }

    @Override
    public void phase(Msg message) {
        System.out.println("phase: " + message);
    }

    @Override
    public void progress(int percent) {
    }

    @Override
    public void warning(Msg message) {
        System.err.println("warning: " + message);
    }

    private void introspect() throws IntrospectionException, TypeCatalogException, IOException {
        Introspector introspector;
        JavaIntrospector.class.getName();
        MutableComponentCatalog repository = TypeUtils.createComponentCatalog(TypeUtils.getDefaultCatalog());
        File storeDir = new File(this.repositoryPath);
        repository.setDefaultStorageBundle(new DirectoryComponentBundle(storeDir));
        File cacheDir = new File(FuegoDirectories.temp(), "tmpcatalog" + File.separator + storeDir.getName());
        FileUtils.deleteDirectory(cacheDir);
        repository.sync();
        Extension<IntrospectorMetadata> extension = Introspector.Extension.find(this.componentType);
        try {
            introspector = extension.instantiateAs(Introspector.class);
        }
        catch (InstantiationException e) {
            throw new IntrospectionException(LibMsg.INSTANTIATION_EXCEPTION, (Throwable)e);
        }
        Map<String, Object> props = introspector.defaultProperties();
        if (this.properties != null) {
            props.putAll(this.properties);
        }
        TypeDescription[] objects = introspector.introspect(props, repository, this);
        TypeBeautifier beautifier = new TypeBeautifier();
        beautifier.beautify((ObjectTypeDescription[])objects, this);
        IntrospectionRules rules = IntrospectionRules.parse(this.rulesFile);
        objects = (ObjectTypeDescription[])rules.apply(objects);
        if (this.moduleName != null) {
            ObjectTypeDescription module = new ObjectTypeDescription(Identifier.classname(this.moduleName));
            for (TypeDescription object : objects) {
                module.addInnerType(object);
            }
            repository.add(module);
        } else {
            for (TypeDescription object : objects) {
                repository.add((ObjectTypeDescription)object);
            }
        }
    }
}

