/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.util.StringCache;
import oracle.bpm.xobject.presentationmodel.XFormArray;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormGraphic;
import oracle.bpm.xobject.presentationmodel.XFormPresentation;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;
import oracle.bpm.xobject.presentationmodel.XFormRepeatablesection;
import oracle.bpm.xobject.presentationmodel.XFormRow;
import oracle.bpm.xobject.presentationmodel.XFormTable;
import oracle.bpm.xobject.presentationmodel.XFormUserInputPresentationXMLObject;

public abstract class AbstractPresentationMigrator {
    protected String currentParentName;
    protected XObjectTypeDescription obj;
    protected StringList requiredAttributes;
    private StringCache stringCache = new StringCache(300);

    public AbstractPresentationMigrator(XObjectTypeDescription obj, String currentParentName, StringList requiredAttributes) {
        this.obj = obj;
        this.currentParentName = currentParentName;
        this.requiredAttributes = requiredAttributes;
    }

    public XObjectTypeDescription migrate() {
        Map<String, XFormPresentationModel> pres = this.obj.getPresentations();
        HashMap<String, String> groupMethods = new HashMap<String, String>();
        if (pres != null) {
            Iterator<XFormPresentationModel> i$ = pres.values().iterator();
            while (i$.hasNext()) {
                XFormPresentationModel o;
                XFormPresentationModel pModel = o = i$.next();
                XFormPresentation presentation = (XFormPresentation)pModel.get();
                if (presentation.table == null) continue;
                this.migratePresentationTable(presentation.table, groupMethods);
            }
            if (!groupMethods.isEmpty()) {
                this.migrateGroupMethod(groupMethods);
            }
        }
        return this.obj;
    }

    protected void migrateGroupMethod(Map<String, String> groupMethods) {
    }

    protected void migrateCellSetting(XFormCell cll) {
    }

    protected void migratePresentationComponent(XFormUserInputPresentationXMLObject comp, String arrayRef, Map<String, String> groupMethods) {
    }

    protected void migratePresentationLabel(XFormCell cll) {
    }

    protected void migrateArraySetting(XFormArray array) {
    }

    protected void migrateTableSetting(XFormTable table) {
    }

    protected String cachedString(String string) {
        return string != null ? this.stringCache.getString(string) : null;
    }

    protected void migrateRepeatableSettings(XFormRepeatablesection repeatablesection) {
    }

    protected void migratePresentationGraphic(XFormGraphic graphic, String arrayRef, Map<String, String> groupMethods) {
    }

    private void migratePresentationArray(XFormArray array, Map<String, String> groupMethods) {
        this.migrateArraySetting(array);
        if (array.row != null) {
            this.migratePresentationRow(array.row, array.reference, groupMethods);
        }
    }

    private void migratePresentationTable(XFormTable table, Map<String, String> groupMethods) {
        if (table == null) {
            return;
        }
        this.migrateTableSetting(table);
        this.migratePresentationRows(table.row, groupMethods);
    }

    private void migratePresentationRow(XFormRow row, String arrayRef, Map<String, String> groupMethods) {
        this.migratePresentationCells(row.cell, arrayRef, groupMethods);
    }

    private void migratePresentationRows(XFormRow[] row, Map<String, String> groupMethods) {
        if (row == null) {
            return;
        }
        for (XFormRow rw : row) {
            this.migratePresentationCells(rw.cell, null, groupMethods);
        }
    }

    private void migratePresentationCells(XFormCell[] cell, String arrayRef, Map<String, String> groupMethods) {
        if (cell == null) {
            return;
        }
        for (XFormCell cll : cell) {
            this.migrateCellSetting(cll);
            if (cll.repeatablesection != null) {
                this.migratePresentationRepeatable(cll.repeatablesection, arrayRef, groupMethods);
                continue;
            }
            if (cll.table != null) {
                this.migratePresentationTable(cll.table, groupMethods);
                continue;
            }
            if (cll.array != null) {
                this.migratePresentationArray(cll.array, groupMethods);
                continue;
            }
            if (cll.gauge != null) {
                this.migratePresentationGraphic(cll.gauge, arrayRef, groupMethods);
                continue;
            }
            if (cll.pie != null) {
                this.migratePresentationGraphic(cll.pie, arrayRef, groupMethods);
                continue;
            }
            if (cll.chart != null) {
                this.migratePresentationGraphic(cll.chart, arrayRef, groupMethods);
                continue;
            }
            if (cll.check != null) {
                this.migratePresentationComponent(cll.check, arrayRef, groupMethods);
                continue;
            }
            if (cll.combo != null) {
                this.migratePresentationComponent(cll.combo, arrayRef, groupMethods);
                continue;
            }
            if (cll.datetimepiker != null) {
                this.migratePresentationComponent(cll.datetimepiker, arrayRef, groupMethods);
                continue;
            }
            if (cll.image != null) {
                this.migratePresentationComponent(cll.image, arrayRef, groupMethods);
                continue;
            }
            if (cll.multilinetext != null) {
                this.migratePresentationComponent(cll.multilinetext, arrayRef, groupMethods);
                continue;
            }
            if (cll.interval != null) {
                this.migratePresentationComponent(cll.interval, arrayRef, groupMethods);
                continue;
            }
            if (cll.radio != null) {
                this.migratePresentationComponent(cll.radio, arrayRef, groupMethods);
                continue;
            }
            if (cll.text != null) {
                this.migratePresentationComponent(cll.text, arrayRef, groupMethods);
                continue;
            }
            if (cll.label == null) continue;
            this.migratePresentationLabel(cll);
        }
    }

    private void migratePresentationRepeatable(XFormRepeatablesection repeatablesection, String arrayRef, Map<String, String> groupMethods) {
        this.migrateRepeatableSettings(repeatablesection);
        XFormRow row = repeatablesection.row;
        if (row != null) {
            this.migratePresentationRow(row, arrayRef, groupMethods);
        }
    }
}

