/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import oracle.bpm.component.Component;
import oracle.bpm.component.ContextEvent;
import oracle.bpm.component.ContextListener;
import oracle.bpm.component.ExecutionThreadContext;
import oracle.bpm.connector.ConnectorException;
import oracle.bpm.connector.ConnectorTransaction;
import oracle.bpm.connector.JDBCHelper;
import oracle.bpm.io.TransferOutputStream;
import oracle.bpm.jdbc.DatabaseManager;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.RuntimeExceptionShell;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;
import oracle.bpm.sql.SQLObject;
import oracle.bpm.sql.SQLUtils;
import oracle.bpm.util.ExecutionContext;
import oracle.bpm.util.ExecutionContextAccessor;

public class TableSQLObject
extends SQLObject {
    private Map<TableSQLObject, Map<String, String>> attachments;
    private String deleteStmt;
    private String insertStmt;
    private Set<String> pkMembers;
    private Map<Object, Boolean> pkSet;
    private String schema;
    private String selectStmt;
    private int state = 0;
    private String updateStmt;
    private static final int NOT_LOADED = 0;
    private static final int MUST_UPDATE = 1;
    private static final int EXISTS = 2;
    private static final int MUST_INSERT = 3;
    static final long serialVersionUID = -8329280375969859769L;
    static final long serialCheck = 4818903959261527148L;

    public TableSQLObject(String moduleName, String signature) {
        super(moduleName, signature);
        this.registerListener();
        this.parseTableSignature(signature);
    }

    private TableSQLObject() {
    }

    @Override
    public void setFieldValue(String field, Object value) {
        boolean isInPK = this.isPrimaryKey(field);
        if (isInPK) {
            boolean valueHasChanged;
            boolean bl = valueHasChanged = !Any.equals(super.getFieldValue(field), value);
            if (valueHasChanged) {
                this.pkSet.put(field.toUpperCase(), value != null ? Boolean.TRUE : Boolean.FALSE);
                this.state = 0;
            }
        } else if (this.isAccessDatabase()) {
            this.checkPrimaryKey();
            if (this.state == 2) {
                this.state = 1;
            }
        }
        if ("MsetAccessDatabase(Z)V".equals(field)) {
            assert (value != null);
            this.setAccessDatabase((Boolean)value);
        }
        super.setFieldValue(field, value);
    }

    @Override
    public Object getFieldValue(String field) {
        if (this.state == 0 && !this.isPrimaryKey(field) && this.isAccessDatabase()) {
            this.checkPrimaryKey();
        }
        if ("MisAccessDatabase()Z".equals(field)) {
            return this.isAccessDatabase();
        }
        return super.getFieldValue(field);
    }

    @Override
    public String getName() {
        return this.getObjectName();
    }

    public void add() throws oracle.bpm.components.SQLException {
        Statement insert = null;
        try {
            this.setAccessDatabase(true);
            this.rebuildStatements();
            insert = this.getInsertStatement();
            this.setFldParams((PreparedStatement)insert);
            insert.executeUpdate();
            this.state = 2;
            if (this.attachments != null) {
                this.addAttachments(this.attachments);
            }
        }
        catch (SQLException e) {
            throw new oracle.bpm.components.SQLException(e);
        }
        finally {
            if (insert != null) {
                try {
                    insert.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    @Override
    public synchronized void close() throws oracle.bpm.components.SQLException {
        if (this.attachments != null) {
            this.close(this.attachments);
        }
    }

    public void join(TableSQLObject table) {
        this.join(table, null);
    }

    public void join(TableSQLObject table, Map<String, String> foreingKeys) {
        if (this.attachments == null) {
            this.attachments = new LinkedHashMap<TableSQLObject, Map<String, String>>();
        }
        this.attachments.put(table, foreingKeys);
    }

    public void join(List<TableSQLObject> table) {
        this.join(table, null);
    }

    public void join(List<TableSQLObject> tables, Map<String, String> foreignKeys) {
        this.setAccessDatabase(true);
        if (this.attachments == null) {
            this.attachments = new LinkedHashMap<TableSQLObject, Map<String, String>>();
        }
        for (TableSQLObject table : tables) {
            this.attachments.put(table, foreignKeys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean load() throws oracle.bpm.components.SQLException {
        try {
            this.setAccessDatabase(true);
            this.checkPkOperation("load");
            this.rebuildStatements();
            PreparedStatement select = this.getSelectStatement();
            this.setPrimaryKeys(select);
            ResultSet result = null;
            try {
                result = select.executeQuery();
                if (!result.next()) {
                    this.state = 3;
                    boolean bl2 = false;
                    return bl2;
                }
                this.loadValuesFrom(result);
                if (this.attachments != null) {
                    this.loadAttachments(this.attachments);
                }
                this.state = 2;
                boolean bl = true;
                return bl;
            }
            finally {
                if (result != null) {
                    result.close();
                }
                if (select != null) {
                    select.close();
                }
            }
        }
        catch (SQLException e) {
            throw new oracle.bpm.components.SQLException(e);
        }
    }

    @Override
    public void remove() throws oracle.bpm.components.SQLException {
        Statement delete = null;
        try {
            this.setAccessDatabase(true);
            this.checkPkOperation("remove");
            if (this.attachments != null) {
                this.removeAttachements(this.attachments);
            }
            this.rebuildStatements();
            delete = this.getDeleteStatement();
            this.setPrimaryKeys((PreparedStatement)delete);
            delete.executeUpdate();
            this.clearPkSet();
            this.fields.clear();
            this.state = 0;
        }
        catch (SQLException e) {
            throw new oracle.bpm.components.SQLException(e);
        }
        finally {
            if (delete != null) {
                try {
                    delete.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    @Override
    public void store() throws oracle.bpm.components.SQLException {
        this.setAccessDatabase(true);
        if (this.state == 2) {
            this.state = 1;
        }
        this.implicitStore();
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    String getFullName() {
        String name = this.getObjectName();
        if (this.schema != null && !"".equals(this.schema)) {
            name = this.schema + "." + name;
        }
        return name;
    }

    void implicitStore() throws oracle.bpm.components.SQLException {
        if (!this.isPrimaryKeySet() && !this.pkSet.isEmpty()) {
            Log.logWarning(LibMsg.PK_NOT_SET(this.toString(), this.getName()));
            return;
        }
        assert (this.isServerSide()) : "Component.Location must be Server, but is: " + Component.getLocation();
        try {
            this.rebuildStatements();
            this.checkPrimaryKey();
            if (this.state == 1) {
                SQLException recoverableException;
                boolean success = this.update();
                if (!success && (recoverableException = this.insert()) != null) {
                    throw recoverableException;
                }
                this.state = 2;
            } else if (this.state == 3) {
                boolean success;
                SQLException recoverableException = this.insert();
                if (recoverableException != null && !(success = this.update())) {
                    throw recoverableException;
                }
                this.state = 2;
            }
            if (this.attachments != null) {
                this.storeAttachements(this.attachments);
            }
        }
        catch (SQLException e) {
            throw new oracle.bpm.components.SQLException(e);
        }
    }

    private Connection getConnection() throws SQLException {
        Connection conn;
        try {
            String moduleName = this.getModuleName();
            conn = JDBCHelper.getConnection(moduleName);
        }
        catch (ConnectorException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            SQLException sqlException = new SQLException(e.getMessage());
            sqlException.initCause(e);
            throw sqlException;
        }
        return conn;
    }

    private PreparedStatement getDeleteStatement() throws SQLException {
        this.rebuildStatements();
        return this.getConnection().prepareStatement(this.deleteStmt);
    }

    private boolean isDuplicatedPrimaryKey(SQLException e) throws SQLException {
        try {
            DatabaseManager mgr = JDBCHelper.getDatabaseManager(this.getModuleName());
            return mgr.isUniqueConstraint(e);
        }
        catch (ConnectorException e1) {
            throw e;
        }
    }

    private PreparedStatement getInsertStatement() throws SQLException {
        this.rebuildStatements();
        return this.getConnection().prepareStatement(this.insertStmt);
    }

    private boolean isPrimaryKey(String field) {
        return this.getPrimaryKeys().contains(field);
    }

    private boolean isPrimaryKeySet() {
        Collection<Boolean> pkValues = this.pkSet.values();
        if (pkValues.size() == 0) {
            return false;
        }
        for (Boolean b : pkValues) {
            if (b != null && b.booleanValue()) continue;
            return false;
        }
        return true;
    }

    private int setPrimaryKeys(PreparedStatement statement) throws SQLException {
        return this.setPrimaryKeys(statement, 1);
    }

    private int setPrimaryKeys(PreparedStatement statement, int from) throws SQLException {
        int position = from;
        for (SQLObject.Member member : this.getMembers()) {
            if (!this.isPrimaryKey(member.getName())) continue;
            Object value = this.fields.get(member.getName());
            SQLUtils.setParameter(statement, position++, value, member.getSQLType());
        }
        return position;
    }

    private Set<String> getPrimaryKeys() {
        return this.pkMembers;
    }

    private PreparedStatement getSelectStatement() throws SQLException {
        this.rebuildStatements();
        return this.getConnection().prepareStatement(this.selectStmt);
    }

    private boolean isServerSide() {
        return Component.isRunningOnServerSide();
    }

    private PreparedStatement getUpdateStatement() throws SQLException {
        this.rebuildStatements();
        return this.getConnection().prepareStatement(this.updateStmt);
    }

    private void addAttachment(TableSQLObject sqlObject, Map<String, String> mappings) throws oracle.bpm.components.SQLException {
        this.mapFields(sqlObject, mappings);
        sqlObject.add();
    }

    private void addAttachments(Map<TableSQLObject, Map<String, String>> attachments) throws oracle.bpm.components.SQLException {
        if (attachments != null) {
            for (Map.Entry<TableSQLObject, Map<String, String>> map : attachments.entrySet()) {
                this.addAttachment(map.getKey(), map.getValue());
            }
        }
    }

    private void checkPkOperation(String operation) {
        if (this.pkMembers.isEmpty()) {
            throw new UnsupportedOperationException("Operation '" + operation + "' is not supported for table '" + this.getObjectName() + "' because it does not have primary keys defined in the database schema.");
        }
    }

    private boolean checkPrimaryKey() {
        boolean primarySeted;
        boolean bl = primarySeted = this.isPrimaryKeySet() && this.isServerSide();
        if (primarySeted && this.state == 0) {
            try {
                this.load();
            }
            catch (oracle.bpm.components.SQLException e) {
                throw new RuntimeExceptionShell(e);
            }
        } else if (this.pkSet.isEmpty()) {
            this.state = 3;
        }
        return primarySeted;
    }

    private void clearPkSet() {
        for (Map.Entry<Object, Boolean> entry : this.pkSet.entrySet()) {
            entry.setValue(Boolean.FALSE);
        }
    }

    private void close(Map<TableSQLObject, Map<String, String>> attachments) throws oracle.bpm.components.SQLException {
        if (attachments != null) {
            for (Map.Entry<TableSQLObject, Map<String, String>> map : attachments.entrySet()) {
                this.close(map.getKey());
            }
        }
    }

    private void close(Object attachment) throws oracle.bpm.components.SQLException {
        if (attachment instanceof List) {
            List elements = (List)attachment;
            for (Object element : elements) {
                this.close(element);
            }
        } else if (attachment instanceof SQLObject) {
            SQLObject object = (SQLObject)attachment;
            object.close();
        }
    }

    private SQLException insert() throws SQLException {
        PreparedStatement insert = null;
        try {
            insert = this.getInsertStatement();
            this.setFldParams(insert);
            insert.executeUpdate();
            SQLException sQLException = null;
            return sQLException;
        }
        catch (SQLException e) {
            if (this.isDuplicatedPrimaryKey(e)) {
                SQLException sQLException = e;
                return sQLException;
            }
            throw e;
        }
        finally {
            if (insert != null) {
                try {
                    insert.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    private void loadAttachment(Object attachment, Map<String, String> mappings) throws oracle.bpm.components.SQLException {
        if (attachment instanceof List) {
            List elements = (List)attachment;
            for (Object element : elements) {
                this.loadAttachment(element, mappings);
            }
        } else if (attachment instanceof TableSQLObject) {
            TableSQLObject object = (TableSQLObject)attachment;
            this.mapFields(object, mappings);
            object.load();
        }
    }

    private void loadAttachments(Map<TableSQLObject, Map<String, String>> attachments) throws oracle.bpm.components.SQLException {
        if (attachments != null) {
            for (Map.Entry<TableSQLObject, Map<String, String>> map : attachments.entrySet()) {
                this.loadAttachment(map.getKey(), map.getValue());
            }
        }
    }

    private void mapFields(SQLObject object, Map<String, String> mappings) {
        if (mappings != null) {
            for (Map.Entry<String, String> entry : mappings.entrySet()) {
                object.setFieldValue(entry.getValue(), this.getFieldValue(entry.getKey()));
            }
        }
    }

    private boolean mustLoad() {
        return this.isAccessDatabase() && this.isServerSide() && this.state == 0 && this.isPrimaryKeySet();
    }

    private void parseTableSignature(String signature) {
        StringTokenizer tokenizer = new StringTokenizer(signature, "#");
        tokenizer.nextToken();
        tokenizer.nextToken();
        tokenizer.nextToken();
        String pkMembers = tokenizer.nextToken();
        StringTokenizer pkeys = new StringTokenizer(pkMembers, ";");
        this.pkMembers = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        this.pkSet = new HashMap<Object, Boolean>();
        while (pkeys.hasMoreTokens()) {
            String field = pkeys.nextToken();
            if ("~".equals(field)) continue;
            this.pkMembers.add(field);
            this.pkSet.put(field.toUpperCase(), Boolean.FALSE);
        }
        this.pkMembers = Collections.unmodifiableSet(this.pkMembers);
        this.schema = tokenizer.nextToken();
        if ("~".equals(this.schema)) {
            this.schema = null;
        }
    }

    private void readObject(ObjectInputStream stream) throws Exception {
        Map map = (Map)stream.readObject();
        stream.defaultReadObject();
        this.fields = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        this.fields.putAll(map);
        this.registerListener();
    }

    private void rebuildStatements() throws SQLException {
        String currentSchemaName;
        String quote;
        if (this.selectStmt != null) {
            return;
        }
        try {
            Connection conn = JDBCHelper.getConnection(this.getModuleName());
            quote = conn.getMetaData().getIdentifierQuoteString();
            DatabaseManager dbm = JDBCHelper.getDatabaseManager(this.getModuleName());
            currentSchemaName = dbm.getSchemaForIntrospecting();
        }
        catch (ConnectorException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw new RuntimeExceptionShell(e);
        }
        int length = this.getMembers().size();
        ArrayList<String> fields = new ArrayList<String>(length);
        ArrayList<String> updateableFields = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            SQLObject.Member member = this.getMembers().get(i);
            fields.add(quote + member.getName() + quote);
            if (member.isReadOnly()) continue;
            updateableFields.add(quote + member.getName() + quote);
        }
        ArrayList<String> primaryKeys = new ArrayList<String>();
        for (String s : this.getPrimaryKeys()) {
            primaryKeys.add(quote + s + quote);
        }
        String table = this.schema != null && !"".equals(this.schema) ? (currentSchemaName != null ? currentSchemaName : this.schema) + "." + quote + this.getObjectName() + quote : quote + this.getObjectName() + quote;
        this.selectStmt = SQLUtils.getSelect(table, fields, primaryKeys);
        this.insertStmt = SQLUtils.getInsert(table, updateableFields);
        this.deleteStmt = SQLUtils.getDelete(table, primaryKeys);
        this.updateStmt = SQLUtils.getUpdate(table, updateableFields, primaryKeys);
    }

    private void registerListener() {
        ExecutionThreadContext executionThreadContext = ExecutionThreadContext.current();
        ExecutionContext executionContext = ExecutionContextAccessor.getContext();
        if (executionThreadContext != null && executionContext != null) {
            String listenerKey = this.getClass().getName() + ".contextListener";
            TableContextListener listener = (TableContextListener)executionContext.getProperty(listenerKey);
            if (listener == null) {
                listener = new TableContextListener();
                executionThreadContext.addListener(listener);
                executionContext.putProperty(listenerKey, listener);
            }
            listener.registerListener(this);
        }
    }

    private void removeAttachements(Map<TableSQLObject, Map<String, String>> attachments) throws oracle.bpm.components.SQLException {
        if (attachments != null) {
            for (Map.Entry<TableSQLObject, Map<String, String>> map : attachments.entrySet()) {
                this.removeAttachment(map.getKey(), map.getValue());
            }
        }
    }

    private void removeAttachment(Object attachment, Map<String, String> mappings) throws oracle.bpm.components.SQLException {
        if (attachment instanceof List) {
            List elements = (List)attachment;
            for (Object element : elements) {
                this.removeAttachment(element, mappings);
            }
        } else if (attachment instanceof SQLObject) {
            SQLObject object = (SQLObject)attachment;
            this.mapFields(object, mappings);
            object.remove();
        }
    }

    private void storeAttachements(Map<TableSQLObject, Map<String, String>> attachments) throws oracle.bpm.components.SQLException {
        if (attachments != null) {
            for (Map.Entry<TableSQLObject, Map<String, String>> map : attachments.entrySet()) {
                this.storeAttachment(map.getKey(), map.getValue());
            }
        }
    }

    private void storeAttachment(TableSQLObject attachment, Map<String, String> mappings) throws oracle.bpm.components.SQLException {
        this.mapFields(attachment, mappings);
        attachment.store();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean update() throws SQLException {
        int updateCount;
        this.checkPkOperation("store/update");
        PreparedStatement update = this.getUpdateStatement();
        int last = this.setFldParams(update);
        this.setPrimaryKeys(update, last);
        try {
            updateCount = update.executeUpdate();
        }
        finally {
            if (update != null) {
                update.close();
            }
        }
        return updateCount > 0;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        HashMap rowidentifier = new HashMap();
        boolean serializeAll = stream instanceof TransferOutputStream || this.state != 2;
        int stateBak = this.state;
        boolean bl = serializeAll = serializeAll || !this.isAccessDatabase();
        if (serializeAll) {
            rowidentifier.putAll(this.fields);
        } else {
            for (String key : this.getPrimaryKeys()) {
                rowidentifier.put(key, this.fields.get(key));
            }
            this.state = 0;
        }
        try {
            stream.writeObject(rowidentifier);
            Map fieldsBak = this.fields;
            this.fields = null;
            stream.defaultWriteObject();
            this.fields = fieldsBak;
            this.state = stateBak;
        }
        catch (IOException e) {
            Log.logSevere(LibMsg.PROBLEM_SERIALIZING(this.getSQLText(""), rowidentifier, this.pkMembers));
            throw e;
        }
        try {
            this.close();
        }
        catch (oracle.bpm.components.SQLException e) {
            throw new IOException(e.toString());
        }
    }

    private static class TableContextListener
    implements ContextListener {
        private WeakHashMap<TableSQLObject, Object> tables = new WeakHashMap();

        private TableContextListener() {
        }

        @Override
        public void processEvent(ExecutionThreadContext source, ContextEvent event) {
            if (event == ContextEvent.BEFORE_CLIENT_EXECUTION) {
                Set<TableSQLObject> keySet = this.tables.keySet();
                for (TableSQLObject table : keySet) {
                    if (table == null || !table.mustLoad() || !ConnectorTransaction.hasCurrent()) continue;
                    try {
                        table.load();
                    }
                    catch (oracle.bpm.components.SQLException e) {
                        throw new RuntimeException(e.getMessage());
                    }
                }
            }
        }

        public int compareTo(Object o) {
            return -1;
        }

        public void registerListener(TableSQLObject table) {
            this.tables.put(table, null);
        }
    }
}

