/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.sql;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import oracle.bpm.connector.ConnectorException;
import oracle.bpm.connector.JDBCHelper;
import oracle.bpm.jdbc.DatabaseManager;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.Time;
import oracle.bpm.log.Log;
import oracle.bpm.sql.SQLObject;
import oracle.bpm.sql.SQLUtils;
import oracle.bpm.sql.StatementException;
import org.jetbrains.annotations.NonNls;

public class ProcedureSQLObject
extends SQLObject {
    private boolean hasReturn = false;
    private int[] paramType_d;
    private String schema;
    @NonNls
    private String statement;
    private static final long serialVersionUID = 7060739050030993108L;
    static final int IN = 1;
    static final int OUT = 2;
    static final int INOUT = 3;

    public ProcedureSQLObject(String moduleName, String signature) {
        super(moduleName, signature);
        this.parseProcedureSignature(signature);
        this.hasReturn = this.statement.startsWith("{? = call");
    }

    @Override
    public String getName() {
        return this.getObjectName();
    }

    @Override
    public void close() {
    }

    @Override
    public Object invokeImpl(String signature, boolean sync, Object[] inputArgs, Object[] outputArgs) throws ComponentExecutionException {
        Object result;
        block20: {
            result = null;
            this.parseMethodSignature(signature);
            try {
                Connection conn = JDBCHelper.getConnection(this.getModuleName());
                DatabaseManager dbm = JDBCHelper.getDatabaseManager(this.getModuleName());
                String currentSchemaName = dbm.getSchemaForIntrospecting();
                try {
                    int baseIndex;
                    String statementStr = Str.replace(this.statement, "@SCHEMA@", currentSchemaName != null ? currentSchemaName.toUpperCase() : this.schema);
                    CallableStatement statement = conn.prepareCall(statementStr);
                    int n = baseIndex = this.hasReturn ? 1 : 0;
                    if (this.hasReturn) {
                        statement.registerOutParameter(1, this.getSQLType(0));
                    }
                    if (inputArgs != null) {
                        ParameterMetaData parameterMetaData = null;
                        try {
                            parameterMetaData = statement.getParameterMetaData();
                        }
                        catch (AbstractMethodError e) {
                            this.handleDriverCompatibilityException(e);
                        }
                        catch (SQLException e) {
                            this.handleDriverCompatibilityException(e);
                        }
                        for (int i = 0; i < inputArgs.length; i += 2) {
                            String argSignature = (String)inputArgs[i];
                            int argno = baseIndex + Integer.parseInt(argSignature.substring(1));
                            int position = argno + 1;
                            int parameterMode = 1;
                            if (parameterMetaData != null) {
                                try {
                                    parameterMode = parameterMetaData.getParameterMode(position);
                                }
                                catch (AbstractMethodError e) {
                                    this.handleDriverCompatibilityException(e);
                                    parameterMode = 1;
                                }
                                catch (SQLException e) {
                                    this.handleDriverCompatibilityException(e);
                                    parameterMode = 1;
                                }
                            }
                            if (parameterMode != 1 && parameterMode != 2) continue;
                            SQLUtils.setParameter(statement, position, inputArgs[i + 1], this.getSQLType(argno));
                        }
                    }
                    if (outputArgs != null) {
                        for (Object outputArg : outputArgs) {
                            String argSignature = (String)outputArg;
                            int argno = baseIndex + Integer.parseInt(argSignature.substring(1));
                            statement.registerOutParameter(argno + 1, this.getSQLType(argno));
                        }
                    }
                    statement.execute();
                    if (this.hasReturn) {
                        result = statement.getObject(1);
                    }
                    if (outputArgs != null) {
                        for (int i = 0; i < outputArgs.length; ++i) {
                            String argSignature = (String)outputArgs[i];
                            int argno = baseIndex + Integer.parseInt(argSignature.substring(1));
                            outputArgs[i] = statement.getObject(argno + 1);
                        }
                    }
                    statement.close();
                }
                catch (StatementException e) {
                    throw new ComponentExecutionException(e);
                }
            }
            catch (SQLException e) {
                throw new ComponentExecutionException(e);
            }
            catch (ConnectorException e) {
                if (!(e.getCause() instanceof SQLException)) break block20;
                throw new ComponentExecutionException(e.getCause());
            }
        }
        return result;
    }

    public void parseMethodSignature(String signature) {
        if (signature == null || signature.length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(signature, "#");
        String size = st.nextToken();
        if (size == null || size.equals("") || size.equals("null")) {
            return;
        }
        this.paramType_d = new int[Integer.parseInt(size)];
        int i = 0;
        while (st.hasMoreTokens()) {
            this.paramType_d[i] = Integer.parseInt(st.nextToken());
            ++i;
        }
    }

    @Override
    public void parseSignature(String signature) {
    }

    @Override
    protected void beginTrace(String method, String component, Time started) {
        super.beginTrace("call", this.statement, started);
    }

    @Override
    protected void endTrace(String method, String component, Time started) {
        super.endTrace("call", this.statement, started);
    }

    private void handleDriverCompatibilityException(Throwable e) {
        if (Log.isDebugging()) {
            Log.logDebug("Probably is a JDBC 2.0 driver that does not implement ParameterMetaData methods");
        }
        if (Log.isDebugging()) {
            Log.logDebug(e);
        }
    }

    private int getSQLType(int argno) {
        return this.paramType_d[argno];
    }

    private void parseProcedureSignature(String signature) {
        StringTokenizer tokenizer = new StringTokenizer(signature, "#");
        tokenizer.nextToken();
        this.statement = tokenizer.nextToken();
        try {
            this.schema = tokenizer.nextToken();
            if (this.schema.equals("~")) {
                this.schema = null;
            }
        }
        catch (NoSuchElementException e) {
            this.schema = null;
        }
    }
}

