/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Iterator;
import oracle.bpm.components.SQLException;
import oracle.bpm.connector.ConnectorException;
import oracle.bpm.connector.JDBCHelper;
import oracle.bpm.jdbc.DatabaseManager;
import oracle.bpm.log.Log;
import oracle.bpm.sql.ParsedQuery;
import oracle.bpm.sql.QueryObject;
import oracle.bpm.sql.SQLUtils;

public class JDBC11SQLQueryObject
extends QueryObject {
    private PreparedStatement deleteCurrentStatement_d;
    private PreparedStatement updateCurrentStatement_d;
    private static int cursorNumber = 0;
    static final long serialVersionUID = -8585951203372883732L;
    static final long serialCheck = 332323031814211221L;

    public JDBC11SQLQueryObject(String moduleName, String signature) throws java.sql.SQLException {
        super(moduleName, signature);
    }

    @Override
    public synchronized void close() throws SQLException {
        super.close();
        if (this.deleteCurrentStatement_d != null) {
            try {
                this.deleteCurrentStatement_d.close();
            }
            catch (java.sql.SQLException e) {
                // empty catch block
            }
        }
        this.deleteCurrentStatement_d = null;
        if (this.updateCurrentStatement_d != null) {
            try {
                this.updateCurrentStatement_d.close();
            }
            catch (java.sql.SQLException sQLException) {
                // empty catch block
            }
        }
        this.updateCurrentStatement_d = null;
    }

    @Override
    public void remove() throws SQLException {
        if (this.deleteCurrentStatement_d == null) {
            throw new UnsupportedOperationException();
        }
        try {
            this.deleteCurrentStatement_d.executeUpdate();
        }
        catch (java.sql.SQLException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void store() throws SQLException {
        try {
            this.setFldParams(this.updateCurrentStatement_d);
            this.updateCurrentStatement_d.executeUpdate();
        }
        catch (java.sql.SQLException e) {
            throw new SQLException(e);
        }
    }

    @Override
    protected void cancelChanges() {
    }

    @Override
    protected void initCursor() {
        block9: {
            try {
                DatabaseManager mgr = JDBCHelper.getDatabaseManager(this.getModuleName());
                String cursor = "";
                if (mgr.supportsCursors()) {
                    cursor = JDBC11SQLQueryObject.getNextCursorName();
                    this.queryStatement_d.setCursorName(cursor);
                }
                Connection conn = JDBCHelper.getConnection(this.getModuleName());
                ParsedQuery parsed = ParsedQuery.parse(this.getSQLText(conn.getMetaData().getIdentifierQuoteString()));
                String from = "";
                Iterator<String> it = parsed.getTables();
                while (it.hasNext()) {
                    from = from + it.next().toString();
                }
                if (mgr.supportsCursors()) {
                    String deleteCurrent = SQLUtils.getDeleteCurrent(from, cursor);
                    this.deleteCurrentStatement_d = conn.prepareStatement(deleteCurrent);
                }
            }
            catch (java.sql.SQLException e) {
                if (Log.isDebugging()) {
                    Log.logDebug("Could not create delete cursor: " + e.getMessage());
                }
                if (Log.isDebugging()) {
                    Log.logDebug(e);
                }
            }
            catch (ConnectorException e) {
                if (Log.isDebugging()) {
                    Log.logDebug("Could not create delete cursor: " + e.getMessage());
                }
                if (!Log.isDebugging()) break block9;
                Log.logDebug(e);
            }
        }
    }

    private static synchronized String getNextCursorName() {
        return "defC" + cursorNumber++;
    }
}

