/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.servlet.multipart;

import oracle.bpm.servlet.multipart.CharCursor;

public class StringCharCursor
extends CharCursor {
    int pos;
    String string;

    public StringCharCursor(String string) {
        this.string = string;
        this.pos = 0;
    }

    public StringCharCursor(String string, int offset) {
        this.string = string;
        this.pos = offset;
    }

    @Override
    public int getBeginIndex() {
        return 0;
    }

    @Override
    public int getEndIndex() {
        return this.string.length();
    }

    @Override
    public char setIndex(int pos) {
        if (pos < 0) {
            this.pos = 0;
            return '\uffff';
        }
        if (pos >= this.string.length()) {
            this.pos = this.string.length();
            return '\uffff';
        }
        this.pos = pos;
        return this.string.charAt(pos);
    }

    @Override
    public int getIndex() {
        return this.pos;
    }

    @Override
    public Object clone() {
        return new StringCharCursor(this.string);
    }

    @Override
    public char current() {
        if (this.pos >= this.string.length()) {
            return '\uffff';
        }
        return this.string.charAt(this.pos);
    }

    public void init(String string) {
        this.string = string;
        this.pos = 0;
    }

    @Override
    public char next() {
        if (++this.pos >= this.string.length()) {
            this.pos = this.string.length();
            return '\uffff';
        }
        return this.string.charAt(this.pos);
    }

    @Override
    public char previous() {
        if (--this.pos < 0) {
            this.pos = 0;
            return '\uffff';
        }
        return this.string.charAt(this.pos);
    }

    @Override
    public char skip(int n) {
        this.pos += n;
        if (this.pos >= this.string.length()) {
            this.pos = this.string.length();
            return '\uffff';
        }
        return this.string.charAt(this.pos);
    }
}

