/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.servlet.multipart;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import oracle.bpm.servlet.multipart.MultipartRequest;

public class MultipartWrapper
extends HttpServletRequestWrapper {
    MultipartRequest mreq = null;

    public MultipartWrapper(HttpServletRequest req, String dir) throws IOException {
        this(req, dir, 10000000);
    }

    public MultipartWrapper(HttpServletRequest req, String dir, int maxSize) throws IOException {
        super(req);
        this.mreq = new MultipartRequest(req, dir, req.getSession(false).getId(), maxSize, true);
    }

    public String getContentType(String name) {
        return this.mreq.getContentType(name);
    }

    public File getFile(String name) {
        return this.mreq.getFile(name);
    }

    public Iterable<String> getFileNames() {
        return this.mreq.getFileNames();
    }

    public String getFilesystemName(String name) {
        return this.mreq.getFilesystemName(name);
    }

    public String getFileName(String name) {
        return this.mreq.getFileName(name);
    }

    public String getParameter(String name) {
        String paramValue = this.getRequest().getParameter(name);
        if (paramValue == null) {
            paramValue = this.mreq.getParameter(name);
        }
        return paramValue;
    }

    public Map getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Enumeration names = this.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            map.put(name, this.mreq.getParameterValues(name));
        }
        return map;
    }

    public Enumeration getParameterNames() {
        return this.mreq.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        String[] ret = this.mreq.getParameterValues(name);
        if (ret != null) {
            return ret;
        }
        return new String[]{""};
    }
}

