/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.processmodel;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import oracle.bpm.io.TokenReader;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.processmodel.ActivityType;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.FileFilter;
import oracle.bpm.util.FileUtils;
import org.jetbrains.annotations.NotNull;

public enum SchemaType implements I18nProvider
{
    PROCESS(LibMsg.PROCESS, LibMsg.PROCESS, LibMsg.PROCESS_FILES, new String[]{".bpmn"}){

        @Override
        public boolean isAllowed(ActivityType activityType) {
            return activityType != null && activityType.isAllowedInProcesses();
        }
    }
    ,
    PROCEDURE(LibMsg.PROCEDURE, LibMsg.NEW_PROCEDURE, LibMsg.PROCEDURE_FILES, ".xadl"){

        @Override
        public boolean isAllowed(ActivityType activityType) {
            return activityType != null && activityType.isAllowedInProcedures();
        }
    }
    ,
    SCREENFLOW(LibMsg.SCREENFLOW, LibMsg.NEW_SCREENFLOW, LibMsg.SCREENFLOW_FILES, ".xsdl"){

        @Override
        public boolean isAllowed(ActivityType activityType) {
            return activityType != null && activityType.isAllowedInScreenFlows();
        }
    };

    private final transient Msg msg;
    private final transient Msg newMsg;
    private final transient Msg filesMsg;
    private final transient String[] extensions;
    static final String WSBPEL_20_PROCESS_EXECUTABLE = "http://docs.oasis-open.org/wsbpel/2.0/process/executable";
    static final String BPEL_NAMESPACE2004 = "http://schemas.xmlsoap.org/ws/2004/03/business-process/";

    private SchemaType(Msg msg, Msg newMsg, Msg filesMsg, String ext) {
        this(msg, newMsg, filesMsg, new String[]{ext});
    }

    private SchemaType(Msg msg, Msg newMsg, Msg filesMsg, String[] extensions) {
        this.msg = msg;
        this.newMsg = newMsg;
        this.filesMsg = filesMsg;
        this.extensions = extensions;
    }

    @Override
    public String getString() {
        return this.getMsg().getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.getMsg().getString(locale);
    }

    public final Msg getMsg() {
        return this.msg;
    }

    public boolean isAllowed(ActivityType activityType) {
        return false;
    }

    public final String[] getFileExtension() {
        return this.extensions;
    }

    public final boolean hasExtension(@NotNull String extension) {
        if (extension == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/processmodel/SchemaType.hasExtension must not be null");
        }
        for (String str : this.extensions) {
            if (!str.equals(extension)) continue;
            return true;
        }
        return false;
    }

    public final FileFilter getFileFilter() {
        return FileFilter.create(this.filesMsg, this.extensions);
    }

    public final Msg getNewSchemaMsg() {
        return this.newMsg;
    }

    public static SchemaType getSchemaTypeFor(File file) {
        return SchemaType.getSchemaTypeFor(FileUtils.getExtension(file));
    }

    public static boolean isSupportedSchema(File file) {
        return SchemaType.getSchemaTypeFor(FileUtils.getExtension(file)) != null;
    }

    public static boolean isSupportedSchema(String extension) {
        return SchemaType.getSchemaTypeFor(extension) != null;
    }

    public boolean isProcess() {
        return this == PROCESS;
    }

    public boolean isProcedure() {
        return this == PROCEDURE;
    }

    public boolean isScreenflow() {
        return this == SCREENFLOW;
    }

    public static SchemaType getSchemaTypeFor(String extension) {
        SchemaType result = null;
        if (extension != null) {
            if (extension.charAt(0) != '.') {
                extension = "." + extension;
            }
            SchemaType[] types = SchemaType.values();
            for (int i = 0; result == null && i < types.length; ++i) {
                if (!types[i].hasExtension(extension)) continue;
                result = types[i];
            }
        }
        return result;
    }

    public static boolean isWSBPELSchemaTypeStream(Reader reader) throws IOException {
        int tokenType;
        boolean result = false;
        TokenReader tokenReader = new TokenReader(reader);
        while ((tokenType = tokenReader.getToken()) != -1) {
            String tokenText = tokenReader.getTokenText();
            if (tokenType != -4 || !WSBPEL_20_PROCESS_EXECUTABLE.equals(tokenText) && !BPEL_NAMESPACE2004.equals(tokenText)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static String getExtensionFor(SchemaType schemaType) {
        return schemaType.getFileExtension()[0];
    }
}

