/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.EnumTypeDescription;
import oracle.bpm.lang.IllegalConversionException;
import oracle.bpm.lang.Initialization;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.type.SchemaObjectFactory;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.impl.TypeDescriptionImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlEnumTypeDescription
extends XmlTypeDescription
implements EnumTypeDescription {
    private List<String> labels;
    private List<String> nativeNames;
    private boolean sequential;
    private List<Integer> values;
    private static final String VALUEOF = "valueOf";
    public static final String VALUES_FIELD = "VALUES";
    private static final String FACTORY_NAME = "valueOf";

    private XmlEnumTypeDescription(@NotNull String name, @NotNull String namespace, @Nullable String parentFullName) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/XmlEnumTypeDescription.<init> must not be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/XmlEnumTypeDescription.<init> must not be null");
        }
        super(name, namespace, null, XmlElementType.TYPE, 17, parentFullName);
    }

    public static ObjectTypeDescription create(@NotNull String nativeName, @NotNull String namespace, @Nullable String parentFullName) {
        if (nativeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/XmlEnumTypeDescription.create must not be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/XmlEnumTypeDescription.create must not be null");
        }
        return new XmlEnumTypeDescription(nativeName, namespace, parentFullName);
    }

    @Override
    public void addItem(String nm) {
        this.addItem(nm, null);
    }

    @Override
    public void addItem(String nm, Integer value) {
        this.addItem(nm, value, null);
    }

    @Override
    public void addItem(String nm, Integer value, String nativeName) {
        if (this.labels == null) {
            this.labels = new ArrayList<String>();
            this.nativeNames = new ArrayList<String>();
            if (value == null) {
                this.sequential = true;
                this.values = null;
            } else {
                this.values = new ArrayList<Integer>();
                this.sequential = false;
            }
        } else if (value == null) assert (this.sequential) : "Attempt to add a value '" + value + "' for item '" + nm + "' from non-sequential enum '" + this.getText() + '\'';
        this.labels.add(nm);
        this.nativeNames.add(nativeName);
        if (value != null) {
            this.values.add(value);
        }
        this.createEnumAttribute(this.labels.size() - 1);
    }

    @Override
    public boolean equality(TypeDescription type) {
        return type.isEnum() && type.getName().equals(this.getName()) || type.getKind() == 9;
    }

    @Override
    public TypeDescription getHolderType() {
        return this.isNativeEnum() ? TypeFactory.getAny() : (this.isPrimitive() ? TypeFactory.getPrimitiveInt(32) : TypeFactory.getInt(32));
    }

    @Override
    public Initialization getInitialization() {
        return Initialization.ZERO;
    }

    @Override
    public Class getJavaClass() {
        return this.isNativeEnum() ? super.getJavaClass() : (this.isPrimitive() ? Integer.TYPE : Integer.class);
    }

    @Override
    public String getJavaSignature() {
        return JavaClass.getSignature(this.getJavaClass());
    }

    @Override
    public String[] getLabels() {
        return this.labels == null ? null : this.labels.toArray(new String[this.labels.size()]);
    }

    @Override
    public int getNextMemberIndex(String nm, int from, int requiredKind) {
        return super.searchMember(0, nm, requiredKind);
    }

    @Override
    public int getValue(int i) {
        return this.sequential ? i : this.values.get(i);
    }

    public int[] getValues() {
        if (this.values == null) {
            return null;
        }
        int len = this.values.size();
        int[] result = new int[len];
        for (int i = 0; i < len; ++i) {
            result[i] = this.values.get(i);
        }
        return result;
    }

    @Override
    public boolean hasDefaultInit() {
        return true;
    }

    @Override
    public boolean isComparable(TypeDescription type) {
        return this.equality(type);
    }

    @Override
    public boolean isIterable() {
        return true;
    }

    @Override
    public boolean isSequential() {
        return this.sequential;
    }

    @Override
    public Object newInstance(String value) {
        Object result = null;
        if (!this.isNativeEnum()) {
            result = Integer.valueOf(value);
        } else {
            Class clazz = this.getJavaClass();
            try {
                Method factory = clazz.getDeclaredMethod("valueOf", String.class);
                result = factory.invoke(null, value);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public void setSequential(boolean b) {
        throw new UnsupportedOperationException();
    }

    public Object newInstance(long value) {
        Long result = null;
        if (this.isNativeEnum()) {
            Class clazz = this.getJavaClass();
            try {
                Field valuesField = clazz.getDeclaredField(VALUES_FIELD);
                List list = (List)valuesField.get(null);
                result = list.get((int)value);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        } else {
            result = value;
        }
        return result;
    }

    @Override
    public void removeMembers() {
        super.removeMembers();
        this.labels = null;
        this.values = null;
        this.nativeNames = null;
    }

    @Override
    public void renameMember(MethodTypeDescription member, String newName) {
        String oldName = member.getName();
        super.renameMember(member, newName);
        if (this.labels == null || !member.isAttribute()) {
            return;
        }
        int index = this.labels.indexOf(oldName);
        if (index == -1) {
            return;
        }
        this.labels.set(index, newName);
        if (!this.isNativeEnum()) {
            return;
        }
        index = this.getMemberIndex(newName, member.getKind());
        if (index == -1) {
            return;
        }
        this.setDefaultValue(this.getMemberType(index).asAttribute(), index);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.isPrimitive()) {
            result.append('p');
        } else if (this.isNativeEnum()) {
            result.append("Native");
        }
        result.append("Enum ");
        result.append(this.getName());
        result.append('(');
        if (this.labels != null) {
            for (int i = 0; i < this.labels.size(); ++i) {
                if (i > 0) {
                    result.append(',');
                }
                result.append(this.labels.get(i));
            }
        }
        result.append(')');
        return result.toString();
    }

    @Override
    public boolean isSchemaObject() {
        return this.getProperty("namespace") != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public SchemaObject asSchemaObject() {
        if (!this.isSchemaObject()) {
            throw new IllegalConversionException(this.getText(), "SchemaObject: " + this.getText());
        }
        SchemaObject schemaObject = SchemaObjectFactory.createForXmlType(this);
        if (schemaObject == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/XmlEnumTypeDescription.asSchemaObject must not return null");
        }
        return schemaObject;
    }

    @Override
    protected MethodTypeDescription removeMember(int index) {
        int idx;
        MethodTypeDescription oldMember = super.removeMember(index);
        if (this.labels != null && oldMember.isAttribute() && oldMember.isConst() && (idx = this.labels.indexOf(oldMember.getName())) != -1) {
            this.labels.remove(idx);
            if (this.nativeNames != null) {
                this.nativeNames.remove(idx);
            }
            if (this.values != null) {
                this.values.remove(idx);
            }
            if (!this.isNativeEnum() && this.isSequential()) {
                this.setDefaultValues();
            }
        }
        return oldMember;
    }

    private void setDefaultValues() {
        if (this.labels != null && !this.labels.isEmpty()) {
            for (MethodTypeDescription member : this.getMemberTypes()) {
                String memberName;
                int index;
                if (!member.isAttribute() || !member.isConst() || (index = this.labels.indexOf(memberName = member.getName())) == -1) continue;
                this.setDefaultValue(member.asAttribute(), index);
            }
        }
    }

    private void setDefaultValue(AttributeTypeDescription attribute, int index) {
        attribute.setDefaultValue(this.isNativeEnum() ? attribute.getName() : (this.isSequential() ? Integer.toString(index) : String.valueOf(this.values.get(index))));
    }

    private void createEnumAttribute(int index) {
        String nativeName;
        String nm = this.labels.get(index);
        AttributeTypeDescription attribute = new AttributeTypeDescription(nm, this);
        attribute.makeConst();
        this.setDefaultValue(attribute, index);
        if (this.nativeNames != null && (nativeName = this.nativeNames.get(index)) != null) {
            attribute.setProperty("nativeName", nativeName);
        }
        assert (attribute.isConst());
        attribute.setParent(this);
        this.getMemberNames().add(nm);
        this.getMemberTypes().add(attribute);
    }

    public static class Unknown
    extends TypeDescriptionImpl {
        private String id;

        public Unknown(String id) {
            super(-1, -1, -1, false);
            this.id = id;
        }

        @Override
        public String getText() {
            return this.id;
        }
    }
}

