/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import org.jetbrains.annotations.NotNull;

public enum XmlElementType {
    ELEMENT('E', "element", "Element"),
    TYPE('C', "type", "Type"),
    MESSAGE('M', "WSDL message", "Message"),
    FAULT('F', "fault", "Fault"),
    ATTRIBUTE('A', "attribute", "Attribute"),
    ATTGROUP('T', "attgroup", "Attribute Group"),
    GROUP('G', "group", "Group");

    private char charCode;
    private String description;
    private String suffix;

    private XmlElementType(char charCode, String description, String suffix) {
        this.charCode = charCode;
        this.description = description;
        this.suffix = suffix;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getDescription() {
        String string = this.description;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/XmlElementType.getDescription must not return null");
        }
        return string;
    }

    public char getCharCode() {
        return this.charCode;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getSuffix() {
        String string = this.suffix;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/XmlElementType.getSuffix must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    static XmlElementType valueFromCharCode(char charCode) {
        XmlElementType[] types;
        XmlElementType result = null;
        for (XmlElementType type : types = XmlElementType.values()) {
            if (type.getCharCode() != charCode) continue;
            result = type;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("Invalid char code '" + charCode + "'");
        }
        XmlElementType xmlElementType = result;
        if (xmlElementType == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/XmlElementType.valueFromCharCode must not return null");
        }
        return xmlElementType;
    }
}

