/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.io.Serializable;
import java.util.Calendar;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;

public class WorkDaySchedule
implements Serializable {
    private int finish1 = 2400;
    private int finish2 = 2400;
    private int start1 = 2400;
    private int start2 = 2400;
    static final long serialVersionUID = -6515878596423782038L;
    private static final int NULL_TIME = 2400;
    public static final WorkDaySchedule DEFAULT = WorkDaySchedule.valueOf("8:00-12:00, 13:00-17:00");
    static final long serialCheck = -3631772826286008368L;

    public static WorkDaySchedule valueOf(String str) {
        int shift;
        WorkDaySchedule result = new WorkDaySchedule();
        int ind = str.indexOf(44);
        for (shift = 0; shift < 2 && ind != -1; ++shift) {
            result.setShift(0, str.substring(0, ind));
            str = str.substring(ind + 1);
            ind = str.indexOf(44);
        }
        result.setShift(shift, str);
        return result;
    }

    public Time getFinishTime(int shift) {
        int t = shift == 0 ? this.finish1 : this.finish2;
        return Time.valueOf(t / 100, t % 100);
    }

    public void setShift(int shift, Time startTime, Time endTime) {
        this.setShift(shift, this.fromTime(startTime), this.fromTime(endTime));
    }

    public Time getStartTime(int shift) {
        int t = shift == 0 ? this.start1 : this.start2;
        return Time.valueOf(t / 100, t % 100);
    }

    public boolean isValid() {
        boolean check1 = this.check(this.start1) && this.check(this.finish1) && this.start1 < this.finish1;
        boolean check2 = this.start2 == 2400 && this.finish2 == 2400 || this.check(this.start2) && this.check(this.finish2) && this.start2 < this.finish2 && this.start2 > this.finish1;
        return check1 && check2;
    }

    public Interval consumeWorkingDay(Calendar calendar, Interval interval) {
        if (interval.compareTo(Interval.ZERO) < 0) {
            interval = this.backward(calendar, interval, this.start2, this.finish2);
            return this.backward(calendar, interval, this.start1, this.finish1);
        }
        interval = this.advance(calendar, interval, this.start1, this.finish1);
        return this.advance(calendar, interval, this.start2, this.finish2);
    }

    public boolean equals(Object o) {
        boolean result;
        boolean bl = result = this == o;
        if (!result && o instanceof WorkDaySchedule) {
            WorkDaySchedule that = (WorkDaySchedule)o;
            result = this.finish1 == that.finish1 && this.finish2 == that.finish2 && this.start1 == that.start1 && this.start2 == that.start2;
        }
        return result;
    }

    public boolean hasShift(int i) {
        return i == 0 && this.start1 != this.finish1 || i == 1 && this.start2 != this.finish2;
    }

    public int hashCode() {
        int result = this.finish1;
        result = 29 * result + this.finish2;
        result = 29 * result + this.start1;
        result = 29 * result + this.start2;
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.start1 != 2400) {
            this.append(result, this.start1);
            result.append("-");
            this.append(result, this.finish1);
            if (this.start2 != 2400) {
                result.append(",");
                this.append(result, this.start2);
                result.append("-");
                this.append(result, this.finish2);
            }
        }
        return result.toString();
    }

    public void setShift(int i, int start, int finish) {
        if (i == 0) {
            this.start1 = start;
            this.finish1 = finish;
        } else if (i == 1) {
            this.start2 = start;
            this.finish2 = finish;
        }
    }

    private static void setTime(Calendar calendar, int t) {
        calendar.set(11, t / 100);
        calendar.set(12, t % 100);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    private static void addInterval(Calendar cal, Interval interval) {
        cal.add(11, interval.getHoursOnly());
        cal.add(12, interval.getMinutesOnly());
        cal.add(13, interval.getSecondsOnly());
    }

    private static int minutes(int a) {
        return a / 100 * 60 + a % 100;
    }

    private Interval backward(Calendar calendar, Interval interval, int start, int finish) {
        if (!interval.equals(Interval.ZERO) && start != 2400) {
            int hour = calendar.get(11) * 100 + calendar.get(12);
            if (hour > finish) {
                WorkDaySchedule.setTime(calendar, finish);
                hour = finish;
            }
            if (hour > start) {
                int minutes = WorkDaySchedule.minutes(hour) - WorkDaySchedule.minutes(start);
                if (Math.abs(interval.getMinutes()) >= minutes) {
                    interval = interval.addMinutes(minutes);
                    WorkDaySchedule.setTime(calendar, start);
                } else {
                    WorkDaySchedule.addInterval(calendar, interval);
                    interval = Interval.ZERO;
                }
            }
        }
        return interval;
    }

    private void setShift(int i, String str) {
        int ind;
        int start = 2400;
        int finish = 2400;
        if (str != null && (ind = str.indexOf(45)) != -1) {
            start = this.strToInt(str.substring(0, ind));
            finish = this.strToInt(str.substring(ind + 1));
        }
        this.setShift(i, start, finish);
    }

    private Interval advance(Calendar calendar, Interval interval, int start, int finish) {
        if (!interval.equals(Interval.ZERO) && start != 2400) {
            int hour = calendar.get(11) * 100 + calendar.get(12);
            if (hour < start) {
                WorkDaySchedule.setTime(calendar, start);
                hour = start;
            }
            if (hour < finish) {
                int minutes = WorkDaySchedule.minutes(finish) - WorkDaySchedule.minutes(hour);
                if (interval.getMinutes() >= minutes) {
                    interval = interval.addMinutes(-minutes);
                } else {
                    WorkDaySchedule.addInterval(calendar, interval);
                    interval = Interval.ZERO;
                }
            }
        }
        return interval;
    }

    private void append(StringBuffer result, int time) {
        result.append(time / 100);
        result.append(':');
        if ((time %= 100) < 10) {
            result.append('0');
        }
        result.append(time);
    }

    private boolean check(int time) {
        return time >= 0 && time <= 2400 && time % 100 <= 60;
    }

    private int fromTime(Time t) {
        int minutes = t.toGMT().getMinutes();
        return minutes / 60 * 100 + minutes % 60;
    }

    private int strToInt(String str) {
        int result = 2400;
        int ind = str.indexOf(58);
        if (ind != -1) {
            try {
                int h = Integer.parseInt(str.substring(0, ind).trim());
                int m = Integer.parseInt(str.substring(ind + 1).trim());
                if (h == 24 && m == 0 || h >= 0 && h < 24 && m >= 0 && m < 60) {
                    result = h * 100 + m;
                }
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        return result;
    }
}

