/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import oracle.bpm.lang.AbstractTypeUUID;
import oracle.bpm.lang.FaultUUID;
import oracle.bpm.lang.PortTypeUUID;
import oracle.bpm.lang.ServiceUUID;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.lang.XmlUUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UUIDFactory {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static XmlUUID parseXmlId(@NotNull String uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/UUIDFactory.parseXmlId must not be null");
        }
        XmlUUID xmlUUID = XmlUUID.parse(uuid);
        if (xmlUUID == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/UUIDFactory.parseXmlId must not return null");
        }
        return xmlUUID;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static XmlUUID createXmlId(@NotNull XmlElementType elemType, @NotNull String namespace, @NotNull String name) {
        if (elemType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/UUIDFactory.createXmlId must not be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/UUIDFactory.createXmlId must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/lang/UUIDFactory.createXmlId must not be null");
        }
        XmlUUID xmlUUID = UUIDFactory.createXmlId(elemType, namespace, name, null);
        if (xmlUUID == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/UUIDFactory.createXmlId must not return null");
        }
        return xmlUUID;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static XmlUUID createXmlId(@NotNull XmlElementType elemType, @NotNull String namespace, @NotNull String name, @Nullable String parentFullName) {
        if (elemType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/UUIDFactory.createXmlId must not be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/UUIDFactory.createXmlId must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/lang/UUIDFactory.createXmlId must not be null");
        }
        XmlUUID xmlUUID = XmlUUID.create(elemType, namespace, name, parentFullName);
        if (xmlUUID == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/UUIDFactory.createXmlId must not return null");
        }
        return xmlUUID;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static FaultUUID parseFaultId(@NotNull String uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/UUIDFactory.parseFaultId must not be null");
        }
        FaultUUID faultUUID = FaultUUID.parse(uuid);
        if (faultUUID == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/UUIDFactory.parseFaultId must not return null");
        }
        return faultUUID;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static FaultUUID createFaultId(@NotNull String namespace, @NotNull String name, @NotNull String msgNamespace, @NotNull String msgName) {
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/UUIDFactory.createFaultId must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/UUIDFactory.createFaultId must not be null");
        }
        if (msgNamespace == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/lang/UUIDFactory.createFaultId must not be null");
        }
        if (msgName == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/lang/UUIDFactory.createFaultId must not be null");
        }
        FaultUUID faultUUID = FaultUUID.create(namespace, name, msgNamespace, msgName);
        if (faultUUID == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/UUIDFactory.createFaultId must not return null");
        }
        return faultUUID;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static ServiceUUID parseServiceId(@NotNull String uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/UUIDFactory.parseServiceId must not be null");
        }
        ServiceUUID serviceUUID = ServiceUUID.parse(uuid);
        if (serviceUUID == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/UUIDFactory.parseServiceId must not return null");
        }
        return serviceUUID;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static ServiceUUID createServiceId(@NotNull String namespace, @NotNull String nativeName, @NotNull String target, @Nullable String targetPort) {
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/UUIDFactory.createServiceId must not be null");
        }
        if (nativeName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/UUIDFactory.createServiceId must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/lang/UUIDFactory.createServiceId must not be null");
        }
        ServiceUUID serviceUUID = ServiceUUID.create(namespace, nativeName, target, targetPort);
        if (serviceUUID == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/UUIDFactory.createServiceId must not return null");
        }
        return serviceUUID;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PortTypeUUID parsePortTypeId(@NotNull String uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/UUIDFactory.parsePortTypeId must not be null");
        }
        PortTypeUUID portTypeUUID = PortTypeUUID.parse(uuid);
        if (portTypeUUID == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/UUIDFactory.parsePortTypeId must not return null");
        }
        return portTypeUUID;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PortTypeUUID createPortTypeId(@NotNull String namespace, @NotNull String name) {
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/UUIDFactory.createPortTypeId must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/UUIDFactory.createPortTypeId must not be null");
        }
        PortTypeUUID portTypeUUID = PortTypeUUID.create(namespace, name);
        if (portTypeUUID == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/UUIDFactory.createPortTypeId must not return null");
        }
        return portTypeUUID;
    }

    @Nullable
    public static AbstractTypeUUID parseUUID(@NotNull String uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/UUIDFactory.parseUUID must not be null");
        }
        AbstractTypeUUID result = null;
        if (!Str.isEmpty(uuid)) {
            char c = uuid.charAt(0);
            if (c == XmlElementType.ELEMENT.getCharCode() || c == XmlElementType.TYPE.getCharCode() || c == XmlElementType.ATTGROUP.getCharCode() || c == XmlElementType.ATTRIBUTE.getCharCode() || c == XmlElementType.GROUP.getCharCode() || c == XmlElementType.MESSAGE.getCharCode()) {
                result = UUIDFactory.parseXmlId(uuid);
            } else if (c == XmlElementType.FAULT.getCharCode()) {
                result = UUIDFactory.parseFaultId(uuid);
            } else if (c == 'S') {
                result = UUIDFactory.parseServiceId(uuid);
            } else if (c == 'P') {
                result = UUIDFactory.parsePortTypeId(uuid);
            }
        }
        return result;
    }
}

