/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.Argument;
import oracle.bpm.type.SourceCode;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.Variable;
import oracle.bpm.util.documentation.DocumentationType;

public class TransformTypeDescription
extends MethodTypeDescription {
    private SourceCode beginCode;
    private SourceCode endCode;
    private List<FieldMapping> mappings;

    public TransformTypeDescription() {
        this(TypeFactory.getVoid());
    }

    public TransformTypeDescription(TypeRef parent) {
        super(20, "");
        this.setTargetName("target");
        this.setTarget(parent);
        this.setModifiers(32832L);
    }

    public void setBeginCode(SourceCode code) {
        this.beginCode = code;
    }

    public SourceCode getBeginCode() {
        return this.beginCode;
    }

    @Override
    public char[] getCodeText() {
        StringBuffer code = new StringBuffer();
        if (this.beginCode != null) {
            code.append(this.beginCode);
        }
        int length = this.getFieldMappingCount();
        for (int i = 0; i < length; ++i) {
            FieldMapping fm = this.getFieldMapping(i);
            code.append(fm.getTargetField());
            code.append(" = ");
            code.append(fm.getCodeText());
            code.append('\n');
        }
        if (this.endCode != null) {
            code.append(this.endCode);
        }
        char[] text = new char[code.length()];
        code.getChars(0, text.length, text, 0);
        return text;
    }

    public void setEndCode(SourceCode code) {
        this.endCode = code;
    }

    public SourceCode getEndCode() {
        return this.endCode;
    }

    public FieldMapping getFieldMapping(int index) {
        return this.mappings != null ? this.mappings.get(index) : null;
    }

    public FieldMapping getFieldMapping(String targetField) {
        int mappingCount = this.getFieldMappingCount();
        for (int i = 0; i < mappingCount; ++i) {
            FieldMapping fieldMapping = this.mappings.get(i);
            if (!fieldMapping.getTargetField().equals(targetField)) continue;
            return fieldMapping;
        }
        return null;
    }

    public int getFieldMappingCount() {
        return this.mappings != null ? this.mappings.size() : 0;
    }

    public TypeDescription getSource(int index) {
        return this.getArgument(index).getType();
    }

    public int getSourceCount() {
        return this.getInputArgumentCount();
    }

    public String getSourceName(int index) {
        return this.getArgument(index).getName();
    }

    public void setTarget(TypeRef target) {
        this.setResultType(target);
    }

    public TypeDescription getTarget() {
        return this.getResultType();
    }

    public void setTargetName(String name) {
        this.getResultArgument().setName(name);
    }

    public String getTargetName() {
        return this.getResultArgument().getName();
    }

    @Override
    public String getText() {
        StringBuffer text = new StringBuffer();
        text.append(this.getTarget().getText());
        text.append("<-");
        int scount = this.getSourceCount();
        if (scount > 1) {
            text.append('(');
        }
        for (int i = 0; i < scount; ++i) {
            text.append(this.getSource(i).getText());
            if (i + 1 >= scount) continue;
            text.append(", ");
        }
        if (scount > 1) {
            text.append(')');
        }
        return text.toString();
    }

    public void addFieldMapping(FieldMapping mapping) {
        if (this.mappings == null) {
            this.mappings = new ArrayList<FieldMapping>();
        }
        this.mappings.add(mapping);
    }

    public void addSource(String name, TypeRef source) {
        this.addArgument(new Argument(name, source, 1L));
    }

    public void clearFieldMappings() {
        this.mappings = null;
    }

    public void removeAllSources() {
        this.removeAllArguments();
    }

    public boolean removeFieldMapping(FieldMapping mapping) {
        return this.mappings != null && this.mappings.remove(mapping);
    }

    public void removeSource(String name) {
        Argument argument = this.findArgument(name);
        if (argument != null) {
            this.removeArgument(argument);
        }
    }

    public List<MethodTypeDescription> toMethodTypeDescription() {
        ArrayList<MethodTypeDescription> mtds = new ArrayList<MethodTypeDescription>();
        StringBuilder code = new StringBuilder();
        MethodTypeDescription mtd = new MethodTypeDescription(this.getName(), this.getModifiers());
        Variable localVariable = this.getTransformationVariable();
        String languageSeparator = this.getLanguageSeparator(this.getLanguage());
        mtd.setArguments(this.getArguments());
        mtd.setVariables(Arrays.asList(localVariable));
        if (this.beginCode != null) {
            MethodTypeDescription beginMethod = this.getBeginMethod(this.beginCode);
            code.append(localVariable.getName() + " = " + this.getBeginEndMethodCall(beginMethod) + languageSeparator + "\n");
            mtds.add(beginMethod);
        }
        code.append(this.getMigratedCodeText());
        if (this.endCode != null) {
            MethodTypeDescription endMethod = this.getEndMethod(this.endCode);
            code.append(localVariable.getName() + " = " + this.getBeginEndMethodCall(endMethod) + languageSeparator + "\n");
            mtds.add(endMethod);
        }
        code.append(this.getReturnExpression(this.getLanguage()) + " " + localVariable.getName() + languageSeparator + "\n");
        mtd.setCode(code.toString(), this.getLanguage());
        LocaleStringMap docs = this.getDocumentation(DocumentationType.DOCUMENTATION);
        Set set = docs.keySet();
        for (Locale locale : set) {
            String doc = (String)docs.get((Object)locale);
            mtd.setDocumentation(DocumentationType.DOCUMENTATION, locale, doc);
        }
        LocaleStringMap useCases = this.getDocumentation(DocumentationType.USE_CASE_DOCUMENTATION);
        Set setUC = useCases.keySet();
        for (Locale locale : setUC) {
            String useCase = (String)useCases.get((Object)locale);
            mtd.setDocumentation(DocumentationType.USE_CASE_DOCUMENTATION, locale, useCase);
        }
        mtd.setReturnArgument(this.getResultArgument());
        mtds.add(mtd);
        return mtds;
    }

    private Variable getTransformationVariable() {
        String targetName = this.getTargetName();
        TypeRef targetType = this.getResultArgument().getTypeRef();
        return new Variable(targetName, targetType);
    }

    private String getLanguage() {
        String language = "Fuego";
        if (this.getFieldMappingCount() > 0) {
            language = this.getFieldMapping(0).getCode().getLanguage();
        }
        return language;
    }

    private String getLanguageSeparator(String language) {
        String languageSeparator = "";
        if (language.toLowerCase().contains("java")) {
            languageSeparator = ";";
        }
        return languageSeparator;
    }

    private String getReturnExpression(String language) {
        String returnExpression = "return";
        if (language.toLowerCase().contains("visualbasic")) {
            returnExpression = "Return";
        }
        return returnExpression;
    }

    private String getBeginEndMethodCall(MethodTypeDescription method) {
        StringBuilder argumentText = new StringBuilder();
        for (Argument argument : this.getArguments()) {
            argumentText.append(argument.getName() + ",");
        }
        return method.getName() + "(" + argumentText.toString() + this.getTransformationVariable().getName() + ")";
    }

    private MethodTypeDescription getBeginMethod(SourceCode sourceCode) {
        return this.getBeginEndMethod(this.getName() + "Begin", sourceCode);
    }

    private MethodTypeDescription getEndMethod(SourceCode sourceCode) {
        return this.getBeginEndMethod(this.getName() + "End", sourceCode);
    }

    private MethodTypeDescription getBeginEndMethod(String methodName, SourceCode sourceCode) {
        StringBuilder code = new StringBuilder();
        MethodTypeDescription mtd = new MethodTypeDescription(methodName, this.getModifiers());
        Variable localVariable = this.getTransformationVariable();
        String languageSeparator = this.getLanguageSeparator(sourceCode.getLanguage());
        mtd.setArguments(this.getArguments());
        String argumentName = localVariable.getName() + "$arg";
        Argument argument = new Argument(argumentName, localVariable.getTypeRef(), 1L);
        mtd.addArgument(argument);
        mtd.addVariable(localVariable);
        code.append(localVariable.getName() + " = " + argumentName + languageSeparator + "\n");
        code.append(sourceCode.getText());
        code.append(this.getReturnExpression(sourceCode.getLanguage()) + " " + localVariable.getName() + languageSeparator + "\n");
        mtd.setCode(code.toString(), sourceCode.getLanguage());
        mtd.setReturnArgument(this.getResultArgument());
        return mtd;
    }

    private char[] getMigratedCodeText() {
        StringBuffer code = new StringBuffer();
        String languageSeparator = this.getLanguageSeparator(this.getLanguage());
        TypeRef targetType = this.getResultArgument().getTypeRef();
        String targetName = this.getTargetName();
        int length = this.getFieldMappingCount();
        for (int i = 0; i < length; ++i) {
            FieldMapping fm = this.getFieldMapping(i);
            SourceCode codeText = fm.getCode();
            String s = codeText.asString();
            String newCodeText = s.replaceAll("arg\\.", "");
            if (fm.isExpression()) {
                boolean predefined = false;
                if (targetType instanceof TypeDescription) {
                    predefined = ((TypeDescription)targetType).isPredefined();
                }
                code.append((predefined ? "" : targetName + ".") + fm.getTargetField());
                code.append(" = ");
            }
            code.append(newCodeText + languageSeparator);
            code.append('\n');
        }
        char[] text = new char[code.length()];
        code.getChars(0, text.length, text, 0);
        return text;
    }

    public static class FieldMapping {
        private SourceCode code;
        private boolean isExpression = true;
        private int order = 0;
        private String targetField;

        public void setCode(SourceCode code) {
            this.code = code;
        }

        public SourceCode getCode() {
            return this.code;
        }

        public void setCodeText(char[] text) {
            if (this.code == null) {
                this.code = new SourceCode();
            }
            this.code.setText(text);
        }

        public char[] getCodeText() {
            return this.code != null ? this.code.getText() : null;
        }

        public void setExpression(boolean isExp) {
            this.isExpression = isExp;
        }

        public boolean isExpression() {
            return this.isExpression;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public int getOrder() {
            return this.order;
        }

        public void setTargetField(String field) {
            this.targetField = field;
        }

        public String getTargetField() {
            return this.targetField;
        }
    }
}

