/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.bpm.lang.LowResolutionTimer;
import oracle.bpm.lang.LowResolutionTimerListener;

public class TimedCache
extends HashMap<Object, Object> {
    private int capacity_d;
    private int clock_d = 0;
    private Entry[] elements_d;
    private int lockCount_d = 0;
    static final long serialVersionUID = 5286023725099932596L;
    static final long serialCheck = -4453032228653056736L;

    public TimedCache(int capacity, int timeToLive) {
        super(capacity);
        this.elements_d = new Entry[capacity];
        for (int i = 0; i < capacity; ++i) {
            this.elements_d[i] = new Entry();
            this.elements_d[i].index = i;
        }
        this.capacity_d = capacity;
        LowResolutionTimer timer_d = new LowResolutionTimer(timeToLive);
        timer_d.add(new Disposer());
        timer_d.start();
    }

    public static void main(String[] args) throws Throwable {
        TimedCache c = new TimedCache(3, 1);
        c.put("a", "AAAAAAAAA");
        System.out.println(c);
        c.put("b", "BBBBB");
        System.out.println(c);
        c.put("c", "CCCCC");
        System.out.println(c);
        c.put("d", "DDDDD");
        System.out.println(c);
        c.put("d", "DEEEEE");
        System.out.println(c);
        System.out.println(c.get("a"));
        c.put("e", "EEEEE");
        System.out.println(c);
        c.put("f", "FFFF");
        System.out.println(c);
        Thread.sleep(1000L);
        System.out.println(c);
        c.get("e");
        Thread.sleep(1000L);
        System.out.println(c);
        Thread.sleep(1000L);
        System.out.println(c);
    }

    public int getCapacity() {
        return this.capacity_d;
    }

    public synchronized Object getLocked(Object key) throws AlreadyLockedException {
        Entry entry = this.getEntry(key);
        if (entry == null) {
            return null;
        }
        if (entry.locked_d) {
            throw new AlreadyLockedException(entry.value);
        }
        entry.locked_d = true;
        entry.keepIt_d = true;
        ++this.lockCount_d;
        return entry.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        super.clear();
        TimedCache timedCache = this;
        synchronized (timedCache) {
            for (int i = 0; i < this.capacity_d; ++i) {
                this.elements_d[i].value = null;
                this.elements_d[i].clock = 0;
            }
        }
    }

    @Override
    public synchronized boolean containsValue(Object key) {
        for (int i = 0; i < this.capacity_d; ++i) {
            if (!this.elements_d[i].equals(key)) continue;
            this.elements_d[i].keepIt_d = true;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) {
        Object value;
        TimedCache timedCache = this;
        synchronized (timedCache) {
            Entry entry = this.getEntry(key);
            if (entry == null) {
                return null;
            }
            entry.keepIt_d = true;
            value = entry.value;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object key, Object value) {
        TimedCache timedCache = this;
        synchronized (timedCache) {
            Entry entry = this.putEntry(key, value);
            if (entry == null) {
                return null;
            }
            entry.keepIt_d = true;
            value = entry.value;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Object key) {
        Object result = null;
        TimedCache timedCache = this;
        synchronized (timedCache) {
            Object index = super.remove(key);
            if (index != null) {
                int n = ((Number)index).intValue();
                result = this.elements_d[n].value;
                this.elements_d[n].clock = 0;
                this.elements_d[n].value = null;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        boolean first = true;
        StringBuffer result = new StringBuffer("<");
        Entry[] entryArray = this.elements_d;
        synchronized (this.elements_d) {
            for (int i = 0; i < this.capacity_d; ++i) {
                if (this.elements_d[i].value == null) continue;
                if (!first) {
                    result.append(", ");
                }
                first = false;
                result.append(this.elements_d[i].value.toString());
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result.append(">").toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Object key) {
        TimedCache timedCache = this;
        synchronized (timedCache) {
            Entry entry = this.getEntry(key);
            if (entry.locked_d) {
                --this.lockCount_d;
                entry.locked_d = false;
                entry.keepIt_d = true;
            }
        }
    }

    @Override
    public Collection<Object> values() {
        return null;
    }

    protected boolean dispose(Object o) {
        return true;
    }

    protected Object load(Object key) {
        return null;
    }

    private Entry getEntry(Object key) {
        Object index = super.get(key);
        if (index == null) {
            Object obj = this.load(key);
            if (obj == null) {
                return null;
            }
            return this.putEntry(key, obj);
        }
        int n = ((Number)index).intValue();
        ++this.elements_d[n].clock;
        return this.elements_d[n];
    }

    private Entry putEntry(Object key, Object value) {
        int n = -1;
        Object index = super.get(key);
        if (index != null) {
            n = ((Number)index).intValue();
        } else {
            for (int i = 0; i < this.capacity_d; ++i) {
                if (this.elements_d[i].value != null) continue;
                n = i;
                break;
            }
            if (n == -1) {
                if (this.lockCount_d >= this.capacity_d) {
                    throw new NoDisposableEntriesException();
                }
                while (this.elements_d[this.clock_d].clock > 0 || this.elements_d[this.clock_d].locked_d) {
                    --this.elements_d[this.clock_d].clock;
                    ++this.clock_d;
                    this.clock_d %= this.capacity_d;
                }
                super.remove(this.elements_d[this.clock_d].key);
                this.dispose(this.elements_d[this.clock_d].value);
                n = this.clock_d;
            }
        }
        super.put(key, this.elements_d[n].index);
        this.elements_d[n].value = value;
        this.elements_d[n].key = key;
        this.elements_d[n].clock = 1;
        return this.elements_d[n];
    }

    private class Disposer
    implements LowResolutionTimerListener {
        private Disposer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void timerFired(LowResolutionTimer timer) {
            TimedCache timedCache = TimedCache.this;
            synchronized (timedCache) {
                for (Entry anElements_d : TimedCache.this.elements_d) {
                    if (anElements_d.value == null) continue;
                    if (!anElements_d.locked_d && !anElements_d.keepIt_d) {
                        if (TimedCache.this.dispose(anElements_d.value)) {
                            TimedCache.this.remove(anElements_d.key);
                            continue;
                        }
                        anElements_d.keepIt_d = true;
                        continue;
                    }
                    anElements_d.keepIt_d = false;
                }
            }
        }
    }

    static class Entry {
        int clock;
        Integer index;
        boolean keepIt_d;
        Object key;
        boolean locked_d;
        Object value;

        Entry() {
        }
    }

    public static class NoDisposableEntriesException
    extends RuntimeException {
        static final long serialVersionUID = 2125987647508046530L;
        static final long serialCheck = 51911894693628157L;
    }

    public static class AlreadyLockedException
    extends Exception {
        private Object obj_d;
        static final long serialVersionUID = 4668958927722131399L;
        static final long serialCheck = 6606599149108047030L;

        public AlreadyLockedException(Object o) {
            this.obj_d = o;
        }

        public Object getEntry() {
            return this.obj_d;
        }
    }
}

