/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import oracle.bpm.lang.AbstractTypeUUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServiceUUID
extends AbstractTypeUUID {
    private String target;
    private String targetPort;
    public static final char TYPE_PREFIX_ID = 'S';

    private ServiceUUID(@NotNull String namespace, @NotNull String name, @NotNull String target, @Nullable String targetPort) {
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/ServiceUUID.<init> must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/ServiceUUID.<init> must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/lang/ServiceUUID.<init> must not be null");
        }
        super(namespace, name);
        this.target = target;
        this.targetPort = targetPort;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getTarget() {
        String string = this.target;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/ServiceUUID.getTarget must not return null");
        }
        return string;
    }

    @Nullable
    public String getTargetPort() {
        return this.targetPort;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String getId() {
        String result = this.getTypeId() + "|" + this.getNamespace() + "|" + this.getNativeName() + "|" + this.target;
        if (this.targetPort != null) {
            result = result + "|" + this.targetPort;
        }
        String string = result;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/ServiceUUID.getId must not return null");
        }
        return string;
    }

    @Override
    protected char getTypeId() {
        return 'S';
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    static ServiceUUID parse(@NotNull String uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/ServiceUUID.parse must not be null");
        }
        String[] strings = uuid.split("\\|");
        if (uuid.charAt(0) != 'S' || strings.length > 5 || strings.length < 4) {
            throw new IllegalArgumentException("Invalid service id: '" + uuid + "'");
        }
        String namespace = strings[1];
        String name = strings[2];
        String target = strings[3];
        String targetPort = null;
        if (strings.length > 4) {
            targetPort = strings[4];
        }
        ServiceUUID serviceUUID = new ServiceUUID(namespace, name, target, targetPort);
        if (serviceUUID == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/ServiceUUID.parse must not return null");
        }
        return serviceUUID;
    }

    static ServiceUUID create(@NotNull String namespace, @NotNull String nativeName, @NotNull String target, @Nullable String targetPort) {
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/ServiceUUID.create must not be null");
        }
        if (nativeName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/ServiceUUID.create must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/lang/ServiceUUID.create must not be null");
        }
        return new ServiceUUID(namespace, nativeName, target, targetPort);
    }
}

