/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.util.StringTokenizer;

public class Modifier {
    public static final long IN = 1L;
    public static final long OUT = 2L;
    public static final long INOUT = 3L;
    public static final long HASSETTER = 4L;
    public static final long HASGETTER = 8L;
    public static final long RETVAL = 16L;
    public static final long ATTRIBUTE = 32L;
    public static final long STATIC = 64L;
    public static final long COMPARABLE = 128L;
    public static final long CLIENT_AVAILABLE = 256L;
    public static final long ABSTRACT = 512L;
    public static final long INTERFACE = 1024L;
    public static final long EXTERNAL = 2048L;
    public static final long CLONEABLE = 4096L;
    public static final long PRIVATE = 8192L;
    public static final long PROTECTED = 16384L;
    public static final long PUBLIC = 32768L;
    public static final long SERVER = 65536L;
    public static final long FINAL = 131072L;
    public static final long EXCEPTION = 262144L;
    public static final long INHERITED = 524288L;
    public static final long DEPRECATED = 0x100000L;
    public static final long TRANSIENT = 0x200000L;
    public static final long CONFIGURABLE = 0x400000L;
    public static final long DELEGATED = 0x800000L;
    public static final long PK = 0x1000000L;
    public static final long HIDDEN = 0x2000000L;
    public static final long REQUIRED = 0x4000000L;
    public static final long RUNSONCLIENT = 0x8000000L;
    public static final long INVOKEABLE = 0x10000000L;
    public static final long REMOTE = 0x20000000L;
    public static final long PRESENTABLE = 0x40000000L;
    public static final long OPTIONAL = 0x80000000L;
    public static final long SYNTHESIZED = 0x100000000L;
    public static final long DETACHED = 0x200000000L;
    public static final long COLUMN = 0x400000000L;
    public static final long ITERABLE = 0x800000000L;
    public static final long EXPRESSION = 0x1000000000L;
    public static final long ADAPTORS = 0x2000000000L;
    public static final long DISABLE_CLIENT = 0x4000000000L;
    public static final long REFACTOR = 0x8000000000L;
    public static final long CACHED = 0x10000000000L;
    public static final long VIRTUAL = 0x20000000000L;
    public static final long REPLACEABLE = 0x40000000000L;
    public static final long ENTERPRISE_ONLY = 0x80000000000L;
    public static final long J2EE_ONLY = 0x100000000000L;
    public static final long INCLUDE_IN_CHECK = 0x200000000000L;
    public static final long PUNIT_SUITE = 0x400000000000L;
    public static final long CUNIT_SUITE = 0x800000000000L;
    public static final long SYSTEM_EXCEPTION = 0x1000000000000L;
    public static final long MODULE = 0x2000000000000L;
    public static final long LVALUE = 0x4000000000000L;
    public static final long LAST_VALID = 0x4000000000000L;
    public static final long ACCESS_MASK = 57344L;
    public static final long VALID_MASK = 0x3FFFFFFFFFFFFL;
    private static final String[] NAMES = new String[]{"in", "out", "hassetter", "hasgetter", "retval", "attribute", "static", "comparable", "clientavailable", "abstract", "interface", "external", "cloneable", "private", "protected", "public", "server", "final", "exception", "inherited", "deprecated", "transient", "configurable", "delegated", "pk", "hidden", "required", "runsonclient", "invokeable", "remote", "presentable", "optional", "synthesized", "detached", "column", "iterable", "expression", "adaptors", "disableclient", "refactor", "cached", "virtual", "replaceable", "enterprise_only", "j2ee_only", "includeincheck", "punit_suite", "cunit_suite", "system_exception", "module"};

    private Modifier() {
    }

    public static long setAbstract(long modifiers, boolean isAbstract) {
        modifiers = isAbstract ? (modifiers |= 0x200L) : (modifiers &= 0xFFFFFFFFFFFFFDFFL);
        return modifiers;
    }

    public static long setException(long modifiers, boolean exception) {
        modifiers = exception ? (modifiers |= 0x40000L) : (modifiers &= 0xFFFFFFFFFFFBFFFFL);
        return modifiers;
    }

    public static long setSystemException(long modifiers, boolean exception) {
        modifiers = exception ? (modifiers |= 0x1000000000000L) : (modifiers &= 0xFFFEFFFFFFFFFFFFL);
        return modifiers;
    }

    public static boolean isAbstract(long modifier) {
        return (modifier & 0x200L) != 0L;
    }

    public static boolean isAdaptors(long modifier) {
        return (modifier & 0x2000000000L) != 0L;
    }

    public static boolean isAttribute(long modifier) {
        return (modifier & 0x20L) != 0L;
    }

    public static boolean isCached(long modifier) {
        return (modifier & 0x10000000000L) != 0L;
    }

    public static boolean isClientAvailable(long modifier) {
        return (modifier & 0x100L) != 0L;
    }

    public static boolean isCloneable(long modifier) {
        return (modifier & 0x1000L) != 0L;
    }

    public static long setComparable(long modifiers, boolean comparable) {
        modifiers = comparable ? (modifiers |= 0x80L) : (modifiers &= 0xFFFFFFFFFFFFFF7FL);
        return modifiers;
    }

    public static boolean isComparable(long modifier) {
        return (modifier & 0x80L) != 0L;
    }

    public static boolean isConfigurable(long modifier) {
        return (modifier & 0x400000L) != 0L;
    }

    public static boolean isConst(long modifier) {
        return Modifier.isAttribute(modifier) && !Modifier.hasSetter(modifier) && !Modifier.isIn(modifier);
    }

    public static boolean isReadOnly(long modifier) {
        return Modifier.isAttribute(modifier) && !Modifier.hasSetter(modifier) && !Modifier.isIn(modifier) && !Modifier.hasGetter(modifier) && !Modifier.isOut(modifier);
    }

    public static boolean isDelegated(long modifier) {
        return (modifier & 0x800000L) != 0L;
    }

    public static boolean isDeprecated(long modifier) {
        return (modifier & 0x100000L) != 0L;
    }

    public static boolean isDetached(long modifier) {
        return (modifier & 0x200000000L) != 0L;
    }

    public static boolean isDisableClient(long modifier) {
        return (modifier & 0x4000000000L) != 0L;
    }

    public static long setDynamic(long modifiers, boolean dynamic) {
        modifiers = dynamic ? (modifiers |= 0x10000000L) : (modifiers &= 0xFFFFFFFFEFFFFFFFL);
        return modifiers;
    }

    public static boolean isInvokeable(long modifier) {
        return (modifier & 0x10000000L) != 0L;
    }

    public static boolean isExternal(long modifier) {
        return (modifier & 0x800L) != 0L;
    }

    public static boolean isFinal(long modifier) {
        return (modifier & 0x20000L) != 0L;
    }

    public static boolean isHidden(long modifier) {
        return (modifier & 0x2000000L) != 0L;
    }

    public static boolean isIn(long modifier) {
        return (modifier & 1L) != 0L;
    }

    public static boolean isInOut(long modifier) {
        return Modifier.isIn(modifier) && Modifier.isOut(modifier);
    }

    public static boolean isInherited(long modifier) {
        return (modifier & 0x80000L) != 0L;
    }

    public static boolean isInterface(long modifier) {
        return (modifier & 0x400L) != 0L;
    }

    public static boolean isIterable(long modifier) {
        return (modifier & 0x800000000L) != 0L;
    }

    public static long setModifier(long modifiers, boolean set, long modifier) {
        modifiers = set ? (modifiers |= modifier) : (modifiers &= modifier ^ 0xFFFFFFFFFFFFFFFFL);
        return modifiers;
    }

    public static boolean isModifier(long modifiers, long modifier) {
        return (modifiers & modifier) != 0L;
    }

    public static long getModifiers(String modifiersText) {
        if (modifiersText == null) {
            return 0L;
        }
        StringTokenizer st = new StringTokenizer(modifiersText, "|, ");
        long modifiers = 0L;
        while (st.hasMoreTokens()) {
            String text = st.nextToken();
            if ("INOUT".equals(text)) {
                modifiers |= 3L;
                continue;
            }
            if ("dynamic".equals(text)) {
                modifiers |= 0x10000000L;
                continue;
            }
            long len = NAMES.length;
            int i = 0;
            while ((long)i < len) {
                if (NAMES[i].equalsIgnoreCase(text)) {
                    modifiers |= 1L << i;
                }
                ++i;
            }
        }
        return modifiers;
    }

    public static boolean isColumn(long modifier) {
        return (modifier & 0x400000000L) != 0L;
    }

    public static boolean isEnterpriseOnly(long modifier) {
        return (modifier & 0x80000000000L) != 0L;
    }

    public static boolean isJ2EEOnly(long modifier) {
        return (modifier & 0x100000000000L) != 0L;
    }

    public static boolean isOptional(long modifier) {
        return (modifier & 0x80000000L) != 0L;
    }

    public static boolean isOut(long modifier) {
        return (modifier & 2L) != 0L;
    }

    public static boolean isPresentable(long modifiers) {
        return (modifiers & 0x40000000L) != 0L;
    }

    public static boolean isPrimaryKey(long modifier) {
        return (modifier & 0x1000000L) != 0L;
    }

    public static boolean isPrivate(long modifier) {
        return (modifier & 0x2000L) != 0L;
    }

    public static boolean isProtected(long modifier) {
        return (modifier & 0x4000L) != 0L;
    }

    public static boolean isPublic(long modifier) {
        return (modifier & 0x8000L) != 0L;
    }

    public static boolean isRefactor(long modifier) {
        return (modifier & 0x8000000000L) != 0L;
    }

    public static long setRemote(long modifiers, boolean remote) {
        modifiers = remote ? (modifiers |= 0x20000000L) : (modifiers &= 0xFFFFFFFFDFFFFFFFL);
        return modifiers;
    }

    public static boolean isRemote(long modifier) {
        return (modifier & 0x20000000L) != 0L;
    }

    public static boolean isRequired(long modifier) {
        return (modifier & 0x4000000L) != 0L;
    }

    public static long setRunsOnClient(long modifiers, boolean runsOnClient) {
        modifiers = runsOnClient ? (modifiers |= 0x8000000L) : (modifiers &= 0xFFFFFFFFF7FFFFFFL);
        return modifiers;
    }

    public static boolean isRunsOnClient(long modifier) {
        return (modifier & 0x8000000L) != 0L;
    }

    public static boolean isServer(long modifier) {
        return (modifier & 0x10000L) != 0L;
    }

    public static boolean isStatic(long modifier) {
        return (modifier & 0x40L) != 0L;
    }

    public static boolean isSynthesized(long modifier) {
        return (modifier & 0x100000000L) != 0L;
    }

    public static String getText(long modifiers) {
        StringBuilder result = new StringBuilder();
        int len = NAMES.length;
        for (int i = 0; modifiers != 0L && i < len; ++i, modifiers >>>= 1) {
            if ((modifiers & 1L) == 0L) continue;
            if (result.length() != 0) {
                result.append(' ');
            }
            result.append(NAMES[i]);
        }
        return result.toString();
    }

    public static boolean isException(long modifiers) {
        return (modifiers & 0x40000L) != 0L;
    }

    public static boolean isSystemException(long modifiers) {
        return (modifiers & 0x1000000000000L) != 0L;
    }

    public static boolean isModule(long modifiers) {
        return (modifiers & 0x2000000000000L) != 0L;
    }

    public static boolean isPUnitSuite(long modifiers) {
        return (modifiers & 0x400000000000L) != 0L;
    }

    public static boolean isCUnitSuite(long modifiers) {
        return (modifiers & 0x800000000000L) != 0L;
    }

    public static boolean isExpression(long modifier) {
        return (modifier & 0x1000000000L) != 0L;
    }

    public static boolean isLValue(long modifier) {
        return (modifier & 0x4000000000000L) != 0L;
    }

    public static boolean isReplaceable(long modifier) {
        return (modifier & 0x40000000000L) != 0L;
    }

    public static boolean isTransient(long modifier) {
        return (modifier & 0x200000L) != 0L;
    }

    public static boolean isVirtual(long modifier) {
        return (modifier & 0x20000000000L) != 0L;
    }

    public static boolean hasAccessModifiers(long modifier) {
        return Modifier.isPublic(modifier) || Modifier.isProtected(modifier) || Modifier.isPrivate(modifier);
    }

    public static boolean hasGetter(long modifier) {
        return (modifier & 8L) != 0L;
    }

    public static boolean hasSetter(long modifier) {
        return (modifier & 4L) != 0L;
    }

    public static int javaModifiers(long modifiers) {
        int result = 0;
        if (Modifier.isPublic(modifiers)) {
            result |= 1;
            if (Modifier.isAbstract(modifiers)) {
                result |= 0x400;
            } else if (Modifier.isStatic(modifiers)) {
                result |= 8;
            }
        } else if (Modifier.isProtected(modifiers)) {
            result |= 4;
        } else if (Modifier.isPrivate(modifiers)) {
            result |= 2;
        }
        if (Modifier.isFinal(modifiers)) {
            result |= 0x10;
        }
        return result;
    }

    public static boolean isIncludeInCheck(long modifier) {
        return (modifier & 0x200000000000L) != 0L;
    }
}

