/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.bpm.component.metadata.BusinessException;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.component.metadata.Hidden;
import oracle.bpm.component.metadata.ReplacementFor;
import oracle.bpm.component.metadata.Type;
import oracle.bpm.connector.JavaLibrariesHelper;
import oracle.bpm.extensionpoint.metadata.IntrospectorMetadata;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.ArrayTypeDescription;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.BytecodeIntrospector;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.DynamicLocal;
import oracle.bpm.lang.DynamicRemote;
import oracle.bpm.lang.EnumType;
import oracle.bpm.lang.EnumTypeDescription;
import oracle.bpm.lang.IteratorTypeDescription;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.JavaClassScanner;
import oracle.bpm.lang.JavaEnumTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SetTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.Argument;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.DynamicRef;
import oracle.bpm.type.InterruptedIntrospectionException;
import oracle.bpm.type.Introspector;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeMappings;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.type.catalog.DirectoryComponentBundle;
import oracle.bpm.util.ArrayUtils;
import oracle.bpm.util.Identifier;
import oracle.bpm.util.ProgressMonitor;
import org.jetbrains.annotations.NotNull;

@IntrospectorMetadata(type="java")
public class JavaIntrospector
implements Introspector {
    private BytecodeIntrospector bytecodeIntrospector;
    private int current;
    private Map<String, ObjectTypeDescription> id2type;
    private boolean interrupted;
    private ComponentCatalog loader;
    private ProgressMonitor monitor;
    private int total;
    private Map<String, TypeRef> unresolved;
    private int virtual;
    private static final Map<String, String> I18N_METHODS_TO_REPLACE = Collections.unmodifiableMap(ArrayUtils.asMap(new String[]{"getString", "localizedName", "getShortString", "localizedShortName"}));
    private static final String REPLACEMENT_FOR = "replacementFor";
    public static final String IS_PACKAGE = "isPackage";
    private static final String ROOT = "";
    public static final String SCANNED_CLASSES = "classes";
    private static JavaClass<Object> object;
    private static final String CLASSPATH = "classpath";
    private static final String CLASSLOADER = "classLoader";
    private static final String COPY_FILE_TO_EXT = "copyFileToExt";
    private static final String MAIN_METHOD = "Mmain([Ljava.lang.String;)V";
    private static final int METHOD_ELEMENT = 0;
    private static final int METHOD_INDEX = 1;
    private static final int METHOD_TYPE = 2;
    private static final int ELEMENT = 3;
    private static final int INDEX = 4;
    private static final int TYPE = 5;
    private static final boolean DEBUG;

    public static void main(String[] args) throws oracle.bpm.type.IntrospectionException, TypeCatalogException {
        ObjectTypeDescription[] tree;
        if (args.length != 4) {
            System.err.println("Usage: JavaIntrospector <classpath> <storage-path> <cache-dir> <selected components>");
            return;
        }
        MutableComponentCatalog repository = TypeUtils.createComponentCatalog(TypeUtils.getDefaultCatalog());
        repository.setDefaultStorageBundle(new DirectoryComponentBundle(new File(args[1])));
        JavaIntrospector introspector = new JavaIntrospector();
        Map<String, Object> properties = introspector.defaultProperties();
        properties.put(CLASSPATH, args[0]);
        properties.put("SELECTED_COMPONENTS", args[3]);
        properties.put(COPY_FILE_TO_EXT, "false");
        for (ObjectTypeDescription type : tree = introspector.introspect(properties, repository, SimpleProgressMonitor.INSTANCE)) {
            repository.add(type);
        }
    }

    public static ObjectTypeDescription[] introspectFromClassLoader(ComponentCatalog catalog, Class ... classes) {
        try {
            ObjectTypeDescription[] types;
            JavaIntrospector introspector = new JavaIntrospector();
            Map<String, Object> properties = introspector.defaultProperties();
            properties.put(CLASSLOADER, classes[0].getClassLoader());
            properties.put(CLASSPATH, ".");
            String[] names = new String[classes.length];
            for (int i = 0; i < classes.length; ++i) {
                names[i] = classes[i].getName();
            }
            properties.put(SCANNED_CLASSES, names);
            ArrayList<ObjectTypeDescription> result = new ArrayList<ObjectTypeDescription>();
            ProgressMonitor progressMonitor = introspector.getClass().desiredAssertionStatus() ? SimpleProgressMonitor.INSTANCE : ProgressMonitor.NULL_INSTANCE;
            for (ObjectTypeDescription type : types = introspector.introspect(properties, catalog, progressMonitor)) {
                JavaIntrospector.collectLeafTypes(type, catalog, result);
            }
            return result.toArray(new ObjectTypeDescription[result.size()]);
        }
        catch (oracle.bpm.type.IntrospectionException e) {
            e.printStackTrace();
            return new ObjectTypeDescription[0];
        }
    }

    public static Map<String, String> filterObjects(Map<String, Object> properties) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            result.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return result;
    }

    public void setCustomProperties(Map properties, ObjectTypeDescription rootObject) {
    }

    @Override
    public Map<String, Object> defaultProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(CLASSPATH, ROOT);
        props.put(COPY_FILE_TO_EXT, "true");
        return props;
    }

    @Override
    public ObjectTypeDescription[] introspect(Map<String, Object> properties, ComponentCatalog catalog, ProgressMonitor monitor) throws oracle.bpm.type.IntrospectionException {
        ClassLoader prevContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            File[] files;
            this.monitor = monitor;
            this.loader = catalog;
            monitor.progress(-1);
            String configName = (String)properties.get("configName");
            ClassLoader classLoader = (ClassLoader)properties.get(CLASSLOADER);
            if (configName != null) {
                classLoader = JavaLibrariesHelper.getClassLoader();
                List<File> library = JavaLibrariesHelper.getLibraryFiles(configName);
                files = library.toArray(new File[library.size()]);
            } else {
                String classpath = (String)properties.get(CLASSPATH);
                if (Str.isEmpty(classpath)) {
                    monitor.error(CoreMsg.MISSING_CLASSPATH);
                    throw new oracle.bpm.type.IntrospectionException(CoreMsg.MISSING_CLASSPATH);
                }
                String[] classpathList = classpath.split(";");
                files = new File[classpathList.length];
                URL[] classPathFiles = new URL[classpathList.length];
                for (int i = 0; i < classpathList.length; ++i) {
                    files[i] = new File(classpathList[i]);
                    classPathFiles[i] = files[i].toURI().toURL();
                }
                if (classLoader == null) {
                    ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                    classLoader = URLClassLoader.newInstance(classPathFiles, contextClassLoader);
                }
            }
            Object selectedIds = properties.get("SELECTED_COMPONENTS");
            String[] selection = null;
            if (selectedIds != null) {
                selection = selectedIds instanceof String[] ? (String[])selectedIds : ((String)selectedIds).split(",");
            }
            ObjectTypeDescription root = new ObjectTypeDescription(ROOT);
            root.setComponentType(ComponentType.JAVA.getText());
            root.setProperties(JavaIntrospector.filterObjects(properties));
            root.setProperty(IS_PACKAGE, "true");
            this.unresolved = new HashMap<String, TypeRef>();
            this.id2type = new HashMap<String, ObjectTypeDescription>();
            this.id2type.put(ROOT, root);
            String[] scannedClasses = (String[])properties.get(SCANNED_CLASSES);
            if (scannedClasses == null) {
                ArrayList<String> classes = new ArrayList<String>();
                for (File file : files) {
                    monitor.phase(CoreMsg.SCANNING_JAR(file.getPath()));
                    JavaClassScanner.scan(file, selection, classes);
                }
                scannedClasses = classes.toArray(new String[classes.size()]);
            } else {
                scannedClasses = JavaClassScanner.filterClasses(scannedClasses, selection);
            }
            monitor.progress(-2);
            monitor.progress(0);
            this.total = scannedClasses.length;
            this.current = 0;
            monitor.phase(CoreMsg.LOADING_CLASSES);
            Thread.currentThread().setContextClassLoader(classLoader);
            boolean errors = false;
            boolean added = false;
            String currentPackage = ROOT;
            for (String clName : scannedClasses) {
                this.checkInterrupted();
                try {
                    int dot = clName.lastIndexOf(46);
                    if (!clName.startsWith(currentPackage) && dot > currentPackage.length()) {
                        currentPackage = clName.substring(0, dot);
                        monitor.info(0, CoreMsg.LOADING_CLASSES_FROM_PKG(currentPackage));
                    }
                    monitor.info(1, CoreMsg.LOADING_CLASS(clName));
                    Class cl = JavaClass.loadClass(clName, classLoader, true);
                    ObjectTypeDescription type = JavaIntrospector.createType(cl);
                    this.addType(clName, type, this.id2type, cl);
                    added = true;
                    monitor.progress(this.advance());
                }
                catch (ClassNotFoundException e) {
                    Log.logInfo(e);
                    monitor.error(CoreMsg.INTROSPECTION_ERROR(e.getMessage()));
                    errors = true;
                }
                catch (UnsatisfiedLinkError e) {
                    Log.logInfo(e);
                    monitor.error(CoreMsg.CLASS_NOT_FOUND(clName, e.getMessage()));
                    errors = true;
                }
            }
            monitor.progress(100);
            this.total += this.virtual;
            this.current = 0;
            monitor.progress(0);
            if (added) {
                monitor.phase(CoreMsg.LOADING_MEMBERS);
                this.loadMembers(root, classLoader, catalog);
            }
            if (errors) {
                monitor.phase(CoreMsg.INTROSPECTION_COMPLETE_WITH_ERRORS);
            } else {
                monitor.phase(CoreMsg.INSTROSPECTION_COMPLETE);
            }
            int childCount = root.getInnerTypeCount();
            ObjectTypeDescription[] objects = new ObjectTypeDescription[childCount];
            for (int i = 0; i < childCount; ++i) {
                objects[i] = root.getInnerType(i);
                if (configName == null) continue;
                objects[i].setProperty("configName", configName);
            }
            for (ObjectTypeDescription object1 : objects) {
                root.removeInnerType(object1);
            }
            this.id2type = null;
            this.unresolved = null;
            ObjectTypeDescription[] objectTypeDescriptionArray = objects;
            return objectTypeDescriptionArray;
        }
        catch (MalformedURLException e) {
            Msg message = CoreMsg.MALFORMED_URL(e.getMessage());
            monitor.error(message);
            throw new oracle.bpm.type.IntrospectionException(message, (Throwable)e);
        }
        catch (IOException e) {
            Msg message = CoreMsg.IO_ERROR(e.getMessage());
            monitor.error(message);
            throw new oracle.bpm.type.IntrospectionException(message, (Throwable)e);
        }
        catch (IntrospectionException e) {
            Msg message = CoreMsg.INTROSPECTION_ERROR(e.getMessage());
            monitor.error(message);
            throw new oracle.bpm.type.IntrospectionException(message, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            Msg message = CoreMsg.INTROSPECTION_ERROR(e.getMessage());
            monitor.error(message);
            throw new oracle.bpm.type.IntrospectionException(message, (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevContextClassLoader);
            monitor.progress(100);
        }
    }

    @Override
    public void interrupt() {
        this.interrupted = true;
    }

    @Override
    public boolean supportsReIntrospection() {
        return true;
    }

    static long getModifiers(Class<?> cl) {
        long mods = 0L;
        if (Comparable.class.isAssignableFrom(cl)) {
            mods |= 0x80L;
        }
        if (cl.isInterface()) {
            mods |= 0x400L;
        }
        if (Cloneable.class.isAssignableFrom(cl)) {
            mods |= 0x1000L;
        }
        if (Throwable.class.isAssignableFrom(cl)) {
            mods |= 0x40000L;
            BusinessException business = cl.getAnnotation(BusinessException.class);
            if (business == null) {
                mods |= 0x1000000000000L;
            }
        }
        if (JavaIntrospector.isDeprecated(cl)) {
            mods |= 0x100000L;
        }
        if (java.lang.reflect.Modifier.isAbstract(cl.getModifiers()) || JavaIntrospector.isInstanceInner(cl)) {
            mods |= 0x200L;
        }
        if (JavaIntrospector.isHiddenClass(cl)) {
            mods |= 0x2000000L;
        }
        return mods;
    }

    static void setRunningSide(ObjectTypeDescription otd, Class<?> cl) {
        otd.setLocalEnabled(true);
        boolean runsOnServer = true;
        boolean runsOnClient = true;
        if (cl != null) {
            if (DynamicRemote.class.isAssignableFrom(cl)) {
                runsOnServer = false;
            } else if (DynamicLocal.class.isAssignableFrom(cl)) {
                runsOnClient = false;
            } else {
                Component metadata = cl.getAnnotation(Component.class);
                if (metadata != null) {
                    runsOnServer = metadata.runsOnServer();
                    runsOnClient = metadata.runsOnClient();
                }
            }
        }
        if (runsOnClient && !runsOnServer) {
            otd.setLocalEnabled(false);
            otd.addModifier(0x8000000L);
            otd.setRemote(true);
        } else if (runsOnServer && !runsOnClient) {
            otd.setRemote(false);
        }
    }

    private static boolean isDeprecated(Class<?> cl) {
        return cl.getAnnotation(Deprecated.class) != null;
    }

    private static boolean isHiddenClass(Class<?> cl) {
        return cl.getAnnotation(Hidden.class) != null;
    }

    private static boolean isInstanceInner(@NotNull Class cl) {
        if (cl == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/JavaIntrospector.isInstanceInner must not be null");
        }
        return !java.lang.reflect.Modifier.isStatic(cl.getModifiers()) && cl.getEnclosingClass() != null;
    }

    private static Set<String> getAccessorsFromProperties(PropertyDescriptor[] properties) {
        HashSet<String> gettersAndSetters = new HashSet<String>();
        for (PropertyDescriptor descrip : properties) {
            if (descrip == null) continue;
            Method getter = descrip.getReadMethod();
            Method setter = descrip.getWriteMethod();
            if (JavaClass.isGetter(getter)) {
                gettersAndSetters.add(JavaClass.getSignature(getter));
            }
            if (!JavaClass.isSetter(setter)) continue;
            gettersAndSetters.add(JavaClass.getSignature(setter));
        }
        return gettersAndSetters;
    }

    private static boolean isHiddenMethod(String signature) {
        boolean hidden = false;
        if (signature.startsWith("get") || signature.startsWith("set")) {
            hidden = true;
        } else if (signature.startsWith("is") && (signature.endsWith(")Z") || signature.endsWith("Ljava.lang.Boolean;"))) {
            hidden = true;
        } else if (signature.equals(MAIN_METHOD)) {
            hidden = true;
        }
        return hidden;
    }

    private static boolean isMetaField(String name) {
        return name.endsWith("_INDEX_") || name.endsWith("_ELEMENT_") || name.endsWith("_TYPE_") || name.endsWith("$index") || name.endsWith("$element") || name.endsWith("$type");
    }

    private static Map<String, Class> getMetaFields(Class cl) {
        HashMap<String, Class> metaFields = new HashMap<String, Class>();
        for (Class current = cl; current != null; current = current.getSuperclass()) {
            Field[] declaringFields = current.getDeclaredFields();
            int length = declaringFields.length;
            for (int i = 0; i < length; ++i) {
                String name = declaringFields[i].getName();
                if (!JavaIntrospector.isMetaField(name) || metaFields.containsKey(name)) continue;
                metaFields.put(name, declaringFields[i].getType());
            }
        }
        return metaFields;
    }

    private static Class getMetadata(Map<String, Class> metaFields, String name, int type) {
        Class result = null;
        switch (type) {
            case 0: {
                result = metaFields.get(name + "_METHOD_ELEMENT_");
                if (result != null) break;
                result = metaFields.get(name + "$method$element");
                break;
            }
            case 1: {
                result = metaFields.get(name + "_METHOD_INDEX_");
                if (result != null) break;
                result = metaFields.get(name + "$method$index");
                break;
            }
            case 2: {
                result = metaFields.get(name + "_METHOD_TYPE_");
                if (result != null) break;
                result = metaFields.get(name + "$method$type");
                break;
            }
            case 3: {
                result = metaFields.get(name + "_ELEMENT_");
                if (result != null) break;
                result = metaFields.get(name + "$element");
                break;
            }
            case 4: {
                result = metaFields.get(name + "_INDEX_");
                if (result != null) break;
                result = metaFields.get(name + "$index");
                break;
            }
            case 5: {
                result = metaFields.get(name + "_TYPE_");
                if (result != null) break;
                result = metaFields.get(name + "$type");
                break;
            }
        }
        return result;
    }

    private static void collectLeafTypes(ObjectTypeDescription type, ComponentCatalog catalog, List<ObjectTypeDescription> result) {
        type.setCatalog(catalog);
        int innerCount = type.getInnerTypeCount();
        if (innerCount == 0) {
            result.add(type);
        } else {
            for (int i = 0; i < innerCount; ++i) {
                JavaIntrospector.collectLeafTypes(type.getInnerType(i), catalog, result);
            }
        }
    }

    private static MethodTypeDescription copyMethod(MethodTypeDescription source, String newName) {
        ObjectTypeDescription parentObject = source.getParent().asObject();
        MethodTypeDescription copy = source.clone();
        copy.setNextMethod(null);
        copy.setName(newName);
        parentObject.addMember(copy);
        return copy;
    }

    private static void markReplaced(MethodTypeDescription targetMember, String replacementName) {
        targetMember.addModifiers(0x2100000L);
        targetMember.setReplacement(replacementName);
    }

    private static String getAttributeName(MethodTypeDescription method) {
        if (!JavaIntrospector.isGetter(method) && !JavaIntrospector.isSetter(method)) {
            return null;
        }
        String name = method.getName();
        name = name.startsWith("is") ? name.substring(2) : name.substring(3);
        name = Identifier.attribute(name);
        return name;
    }

    private static boolean isGetter(MethodTypeDescription javaMethod) {
        if (javaMethod.getArgumentCount() != 0) {
            return false;
        }
        TypeRef resultType = javaMethod.getResultArgument().getTypeRef();
        if (resultType.getKind() == 0) {
            return false;
        }
        String name = javaMethod.getName();
        return name.startsWith("get") ? name.length() > 3 && !name.equals("getClass") : name.startsWith("is") && resultType.getKind() == 1 && name.length() > 2;
    }

    private static boolean isSetter(MethodTypeDescription javaMethod) {
        if (javaMethod.getArgumentCount() != 1) {
            return false;
        }
        TypeRef resultType = javaMethod.getResultArgument().getTypeRef();
        if (resultType.getKind() != 0) {
            return false;
        }
        String name = javaMethod.getName();
        return name.startsWith("set") && name.length() > 3;
    }

    private static void parseMetadata(Argument arg, String metadata, ComponentCatalog catalog) {
        Matcher matcher = MetadataPattern.INSTANCE.matcher(metadata);
        if (!matcher.matches()) {
            if (DEBUG) {
                System.out.println("Warning: Invalid metadata syntax \"" + metadata + "\" : " + arg);
            }
            return;
        }
        boolean hasIn = matcher.group(1) != null;
        boolean hasOut = matcher.group(2) != null;
        arg.setIn(hasIn || !hasOut);
        arg.setOut(hasOut);
        arg.setName(matcher.group(3));
        arg.setProperty("hasMetadataAnnotations", Boolean.TRUE.toString());
        String paramType = matcher.group(4);
        if (paramType != null) {
            boolean primitive = arg.getType().isPrimitive();
            arg.setType(TypeFactory.forNameLazy(paramType, catalog, arg.getJavaType()).get().primitiveEquivalent(primitive));
        }
    }

    private static TypeRef getAnnotatedType(AnnotatedElement element, ComponentCatalog catalog) {
        TypeRef result = null;
        Type type = element.getAnnotation(Type.class);
        if (type != null) {
            result = TypeFactory.forName(type.value(), catalog);
        } else {
            String[] resultMetadata;
            oracle.bpm.component.metadata.Method method = element.getAnnotation(oracle.bpm.component.metadata.Method.class);
            if (method != null && (resultMetadata = method.result().split("\\s:\\s")).length == 2 && resultMetadata[1].length() > 0) {
                result = TypeFactory.forNameLazy(resultMetadata[1], catalog);
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    private static ObjectTypeDescription createType(@NotNull Class cl) {
        void var6_9;
        int index;
        if (cl == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/JavaIntrospector.createType must not be null");
        }
        String classname = cl.getName();
        int dot = classname.lastIndexOf(46);
        String pkg = null;
        String name = classname;
        if (dot > 0) {
            pkg = classname.substring(0, dot);
            name = classname.substring(dot + 1);
            pkg = pkg.intern();
        }
        if ((index = name.lastIndexOf(36)) != -1) {
            name = name.substring(index + 1);
        }
        if (cl.isEnum()) {
            JavaEnumTypeDescription javaEnumTypeDescription = JavaEnumTypeDescription.create(name, cl);
        } else if (EnumType.class.isAssignableFrom(cl)) {
            ObjectTypeDescription objectTypeDescription = JavaEnumTypeDescription.createDeprecated(name, cl);
        } else {
            ObjectTypeDescription objectTypeDescription = JavaIntrospector.createObjectTypeDescription(cl, pkg, name);
        }
        var6_9.addModifier(JavaIntrospector.getModifiers(cl));
        void v0 = var6_9;
        if (v0 == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/JavaIntrospector.createType must not return null");
        }
        return v0;
    }

    private static ObjectTypeDescription createObjectTypeDescription(Class cl, String pkg, String name) {
        ObjectTypeDescription otd = new ObjectTypeDescription(name);
        String classname = cl.getName();
        otd.setId(cl.getName());
        otd.setComponentType(ComponentType.JAVA.getText());
        otd.setJavaClass(cl);
        otd.setName(name);
        otd.setSignature(classname);
        if (pkg != null) {
            otd.setProperty("package", pkg);
        }
        otd.setProperty("javaClassName", classname);
        JavaIntrospector.setRunningSide(otd, cl);
        return otd;
    }

    private static void assignNewNameTo(ObjectTypeDescription innerType) {
        String currentName;
        TypeDescription parent = innerType.getParent();
        String baseName = currentName = innerType.getName();
        int currentSuffix = 1;
        int length = currentName.length();
        for (int i = length - 1; i >= 0; --i) {
            if (Character.isDigit(currentName.charAt(i))) continue;
            if (i == length - 1) break;
            baseName = currentName.substring(0, i + 1);
            String suffix = currentName.substring(i + 1);
            currentSuffix = Integer.parseInt(suffix);
            break;
        }
        ++currentSuffix;
        if (parent != null) {
            ObjectTypeDescription objType = parent.asObject();
            while (objType.findInnerType(baseName + currentSuffix) != null) {
                ++currentSuffix;
            }
        }
        innerType.setName(baseName + currentSuffix);
    }

    private static void clearEnumBuiltins(ObjectTypeDescription root, MethodTypeDescription[] members) {
        EnumTypeDescription enumType = (EnumTypeDescription)((Object)root);
        HashSet<String> labels = new HashSet<String>(Arrays.asList(enumType.getLabels()));
        for (int i = 0; i < members.length; ++i) {
            MethodTypeDescription member = members[i];
            if (member == null) continue;
            String name = member.getName();
            if (labels.contains(name)) {
                members[i] = null;
                continue;
            }
            if (name.equals("VALUES")) {
                member.setResultType(TypeFactory.getArray(enumType));
                continue;
            }
            MethodTypeDescription prev = null;
            while (member != null) {
                MethodTypeDescription next = member.getNextMethod();
                if (!JavaEnumTypeDescription.isDefaultFactory(name, member)) {
                    prev = member;
                } else if (prev == null) {
                    members[i] = next;
                } else {
                    prev.setNextMethod(next);
                }
                member = next;
            }
        }
    }

    private static boolean isExternal(Class type, Class javaClass) {
        return Any.equals(type, javaClass);
    }

    private static void checkI18nMethod(MethodTypeDescription member) {
        String replacementName = I18N_METHODS_TO_REPLACE.get(member.getName());
        if (replacementName != null) {
            for (MethodTypeDescription ovlMember = member; ovlMember != null; ovlMember = ovlMember.getNextMethod()) {
                JavaIntrospector.copyMethod(ovlMember, replacementName);
                JavaIntrospector.markReplaced(ovlMember, replacementName);
            }
        }
    }

    private static <T extends AnnotatedElement> T[] filterExcluded(T[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            T element = elements[i];
            if (!JavaIntrospector.isExcluded(element)) continue;
            elements[i] = null;
        }
        elements = (AnnotatedElement[])ArrayUtils.trim(elements);
        return elements;
    }

    private static boolean isExcluded(AnnotatedElement element) {
        return element != null && element.getAnnotation(Exclude.class) != null;
    }

    private static Method sanitizeMethod(Method method) {
        block2: {
            Class<?> declaringClass = method.getDeclaringClass();
            try {
                method = declaringClass.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)("The method should be there" + e));
            }
        }
        return method;
    }

    private static MethodTypeDescription[] createStaticProperties(MethodTypeDescription[] members) {
        members = ArrayUtils.trim(members);
        HashMap<String, AttributeTypeDescription> attributes = new HashMap<String, AttributeTypeDescription>();
        for (MethodTypeDescription member : members) {
            if (!(member instanceof AttributeTypeDescription) || !member.isStatic()) continue;
            attributes.put(member.getName(), (AttributeTypeDescription)member);
        }
        HashSet<AttributeTypeDescription> addedMembers = new HashSet<AttributeTypeDescription>();
        for (MethodTypeDescription member : members) {
            AttributeTypeDescription attribute;
            String attributeName;
            if (!member.isStatic()) continue;
            if (JavaIntrospector.isGetter(member)) {
                attributeName = JavaIntrospector.getAttributeName(member);
                attribute = (AttributeTypeDescription)attributes.get(attributeName);
                TypeRef resultType = member.getResultArgument().getTypeRef();
                if (attribute == null) {
                    attribute = new AttributeTypeDescription(attributeName, resultType);
                    attribute.setModifiers(member.getModifiers());
                    attributes.put(attributeName, attribute);
                    addedMembers.add(attribute);
                }
                if (!attribute.getTypeRef().equals(resultType)) continue;
                attribute.addModifiers(8L);
                attribute.setReadSignature(member.getSignature());
                attribute.setJavaType(member.getResultArgument().getJavaType());
                member.setVisible(false);
                continue;
            }
            if (!JavaIntrospector.isSetter(member)) continue;
            attributeName = JavaIntrospector.getAttributeName(member);
            attribute = (AttributeTypeDescription)attributes.get(attributeName);
            TypeRef argumentType = member.getArgument(0).getTypeRef();
            if (attribute == null) {
                attribute = new AttributeTypeDescription(attributeName, argumentType);
                attribute.setModifiers(member.getModifiers());
                attributes.put(attributeName, attribute);
                addedMembers.add(attribute);
            }
            if (!attribute.getTypeRef().equals(argumentType)) continue;
            attribute.addModifiers(4L);
            attribute.setWriteSignature(member.getSignature());
            member.setVisible(false);
        }
        MethodTypeDescription[] result = new MethodTypeDescription[members.length + addedMembers.size()];
        System.arraycopy(members, 0, result, 0, members.length);
        int insertionPoint = members.length;
        for (AttributeTypeDescription attribute : addedMembers) {
            result[insertionPoint++] = attribute;
        }
        return result;
    }

    private void loadMembers(ObjectTypeDescription root, ClassLoader classLoader, ComponentCatalog catalog) throws IntrospectionException, ClassNotFoundException, InterruptedIntrospectionException {
        ProgressMonitor monitor = this.monitor;
        if (monitor == null) {
            monitor = SimpleProgressMonitor.INSTANCE;
        }
        this.loadMembers(root, classLoader, catalog, monitor);
    }

    private void loadParametersFromByteCode(ObjectTypeDescription objectType, Class<?> root, Set<Class<?>> classesToAnalyze) {
        LinkedList classes = new LinkedList();
        for (Class<?> c = root; c != null && !c.getName().equals("java.lang.Object"); c = c.getSuperclass()) {
            if (!classesToAnalyze.contains(c)) continue;
            classes.addFirst(c);
        }
        try {
            if (this.bytecodeIntrospector == null) {
                this.bytecodeIntrospector = new BytecodeIntrospector();
            }
            for (Class clazz : classes) {
                this.bytecodeIntrospector.introspect(clazz, objectType);
            }
        }
        catch (Throwable unexpected) {
            System.err.println("Could not enhance type with bytecode info: " + unexpected);
        }
    }

    private void addType(String clName, ObjectTypeDescription type, Map<String, ObjectTypeDescription> id2type, Class<?> cl) throws IntrospectionException {
        Component metadata = cl == null ? null : cl.getAnnotation(Component.class);
        int dot = Math.max(clName.lastIndexOf(46), clName.lastIndexOf(36));
        String module = metadata != null ? metadata.module() : (dot != -1 ? clName.substring(0, dot) : ROOT);
        ObjectTypeDescription container = id2type.get(module);
        if (container == null) {
            String containerName = module.substring(module.lastIndexOf(46) + 1);
            container = new ObjectTypeDescription(Identifier.classname(containerName));
            container.setComponentType(ComponentType.JAVA.getText());
            container.setProperty(IS_PACKAGE, "true");
            container.addModifier(512L);
            ++this.virtual;
            this.addType(module, container, id2type, null);
        }
        id2type.put(clName, type);
        assert (type != null) : "null type for " + clName;
        TypeRef prev = container.findInnerType(type.getName());
        while (prev != null) {
            ObjectTypeDescription innerType = prev.get().asObject();
            if (Boolean.parseBoolean(innerType.getProperty(IS_PACKAGE))) {
                JavaIntrospector.assignNewNameTo(innerType);
            } else {
                JavaIntrospector.assignNewNameTo(type);
            }
            prev = container.findInnerType(type.getName());
        }
        container.addInnerType(type);
    }

    private int advance() {
        return this.total != 0 ? this.current++ * 100 / this.total : 100;
    }

    private void checkInterrupted() throws InterruptedIntrospectionException {
        if (this.interrupted) {
            throw new InterruptedIntrospectionException();
        }
    }

    private AttributeTypeDescription createAttribute(Field field, Class element, Class index, Class typeSpec) {
        ReplacementFor replacement;
        int fModifiers;
        Class<?> fieldClass = field.getType();
        Class<?> typeClass = typeSpec != null ? typeSpec : fieldClass;
        TypeRef type = this.valueOf(typeClass, field.getDeclaringClass().getName(), element, index, false, false);
        AttributeTypeDescription attr = new AttributeTypeDescription(field.getName(), type);
        attr.setName(field.getName());
        attr.setResultType(type);
        String signature = JavaClass.getSignature(field);
        attr.setReadSignature(signature);
        attr.setWriteSignature(signature);
        attr.setJavaType(JavaClass.getJavaType(fieldClass));
        long modifiers = 40L;
        if (JavaIntrospector.isExternal(typeClass, fieldClass)) {
            modifiers |= 0x800L;
        }
        if (!java.lang.reflect.Modifier.isFinal(fModifiers = field.getModifiers())) {
            modifiers |= 4L;
        }
        if (java.lang.reflect.Modifier.isFinal(fModifiers)) {
            modifiers |= 0x20000L;
        }
        if (java.lang.reflect.Modifier.isStatic(fModifiers)) {
            modifiers |= 0x40L;
        }
        attr.setModifiers(modifiers);
        if (field.getName().contains("$")) {
            attr.setVisible(false);
        } else {
            attr.setVisible(field.getAnnotation(Hidden.class) == null);
        }
        if (java.lang.reflect.Modifier.isStatic(field.getModifiers()) && java.lang.reflect.Modifier.isFinal(field.getModifiers())) {
            attr.setName(Identifier.constant(field.getName()));
        }
        if ((replacement = field.getAnnotation(ReplacementFor.class)) != null) {
            attr.setProperty(REPLACEMENT_FOR, replacement.value());
        }
        return attr;
    }

    private AttributeTypeDescription createAttribute(ObjectTypeDescription otd, PropertyDescriptor property, Class element, Class index, Class typeSpec, ComponentCatalog catalog) {
        TypeRef forcedType;
        Class typeClass;
        TypeRef type;
        Class propertyType;
        Method read = null;
        Method write = null;
        if (property instanceof IndexedPropertyDescriptor) {
            IndexedPropertyDescriptor indexedProperty = (IndexedPropertyDescriptor)property;
            propertyType = indexedProperty.getIndexedPropertyType();
            type = TypeFactory.getPrimitiveArray(this.valueOf(propertyType, otd.getText()));
            typeClass = propertyType;
            read = indexedProperty.getIndexedReadMethod();
            write = indexedProperty.getIndexedWriteMethod();
        } else {
            propertyType = property.getPropertyType();
            type = this.valueOf(propertyType, otd.getText(), element, index, false, false);
            typeClass = propertyType;
        }
        if (read == null) {
            read = property.getReadMethod();
        }
        if (write == null) {
            write = property.getWriteMethod();
        }
        if (typeSpec != null) {
            type = this.valueOf(typeSpec, otd.getText(), element, index, false, false);
            typeClass = typeSpec;
        }
        if (read != null && (forcedType = JavaIntrospector.getAnnotatedType(read, catalog)) != null) {
            type = forcedType;
        }
        String propertyName = property.getName();
        if (read != null && read.getAnnotations() != null) {
            oracle.bpm.component.metadata.Method annotation = read.getAnnotation(oracle.bpm.component.metadata.Method.class);
            propertyName = annotation != null && annotation.name().length() > 0 ? annotation.name() : propertyName;
        }
        AttributeTypeDescription attr = new AttributeTypeDescription(propertyName, type);
        attr.setJavaType(JavaClass.getJavaType(propertyType));
        long modifiers = 0L;
        if (JavaIntrospector.isExternal(typeClass, propertyType)) {
            modifiers |= 0x800L;
        }
        if (read != null) {
            modifiers |= 8L;
            attr.setReadSignature(JavaClass.getSignature(read));
        }
        if (write != null) {
            modifiers |= 4L;
            attr.setWriteSignature(JavaClass.getSignature(write));
        }
        assert (read != null || write != null) : attr.getName();
        attr.setModifiers(modifiers);
        ReplacementFor replacement = null;
        if (read != null) {
            replacement = read.getAnnotation(ReplacementFor.class);
        }
        if (write != null && replacement == null) {
            replacement = write.getAnnotation(ReplacementFor.class);
        }
        if (replacement != null) {
            attr.setProperty(REPLACEMENT_FOR, replacement.value());
        }
        return attr;
    }

    private MethodTypeDescription createConstructorType(ObjectTypeDescription otd, Constructor<?> constr, ComponentCatalog catalog) {
        MethodTypeDescription mtd = new MethodTypeDescription(otd.getName());
        Class<?>[] args = constr.getParameterTypes();
        oracle.bpm.component.metadata.Method metadata = constr.getAnnotation(oracle.bpm.component.metadata.Method.class);
        TypeDescription type = TypeMappings.getType(constr.getDeclaringClass().getName());
        TypeDescription returnType = type != null ? type : otd;
        mtd.setResultType(returnType);
        mtd.setSignature(JavaClass.getSignature(constr));
        mtd.setModifiers(64L);
        String[] metaParameters = metadata != null ? metadata.parameters() : ArrayUtils.EMPTY_STRING_ARRAY;
        int length = args.length;
        for (int i = 0; i < length; ++i) {
            Class<?> cl = args[i];
            TypeRef argType = this.valueOf(cl, otd.getText());
            long modifiers = JavaIntrospector.isExternal(cl, args[i]) ? 2048L : 0L;
            Argument arg = new Argument("arg" + (i + 1), argType, modifiers |= 1L);
            arg.setJavaType(JavaClass.getJavaType(args[i]).intern());
            mtd.addArgument(arg);
            if (i >= metaParameters.length) continue;
            JavaIntrospector.parseMetadata(arg, metaParameters[i], catalog);
        }
        mtd.setVisible(args.length != 0);
        if (constr.getAnnotation(Hidden.class) != null) {
            mtd.setVisible(false);
        }
        return mtd;
    }

    private MethodTypeDescription createMethodType(ObjectTypeDescription otd, Method jmethod, Class elementType, Class indexType, ComponentCatalog catalog) {
        boolean isDeprecated;
        String resultName;
        String name = jmethod.getName().intern();
        String signature = JavaClass.getSignature(jmethod);
        signature = signature.intern();
        oracle.bpm.component.metadata.Method metadata = jmethod.getAnnotation(oracle.bpm.component.metadata.Method.class);
        if (metadata != null && metadata.name().length() > 0) {
            name = metadata.name();
        }
        MethodTypeDescription mtd = new MethodTypeDescription(name);
        mtd.setSignature(signature);
        Class<?> typeClass = jmethod.getReturnType();
        TypeRef type = this.valueOf(typeClass, otd.getText(), elementType, indexType, false, false);
        mtd.setResultType(type);
        mtd.getResultArgument().setJavaType(JavaClass.getJavaType(typeClass));
        int returnModif = 0;
        if (JavaIntrospector.isExternal(typeClass, typeClass)) {
            returnModif = (int)((long)returnModif | 0x800L);
        }
        mtd.getResultArgument().setModifiers((long)returnModif | 0x10L);
        TypeRef annotatedType = JavaIntrospector.getAnnotatedType(jmethod, catalog);
        if (annotatedType != null && typeClass != Void.TYPE) {
            mtd.setResultType(annotatedType);
        }
        if (metadata != null && (resultName = metadata.result()).length() > 0) {
            int colon = resultName.indexOf(58);
            if (colon != -1) {
                resultName = resultName.substring(0, colon).trim();
            }
            mtd.getResultArgument().setName(resultName);
        }
        if (java.lang.reflect.Modifier.isStatic(jmethod.getModifiers())) {
            mtd.setModifiers(mtd.getModifiers() | 0x40L);
        }
        if (java.lang.reflect.Modifier.isAbstract(jmethod.getModifiers())) {
            mtd.setModifiers(mtd.getModifiers() | 0x200L);
        }
        if (java.lang.reflect.Modifier.isFinal(jmethod.getModifiers())) {
            mtd.setModifiers(mtd.getModifiers() | 0x20000L);
        }
        if (Modifier.isExternal(returnModif)) {
            mtd.setModifiers(mtd.getModifiers() | 0x800L);
        }
        boolean bl = isDeprecated = null != jmethod.getAnnotation(Deprecated.class);
        if (isDeprecated) {
            mtd.setModifiers(mtd.getModifiers() | 0x100000L);
        }
        mtd.setVisible(true);
        if (JavaIntrospector.isHiddenMethod(signature) || jmethod.getAnnotation(Hidden.class) != null) {
            mtd.setVisible(false);
        }
        Class<?>[] params = jmethod.getParameterTypes();
        String[] metaParameters = metadata != null ? metadata.parameters() : ArrayUtils.EMPTY_STRING_ARRAY;
        for (int i = 0; i < params.length; ++i) {
            Class argClass;
            String argName = "arg" + (i + 1);
            argName = argName.intern();
            Argument arg = new Argument(argName, TypeFactory.getAny(), 1L);
            arg.setDescription(ROOT);
            if (JavaClass.isHolder(params[i])) {
                arg.setModifiers(3L);
                arg.setHolderJavaType(params[i].getName());
                Class holderType = JavaClass.getHolderType(params[i]);
                arg.setType(this.valueOf(holderType, otd.getText()));
                argClass = holderType;
            } else {
                arg.setModifiers(1L);
                Class cl = params[i];
                arg.setType(this.valueOf(cl, otd.getText()));
                argClass = cl;
            }
            if (JavaIntrospector.isExternal(argClass, params[i])) {
                arg.setModifiers(arg.getModifiers() | 0x800L);
            }
            arg.setJavaType(JavaClass.getJavaType(params[i]));
            if (i < metaParameters.length) {
                JavaIntrospector.parseMetadata(arg, metaParameters[i], catalog);
            }
            mtd.addArgument(arg);
        }
        if (typeClass == Void.TYPE && annotatedType != null && mtd.getArgumentCount() == 1) {
            mtd.getArgument(0).setType(annotatedType);
        }
        Class<?>[] excs = jmethod.getExceptionTypes();
        int length = excs.length;
        for (int i = 0; i < length; ++i) {
            mtd.addException(this.valueOf(excs[i], otd.getText()));
        }
        ReplacementFor replacement = jmethod.getAnnotation(ReplacementFor.class);
        if (replacement != null) {
            mtd.setProperty(REPLACEMENT_FOR, replacement.value());
        }
        return mtd;
    }

    private MethodTypeDescription createMethodType(ObjectTypeDescription otd, MethodDescriptor method, Class elementType, Class indexType, ComponentCatalog catalog) {
        Method jmethod = JavaIntrospector.sanitizeMethod(method.getMethod());
        MethodTypeDescription mtd = this.createMethodType(otd, jmethod, elementType, indexType, catalog);
        mtd.setDescription(method.getShortDescription());
        ParameterDescriptor[] paramsdescr = method.getParameterDescriptors();
        if (paramsdescr != null) {
            for (int i = 0; i < paramsdescr.length; ++i) {
                Argument arg = mtd.getArgument(i);
                arg.setName(paramsdescr[i].getName().intern());
                arg.setDescription(paramsdescr[i].getShortDescription());
            }
        }
        return mtd;
    }

    private MethodTypeDescription loadConstructors(Constructor[] constructors, ObjectTypeDescription otd, ComponentCatalog catalog) {
        MethodTypeDescription mtd = null;
        int length = constructors.length;
        for (int i = 0; i < length; ++i) {
            MethodTypeDescription constr = this.createConstructorType(otd, constructors[i], catalog);
            mtd = mtd == null ? constr : MethodTypeDescription.appendMethod(mtd, constr);
        }
        return mtd;
    }

    private void loadMembers(ObjectTypeDescription root, ClassLoader classLoader, ComponentCatalog catalog, ProgressMonitor monitor) throws IntrospectionException, ClassNotFoundException, InterruptedIntrospectionException {
        this.checkInterrupted();
        monitor.progress(this.advance());
        boolean isPackage = Boolean.parseBoolean(root.getProperty(IS_PACKAGE));
        if (isPackage) {
            monitor.info(0, CoreMsg.LOADING_MEMBER_FOR_CLASSES(root.getText()));
        } else {
            monitor.info(1, CoreMsg.LOADING_MEMBERS_FOR(root.getJavaType()));
            this.loadClassMembers(root, classLoader, catalog, monitor);
        }
        for (TypeRef ref : root.getInnerTypeRefs()) {
            this.loadMembers(ref.get().asObject(), classLoader, catalog);
        }
    }

    private void loadClassMembers(ObjectTypeDescription root, ClassLoader classLoader, ComponentCatalog catalog, ProgressMonitor monitor) {
        String javaType = root.getJavaType();
        try {
            Class<?> javaClass = JavaClass.loadByJavaType(javaType, classLoader, true);
            Component compAnn = javaClass.getAnnotation(Component.class);
            boolean hideInheritance = compAnn != null && compAnn.hideInheritance();
            HashSet classesToAnalyze = new HashSet();
            MethodTypeDescription[] members = this.loadMembers(javaClass, root, catalog, hideInheritance, classesToAnalyze);
            if (root.isEnum()) {
                JavaIntrospector.clearEnumBuiltins(root, members);
            }
            boolean isI18nProvider = I18nProvider.class.isAssignableFrom(root.getJavaClass());
            for (MethodTypeDescription member : members) {
                String replacementFor;
                if (member == null) continue;
                root.addMember(member);
                if (isI18nProvider) {
                    JavaIntrospector.checkI18nMethod(member);
                }
                if ((replacementFor = member.getProperty(REPLACEMENT_FOR)) == null) continue;
                MethodTypeDescription replacedMethod = JavaIntrospector.copyMethod(member, replacementFor);
                JavaIntrospector.markReplaced(replacedMethod, member.getName());
            }
            Class<Object> parent = javaClass.getSuperclass();
            long parentFlags = 32768L;
            if (hideInheritance || parent == null && javaClass.isInterface() && javaClass.getInterfaces().length == 0) {
                parent = Object.class;
                parentFlags |= 0x2000000L;
            }
            if (parent != null) {
                TypeRef otd = this.classValueOf(parent, true, root.getText());
                if (otd != null) {
                    root.addSuperType(new SuperType(otd, parentFlags));
                    if (otd instanceof DynamicRef) {
                        monitor.warning(CoreMsg.COULDNT_RESOLVE_SUPER(parent.getName(), root.getText()));
                    }
                } else {
                    monitor.error(CoreMsg.COULDNT_RESOLVE_SUPER(parent.getName(), root.getText()));
                }
            }
            for (Class<?> iface : javaClass.getInterfaces()) {
                if (!java.lang.reflect.Modifier.isPublic(iface.getModifiers())) continue;
                TypeRef otd = this.classValueOf(iface, true, root.getText());
                if (otd != null) {
                    root.addSuperType(new SuperType(otd, 0L));
                    continue;
                }
                monitor.error(CoreMsg.COULDNT_RESOLVE_INTERFACE(iface.getName(), javaType));
            }
            try {
                this.loadParametersFromByteCode(root, javaClass, classesToAnalyze);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        catch (NoClassDefFoundError e) {
            monitor.error(CoreMsg.CLASS_DEF_NOT_FOUND(javaType, e.getMessage()));
        }
        catch (ExceptionInInitializerError e) {
            monitor.error(CoreMsg.EXCEPTION_IN_INITIALIZER(javaType, e.toString()));
        }
        catch (Throwable unexpected) {
            unexpected.printStackTrace();
            monitor.error(CoreMsg.COULDNT_LOAD_MEMBERS(javaType, unexpected.toString()));
        }
    }

    private MethodTypeDescription[] loadMembers(Class<?> cl, ObjectTypeDescription otd, ComponentCatalog catalog, boolean hideInheritance, Set<Class<?>> classesToAnalyze) throws IntrospectionException {
        MethodTypeDescription mtd;
        PropertyDescriptor[] properties;
        BeanInfo beanInfo;
        try {
            beanInfo = java.beans.Introspector.getBeanInfo(cl);
            String desc = beanInfo.getBeanDescriptor().getShortDescription();
            if (desc != null) {
                otd.setDescription(desc);
            }
            properties = beanInfo.getPropertyDescriptors();
        }
        catch (NullPointerException e) {
            return new MethodTypeDescription[0];
        }
        if (I18nProvider.class.isAssignableFrom(cl)) {
            Map<String, String> i18nMethodsToReplace = I18N_METHODS_TO_REPLACE;
            for (int i = 0; i < properties.length; ++i) {
                PropertyDescriptor property = properties[i];
                if (property == null) continue;
                Method readMethod = property.getReadMethod();
                Method writeMethod = property.getWriteMethod();
                if ((readMethod == null || !i18nMethodsToReplace.containsKey(readMethod.getName())) && (writeMethod == null || !i18nMethodsToReplace.containsKey(writeMethod.getName()))) continue;
                properties[i] = null;
            }
        }
        Set<String> gettersAndSetters = JavaIntrospector.getAccessorsFromProperties(properties);
        MethodDescriptor[] methods = beanInfo.getMethodDescriptors();
        if (object == null) {
            object = JavaClass.fromClass(Object.class);
        }
        ArrayList<MethodDescriptor> list = new ArrayList<MethodDescriptor>();
        for (MethodDescriptor m : methods) {
            Method method = JavaIntrospector.sanitizeMethod(m.getMethod());
            Class<?> declaringClass = method.getDeclaringClass();
            if (!hideInheritance && declaringClass != cl) continue;
            String signature = JavaClass.getSignature(method);
            boolean isAccessor = gettersAndSetters.contains(signature);
            if (isAccessor || object.containsMethod(signature) && cl != Object.class) {
                m.setHidden(true);
            }
            if (JavaIntrospector.isExcluded(method)) continue;
            classesToAnalyze.add(declaringClass);
            list.add(m);
        }
        methods = list.toArray(new MethodDescriptor[list.size()]);
        AnnotatedElement[] fields = cl.getFields();
        AnnotatedElement[] constructors = cl.getConstructors();
        fields = (Field[])JavaIntrospector.filterExcluded((AnnotatedElement[])fields);
        constructors = (Constructor[])JavaIntrospector.filterExcluded((AnnotatedElement[])constructors);
        HashSet<String> propertyNames = new HashSet<String>();
        for (int i = 0; i < properties.length; ++i) {
            PropertyDescriptor property = properties[i];
            if (property == null) continue;
            boolean duplicated = propertyNames.contains(property.getName());
            propertyNames.add(property.getName());
            if (!JavaIntrospector.isExcluded(property.getReadMethod()) && !JavaIntrospector.isExcluded(property.getWriteMethod()) && !duplicated) continue;
            properties[i] = null;
        }
        properties = ArrayUtils.trim(properties);
        int nMembers = fields.length + properties.length;
        nMembers += methods.length;
        if (constructors != null && constructors.length > 0) {
            ++nMembers;
        }
        Map<String, Class> metaFields = JavaIntrospector.getMetaFields(cl);
        MethodTypeDescription[] members = new MethodTypeDescription[nMembers];
        int iMember = 0;
        int methodlength = methods.length;
        for (int i = 0; i < methodlength; ++i) {
            int methodIndex;
            Class index;
            String name = methods[i].getName();
            Class element = JavaIntrospector.getMetadata(metaFields, name, 0);
            MethodTypeDescription mtd2 = this.createMethodType(otd, methods[i], element, index = JavaIntrospector.getMetadata(metaFields, name, 1), catalog);
            if (mtd2.isVisible()) {
                mtd2.setVisible(!methods[i].isHidden());
            }
            String methodName = mtd2.getName();
            for (methodIndex = 0; methodIndex < iMember && !members[methodIndex].getName().equals(methodName); ++methodIndex) {
            }
            if (methodIndex == iMember) {
                members[iMember++] = mtd2;
                continue;
            }
            MethodTypeDescription method = members[methodIndex];
            if (MethodTypeDescription.appendMethod(method, mtd2) != mtd2) continue;
            members[methodIndex] = mtd2;
        }
        HashSet<String> loadedProperties = new HashSet<String>();
        for (PropertyDescriptor prop : properties) {
            String name = prop.getName();
            Method readMethod = prop.getReadMethod();
            Method writeMethod = prop.getWriteMethod();
            Class<?> declaringClass = null;
            if (readMethod != null) {
                declaringClass = readMethod.getDeclaringClass();
            } else if (writeMethod != null) {
                declaringClass = writeMethod.getDeclaringClass();
            }
            if (declaringClass != null && cl != declaringClass && !hideInheritance || name.equals("class") || prop instanceof IndexedPropertyDescriptor && otd.isRemote() || !JavaClass.isGetter(readMethod) && !JavaClass.isSetter(writeMethod)) continue;
            Class element = JavaIntrospector.getMetadata(metaFields, name, 3);
            Class index = JavaIntrospector.getMetadata(metaFields, name, 4);
            Class type = JavaIntrospector.getMetadata(metaFields, name, 5);
            loadedProperties.add(name);
            AttributeTypeDescription attributeTypeDescription = this.createAttribute(otd, prop, element, index, type, catalog);
            boolean isGetterVisible = readMethod == null || readMethod.getAnnotation(Hidden.class) == null;
            boolean isSetterVisible = writeMethod == null || writeMethod.getAnnotation(Hidden.class) == null;
            attributeTypeDescription.setVisible(isGetterVisible && isSetterVisible);
            members[iMember] = attributeTypeDescription;
            loadedProperties.add(members[iMember].getName());
            ++iMember;
        }
        for (AnnotatedElement field : fields) {
            String name = ((Field)field).getName();
            if (((Field)field).getDeclaringClass() != cl && !hideInheritance || JavaIntrospector.isMetaField(name) || loadedProperties.contains(name)) continue;
            Class element = JavaIntrospector.getMetadata(metaFields, name, 3);
            Class index = JavaIntrospector.getMetadata(metaFields, name, 4);
            Class type = JavaIntrospector.getMetadata(metaFields, name, 5);
            members[iMember++] = this.createAttribute((Field)field, element, index, type);
        }
        if (!JavaIntrospector.isInstanceInner(cl) && (mtd = this.loadConstructors((Constructor[])constructors, otd, catalog)) != null) {
            members[iMember] = mtd;
        }
        return JavaIntrospector.createStaticProperties(members);
    }

    private TypeRef valueOf(Class cl, String from) {
        return this.valueOf(cl, from, false, false);
    }

    private TypeRef valueOf(Class cl, String from, boolean parent, boolean silent) {
        return this.valueOf(cl, from, null, null, parent, silent);
    }

    private TypeRef valueOf(Class cl, String from, Class elementType, Class indexType, boolean parent, boolean silent) {
        TypeDescription it;
        TypeRef target = TypeMappings.getType(cl.getName());
        TypeDescription et = elementType != null ? this.valueOf(elementType, from) : TypeFactory.getAny();
        TypeRef typeRef = it = indexType != null ? this.valueOf(indexType, from) : TypeFactory.getAny();
        if (target != null) {
            switch (target.getKind()) {
                case 12: {
                    target = et != TypeFactory.getAny() ? TypeFactory.getArray(et) : target;
                    break;
                }
                case 16: {
                    target = et != TypeFactory.getAny() ? TypeFactory.getIterator(et) : target;
                    break;
                }
                case 13: {
                    target = et != TypeFactory.getAny() || it != TypeFactory.getAny() ? (target.get().isOrdered() ? TypeFactory.getSortedMap(et, it) : TypeFactory.getMap(et, it)) : target;
                    break;
                }
            }
            return target;
        }
        if (cl.isArray() && !parent) {
            if (Byte.TYPE.equals(cl.getComponentType())) {
                return TypeFactory.getBinary();
            }
            return TypeFactory.getPrimitiveArray(this.valueOf(cl.getComponentType(), from));
        }
        target = List.class.isAssignableFrom(cl) && !parent ? new ArrayTypeDescription(et, null, false, false, cl.getName()) : (Set.class.isAssignableFrom(cl) && !parent ? new SetTypeDescription((TypeRef)et, cl) : (Map.class.isAssignableFrom(cl) && !parent ? new ArrayTypeDescription(et, it, SortedMap.class.isAssignableFrom(cl), false, cl.getName()) : (Iterator.class.isAssignableFrom(cl) && !parent ? new IteratorTypeDescription(et, cl.getName()) : this.classValueOf(cl, silent, from))));
        return target;
    }

    private TypeRef classValueOf(Class cl, boolean silent, String from) {
        String className = cl.getName();
        TypeRef target = this.id2type.get(className);
        if (target == null && this.loader != null) {
            target = this.loader.findById(ComponentType.JAVA, className);
        }
        if (target == null && (target = this.unresolved.get(className)) == null) {
            if (!silent) {
                this.monitor.warning(CoreMsg.COULDNT_RESOLVE_TYPE(className, from));
            }
            String[] path = className.split("\\.");
            StringBuilder name = new StringBuilder();
            int length = path.length;
            for (int i = 0; i < length; ++i) {
                if (i != 0) {
                    name.append('.');
                }
                name.append(Identifier.classname(path[i]));
            }
            target = new DynamicRef("java", className, name.toString(), this.loader);
            this.unresolved.put(className, target);
        }
        return target;
    }

    static {
        java.beans.Introspector.setBeanInfoSearchPath(ArrayUtils.EMPTY_STRING_ARRAY);
        DEBUG = Boolean.getBoolean("oracle.bpm.lang.JavaIntrospector.debug");
    }

    private static final class SimpleProgressMonitor
    implements ProgressMonitor {
        static final ProgressMonitor INSTANCE = new SimpleProgressMonitor();

        private SimpleProgressMonitor() {
        }

        @Override
        public void progress(int percent) {
        }

        @Override
        public void phase(Msg message) {
        }

        @Override
        public void info(Msg message) {
        }

        @Override
        public void info(int logLevel, Msg message) {
        }

        @Override
        public void warning(Msg message) {
            if (DEBUG) {
                System.out.println("Warning: " + message);
            }
        }

        @Override
        public void error(Msg message) {
            if (DEBUG) {
                System.out.println("Error " + message);
            }
        }
    }

    private static final class MetadataPattern {
        static final Pattern INSTANCE = Pattern.compile("\\s*(in\\s+)?(out\\s+)?(\\w+)(?:\\s*:\\s*(\\S(?:.*\\S)?))?\\s*");

        private MetadataPattern() {
        }
    }
}

