/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import oracle.bpm.lang.Environment;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.MissingPropertyException;
import oracle.bpm.lang.PropertiesDeclaration;
import oracle.bpm.lang.User;
import oracle.bpm.log.Log;
import oracle.bpm.util.Locales;
import oracle.bpm.util.Properties;

public class DefaultEnvironment
implements Environment,
PropertiesDeclaration {
    protected Locale locale;
    protected TimeZone tz;
    private HashMap<String, Properties> loadedResourcesProperties;
    private Properties mutableProps;
    private String name = "";
    private User user;

    public DefaultEnvironment() {
    }

    public DefaultEnvironment(String appName) {
        this.name = appName;
        this.setUser(User.getLocalUser());
        Locale.setDefault(this.getLocale());
    }

    public DefaultEnvironment(String appName, Locale appLocale) {
        this.name = appName;
        this.locale = appLocale;
        this.setUser(User.getLocalUser());
        Locale.setDefault(this.getLocale());
    }

    public DefaultEnvironment(String name, Properties properties) {
        this.name = name;
        this.mutableProps = properties;
    }

    public DefaultEnvironment(String name, InputStream is) throws IOException {
        this.name = name;
        this.mutableProps = new Properties();
        this.mutableProps.load(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultEnvironment(String name, String propertiesFile) throws IOException {
        this.name = name;
        this.mutableProps = new Properties();
        FileInputStream stream = new FileInputStream(propertiesFile);
        try {
            this.mutableProps.load(stream);
        }
        finally {
            stream.close();
        }
    }

    protected DefaultEnvironment(String appName, User user, Locale deafaultLocale) {
        this.name = appName;
        this.setUser(user);
        Locale.setDefault(deafaultLocale);
    }

    public static DefaultEnvironment create(String appName) {
        return new DefaultEnvironment(appName);
    }

    public static DefaultEnvironment create(String appName, Properties props) {
        return new DefaultEnvironment(appName, props);
    }

    public static boolean isSystemProperty(String name) {
        return DefaultEnvironment.isSystemProperty(name, "file.") || DefaultEnvironment.isSystemProperty(name, "java.class.") || DefaultEnvironment.isSystemProperty(name, "java.") || DefaultEnvironment.isSystemProperty(name, "os.") || DefaultEnvironment.isSystemProperty(name, "file.separator") || DefaultEnvironment.isSystemProperty(name, "path.separator") || DefaultEnvironment.isSystemProperty(name, "line.separator");
    }

    @Override
    public final boolean getBooleanProperty(String propertyName, boolean def) {
        try {
            String property = this.getProperty(propertyName);
            if ("true".equalsIgnoreCase(property)) {
                return true;
            }
            if ("false".equalsIgnoreCase(property)) {
                return false;
            }
            if (Log.isDebugging()) {
                Log.logDebug("WARNING: property '" + propertyName + "' (" + property + ") has invalid format (should be one of true or false); default (" + def + ") will be used instead.");
            }
            return def;
        }
        catch (MissingPropertyException e) {
            return def;
        }
    }

    public final boolean getBooleanProperty(String propertyName) throws MissingPropertyException {
        String property = this.getProperty(propertyName);
        if ("true".equalsIgnoreCase(property)) {
            return true;
        }
        if ("false".equalsIgnoreCase(property)) {
            return false;
        }
        if (Log.isDebugging()) {
            Log.logDebug("WARNING: property '" + propertyName + "' (" + property + ") has invalid format (should be one of true or false)");
        }
        throw new MissingPropertyException(propertyName);
    }

    @Override
    public final int getIntegerProperty(String propertyName, int def) {
        String property = null;
        try {
            property = this.getProperty(propertyName);
            return Integer.parseInt(property);
        }
        catch (MissingPropertyException e) {
            return def;
        }
        catch (NumberFormatException e) {
            if (Log.isDebugging()) {
                Log.logDebug("WARNING: property '" + propertyName + "' (" + property + ") has invalid format (should be an integer); default (" + def + ") will be used instead (exception: " + e.getMessage() + ").");
            }
            return def;
        }
    }

    public final int getIntegerProperty(String propertyName) throws MissingPropertyException {
        String property = null;
        try {
            property = this.getProperty(propertyName);
            return Integer.parseInt(property);
        }
        catch (NumberFormatException e) {
            if (Log.isDebugging()) {
                Log.logDebug("WARNING: property '" + propertyName + "' (" + property + ") has invalid format (should be an integer); (exception: " + e.getMessage() + ").");
            }
            throw new MissingPropertyException(propertyName);
        }
    }

    @Override
    public final Interval getIntervalProperty(String propertyName, Interval def) {
        String property = null;
        try {
            property = this.getProperty(propertyName);
            return Interval.valueOf(Long.parseLong(property) * 1000L);
        }
        catch (MissingPropertyException e) {
            return def;
        }
        catch (NumberFormatException e) {
            if (Log.isDebugging()) {
                Log.logDebug("WARNING: property '" + propertyName + "' (" + property + ") has invalid format (should be milliseconds); default (" + def + ") will be used instead (exception: " + e.getMessage() + ").");
            }
            return def;
        }
    }

    @Override
    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locales.getDefaultLocale();
        }
        return this.locale;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final int getPriorityProperty(String property, String def) {
        String priorityStr = this.getProperty(property, def).toLowerCase();
        if ("min".equals(priorityStr)) {
            return 1;
        }
        if ("max".equals(priorityStr)) {
            return 10;
        }
        if ("default".equals(priorityStr)) {
            return Thread.currentThread().getPriority();
        }
        try {
            return Integer.parseInt(priorityStr);
        }
        catch (NumberFormatException e) {
            if (Log.isDebugging()) {
                Log.logDebug("WARNING: property '" + property + "' (" + priorityStr + ") has invalid format (should be an integer or a literal like min, max or default); " + "current-thread's priority will be used instead (exception: " + e.getMessage() + ").");
            }
            return Thread.currentThread().getPriority();
        }
    }

    @Override
    public synchronized java.util.Properties getProperties(Class clazz, String resource) {
        Properties props;
        String key = clazz.getName() + '/' + resource;
        if (this.loadedResourcesProperties == null) {
            this.loadedResourcesProperties = new HashMap();
        }
        if ((props = this.loadedResourcesProperties.get(key)) == null && (props = this.loadPropertyResource(clazz, resource)) != null) {
            this.loadedResourcesProperties.put(key, props);
        }
        return props;
    }

    @Override
    public final String getProperty(String propertyName, String def) {
        try {
            return this.getProperty(propertyName);
        }
        catch (MissingPropertyException e) {
            return def;
        }
    }

    @Override
    public String getProperty(String propertyName) throws MissingPropertyException {
        String property = null;
        if (this.mutableProps != null) {
            property = (String)this.mutableProps.get(propertyName);
        }
        if (property == null && this.user != null) {
            property = this.user.getProperty(propertyName);
        }
        if (property == null) {
            property = System.getProperty(propertyName);
        }
        if (property == null) {
            throw new MissingPropertyException(propertyName);
        }
        return property;
    }

    @Override
    public String getProperty(String property, Class clazz, String resource, String propInResource) throws MissingPropertyException {
        try {
            return this.getProperty(property);
        }
        catch (MissingPropertyException e) {
            String propVal = null;
            java.util.Properties props = this.getProperties(clazz, resource);
            if (props != null) {
                propVal = props.getProperty(propInResource);
            }
            if (propVal == null) {
                throw new MissingPropertyException(property);
            }
            return propVal;
        }
    }

    public URL getResource(Class clss, String resourceName) {
        return clss.getResource(resourceName);
    }

    public InputStream getResourceAsStream(Class clss, String resourceName) {
        return clss.getResourceAsStream(resourceName);
    }

    public final void setName(String v) {
        this.name = v;
    }

    @Override
    public TimeZone getTimeZone() {
        if (this.tz == null) {
            try {
                this.tz = TimeZone.getTimeZone(this.getProperty("user.timezone"));
            }
            catch (MissingPropertyException missingPropertyException) {
                // empty catch block
            }
            if (this.tz == null) {
                this.tz = TimeZone.getDefault();
            }
        }
        return this.tz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadPropertyResource(Class cl, String resource) {
        block8: {
            try {
                Properties props;
                InputStream in = this.getResourceAsStream(cl, resource);
                if (in == null) break block8;
                try {
                    props = new Properties();
                    props.load(in);
                }
                finally {
                    in.close();
                }
                return props;
            }
            catch (IOException err) {
                if (Log.isDebugging()) {
                    Log.logDebug(err + " while reading '" + resource + "' for " + cl);
                }
                if (Log.isDebugging()) {
                    Log.logDebug(err);
                }
                return null;
            }
        }
        if (Log.isDebugging()) {
            Log.logDebug("can't find property resource '" + resource + "' for " + cl);
        }
        return null;
    }

    @Override
    public final String putProperty(String propertyName, String property) {
        if (this.mutableProps == null) {
            this.mutableProps = new Properties();
        }
        return (String)this.mutableProps.put(propertyName, property);
    }

    protected final Properties getMutableProperties() {
        return this.mutableProps;
    }

    protected void serProperties(Properties properties) {
        this.mutableProps = properties;
    }

    private static boolean isSystemProperty(String name, String start) {
        try {
            return name.startsWith(start) && name.indexOf(46, start.length()) == -1 && System.getProperty(name) != null;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    private void setUser(User user) {
        if (this.user != null) {
            throw new RuntimeException("user is already set");
        }
        this.user = user;
    }
}

