/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.util.Collection;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.collections.maps.SortedStringMap;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.DynamicRef;
import oracle.bpm.type.SourceCode;
import oracle.bpm.type.TypeHolder;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.Variable;

public class AttributeTypeDescription
extends MethodTypeDescription
implements TypeHolder {
    private String defaultValue;
    private String maxOccurs = "*";
    private int position = -1;
    private StringList validValues;
    private SourceCode writeCode;
    private String writeSignature;
    private SortedStringMap<Variable> writeVariables;
    public static final String VIRTUAL_PROPERTY = "virtual";
    public static final String VALID_VALUES_METHOD = "validValuesMethodName";

    public AttributeTypeDescription(String name, TypeRef attributeType) {
        this(name, attributeType, 32780L);
    }

    public AttributeTypeDescription(String name, TypeRef attributeType, long modifiers) {
        super(18, name);
        this.setModifiers(modifiers);
        this.setType(attributeType);
    }

    public void setAbsoluteTime(boolean absolute) {
        this.setProperty("absoluteTime", absolute ? "true" : null);
    }

    public boolean isAbsoluteTime() {
        return Boolean.valueOf(this.getProperty("absoluteTime"));
    }

    public void setCalculated(boolean calculated) {
        this.setVirtual(calculated);
        if (calculated) {
            this.makeReadOnly();
        } else {
            this.makeReadWrite();
        }
    }

    public boolean isCalculated() {
        return this.isVirtual() && Modifier.hasGetter(this.getModifiers());
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        this.firePropertyChanged("defaultValue");
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isJavaAccessor() {
        return this.getParentRef().getComponentType().equals(ComponentType.JAVA.getText()) && this.getSignature().startsWith("M");
    }

    public boolean isJavaAttribute() {
        return this.getParentRef().getComponentType().equals(ComponentType.JAVA.getText()) && this.getSignature().startsWith("A");
    }

    @Override
    public String getJavaSignature() {
        String name = this.getName() + this.getSuffix();
        return JavaClass.createGetAttrSignature(name, this.getResultArgument().getJavaSignature());
    }

    public void setJavaType(String javaType) {
        this.getResultArgument().setJavaType(javaType);
    }

    @Override
    public String getJavaType() {
        return this.getResultArgument().getJavaType();
    }

    public String getJavaWriteSignature() {
        String name = this.getName() + this.getWriteSuffix();
        return JavaClass.createSetAttrSignature(name, this.getResultArgument().getJavaSignature());
    }

    public void setMaxOccurs(String max) {
        this.maxOccurs = max;
    }

    public String getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMemberLength(int length) {
        this.setType(this.getType().setLength(length));
    }

    public int getMemberLength() {
        return this.getType().getLength();
    }

    @Override
    public void setModifiers(long modifiers) {
        this.getResultArgument().setModifiers(modifiers);
        this.fireTypeChanged();
    }

    @Override
    public long getModifiers() {
        return this.getResultArgument().getModifiers();
    }

    @Override
    public void setNextMethod(MethodTypeDescription mtd) {
        assert (mtd == null) : "Attribute must not be linked " + mtd;
    }

    public void setPosition(int position) {
        assert (position >= -1) : "Invalid position: " + position;
        assert (this.getParentRef() == null || position != -1) : "Cannot set position to -1 after adding member to object type";
        this.position = position;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    public void setPrecision(int precision) {
        this.setType(this.getType().setScale(precision));
    }

    public int getPrecision() {
        return this.getType().getScale();
    }

    public void setPrimaryKey(boolean primaryKey) {
        if (primaryKey) {
            this.setModifiers(this.getModifiers() | 0x1000000L);
        } else {
            this.setModifiers(this.getModifiers() & 0xFFFFFFFFFEFFFFFFL);
        }
    }

    public boolean isPrimaryKey() {
        return Modifier.isPrimaryKey(this.getModifiers());
    }

    public boolean isCheckIncluded() {
        return Modifier.isIncludeInCheck(this.getModifiers());
    }

    public void setIncludeInCheck(boolean included) {
        if (included) {
            this.setModifiers(this.getModifiers() | 0x200000000000L);
        } else {
            this.setModifiers(this.getModifiers() & 0xFFFFDFFFFFFFFFFFL);
        }
    }

    public void setReadSignature(String signature) {
        this.setSignature(signature);
    }

    public String getReadSignature() {
        return this.getSignature();
    }

    public void setRequired(boolean required) {
        if (required) {
            this.setModifiers(this.getModifiers() | 0x4000000L);
        } else {
            this.setModifiers(this.getModifiers() & 0xFFFFFFFFFBFFFFFFL);
        }
    }

    public boolean isRequired() {
        return Modifier.isRequired(this.getModifiers());
    }

    public String getSuffix() {
        TypeDescription parent = this.getParent();
        String suffix = "";
        if (parent != null) {
            String name = this.getName();
            String getter = JavaClass.nameForGetter(name);
            int count = 1;
            while (this.causesConflict(getter, count)) {
                ++count;
            }
            if (count != 1) {
                suffix = String.valueOf(count);
            }
        }
        return suffix;
    }

    @Override
    public String getText() {
        TypeRef parent = this.getParentRef();
        return parent != null ? parent.getText() + ':' + this.getName() : this.getName();
    }

    @Override
    public void setType(TypeRef newType) {
        TypeRef oldType = this.getResultArgument().getTypeRef();
        if (!Any.equals(oldType, newType.getRef())) {
            this.onTypeChanged(oldType, newType);
            this.setResultType(newType);
            this.firePropertyChanged("type");
        }
    }

    @Override
    public TypeDescription getType() {
        return this.getTypeRef().get();
    }

    public TypeRef getTypeRef() {
        return this.getResultArgument().getTypeRef();
    }

    public void setValidValues(StringList validValues) {
        this.validValues = validValues;
    }

    public StringList getValidValues() {
        return this.validValues;
    }

    public void setValidValuesMethod(String method) {
        this.setProperty(VALID_VALUES_METHOD, method);
    }

    public String getValidValuesMethod() {
        return this.getProperty(VALID_VALUES_METHOD);
    }

    public void setVirtual(boolean virtual) {
        boolean wasVirtual = this.isVirtual();
        if (virtual) {
            this.setModifiers(this.getModifiers() | 0x20000000000L);
        } else {
            this.setModifiers(this.getModifiers() & 0xFFFFFDFFFFFFFFFFL);
        }
        if (wasVirtual != virtual) {
            this.firePropertyChanged(VIRTUAL_PROPERTY);
        }
        this.fireTypeChanged();
    }

    public boolean isVirtual() {
        return Modifier.isVirtual(this.getModifiers());
    }

    public void setWriteCode(SourceCode code) {
        SourceCode prev = this.writeCode;
        this.writeCode = code;
        if (!Any.equals(code, prev)) {
            this.firePropertyChanged("hasSetter");
        }
    }

    public void setWriteCode(String code, String language) {
        this.setWriteCode(code != null ? code.toCharArray() : null, language);
    }

    public void setWriteCode(char[] code, String language) {
        assert (language != null) : "Null language";
        if (code == null) {
            this.writeCode = null;
        } else if (this.writeCode == null) {
            this.writeCode = SourceCode.create(code, language);
        } else {
            this.writeCode.setText(code);
            this.writeCode.setOffset(0);
            this.writeCode.setLength(code.length);
            this.writeCode.setLanguage(language);
        }
    }

    public SourceCode getWriteCode() {
        return this.writeCode;
    }

    public void setWriteSignature(String signature) {
        if (!this.belongsToFuegoObject()) {
            this.writeSignature = signature;
        }
    }

    public String getWriteSignature() {
        if (this.belongsToFuegoObject()) {
            return this.getJavaWriteSignature();
        }
        return this.writeSignature;
    }

    public String getWriteSuffix() {
        TypeDescription parent = this.getParent();
        String suffix = "";
        if (parent != null) {
            String name = this.getName();
            String setter = JavaClass.nameForSetter(name);
            int count = 1;
            while (this.causesConflict(setter, count)) {
                ++count;
            }
            if (count != 1) {
                suffix = String.valueOf(count);
            }
        }
        return suffix;
    }

    public Collection<Variable> getWriteVariables() {
        if (this.writeVariables == null) {
            this.writeVariables = SortedStringMap.create();
        }
        return this.writeVariables.values();
    }

    public void addWriteVariable(Variable variable) {
        if (this.writeVariables == null) {
            this.writeVariables = SortedStringMap.create();
        }
        this.writeVariables.put(variable.getName(), variable);
    }

    public void changePosition(int position) {
        ObjectTypeDescription type;
        AttributeTypeDescription attr;
        TypeDescription parent = this.getParent();
        int currentPosition = this.getPosition();
        if (parent != null && position != -1 && (attr = (type = parent.asObject()).findAttributeByPosition(position)) != null) {
            attr.setPosition(currentPosition);
        }
        this.setPosition(position);
    }

    @Override
    public AttributeTypeDescription clone() {
        AttributeTypeDescription result = (AttributeTypeDescription)super.clone();
        result.writeCode = SourceCode.copy(this.writeCode);
        result.validValues = this.validValues == null ? null : this.validValues.clone();
        result.position = -1;
        return result;
    }

    @Override
    public void copyModifiableAttributesFrom(MethodTypeDescription m) {
        super.copyModifiableAttributesFrom(m);
        if (Modifier.isConfigurable(m.getModifiers())) {
            this.setModifiers(this.getModifiers() | 0x400000L);
        }
        if (m.isAttribute()) {
            this.setDefaultValue(m.asAttribute().getDefaultValue());
        }
    }

    public Variable findWriteVariable(String name) {
        Variable result = null;
        for (Variable var : this.getWriteVariables()) {
            if (!name.equals(var.getName())) continue;
            result = var;
            break;
        }
        return result;
    }

    public void makeConst() {
        long modifiers = this.getModifiers();
        this.setModifiers((modifiers &= 0xFFFFFFFFFFFFFFFAL) | 0x20L);
    }

    public void makeReadOnly() {
        long modifiers = this.getModifiers();
        this.setModifiers((modifiers &= 0xFFFFFFFFFFFFFFF0L) | 8L);
    }

    public void makeReadWrite() {
        this.setModifiers(this.getModifiers() | 8L | 4L);
    }

    public void makeWriteOnly() {
        long modifiers = this.getModifiers();
        this.setModifiers((modifiers &= 0xFFFFFFFFFFFFFFF0L) | 4L);
    }

    public void removeAllWriteVariables() {
        if (this.writeVariables != null) {
            this.writeVariables.clear();
        }
    }

    public boolean hasValidValues() {
        boolean result;
        boolean bl = result = this.validValues != null && !this.validValues.isEmpty();
        if (!result) {
            String validValuesMethod = this.getValidValuesMethod();
            result = !Str.isEmpty(validValuesMethod);
        }
        return result;
    }

    public void setHasSetter(boolean hasSetter) {
        boolean prevValue = this.hasSetter();
        if (hasSetter) {
            this.addModifiers(4L);
        } else {
            this.clearModifier(4L);
        }
        if (prevValue != hasSetter) {
            this.firePropertyChanged("hasSetter");
        }
    }

    public void setHasGetter(boolean hasGetter) {
        boolean prevValue = this.hasGetter();
        if (hasGetter) {
            this.addModifiers(8L);
        } else {
            this.clearModifier(8L);
        }
        if (prevValue != hasGetter) {
            this.firePropertyChanged("hasGetter");
        }
    }

    private void onTypeChanged(TypeRef oldType, TypeRef newType) {
        if (newType instanceof DynamicRef || oldType instanceof DynamicRef || oldType.getKind() != newType.getKind()) {
            this.validValues = null;
            this.defaultValue = null;
        }
    }

    private boolean causesConflict(String setter, int count) {
        MethodTypeDescription member = this.getParent().findMethod(setter + (count == 1 ? "" : String.valueOf(count)));
        return member != null && !member.getParent().isInterface();
    }
}

