/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;
import oracle.bpm.connector.impl.BaseJDBCConnector;
import oracle.bpm.jdbc.FaultTolerantConnection;
import oracle.bpm.log.Log;
import oracle.bpm.pool.Cache;

public class XAConnectionProxy
extends FaultTolerantConnection
implements XAConnection,
Connection,
ConnectionEventListener {
    private BaseJDBCConnector jdbcConnector;
    private Connection physicalConnection;
    private XAConnection xaconnection;
    private XADataSource xaDataSource;

    private XAConnectionProxy(BaseJDBCConnector jdbcConnector, Properties statementCacheProperties, XADataSource xaDataSource, Cache pool, Properties authenticationProperties) throws SQLException {
        super(jdbcConnector, statementCacheProperties, false, false, pool, authenticationProperties);
        if (xaDataSource == null) {
            throw new NullPointerException("XADataSource");
        }
        this.physicalConnection = null;
        this.jdbcConnector = jdbcConnector;
        this.xaDataSource = xaDataSource;
        this.xaconnection = this.createXAConnection();
    }

    public static XAConnectionProxy create(BaseJDBCConnector jdbcConnector, Properties statementCacheProperties, XADataSource xaDataSource, Cache pool, Properties authenticationProperties) throws SQLException {
        return new XAConnectionProxy(jdbcConnector, statementCacheProperties, xaDataSource, pool, authenticationProperties);
    }

    public static XAConnectionProxy create(BaseJDBCConnector jdbcConnector, XADataSource xaDataSource, Cache pool, Properties authenticationProperties) throws SQLException {
        return new XAConnectionProxy(jdbcConnector, null, xaDataSource, pool, authenticationProperties);
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.physicalConnection == null) {
            this.physicalConnection = this.createConnection();
        }
        return this.physicalConnection;
    }

    public XADataSource getXADataSource() {
        return this.xaDataSource;
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        return this.getXAconnection().getXAResource();
    }

    public XAConnection getXAconnection() throws SQLException {
        if (this.xaconnection == null) {
            throw new SQLException("The xaconnection is null");
        }
        return this.xaconnection;
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        try {
            this.getXAconnection().addConnectionEventListener(listener);
        }
        catch (SQLException e) {
            Log.logSevere(e);
        }
    }

    @Override
    public void close() throws SQLException {
        this.getXAconnection().close();
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        this.deregisterListeners((PooledConnection)event.getSource());
        try {
            this.xaconnection = this.createXAConnection();
        }
        catch (SQLException e) {
            this.xaconnection = null;
            Log.logSevere(e);
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        this.deregisterListeners((PooledConnection)event.getSource());
        try {
            this.xaconnection = this.createXAConnection();
        }
        catch (SQLException e) {
            this.xaconnection = null;
            Log.logSevere(e);
        }
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        try {
            this.getXAconnection().removeConnectionEventListener(listener);
        }
        catch (SQLException e) {
            Log.logSevere(e);
        }
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        try {
            this.getXAconnection().addStatementEventListener(listener);
        }
        catch (SQLException e) {
            Log.logSevere(e);
        }
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        try {
            this.getXAconnection().removeStatementEventListener(listener);
        }
        catch (SQLException e) {
            Log.logSevere(e);
        }
    }

    @Override
    protected Connection createConnection() throws SQLException {
        Connection connection = this.getXAconnection().getConnection();
        this.jdbcConnector.onConnected(connection, false);
        return connection;
    }

    private XAConnection createXAConnection() throws SQLException {
        String password;
        String user;
        if (this.xaconnection != null) {
            this.deregisterListeners(this.xaconnection);
        }
        if (this.getAuthenticationProperties() != null) {
            user = this.getAuthenticationProperties().getProperty("user");
            password = this.getAuthenticationProperties().getProperty("password");
        } else {
            user = this.jdbcConnector.getConnectionProperties().getProperty("user");
            password = this.jdbcConnector.getConnectionProperties().getProperty("password");
        }
        XAConnection xaconn = this.getXADataSource().getXAConnection(user, password);
        this.registerListeners(xaconn);
        return xaconn;
    }

    private void deregisterListeners(PooledConnection conn) {
        conn.removeConnectionEventListener(this);
        conn.removeConnectionEventListener(this.jdbcConnector);
    }

    private void registerListeners(PooledConnection conn) {
        conn.addConnectionEventListener(this);
        conn.addConnectionEventListener(this.jdbcConnector);
    }
}

