/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TreeMap;
import oracle.bpm.connector.impl.StatementHolder;
import oracle.bpm.jdbc.FaultTolerantConnection;
import oracle.bpm.jdbc.FaultTolerantResultSet;
import oracle.bpm.jdbc.FaultTolerantStatement;
import oracle.bpm.jdbc.PoolableStatement;

public class FaultTolerantPreparedStatement
extends FaultTolerantStatement
implements PreparedStatement,
PoolableStatement {
    private boolean notInCache = false;
    private TreeMap<Integer, Object> parameters = null;
    private PreparedStatement preparedStatement;
    private String sql;

    public FaultTolerantPreparedStatement(PreparedStatement preparedStatement, String sql, FaultTolerantConnection ftconnection) {
        super(preparedStatement, ftconnection);
        this.sql = sql;
        this.preparedStatement = preparedStatement;
        this.parameters = new TreeMap();
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        try {
            this.getPreparedStatement().setArray(i, x);
            this.setParameter(i, x);
        }
        catch (SQLException ex) {
            this.handleExceptions(ex, 1);
            throw ex;
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            this.getPreparedStatement().setAsciiStream(parameterIndex, x, length);
            this.setParameter(parameterIndex, x);
            this.getFaultTolerantConnection().setDirty();
        }
        catch (SQLException e) {
            this.handleExceptions(e, 1);
            throw e;
        }
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        try {
            this.getPreparedStatement().setBigDecimal(parameterIndex, x);
            this.setParameter(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleExceptions(e, 1);
            throw e;
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.getFaultTolerantConnection().setDirty();
        try {
            if (this.getFaultTolerantConnection().getJDBCConnector().supports(256L)) {
                this.getPreparedStatement().setBinaryStream(parameterIndex, x, length);
            } else if (this.getFaultTolerantConnection().getJDBCConnector().supports(128L)) {
                byte[] buf = new byte[length];
                try {
                    int read;
                    for (int pos = 0; pos < length; pos += read) {
                        read = x.read(buf, pos, length - pos);
                    }
                }
                catch (IOException e) {
                    throw new SQLException(e.getMessage());
                }
                this.getPreparedStatement().setBytes(parameterIndex, buf);
            } else {
                throw new UnsupportedOperationException("setBinaryStream");
            }
            this.setParameter(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleExceptions(e, 1);
            throw e;
        }
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        try {
            this.getPreparedStatement().setBlob(i, x);
            this.setParameter(i, x);
        }
        catch (SQLException e) {
            this.handleExceptions(e, 1);
            throw e;
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        try {
            this.getPreparedStatement().setBoolean(parameterIndex, x);
            this.setParameter(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleExceptions(e, 1);
            throw e;
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        try {
            this.getPreparedStatement().setByte(parameterIndex, x);
            this.setParameter(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleExceptions(e, 1);
            throw e;
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        try {
            if (this.getFaultTolerantConnection().getJDBCConnector().supports(128L)) {
                this.getPreparedStatement().setBytes(parameterIndex, x);
            } else if (this.getFaultTolerantConnection().getJDBCConnector().supports(256L)) {
                ByteArrayInputStream bais = new ByteArrayInputStream(x);
                this.getPreparedStatement().setBinaryStream(parameterIndex, (InputStream)bais, x.length);
            } else {
                throw new UnsupportedOperationException("setBytes");
            }
            this.setParameter(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleExceptions(e, 1);
            throw e;
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        try {
            if (!this.getFaultTolerantConnection().getJDBCConnector().supports(0x1000000L)) {
                this.getPreparedStatement().setCharacterStream(parameterIndex, reader, length);
            } else {
                this.getPreparedStatement().setObject(parameterIndex, (Object)reader, this.getDatabaseManager().getNCLOB_SQLType());
            }
            this.setParameter(parameterIndex, reader);
            this.getFaultTolerantConnection().setDirty();
        }
        catch (SQLException e) {
            this.handleExceptions(e, 1);
            throw e;
        }
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        try {
            this.getPreparedStatement().setClob(i, x);
            this.setParameter(i, x);
        }
        catch (SQLException e) {
            this.handleExceptions(e, 1);
            throw e;
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        try {
            this.getPreparedStatement().setDate(parameterIndex, x);
            this.setParameter(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleExceptions(e, 1);
            throw e;
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        try {
            this.getPreparedStatement().setDate(parameterIndex, x, cal);
            this.setParameter(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleExceptions(e, 1);
            throw e;
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        try {
            this.getPreparedStatement().setDouble(parameterIndex, x);
            this.setParameter(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleExceptions(e, 1);
            throw e;
        }
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        try {
            this.getPreparedStatement().setFloat(parameterIndex, x);
            this.setParameter(parameterIndex, Float.valueOf(x));
        }
        catch (SQLException e) {
            this.handleExceptions(e, 1);
            throw e;
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        try {
            this.getPreparedStatement().setInt(parameterIndex, x);
            this.setParameter(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleExceptions(e, 1);
            throw e;
        }
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        try {
            this.getPreparedStatement().setLong(parameterIndex, x);
            this.setParameter(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleExceptions(e, 1);
            throw e;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.getPreparedStatement().getMetaData();
    }

    @Override
    public void setNotCacheable(boolean notInCache) {
        this.notInCache = notInCache;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        try {
            if (sqlType == -4 && this.getFaultTolerantConnection().getJDBCConnector().supports(65536L)) {
                this.getPreparedStatement().setNull(parameterIndex, 2004);
            } else {
                this.getPreparedStatement().setNull(parameterIndex, sqlType);
            }
            this.setParameter(parameterIndex, "null");
        }
        catch (SQLException e) {
            this.handleExceptions(e, 1);
            throw e;
        }
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        try {
            if (sqlType == -4 && this.getFaultTolerantConnection().getJDBCConnector().supports(65536L)) {
                this.getPreparedStatement().setNull(paramIndex, 2004, typeName);
            } else {
                this.getPreparedStatement().setNull(paramIndex, sqlType, typeName);
            }
            this.setParameter(paramIndex, "null");
        }
        catch (SQLException e) {
            this.handleExceptions(e, 1);
            throw e;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        try {
            this.getPreparedStatement().setObject(parameterIndex, x);
            this.setParameter(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleExceptions(e, 1);
            throw e;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        try {
            this.getPreparedStatement().setObject(parameterIndex, x, targetSqlType);
            this.setParameter(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleExceptions(e, 1);
            throw e;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        try {
            this.getPreparedStatement().setObject(parameterIndex, x, targetSqlType, scale);
            this.setParameter(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleExceptions(e, 1);
            throw e;
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.getPreparedStatement().getParameterMetaData();
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        try {
            this.getPreparedStatement().setRef(i, x);
            this.setParameter(i, x);
        }
        catch (SQLException e) {
            this.handleExceptions(e, 1);
            throw e;
        }
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        try {
            this.getPreparedStatement().setShort(parameterIndex, x);
            this.setParameter(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleExceptions(e, 1);
            throw e;
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        try {
            if (!this.getFaultTolerantConnection().getJDBCConnector().supports(0x1000000L)) {
                this.getPreparedStatement().setString(parameterIndex, x);
            } else {
                this.getPreparedStatement().setObject(parameterIndex, (Object)x, this.getDatabaseManager().getNVARCHAR_SQLType());
            }
            this.setParameter(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleExceptions(e, 1);
            throw e;
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        try {
            this.getPreparedStatement().setTime(parameterIndex, x);
            this.setParameter(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleExceptions(e, 1);
            throw e;
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        try {
            this.getPreparedStatement().setTime(parameterIndex, x, cal);
            this.setParameter(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleExceptions(e, 1);
            throw e;
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        try {
            this.getPreparedStatement().setTimestamp(parameterIndex, x);
            this.setParameter(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleExceptions(e, 1);
            throw e;
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        try {
            this.getPreparedStatement().setTimestamp(parameterIndex, x, cal);
            this.setParameter(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleExceptions(e, 1);
            throw e;
        }
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        try {
            this.getPreparedStatement().setURL(parameterIndex, x);
            this.setParameter(parameterIndex, x);
        }
        catch (SQLException e) {
            this.handleExceptions(e, 1);
            throw e;
        }
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("deprecated");
    }

    @Override
    public void addBatch() throws SQLException {
        this.getPreparedStatement().addBatch();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.getPreparedStatement().clearParameters();
        this.parameters.clear();
    }

    @Override
    public void close() throws SQLException {
        if (this.statement != null) {
            if (!this.getFaultTolerantConnection().isCachingStatements()) {
                try {
                    this.statement.close();
                }
                catch (SQLException ignore) {}
            } else if (this.notInCache) {
                try {
                    this.statement.close();
                }
                catch (SQLException sQLException) {}
            } else {
                this.getFaultTolerantConnection().getPreparedStatementCache().unlock(this.sql);
            }
        }
    }

    @Override
    public void close(Object sender) throws SQLException {
        if (this.getFaultTolerantConnection().getPreparedStatementCache() == sender && this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean execute() throws SQLException {
        SQLException originalException = null;
        this.setQueryTimeout();
        for (int i = 0; i < FaultTolerantPreparedStatement.getRetryTimes(); ++i) {
            try {
                boolean result = this.getPreparedStatement().execute();
                this.getFaultTolerantConnection().setDirty();
                StatementHolder.getInstance().statementExecuted(this.sql);
                return result;
            }
            catch (SQLException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        SQLException originalException = null;
        this.setQueryTimeout();
        for (int i = 0; i < FaultTolerantPreparedStatement.getRetryTimes(); ++i) {
            try {
                FaultTolerantResultSet result = new FaultTolerantResultSet(this, this.getPreparedStatement().executeQuery());
                this.getFaultTolerantConnection().setDirty();
                StatementHolder.getInstance().statementExecuted(this.sql);
                return result;
            }
            catch (SQLException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public int executeUpdate() throws SQLException {
        SQLException originalException = null;
        this.setQueryTimeout();
        for (int i = 0; i < FaultTolerantPreparedStatement.getRetryTimes(); ++i) {
            try {
                int result = this.getPreparedStatement().executeUpdate();
                this.getFaultTolerantConnection().setDirty();
                StatementHolder.getInstance().statementExecuted(this.sql);
                return result;
            }
            catch (SQLException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    public String toString() {
        int lastIndex;
        String sqlString = this.sql;
        StringBuffer result = new StringBuffer();
        int paramNum = 0;
        while ((lastIndex = sqlString.indexOf(63)) != -1) {
            result.append(sqlString.substring(0, lastIndex));
            int i = ++paramNum;
            Object value = this.parameters.get(i);
            if (value != null) {
                result.append(value);
            } else {
                result.append('?');
            }
            sqlString = sqlString.substring(lastIndex + 1);
        }
        result.append(sqlString);
        return result.toString();
    }

    public PreparedStatement getPreparedStatement() throws SQLException {
        return this.preparedStatement;
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.preparedStatement.setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.preparedStatement.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int paramenterIndex, InputStream x) throws SQLException {
        this.preparedStatement.setBinaryStream(paramenterIndex, x);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.preparedStatement.setRowId(parameterIndex, x);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.preparedStatement.setNString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.preparedStatement.setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.preparedStatement.setNClob(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.preparedStatement.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.preparedStatement.setBlob(parameterIndex, inputStream, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.preparedStatement.setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.preparedStatement.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.preparedStatement.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.preparedStatement.setAsciiStream(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.preparedStatement.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.preparedStatement.setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.preparedStatement.setNClob(parameterIndex, reader);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.preparedStatement.setBlob(parameterIndex, inputStream);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.preparedStatement.setNClob(parameterIndex, reader);
    }

    protected void setParameter(int index, Object value) {
        this.parameters.put(index, value);
    }

    @Override
    protected void recreateConnection(int attempt) throws SQLException {
        this.getFaultTolerantConnection().recreateConnection(attempt);
        this.preparedStatement = this.getFaultTolerantConnection().getConnection().prepareStatement(this.sql);
    }
}

