/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.bpm.components.MailAttachment;
import oracle.bpm.lang.Literals;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.Time;
import oracle.bpm.log.Log;

public class SMTPClient {
    private static String dataSourceName;
    public static final String DEFAULT_CONTENT_TYPE = "text/plain";
    public static final String CONTENT_TYPE_TEXT_PLAIN = "text/plain";
    private static final String PROTOCOL = "smtp";

    public static void setDataSource(String dataSource) {
        dataSourceName = dataSource;
    }

    public static void main(String[] args) {
        if (args.length < 5) {
            System.out.println("Usage: 5 parameters are required:");
            System.out.println("\tMailLogin <\"smtp server\"> <\"sender\"> <\"to\"> <\"subject\"> <\"message\">");
            System.exit(-1);
        }
        System.out.println("smtp server:" + args[0]);
        System.out.println("\tto:" + args[1]);
        System.out.println("\tfrom:" + args[2]);
        System.out.println("\tsubject:" + args[3]);
        System.out.println("\tmessage:" + args[4]);
        String[] to = new String[]{args[1]};
        try {
            SMTPClient.sendMail(args[0], args[1], to, args[3], args[4]);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    public static void sendMail(String mailServer, String sender, String[] to, String subject, String message) throws UnknownHostException, IOException {
        SMTPClient.sendMail(mailServer, sender, to, null, null, subject, message, "text/plain", null);
    }

    public static void sendMail(String mailServer, String sender, String[] to, String[] cc, String[] bcc, String subject, String message) throws UnknownHostException, IOException {
        SMTPClient.sendMail(mailServer, sender, to, cc, bcc, subject, message, "text/plain", null);
    }

    public static void sendMail(String mailServer, String sender, String[] to, String subject, String message, String contentType) throws UnknownHostException, IOException {
        SMTPClient.sendMail(mailServer, sender, to, null, null, subject, message, contentType, null);
    }

    public static void sendMail(String mailServer, String sender, String[] to, String subject, String message, String contentType, MailAttachment[] att) throws UnknownHostException, IOException {
        SMTPClient.sendMail(mailServer, sender, to, null, null, subject, message, contentType, att);
    }

    public static void sendMail(String mailServer, String sender, String[] to, String[] cc, String[] bcc, String subject, String message, String contentType) throws UnknownHostException, IOException {
        SMTPClient.sendMail(mailServer, sender, to, cc, bcc, subject, message, contentType, null);
    }

    public static void sendMail(String mailServer, String sender, String[] to, String[] cc, String[] bcc, String subject, String message, String contentType, MailAttachment[] att) throws UnknownHostException, IOException {
        SMTPClient.sendMail(mailServer, sender, to, cc, bcc, subject, message, contentType, att, null, null);
    }

    public static void sendMail(String mailServer, String sender, String[] to, String[] cc, String[] bcc, String subject, String message, String contentType, MailAttachment[] att, Map embeddedBodyParts) throws UnknownHostException, IOException {
        SMTPClient.sendMail(mailServer, sender, to, cc, bcc, subject, message, contentType, att, embeddedBodyParts, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMail(String mailServer, String sender, String[] to, String[] cc, String[] bcc, String subject, String message, String contentType, MailAttachment[] att, Map embeddedBodyParts, Map headers) throws UnknownHostException, IOException {
        block31: {
            String smtpHost;
            String user = null;
            String password = null;
            try {
                int indUser = mailServer.indexOf(64);
                int indPwd = mailServer.lastIndexOf(58);
                int indPwdNewFormat = mailServer.lastIndexOf(58, indUser);
                if (indUser != -1) {
                    if (indPwd == -1) {
                        throw new IOException("SMTP User specified, but password is void");
                    }
                    if (indPwdNewFormat == -1) {
                        user = mailServer.substring(0, indUser);
                        password = mailServer.substring(indPwd + 1);
                        smtpHost = mailServer.substring(indUser + 1, indPwd);
                    } else {
                        user = mailServer.substring(0, indPwdNewFormat);
                        password = mailServer.substring(indPwdNewFormat + 1, indUser);
                        smtpHost = mailServer.substring(indUser + 1);
                    }
                } else {
                    if (indPwd != -1) {
                        throw new IOException("SMTP Password specified, but user is void");
                    }
                    smtpHost = mailServer;
                }
            }
            catch (NullPointerException e) {
                throw new IOException("No host specified");
            }
            if (!(to != null && to.length != 0 || cc != null && cc.length != 0 || bcc != null && bcc.length != 0)) {
                throw new IOException("No recipients specified");
            }
            Session session = SMTPClient.getSession(smtpHost, sender, user);
            try {
                int i;
                String toList = "";
                MimeMessage msg = new MimeMessage(session);
                if (to != null) {
                    for (int i2 = 0; i2 < to.length; ++i2) {
                        toList = toList + to[i2] + ",";
                    }
                    msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)toList, (boolean)false));
                }
                if (cc != null) {
                    String ccList = "";
                    for (i = 0; i < cc.length; ++i) {
                        ccList = ccList + cc[i] + ",";
                    }
                    msg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)ccList, (boolean)false));
                }
                if (bcc != null) {
                    String bccList = "";
                    for (i = 0; i < bcc.length; ++i) {
                        bccList = bccList + bcc[i] + ",";
                    }
                    msg.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)bccList, (boolean)false));
                }
                msg.setFrom((Address)new InternetAddress(sender));
                String charset = SMTPClient.getCharset(contentType);
                msg.setSubject(MimeUtility.encodeText((String)subject, (String)charset, null));
                boolean hasEmbeddedPart = embeddedBodyParts != null && embeddedBodyParts.size() > 0;
                boolean hasAttachment = att != null && att.length > 0;
                boolean isTextPlain = SMTPClient.isTextPlain(contentType);
                if (hasEmbeddedPart || hasAttachment || !isTextPlain) {
                    MimeBodyPart mbp = new MimeBodyPart();
                    mbp.setContent((Object)message, contentType);
                    MimeMultipart mm = hasEmbeddedPart ? new MimeMultipart("related") : new MimeMultipart();
                    mm.addBodyPart((BodyPart)mbp);
                    if (hasEmbeddedPart) {
                        for (String bodyPartId : embeddedBodyParts.keySet()) {
                            DataHandler dataHandler = (DataHandler)embeddedBodyParts.get(bodyPartId);
                            mbp = new MimeBodyPart();
                            mbp.setDataHandler(dataHandler);
                            mbp.setHeader("Content-ID", bodyPartId);
                            mbp.setFileName("\"" + dataHandler.getName() + "\"");
                            mbp.setDisposition("inline");
                            mm.addBodyPart((BodyPart)mbp);
                        }
                    }
                    if (att != null && att.length > 0) {
                        for (int i3 = 0; i3 < att.length; ++i3) {
                            if (att[i3] == null) continue;
                            mm.addBodyPart(att[i3].getMimeBodyPart());
                        }
                    }
                    msg.setContent((Multipart)mm);
                } else {
                    msg.setContent((Object)message, contentType);
                }
                msg.setSentDate(Time.now().dateValue());
                if (headers != null) {
                    for (String key : headers.keySet()) {
                        msg.addHeader(key, (String)headers.get(key));
                    }
                }
                if (user != null) {
                    Transport transport = session.getTransport(PROTOCOL);
                    if (Log.isDebugging()) {
                        Log.logDebug("Sending mail to host (" + smtpHost + "), using user :" + user);
                    }
                    try {
                        transport.connect(smtpHost, user, password);
                        Address[] ad = msg.getAllRecipients();
                        transport.sendMessage((Message)msg, ad);
                        break block31;
                    }
                    finally {
                        transport.close();
                    }
                }
                Transport.send((Message)msg);
            }
            catch (AddressException aex) {
                throw (IOException)new IOException(aex.getMessage()).initCause(aex);
            }
            catch (MessagingException mex) {
                throw (IOException)new IOException(mex.getMessage()).initCause(mex);
            }
        }
    }

    private static String getCharset(String contentType) {
        String charset;
        try {
            ContentType c = new ContentType(contentType);
            charset = c.getParameter("charset");
            if (Str.isEmpty(charset)) {
                charset = Literals.DEFAULT_ENCODING;
            }
        }
        catch (ParseException e) {
            charset = Literals.DEFAULT_ENCODING;
        }
        return charset;
    }

    private static boolean isTextPlain(String contentType) {
        return contentType.toLowerCase().contains("text/plain");
    }

    private static Session getSession(String smtpHost, String sender, String user) throws IOException {
        Session session;
        if (dataSourceName == null || dataSourceName.trim().equals("")) {
            Properties prop = new Properties();
            if (smtpHost == null || smtpHost.length() == 0) {
                throw new IOException("No host specified");
            }
            if (sender == null || sender.length() == 0) {
                throw new IOException("No sender specified");
            }
            prop.put("mail.smtp.host", smtpHost);
            prop.put("mail.from", sender);
            if (user != null) {
                prop.put("mail.smtp.auth", "true");
            }
            session = Session.getInstance((Properties)prop, null);
        } else {
            try {
                InitialContext ctx = new InitialContext();
                session = (Session)ctx.lookup(dataSourceName);
            }
            catch (NamingException e) {
                throw (IOException)new IOException("Unable to get mail session '" + dataSourceName + "'").initCause(e);
            }
        }
        return session;
    }
}

