/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io;

import java.io.IOException;
import java.io.InputStream;
import oracle.bpm.io.InputStreamTransport;

public class RemoteInputStream
extends InputStream {
    protected byte[] buf = null;
    protected int pos = 0;
    protected InputStreamTransport remoteStream = null;

    public RemoteInputStream(InputStreamTransport client) {
        this.remoteStream = client;
    }

    public int avaliable() throws IOException {
        return this.buf.length - this.pos;
    }

    @Override
    public void close() throws IOException {
        this.remoteStream.close();
        this.remoteStream = null;
    }

    @Override
    public int read() throws IOException {
        if (this.buf == null || this.pos >= this.buf.length) {
            this.buf = this.remoteStream.read();
            if (this.buf == null) {
                // empty if block
            }
            this.pos = 0;
        }
        if (this.buf != null) {
            return this.buf[this.pos++];
        }
        return -1;
    }

    protected void finalize() throws Exception {
        if (this.remoteStream != null) {
            this.close();
        }
    }
}

