/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.PrimitiveTypeUtils;
import oracle.bpm.util.StackTrace;

public class ObjectSerialization {
    private static int PERSISTENT_VERSION = 0;
    private static final String PERSISTENT_FIELD_SEPARATOR = "$";
    public static final String SERIAL_PERSISTENT_FIELDS = "serialPersistentFields";
    public static final String OBJECTSTREAMFIELD_CLASSNAME = "java.io.ObjectStreamField";
    public static final String UNSET_FIELDS = "existingUnsetFields";
    public static final String TRANSIENT_SET_FIELDS = "transientSetFields";
    public static final String DEBUG_CREATION_STACK = "creationStack";

    public static Set getMigratedFields(Object object) {
        Set transientSetFields = null;
        if (object != null) {
            try {
                Object projectOrInstance = ObjectSerialization.getInstance(object);
                Field field = projectOrInstance.getClass().getField(TRANSIENT_SET_FIELDS);
                transientSetFields = (Set)field.get(projectOrInstance);
            }
            catch (IllegalAccessException exception) {
                Log.logWarning(exception);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        if (transientSetFields == null) {
            transientSetFields = new TreeSet();
        }
        return transientSetFields;
    }

    public static void setUnmigratedFields(Object object) {
        try {
            Object projectOrInstance = ObjectSerialization.getInstance(object);
            Field field = projectOrInstance.getClass().getField(UNSET_FIELDS);
            Map unsetFields = (Map)field.get(projectOrInstance);
            if (unsetFields != null && !unsetFields.isEmpty()) {
                Method[] methods;
                TreeMap<String, Method> setMethods = new TreeMap<String, Method>();
                for (Method method : methods = projectOrInstance.getClass().getMethods()) {
                    if (!method.getName().startsWith("set")) continue;
                    setMethods.put(method.getName(), method);
                }
                Iterator i$ = unsetFields.entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = i$.next();
                    String fieldName = (String)entry.getKey();
                    String methodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                    Method method = (Method)setMethods.get(methodName);
                    if (method == null || entry.getValue() == null) continue;
                    Object[] args = new Object[]{entry.getValue()};
                    method.invoke(projectOrInstance, args);
                }
                field.setAccessible(true);
                field.set(projectOrInstance, null);
            }
        }
        catch (IllegalAccessException exception) {
            Log.logWarning(exception);
        }
        catch (NoSuchFieldException exception) {
        }
        catch (InvocationTargetException exception) {
            Log.logWarning(exception);
        }
    }

    public static void customWriteObject(Object instance, ObjectOutputStream outputStream) throws IOException {
        try {
            Class<?> aClass = instance.getClass();
            Field serialPersistentField = aClass.getDeclaredField(SERIAL_PERSISTENT_FIELDS);
            serialPersistentField.setAccessible(true);
            ObjectStreamField[] serialPersistentFields = (ObjectStreamField[])serialPersistentField.get(instance);
            assert (serialPersistentFields != null) : "The serialPersistentFields is null";
            if (serialPersistentFields.length > 0) {
                ObjectOutputStream.PutField putField = outputStream.putFields();
                for (ObjectStreamField persistentFieldsValue : serialPersistentFields) {
                    String fieldName = ObjectSerialization.resolveFieldNameFromPersistentName(persistentFieldsValue);
                    Field field = aClass.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    putField.put(persistentFieldsValue.getName(), field.get(instance));
                }
                outputStream.writeFields();
            }
        }
        catch (IllegalAccessException exception) {
            IOException ioException = new IOException(exception.getMessage());
            ioException.initCause(exception);
            throw ioException;
        }
        catch (NoSuchFieldException exception) {
            IOException ioException = new IOException(exception.getMessage());
            ioException.initCause(exception);
            throw ioException;
        }
    }

    public static void customReadObject(Object instance, ObjectInputStream inputStream, boolean debug) throws IOException {
        ObjectSerialization.customReadObject(instance, inputStream, false, debug);
    }

    public static void customReadObject(Object instance, ObjectInputStream inputStream, boolean convertFieldNames, boolean debug) throws IOException {
        try {
            String fieldName;
            ObjectInputStream.GetField fields = inputStream.readFields();
            ObjectStreamClass streamClass = fields.getObjectStreamClass();
            ObjectStreamField[] streamFields = streamClass.getFields();
            TreeMap<String, ObjectStreamField> storedFields = new TreeMap<String, ObjectStreamField>();
            for (ObjectStreamField streamField : streamFields) {
                String fieldName2 = streamField.getName();
                if (fields.defaulted(fieldName2)) continue;
                storedFields.put(fieldName2, streamField);
            }
            Set<String> transientSetFields = ObjectSerialization.findTransientField(instance, storedFields);
            Field[] classFields = instance.getClass().getDeclaredFields();
            TreeMap<String, ObjectStreamField> classToStoredMapping = new TreeMap<String, ObjectStreamField>();
            for (Field classField : classFields) {
                fieldName = classField.getName();
                ObjectStreamField storedField = (ObjectStreamField)storedFields.remove(ObjectSerialization.resolvePersistentFieldName(fieldName));
                if (storedField == null) {
                    storedField = (ObjectStreamField)storedFields.remove(fieldName);
                }
                if (storedField == null) continue;
                classToStoredMapping.put(fieldName, storedField);
            }
            block19: for (Field classField : classFields) {
                fieldName = classField.getName();
                int modifiers = classField.getModifiers();
                ObjectStreamField storedField = (ObjectStreamField)classToStoredMapping.get(fieldName);
                if (storedField == null || Modifier.isStatic(modifiers)) continue;
                Class<?> typeField = classField.getType();
                classField.setAccessible(true);
                char typeCode = PrimitiveTypeUtils.signature(typeField);
                switch (typeCode) {
                    case 'Z': {
                        classField.setBoolean(instance, (Boolean)ObjectSerialization.resolveFieldValue(storedField, fieldName, Boolean.TYPE, fields));
                        continue block19;
                    }
                    case 'I': {
                        classField.setInt(instance, (Integer)ObjectSerialization.resolveFieldValue(storedField, fieldName, Integer.TYPE, fields));
                        continue block19;
                    }
                    case 'C': {
                        classField.setChar(instance, ((Character)ObjectSerialization.resolveFieldValue(storedField, fieldName, Character.TYPE, fields)).charValue());
                        continue block19;
                    }
                    case 'J': {
                        classField.setLong(instance, (Long)ObjectSerialization.resolveFieldValue(storedField, fieldName, Long.TYPE, fields));
                        continue block19;
                    }
                    case 'D': {
                        classField.setDouble(instance, (Double)ObjectSerialization.resolveFieldValue(storedField, fieldName, Double.TYPE, fields));
                        continue block19;
                    }
                    case 'F': {
                        classField.setFloat(instance, ((Float)ObjectSerialization.resolveFieldValue(storedField, fieldName, Float.TYPE, fields)).floatValue());
                        continue block19;
                    }
                    case 'B': {
                        classField.setByte(instance, (Byte)ObjectSerialization.resolveFieldValue(storedField, fieldName, Byte.TYPE, fields));
                        continue block19;
                    }
                    case 'S': {
                        classField.setShort(instance, (Short)ObjectSerialization.resolveFieldValue(storedField, fieldName, Short.TYPE, fields));
                        continue block19;
                    }
                    default: {
                        classField.set(instance, ObjectSerialization.resolveFieldValue(storedField, fieldName, typeField, fields));
                    }
                }
            }
            TreeMap<String, Object> existingUnsetFields = null;
            if (!storedFields.isEmpty()) {
                existingUnsetFields = new TreeMap<String, Object>();
                for (ObjectStreamField storedField : storedFields.values()) {
                    existingUnsetFields.put(storedField.getName(), fields.get(storedField.getName(), null));
                }
            }
            ObjectSerialization.updateInstance(instance, transientSetFields, existingUnsetFields);
        }
        catch (ClassNotFoundException exception) {
            IOException ioException = new IOException(exception.getMessage());
            ioException.initCause(exception);
            throw ioException;
        }
        catch (IllegalAccessException exception) {
            IOException ioException = new IOException(exception.getMessage());
            ioException.initCause(exception);
            throw ioException;
        }
        if (debug) {
            try {
                Field creationStack = instance.getClass().getField(DEBUG_CREATION_STACK);
                creationStack.set(instance, StackTrace.getStackTrace());
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public static Object getInstance(Object object) {
        Object result;
        block10: {
            Method[] methods;
            Class<?> aClass = object.getClass();
            Method projectAccessor = null;
            for (Method method : methods = aClass.getMethods()) {
                String methodName = method.getName();
                String returnType = method.getReturnType().getName();
                if (!methodName.startsWith("get") || !returnType.equals("CurrentProject.Instance") && !returnType.equals("Fuego__AutoGen__Project__.Instance")) continue;
                projectAccessor = method;
                break;
            }
            if (projectAccessor == null) {
                result = object;
            } else {
                try {
                    result = projectAccessor.invoke(object, new Object[0]);
                    if (result == null) {
                        Method delegatedSetter = ObjectSerialization.getCurrentProjectSetter(methods);
                        Class<?> currentProjectClass = projectAccessor.getReturnType();
                        try {
                            result = currentProjectClass.newInstance();
                            delegatedSetter.invoke(object, result);
                        }
                        catch (InstantiationException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (IllegalAccessException e) {
                    result = object;
                    if (Log.isDebugging()) {
                        Log.logDebug(e);
                    }
                }
                catch (InvocationTargetException e) {
                    result = object;
                    if (!Log.isDebugging()) break block10;
                    Log.logDebug(e);
                }
            }
        }
        return result;
    }

    public static String resolvePersistentFieldName(String fieldName) {
        return PERSISTENT_VERSION + PERSISTENT_FIELD_SEPARATOR + fieldName;
    }

    private static String resolveFieldNameFromPersistentName(ObjectStreamField persistentFieldsValue) {
        int separatorPosition = persistentFieldsValue.getName().indexOf(PERSISTENT_FIELD_SEPARATOR);
        String name = persistentFieldsValue.getName();
        if (separatorPosition > 0) {
            name = persistentFieldsValue.getName().substring(separatorPosition + 1);
        }
        return name;
    }

    private static Object resolveFieldValue(ObjectStreamField storedField, String classFieldName, Class expectedType, ObjectInputStream.GetField fields) throws ClassCastException, IOException {
        Object ret;
        char typeCode = storedField.getTypeCode();
        String fieldName = storedField.getName();
        switch (typeCode) {
            case 'B': {
                ret = fields.get(fieldName, (byte)0);
                break;
            }
            case 'C': {
                ret = Character.valueOf(fields.get(fieldName, ' '));
                break;
            }
            case 'D': {
                ret = fields.get(fieldName, 0.0);
                break;
            }
            case 'F': {
                ret = Float.valueOf(fields.get(fieldName, 0.0f));
                break;
            }
            case 'I': {
                ret = fields.get(fieldName, 0);
                break;
            }
            case 'J': {
                ret = fields.get(fieldName, 0L);
                break;
            }
            case 'S': {
                ret = fields.get(fieldName, (short)0);
                break;
            }
            case 'Z': {
                ret = fields.get(fieldName, false);
                break;
            }
            default: {
                ret = fields.get(fieldName, null);
            }
        }
        Class<?> nonPrimitiveExpectedType = PrimitiveTypeUtils.box(expectedType);
        if (ret != null && !nonPrimitiveExpectedType.isInstance(ret)) {
            Msg msg = LibMsg.INVALID_TYPE_FIELD(classFieldName, expectedType.getCanonicalName(), storedField.getTypeString());
            throw new ClassCastException(msg.getString());
        }
        if (expectedType.isPrimitive() && ret == null) {
            ret = expectedType.cast(0);
        }
        return ret;
    }

    private static Set<String> findTransientField(Object instance, Map<String, ObjectStreamField> storedFields) {
        Field[] classFields;
        TreeSet<String> transientSetFields = new TreeSet<String>();
        for (Field classField : classFields = instance.getClass().getDeclaredFields()) {
            String fieldName = classField.getName();
            int modifiers = classField.getModifiers();
            ObjectStreamField storedField = storedFields.get(fieldName);
            if (storedField == null || Modifier.isStatic(modifiers) || !Modifier.isTransient(modifiers)) continue;
            transientSetFields.add(fieldName);
        }
        return transientSetFields;
    }

    private static Method getCurrentProjectSetter(Method[] methods) {
        Method result = null;
        for (Method method : methods) {
            String methodName = method.getName();
            String projectClassName = "CurrentProject.Instance";
            Class<?>[] parameters = method.getParameterTypes();
            if (!methodName.startsWith("set") || parameters.length != 1 || !"CurrentProject.Instance".equals(parameters[0].getName())) continue;
            result = method;
            break;
        }
        return result;
    }

    private static void updateInstance(Object instance, Set<String> transientSetFields, Map<String, Object> existingUnsetFields) {
        block4: {
            Class<?> aClass = instance.getClass();
            try {
                Field unsetField = aClass.getField(UNSET_FIELDS);
                unsetField.set(instance, existingUnsetFields);
                Field setField = aClass.getField(TRANSIENT_SET_FIELDS);
                setField.set(instance, transientSetFields);
            }
            catch (NoSuchFieldException e) {
                if (Log.isDebugging()) {
                    Log.logDebug(e);
                }
            }
            catch (IllegalAccessException e) {
                if (!Log.isDebugging()) break block4;
                Log.logDebug(e);
            }
        }
    }
}

