/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import oracle.bpm.http.HttpMessage;
import oracle.bpm.http.HttpStatus;

public class HttpResponse
extends HttpMessage {
    private ByteArrayOutputStream out;
    private int status = 200;
    private static final byte[] EOL = new byte[]{13, 10};

    public HttpResponse() {
        this.setHeader("Connection", "close");
        this.setHeader("Content-Type", "text/html");
    }

    public void setContentType(String contentType) {
        this.setHeader("Content-Type", contentType);
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public OutputStream getOutput() {
        if (this.out == null) {
            this.out = new ByteArrayOutputStream();
        }
        return this.out;
    }

    public PrintStream getPrintStream() {
        return new PrintStream(this.getOutput(), true);
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public void send(OutputStream out) throws IOException {
        String status = "HTTP/1.0 " + this.status + " " + HttpStatus.getMessage(this.status);
        out.write(status.getBytes("ASCII"));
        out.write(EOL);
        for (Map.Entry header : this.getHeaders().entrySet()) {
            String name = (String)header.getKey();
            String value = (String)header.getValue();
            String attr = name + ": " + value;
            out.write(attr.getBytes());
            out.write(EOL);
        }
        if (this.out == null && this.status != 200) {
            this.getPrintStream().println("<h1>" + status + "</h1>");
        }
        byte[] message = this.out != null ? this.out.toByteArray() : new byte[]{};
        String contentLength = "Content-length: " + message.length;
        out.write(contentLength.getBytes("ASCII"));
        out.write(EOL);
        out.write(EOL);
        out.write(message);
        out.flush();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Headers   : \n" + this.getHeaders() + "\n");
        return buffer.toString();
    }
}

