/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.http;

import java.io.IOException;
import java.net.Socket;
import oracle.bpm.component.Batch;
import oracle.bpm.component.ExecutionThread;
import oracle.bpm.component.ExecutionThreadContext;
import oracle.bpm.component.Message;
import oracle.bpm.component.Principal;
import oracle.bpm.component.Request;
import oracle.bpm.component.Response;
import oracle.bpm.component.Task;
import oracle.bpm.http.HttpCommand;
import oracle.bpm.http.HttpCommandServer;
import oracle.bpm.http.HttpException;
import oracle.bpm.http.HttpRequest;
import oracle.bpm.http.HttpResponse;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.log.Log;

public class HttpExecution
implements Request {
    private HttpCommandServer server;
    private Socket sock;

    public HttpExecution(Socket sock, HttpCommandServer server) {
        this.sock = sock;
        this.server = server;
    }

    @Override
    public Batch getBatch() {
        return new Batch().add(Message.createTask(new Task(){

            @Override
            public Object run() throws IOException, HttpException {
                int timeout = HttpExecution.this.server.getTimeout();
                if (timeout > 0) {
                    HttpExecution.this.sock.setSoTimeout(timeout);
                }
                HttpRequest request = HttpRequest.createFrom(HttpExecution.this.sock.getInputStream());
                HttpCommand command = HttpExecution.this.server.getCommandForPath(request.getPath());
                if (command == null) {
                    throw new HttpException(404, "NOT FOUND (" + request.getPath() + ")");
                }
                HttpResponse response = new HttpResponse();
                command.process(request, response);
                return response;
            }
        }));
    }

    @Override
    public int getGroup() {
        return 2;
    }

    @Override
    public Integer getId() {
        return ExecutionThreadContext.NEW;
    }

    @Override
    public Principal getPrincipal() {
        return new HttpPrincipal();
    }

    @Override
    public Response getResponse() {
        return new Response(){

            @Override
            public void operationTimeout(long timeout) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void put(Batch responses) {
                Message message = responses.get();
                HttpResponse response = null;
                if (message.isReturnValue()) {
                    response = (HttpResponse)message.getValue();
                } else if (message.isException()) {
                    Object value = message.getValue();
                    assert (value instanceof Throwable) : value.getClass();
                    Throwable ex = (Throwable)value;
                    response = new HttpResponse();
                    if (ex instanceof HttpException) {
                        HttpException httpException = (HttpException)ex;
                        if (Log.isDebugging()) {
                            Log.logDebug(ex);
                        }
                        response.setStatus(httpException.getStatus());
                    } else {
                        if (Log.isDebugging()) {
                            Log.logDebug(ex);
                        }
                        response.setStatus(500);
                    }
                } else assert (false) : "Unexpected message: " + message;
                try {
                    if (response != null) {
                        response.send(HttpExecution.this.sock.getOutputStream());
                    }
                }
                catch (IOException e) {
                    Log.logWarning(e);
                }
                finally {
                    try {
                        try {
                            HttpExecution.this.sock.shutdownOutput();
                        }
                        catch (UnsupportedOperationException e) {}
                        HttpExecution.this.sock.close();
                    }
                    catch (IOException e) {
                        Log.logWarning(e);
                    }
                }
            }
        };
    }

    private static class HttpPrincipal
    implements Principal {
        private HttpPrincipal() {
        }

        @Override
        public Object getInfo() {
            return null;
        }

        @Override
        public Invokeable getTarget() {
            return null;
        }

        @Override
        public ExecutionThreadContext createContext() {
            return new ExecutionThreadContext(this, true);
        }

        @Override
        public Batch processBatch(Batch requests) {
            return ExecutionThread.doProcessBatch(this, requests);
        }
    }
}

