/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.http;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.http.HttpRequest;

public class Cookie {
    private Map attrs = new HashMap();
    private Map systemAttrs = new HashMap();
    private static final String QUOTE = "\"";

    public static Cookie parse(HttpRequest request) {
        String cookieHeader = (String)request.getHeaders().get("Cookie");
        if (cookieHeader == null) {
            return null;
        }
        Cookie cookie = new Cookie();
        int lastSemicolon = 0;
        int semicolon = cookieHeader.indexOf(59);
        while (semicolon != -1) {
            String name;
            String pair = cookieHeader.substring(lastSemicolon, semicolon);
            int eq = pair.indexOf(61);
            if (eq != -1) {
                name = pair.substring(0, eq);
                String value = pair.substring(eq + 1);
                if (name.startsWith(QUOTE) && name.endsWith(QUOTE) && name.length() >= 2) {
                    name = name.substring(1, name.length() - 1);
                }
                if (name.startsWith("$")) {
                    name = name.substring(1).toLowerCase();
                    cookie.systemAttrs.put(name, value);
                } else {
                    cookie.attrs.put(name, value);
                }
            } else {
                name = pair;
                if (name.startsWith("$")) {
                    name = name.substring(1);
                    cookie.systemAttrs.put(name, null);
                } else {
                    cookie.attrs.put(name, null);
                }
            }
            lastSemicolon = semicolon;
            if (semicolon != cookieHeader.length()) {
                semicolon = cookieHeader.indexOf(59, semicolon + 1);
                continue;
            }
            semicolon = -1;
        }
        return cookie;
    }

    public void setAttribute(String name, String value) {
        this.getAttributes().put(name, value);
    }

    public String getAttribute(String name) {
        return (String)this.getAttributes().get(name);
    }

    public void setAttributes(Map attributes) {
        this.attrs = attributes;
    }

    public Map getAttributes() {
        return this.attrs;
    }

    public void setComment(String comment) {
        this.systemAttrs.put("Comment", comment);
    }

    public String getComment() {
        return (String)this.systemAttrs.get("Comment");
    }

    public void setDomain(String domain) {
        this.systemAttrs.put("Domain", domain);
    }

    public String getDomain() {
        return (String)this.systemAttrs.get("Domain");
    }

    public void setMaxAge(String maxAge) {
        this.systemAttrs.put("Max-Age", maxAge);
    }

    public String getMaxAge() {
        return (String)this.systemAttrs.get("Max-Age");
    }

    public void setPath(String path) {
        this.systemAttrs.put("Path", path);
    }

    public String getPath() {
        return (String)this.systemAttrs.get("Path");
    }

    public void setVersion(String version) {
        this.systemAttrs.put("Version", version);
    }

    public String getVersion() {
        return (String)this.systemAttrs.get("Version");
    }

    public String getSetCookie() {
        StringBuffer header = new StringBuffer();
        for (Map.Entry pair : this.attrs.entrySet()) {
            header.append(pair.getKey() + "=" + QUOTE + pair.getValue() + QUOTE + ";");
        }
        for (Map.Entry pair : this.attrs.entrySet()) {
            header.append(pair.getKey() + "=" + QUOTE + pair.getValue() + QUOTE + ";");
        }
        return header.toString();
    }
}

