/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.holidays;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Locale;
import oracle.bpm.holidays.HolidayType;
import oracle.bpm.lang.FormatException;
import oracle.bpm.lang.Time;
import oracle.bpm.msg.CoreMsg;

public abstract class Holiday
implements Serializable {
    private String description;
    static final long serialVersionUID = 4071022318134874963L;
    static final long serialCheck = -5521195476736356636L;

    public abstract HolidayType getType();

    public abstract String getDisplayValue(Locale var1);

    public abstract Time getDate();

    public static Holiday valueOf(String holidaySpec) {
        if (holidaySpec == null) {
            throw new InvalidFormatException("(null)");
        }
        int ind = holidaySpec.indexOf(58);
        if (ind == -1) {
            throw new InvalidFormatException(holidaySpec);
        }
        try {
            HolidayType holidayType = HolidayType.valueOf(holidaySpec.substring(0, ind).trim());
            return Holiday.create(holidayType, holidaySpec.substring(ind + 1));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(holidaySpec);
        }
        catch (InvalidFormatException e) {
            throw new InvalidFormatException(holidaySpec);
        }
    }

    public String getDisplayValue() {
        return this.getDisplayValue(Locale.getDefault());
    }

    public final String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public final String toString() {
        return this.getType() + ":" + this.getString() + ":" + this.description;
    }

    public String getEditionString() {
        return this.getBaseString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Holiday) {
            Holiday holiday = (Holiday)o;
            return this.description == null ? holiday.description == null : this.description.equals(holiday.description);
        }
        return false;
    }

    public int hashCode() {
        return this.description == null ? 0 : this.description.hashCode();
    }

    protected abstract String getBaseString();

    protected static int indexOf(String holidaySpec) {
        int ind = holidaySpec.indexOf(32);
        if (ind == -1) {
            throw new InvalidFormatException(holidaySpec);
        }
        return ind;
    }

    protected static boolean matchDayMonth(Calendar cal, int day, int month) {
        return day == cal.get(5) && month == cal.get(2) + 1;
    }

    protected static boolean matchDayMonthYear(Calendar cal, Time time) {
        return time.getDayOfMonth() == cal.get(5) && time.getMonth() - 1 == cal.get(2) && time.getYear() == cal.get(1);
    }

    protected String getString() {
        return this.getBaseString();
    }

    abstract boolean match(Time var1);

    abstract boolean match(Calendar var1);

    private static Holiday create(HolidayType holidayType, String holidaySpec) {
        String description = "";
        int ind = holidaySpec.lastIndexOf(58);
        if (ind != -1) {
            description = holidaySpec.substring(ind + 1);
            holidaySpec = holidaySpec.substring(0, ind).trim();
        }
        Holiday result = holidayType.createItem(holidaySpec);
        result.setDescription(description);
        return result;
    }

    public static class InvalidFormatException
    extends FormatException {
        private String holidaySpec;
        static final long serialVersionUID = 8043383523977543595L;
        static final long serialCheck = 2945570766877682942L;

        public InvalidFormatException(String holidaySpec) {
            super(CoreMsg.INVALID_HOLIDAY(holidaySpec));
            this.holidaySpec = holidaySpec;
        }

        public InvalidFormatException(String holidaySpec, String expectedFormat) {
            super(CoreMsg.INVALID_HOLIDAY(holidaySpec, expectedFormat));
            this.holidaySpec = holidaySpec;
        }

        public String getHolidaySpec() {
            return this.holidaySpec;
        }
    }
}

