/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.data;

import fuego.directory.DirOLAPConfiguration;
import fuego.directory.DirectoryException;
import fuego.directory.DirectorySession;
import fuego.directory.msg.DirectoryMsg;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.data.AnalyzerUpdateFrequency;
import oracle.bpm.data.PresentableProperties;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.lang.Id;
import oracle.bpm.lang.Time;
import oracle.bpm.resources.Msg;
import oracle.bpm.xml.DeserializationException;
import oracle.bpm.xml.Serializer;
import oracle.bpm.xml.XMLDeserializer;
import oracle.bpm.xml.XMLSerializer;
import oracle.bpm.xml.XMLSerializerWriter;

public class AnalyzerProperties
implements PresentableProperties {
    public String bamConfiguration;
    public String bamRuntimeConfiguration;
    public int caducityInHours;
    public String configuration;
    public Time cubesUpdateTime;
    public boolean disableBAMUpdate;
    public int disableDatawarehouse;
    public boolean disableDatawarehouseBoolean;
    public List disabledVariables;
    public int disableUpdate;
    public boolean disableUpdateBoolean;
    public boolean enableO3Service;
    public boolean generateO3Cubes;
    public String language;
    public String logDefaultSeverities;
    public String logDirectory;
    public List measureVariables;
    public String o3ServerHost;
    public int o3ServerPort;
    public boolean runPerformance;
    public boolean runWorkload;
    public Time snapshotTime;
    public int updateFrequency;
    public int updateFrequencyMinutes;
    public Time updateTime;
    public static final String RUNNING_EMBEDDED = "oracle.bpm.analyzer.running_embedded";
    public static final String DATE_FORMAT = "HH:mm";
    public static final int UPDATE_FREQUENCY_ID = 0;
    public static final int DISABLE_UPDATE_ID = 1;
    public static final int DISABLE_DATAWAREHOUSE_ID = 2;
    public static final int UPDATE_TIME_ID = 3;
    public static final int CONFIGURATION_ID = 4;
    public static final int SNAPSHOT_TIME = 5;
    public static final int CUBES_UPDATE_TIME = 6;
    public static final int CADUCITY_TIME = 7;
    public static final int UPDATE_FREQUENCY = 8;
    public static final int O3_SERVER_HOST = 9;
    public static final int O3_SERVER_PORT = 10;
    public static final int DAILY_UPD = 0;
    public static final int HOURLY_UPD = 1;
    public static final int UPDATE_FREQUENCY_DEF = 0;
    public static final int ENABLE_UPDATE = 0;
    public static final int DISABLE_UPDATE = 1;
    public static final int ENABLE_DATAWAREHOUSE = 0;
    public static final int DISABLE_DATAWAREHOUSE = 1;
    public static final String EXTERNAL_VAR_PREFIX = "V_";
    public static final String UPDATE_FREQUENCY_HOURLY = "Hourly";
    public static final String UPDATE_FREQUENCY_DAILY = "Daily";
    public static final String PREFIX_SEPARATOR = "_";
    public static final String WMN_PREFIX = "WMN_";
    public static final String SMN_PREFIX = "SMN_";
    public static final Time DEFAULT_UPDATE_TIME = Time.valueOf(1, 2, 1, 0, 0, 0);
    public static final Time DEFAULT_UPDATE_CUBE_TIME = Time.valueOf(1, 2, 1, 2, 0, 0);

    private AnalyzerProperties() {
        this.setDefaults();
    }

    public static AnalyzerProperties createDefault() {
        return new AnalyzerProperties();
    }

    public static void doExport(AnalyzerProperties properties, Writer writer) {
        XMLSerializerWriter pw = new XMLSerializerWriter(writer, (Serializer)new XMLSerializer());
        pw.write(Id.getXmlProcessingInstructionLine());
        pw.write(Id.getFuegoProcessingInstructionLine());
        pw.write("AnalyzerProperties", DynamicObject.valueOf(properties));
        pw.close();
    }

    public static AnalyzerProperties doImport(InputStream istr) throws DeserializationException {
        XMLDeserializer deserializer = new XMLDeserializer();
        DynamicObject properties = deserializer.parse(istr);
        return properties.convertTo(AnalyzerProperties.class);
    }

    public static AnalyzerProperties doImport(Reader reader) throws DeserializationException {
        XMLDeserializer deserializer = new XMLDeserializer();
        DynamicObject properties = deserializer.parse(reader);
        return properties.convertTo(AnalyzerProperties.class);
    }

    public static AnalyzerProperties doImport(String string) throws DeserializationException {
        StringReader stringReader = new StringReader(string);
        AnalyzerProperties analyzerProperties = AnalyzerProperties.doImport(stringReader);
        StreamUtils.close(stringReader);
        return analyzerProperties;
    }

    public static AnalyzerProperties load(DirectorySession session) throws DirectoryException {
        DirOLAPConfiguration olapconf = DirOLAPConfiguration.fetch(session);
        try {
            String props;
            String string = props = olapconf == null ? null : olapconf.getProperties();
            if (props == null) {
                return null;
            }
            return AnalyzerProperties.doImport(props);
        }
        catch (DeserializationException de) {
            return null;
        }
    }

    public void setBamConfiguration(String bamConfiguration) {
        this.bamConfiguration = bamConfiguration;
    }

    public String getBamConfiguration() {
        return this.bamConfiguration;
    }

    public void setBamRuntimeConfiguration(String bamRuntimeConfiguration) {
        this.bamRuntimeConfiguration = bamRuntimeConfiguration;
    }

    public String getBamRuntimeConfiguration() {
        return this.bamRuntimeConfiguration == null || this.bamRuntimeConfiguration.equals("") ? this.bamConfiguration : this.bamRuntimeConfiguration;
    }

    public void setCaducityInHours(int caducityInHours) {
        this.caducityInHours = caducityInHours;
    }

    public int getCaducityInHours() {
        return this.caducityInHours;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setCubesUpdateTime(Time cubesUpdateTime) {
        this.cubesUpdateTime = cubesUpdateTime;
    }

    public Time getCubesUpdateTime() {
        return this.cubesUpdateTime;
    }

    public void setDisableBAMUpdate(boolean disableBAMUpdate) {
        this.disableBAMUpdate = disableBAMUpdate;
    }

    public boolean getDisableBAMUpdate() {
        return this.disableBAMUpdate;
    }

    public void setDisableDatawarehouse(boolean val) {
        this.disableDatawarehouseBoolean = val;
    }

    public boolean getDisableDatawarehouse() {
        if (this.disableDatawarehouse != -1) {
            this.disableDatawarehouseBoolean = this.disableDatawarehouse == 1;
        }
        return this.disableDatawarehouseBoolean;
    }

    public void setDisableUpdate(boolean val) {
        this.disableUpdateBoolean = val;
    }

    public boolean getDisableUpdate() {
        if (this.disableUpdate != -1) {
            this.disableUpdateBoolean = this.disableUpdate == 1;
        }
        return this.disableUpdateBoolean;
    }

    public void setEnableO3Service(boolean enableO3Service) {
        this.enableO3Service = enableO3Service;
    }

    public boolean isEnableO3Service() {
        return this.enableO3Service;
    }

    public void setGenerateO3Cubes(boolean generateO3Cubes) {
        this.generateO3Cubes = generateO3Cubes;
    }

    public boolean isGenerateO3Cubes() {
        return this.generateO3Cubes;
    }

    @Override
    public Msg getHint(int id) {
        return null;
    }

    @Override
    public int getIncrement(int id) {
        return 1;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLogDirectory(String logDirectory) {
        this.logDirectory = logDirectory;
    }

    public String getLogDirectory() {
        return this.logDirectory;
    }

    @Override
    public int getMax(int id) {
        switch (id) {
            case 10: {
                return 65535;
            }
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMin(int id) {
        switch (id) {
            case 10: {
                return 1025;
            }
            case 7: 
            case 8: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public boolean isModifiableInRuntime(int id) {
        return false;
    }

    @Override
    public Msg getMsg(int id) {
        switch (id) {
            case 2: {
                return DirectoryMsg.DISABLE_DATAWAREHOUSE;
            }
            case 1: {
                return DirectoryMsg.DISABLE_UPDATE;
            }
            case 0: {
                return DirectoryMsg.UPDATE_FREQUENCY;
            }
            case 3: {
                return DirectoryMsg.UPDATE_TIME;
            }
            case 10: {
                return DirectoryMsg.PORT;
            }
            case 7: {
                return DirectoryMsg.REMOVE_OLD_VALUES;
            }
            case 8: {
                return DirectoryMsg.UPDATE_AT_TIME;
            }
            case 5: {
                return DirectoryMsg.SNAPSHOT_TIME;
            }
            case 6: {
                return DirectoryMsg.GENERATE_CUBES_AT_TIME;
            }
        }
        return null;
    }

    public void setO3ServerHost(String o3ServerHost) {
        this.o3ServerHost = o3ServerHost;
    }

    public String getO3ServerHost() {
        return this.o3ServerHost;
    }

    public void setO3ServerPort(int o3ServerPort) {
        this.o3ServerPort = o3ServerPort;
    }

    public int getO3ServerPort() {
        return this.o3ServerPort;
    }

    public void setRunPerformance(boolean runPerformance) {
        this.runPerformance = runPerformance;
    }

    public boolean isRunPerformance() {
        return this.runPerformance;
    }

    public void setRunWorkload(boolean runWorkload) {
        this.runWorkload = runWorkload;
    }

    public boolean isRunWorkload() {
        return this.runWorkload;
    }

    public void setSnapshotTime(Time snapshotTime) {
        this.snapshotTime = snapshotTime;
    }

    public Time getSnapshotTime() {
        return this.snapshotTime;
    }

    public void setUpdateFrequency(int val) {
        this.updateFrequency = val;
    }

    public void setUpdateFrequency(String val) {
        AnalyzerUpdateFrequency updateFrequency = AnalyzerUpdateFrequency.createFromId(val);
        if (updateFrequency == null) {
            this.setUpdateFrequency(-1);
        } else {
            this.setUpdateFrequency(updateFrequency.getUpdateFrequencyValue());
        }
    }

    public int getUpdateFrequencyValue() {
        return this.updateFrequency;
    }

    public void setUpdateTime(Time updateTime) {
        this.updateTime = updateTime;
    }

    public Time getUpdateTime() {
        return this.updateTime;
    }

    @Override
    public StringList getValues(int id) {
        switch (id) {
            case 0: {
                return AnalyzerProperties.valuesUpdateFrequency();
            }
            case 1: 
            case 2: {
                return AnalyzerProperties.valuesDisable();
            }
        }
        return null;
    }

    public void doExport(Writer writer) {
        AnalyzerProperties.doExport(this, writer);
    }

    public String getFullLogDefaultSeverities() {
        return this.getFullLogSeverities(this.logDefaultSeverities);
    }

    public void setLogDefaultSeverities(String logDefaultSeverities) {
        this.logDefaultSeverities = logDefaultSeverities;
    }

    public String getLogDefaultSeverities() {
        return this.logDefaultSeverities;
    }

    public String getUpdateFrequency() {
        return AnalyzerUpdateFrequency.createFromValue(this.updateFrequency).getUpdateFrequencyId();
    }

    public void setUpdateFrequencyMinutes(int updateFrequencyMinutes) {
        this.updateFrequencyMinutes = updateFrequencyMinutes;
    }

    public int getUpdateFrequencyMinutes() {
        return this.updateFrequencyMinutes;
    }

    public void store(DirectorySession session) throws DirectoryException {
        StringWriter sw = new StringWriter();
        this.doExport(sw);
        DirOLAPConfiguration olapconf = DirOLAPConfiguration.fetch(session);
        if (olapconf != null) {
            olapconf.setProperties(sw.toString());
            olapconf.update();
        } else {
            DirOLAPConfiguration.create(session, sw.toString());
        }
        StreamUtils.close(sw);
    }

    @Override
    public Msg validate() {
        if (!this.getDisableUpdate() && (this.configuration == null || "".equals(this.configuration))) {
            return DirectoryMsg.MISSING_DW_CONFIGURATION;
        }
        if (!this.getDisableBAMUpdate() && (this.bamConfiguration == null || "".equals(this.bamConfiguration))) {
            return DirectoryMsg.MISSING_BAM_CONFIGURATION;
        }
        if (!this.getDisableBAMUpdate() && (this.bamRuntimeConfiguration == null || "".equals(this.bamRuntimeConfiguration))) {
            return DirectoryMsg.MISSING_BAM_RUNTIME_CONFIGURATION;
        }
        if (!this.getDisableUpdate() && this.updateTime == null) {
            return DirectoryMsg.MISSING_UPDATE_TIME;
        }
        if (!this.getDisableUpdate() && this.snapshotTime == null) {
            return DirectoryMsg.MISSING_SNAPSHOT_TIME;
        }
        if (!this.getDisableBAMUpdate() && this.cubesUpdateTime == null) {
            return DirectoryMsg.MISSING_CUBES_GENERATE_TIME;
        }
        if (this.isEnableO3Service() && (this.o3ServerHost == null || "".equals(this.o3ServerHost))) {
            return DirectoryMsg.MISSING_O3_SERVER_HOST;
        }
        return null;
    }

    public Msg validate(int fieldId, Object value) {
        switch (fieldId) {
            case 3: 
            case 5: 
            case 6: {
                String strVal = (String)value;
                if (this.validateDate(strVal)) break;
                return DirectoryMsg.INVALID_TIME;
            }
            case 9: {
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                int intVal = (Integer)value;
                int max = this.getMax(fieldId);
                int min = this.getMin(fieldId);
                if (intVal > max) {
                    return DirectoryMsg.HIGHER_THAN_MAXIMUM(max);
                }
                if (intVal >= min) break;
                return DirectoryMsg.LOWER_THAN_MINIMUM(min);
            }
        }
        return null;
    }

    private static StringList valuesDisable() {
        return StringList.create("NO", "YES");
    }

    private static StringList valuesUpdateFrequency() {
        return StringList.create(UPDATE_FREQUENCY_DAILY, UPDATE_FREQUENCY_HOURLY);
    }

    private void setDefaults() {
        this.setUpdateFrequency(0);
        this.setSnapshotTime(DEFAULT_UPDATE_TIME);
        this.setUpdateTime(this.getSnapshotTime());
        this.setCubesUpdateTime(DEFAULT_UPDATE_CUBE_TIME);
        this.setDisableUpdate(true);
        this.setDisableDatawarehouse(false);
        this.setDisableBAMUpdate(true);
        this.setConfiguration("");
        this.setBamConfiguration("");
        this.setBamRuntimeConfiguration("");
        this.setLogDirectory("");
        this.setLogDefaultSeverities("Warning");
        this.setLanguage(Locale.getDefault().getLanguage());
        this.setUpdateFrequencyMinutes(30);
        this.setO3ServerHost("localhost");
        this.setO3ServerPort(8787);
        this.setEnableO3Service(false);
        this.setGenerateO3Cubes(true);
        this.setCaducityInHours(24);
        this.setRunPerformance(true);
        this.setRunWorkload(true);
        this.disableDatawarehouse = -1;
        this.disableUpdate = -1;
    }

    private String getFullLogSeverities(String severities) {
        if (severities.equals("Debug")) {
            return "Trace,Fatal,Severe,Warning,Info,Debug";
        }
        if (severities.equals("Info")) {
            return "Trace,Fatal,Severe,Warning,Info";
        }
        if (severities.equals("Warning")) {
            return "Trace,Fatal,Severe,Warning";
        }
        if (severities.equals("Severe")) {
            return "Trace,Fatal,Severe";
        }
        return "Trace,Fatal";
    }

    private boolean validateDate(String strDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        try {
            dateFormat.parse(strDate);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }
}

