/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector.spi;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import oracle.bpm.configuration.ConfigType;
import oracle.bpm.configuration.Configuration;
import oracle.bpm.connector.ConnectorException;
import oracle.bpm.connector.ConnectorService;
import oracle.bpm.connector.spi.ConnectorInterface;
import oracle.bpm.extension.Extension;
import oracle.bpm.extension.ExtensionService;
import oracle.bpm.extensionpoint.metadata.ConnectorFactoryMetadata;
import oracle.bpm.lang.Platform;
import oracle.bpm.log.Log;

public abstract class ConnectorFactory {
    protected static final long NO_FEATURES = 0L;

    public abstract ConfigType getConfigType();

    public abstract ConnectorInterface createConnector(ConnectorService var1, String var2, Properties var3);

    public static ConnectorFactory getFactory(Configuration entry) throws ConnectorException {
        return ConnectorFactory.getFactory(entry.getConfigType());
    }

    public static ConnectorFactory getFactory(ConfigType configType) throws ConnectorException {
        ConnectorFactory result = null;
        for (ConfigType current = configType; result == null && current != null; current = current.getParent()) {
            result = ConnectorFactory.getFactories().get(current);
        }
        if (result == null) {
            throw ConnectorException.factoryNotFound(configType);
        }
        return result;
    }

    public static Map<ConfigType, ConnectorFactory> getFactories() {
        return FactoriesHolder.VALUE;
    }

    public static void register(ConnectorFactory factory) {
        ConnectorFactory.getFactories().put(factory.getConfigType(), factory);
    }

    private static final class FactoriesHolder {
        static final Map<ConfigType, ConnectorFactory> VALUE;

        private FactoriesHolder() {
        }

        static {
            HashMap<ConfigType, ConnectorFactory> map = new HashMap<ConfigType, ConnectorFactory>();
            ExtensionService service = Platform.getExtensionService();
            List<Extension<ConnectorFactoryMetadata>> extensions = service.getExtensionsByPoint(ConnectorFactoryMetadata.class);
            for (Extension<ConnectorFactoryMetadata> extension : extensions) {
                try {
                    ConnectorFactory factory = extension.instantiateAs(ConnectorFactory.class);
                    ConfigType configType = factory.getConfigType();
                    assert (configType != null) : "Factory with null config type: " + factory;
                    map.put(configType, factory);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    Log.logSevere(e);
                }
            }
            VALUE = Collections.unmodifiableMap(map);
        }
    }
}

