/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector.impl.pool;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Properties;
import oracle.bpm.connector.ConnectionPoolMonitor;
import oracle.bpm.connector.impl.ConnectionPoolMonitorImpl;
import oracle.bpm.connector.impl.TransactionMonitorImpl;
import oracle.bpm.connector.impl.pool.PooledFactory;
import oracle.bpm.connector.impl.pool.TimedMultivaluePool;
import oracle.bpm.pool.CacheFactoryException;
import oracle.bpm.util.ObjectWatch;

public class PoolManager<V> {
    private Properties defaultAuthenticationProperties;
    private ConnectionPoolMonitor monitor;
    private String name;
    private TimedMultivaluePool<String, V> pool;
    private PooledFactory<V> pooledConnector;
    private Properties poolProperties;
    private static final String salt = Long.toHexString(new SecureRandom().nextLong());

    private PoolManager(PooledFactory<V> pooledConnector, String name, Properties poolProperties, Properties defaultAuthenticationProperties) {
        this.pooledConnector = pooledConnector;
        this.name = name;
        this.poolProperties = poolProperties;
        this.defaultAuthenticationProperties = defaultAuthenticationProperties;
    }

    public static <V> PoolManager<V> create(PooledFactory<V> pooledConnector, String name, Properties poolProperties, Properties defaultAuthenticationProperties) {
        return new PoolManager<V>(pooledConnector, name, poolProperties, defaultAuthenticationProperties);
    }

    public void start() throws Exception {
        this.initPool();
        this.registerPoolMonitor();
    }

    public void stop() {
        if (this.pool != null) {
            this.pool.clear();
            this.pool = null;
        }
        TransactionMonitorImpl.deregisterConnectionPoolMonitorProvider(this.getName());
    }

    public final V getPooledObject(Properties authenticationProperties) throws Exception {
        try {
            return this.pool.get(this.buildKey(authenticationProperties), authenticationProperties);
        }
        catch (CacheFactoryException cfe) {
            if (cfe.getCause() instanceof Exception) {
                throw (Exception)cfe.getCause();
            }
            throw cfe;
        }
    }

    public final void unlock(V value) {
        this.pool.unlock(value);
    }

    public TimedMultivaluePool<String, V> getPool() {
        return this.pool;
    }

    public ConnectionPoolMonitor getMonitor() {
        return this.monitor;
    }

    public String getName() {
        return this.name;
    }

    public Properties getDefaultAuthenticationProperties() {
        return this.defaultAuthenticationProperties;
    }

    public PooledFactory<V> getPooledConnector() {
        return this.pooledConnector;
    }

    public void clear() {
        if (this.pool != null) {
            this.pool.clear();
        }
    }

    protected static String buildKey(String user, String password) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String digest = password != null ? PoolManager.makeDigest(salt + ":" + password) : "";
        return (user != null ? user : "").toLowerCase() + ":" + digest;
    }

    protected static String makeDigest(String value) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-2");
        byte[] digest = md.digest(value.getBytes("UTF8"));
        return new String(digest, "UTF8");
    }

    private void registerPoolMonitor() {
        this.monitor = new ConnectionPoolMonitorImpl(this.getName(), this.pool.getStatistics());
        TransactionMonitorImpl.registerConnectionPoolMonitorProvider(this.getName(), this.monitor);
        ObjectWatch.register("pools and caches", this.getName(), "Connection Pool[" + this.getName() + "]", this.pool.getStatistics());
    }

    private void initPool() {
        Properties poolProperties = new Properties(this.getPoolProperties());
        poolProperties.setProperty("fuego.cache.wait", "true");
        poolProperties.setProperty("fuego.cache.multiplelocks", "false");
        this.pool = TimedMultivaluePool.create(this.getPooledConnector(), poolProperties);
    }

    private String buildKey(Properties authenticationProperties) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String user = null;
        String password = null;
        String userPropertyKey = this.getPooledConnector().getUserPropertyKey();
        String passwordPropertyKey = this.getPooledConnector().getPasswordPropertyKey();
        if (userPropertyKey != null && passwordPropertyKey != null) {
            if (authenticationProperties != null) {
                user = authenticationProperties.getProperty(userPropertyKey);
                password = authenticationProperties.getProperty(passwordPropertyKey);
            } else {
                user = this.getDefaultAuthenticationProperties().getProperty(userPropertyKey);
                password = this.getDefaultAuthenticationProperties().getProperty(passwordPropertyKey);
            }
        }
        return PoolManager.buildKey(user, password);
    }

    private Properties getPoolProperties() {
        return this.poolProperties;
    }
}

