/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import oracle.bpm.configuration.ConfigType;
import oracle.bpm.configuration.JndiConfigType;
import oracle.bpm.connector.ConnectorService;
import oracle.bpm.connector.impl.JNDIConnector;
import oracle.bpm.connector.spi.ConnectorFactory;
import oracle.bpm.connector.spi.ConnectorInterface;
import oracle.bpm.extensionpoint.metadata.ConnectorFactoryMetadata;

@ConnectorFactoryMetadata(configType={"JNDI"})
public class JNDIFactory
extends ConnectorFactory {
    public static final String REFERRAL_FOLLOW = "follow";
    public static final String REFERRAL_IGNORE = "ignore";
    public static final String REFERRAL_THROW = "throw";

    public static List<String> getReferralOptions() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(REFERRAL_FOLLOW);
        result.add(REFERRAL_IGNORE);
        result.add(REFERRAL_THROW);
        return result;
    }

    @Override
    public ConfigType getConfigType() {
        return JndiConfigType.get();
    }

    @Override
    public ConnectorInterface createConnector(ConnectorService manager, String name, Properties properties) {
        return new JNDIConnector(this, manager, name, properties);
    }
}

