/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector.impl;

import java.util.List;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Store;
import oracle.bpm.configuration.KnownConfigTypes;
import oracle.bpm.connector.ConnectorService;
import oracle.bpm.connector.ConnectorTransactionCoordinator;
import oracle.bpm.connector.impl.BaseConnector;
import oracle.bpm.connector.impl.pool.PoolManager;
import oracle.bpm.connector.impl.pool.PooledFactory;
import oracle.bpm.connector.spi.ConnectorFactory;
import oracle.bpm.connector.spi.MailConnectorInterface;
import oracle.bpm.log.Log;
import oracle.bpm.pool.CacheFactoryException;

public abstract class BaseMailConnector
extends BaseConnector
implements PooledFactory<Session>,
ConnectorTransactionCoordinator,
MailConnectorInterface {
    private PoolManager<Session> poolManager = PoolManager.create(this, this.getName(), this.getPoolProperties(), this.getProperties());

    protected BaseMailConnector(ConnectorFactory factory, ConnectorService manager, String name, Properties properties) {
        super(factory, manager, name, properties);
    }

    @Override
    public String getCoordinatorKey() {
        return super.getName();
    }

    @Override
    public Object getResource() throws Exception {
        return this.getResource(null);
    }

    @Override
    public Object getResource(int resourceType) throws Exception {
        return this.getResource(resourceType, null);
    }

    @Override
    public Object getResource(Properties authenticationProperties) throws Exception {
        return this.getResource(0, authenticationProperties);
    }

    @Override
    public Object getResource(int resourceType, Properties authenticationProperties) throws Exception {
        return this.getSession(authenticationProperties);
    }

    @Override
    public void restart() {
    }

    @Override
    public void start() throws Exception {
        this.poolManager.start();
    }

    @Override
    public void stop() {
        this.poolManager.stop();
    }

    @Override
    public String getUserPropertyKey() {
        return "user";
    }

    @Override
    public String getPasswordPropertyKey() {
        return "password";
    }

    @Override
    public Session create(Properties connectionProperties) throws CacheFactoryException {
        return this.createSession(connectionProperties);
    }

    @Override
    public boolean dispose(Session session) {
        boolean disposeResult = true;
        try {
            Store store = session.getStore();
            store.close();
        }
        catch (NoSuchProviderException e) {
            Log.logWarning(e);
            disposeResult = false;
        }
        catch (MessagingException e) {
            Log.logWarning(e);
            disposeResult = false;
        }
        return disposeResult;
    }

    @Override
    public ConnectorTransactionCoordinator createCoordinator() throws Exception {
        return this;
    }

    @Override
    public Session getSession() {
        return this.getSession(null);
    }

    @Override
    public Session getSession(Properties authenticationProperties) {
        Session session = null;
        try {
            session = this.poolManager.getPooledObject(authenticationProperties);
        }
        catch (Exception e) {
            Log.logSevere(e);
        }
        return session;
    }

    public boolean isIncomingMailConnector() {
        return this.getConfigType().getBaseType().equals(KnownConfigTypes.INCOMING_MAIL);
    }

    public boolean isOutgoingMailConnector() {
        return !this.isIncomingMailConnector();
    }

    @Override
    public void commit(List resources) throws Exception {
        if (resources != null) {
            for (Object o : resources) {
                if (!(o instanceof Session)) continue;
                Session session = (Session)o;
                this.poolManager.unlock(session);
            }
        }
    }

    @Override
    public void rollback(List resources) throws Exception {
        if (resources != null) {
            for (Object o : resources) {
                if (!(o instanceof Session)) continue;
                Session session = (Session)o;
                this.poolManager.unlock(session);
            }
        }
    }

    protected final Session createSession(Properties connectionProperties) {
        Session session;
        if (connectionProperties != null) {
            String user = connectionProperties.getProperty("user");
            String password = connectionProperties.getProperty("password");
            session = Session.getInstance((Properties)connectionProperties, (Authenticator)new StaticAuthenticator(user, password));
        } else {
            String user = this.getProperty("user");
            String password = this.getProperty("password");
            session = Session.getInstance((Properties)this.getProperties(), (Authenticator)new StaticAuthenticator(user, password));
        }
        session.setDebug(false);
        return session;
    }

    private static class StaticAuthenticator
    extends Authenticator {
        private String password;
        private String user;

        StaticAuthenticator(String user, String password) {
            this.user = user;
            this.password = password;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.password);
        }
    }
}

