/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAResource;
import oracle.bpm.configuration.util.ValidationUtilities;
import oracle.bpm.connector.ConnectorException;
import oracle.bpm.connector.ConnectorService;
import oracle.bpm.connector.ConnectorTransaction;
import oracle.bpm.connector.ConnectorTransactionCoordinator;
import oracle.bpm.connector.impl.BaseConnector;
import oracle.bpm.connector.impl.DriverManagerHack;
import oracle.bpm.connector.impl.LocalTransactionCoordinator;
import oracle.bpm.connector.impl.pool.PoolManager;
import oracle.bpm.connector.impl.pool.PooledFactory;
import oracle.bpm.connector.spi.ConnectorFactory;
import oracle.bpm.connector.spi.JDBCConnectorInterface;
import oracle.bpm.jdbc.DatabaseManager;
import oracle.bpm.jdbc.FaultTolerantConnection;
import oracle.bpm.jdbc.XAConnectionProxy;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;
import oracle.bpm.pool.CacheFactoryException;

public abstract class BaseJDBCConnector
extends BaseConnector
implements JDBCConnectorInterface,
PooledFactory<Connection>,
ConnectorTransactionCoordinator,
ConnectionEventListener {
    private PoolManager<Connection> poolManager = PoolManager.create(this, this.getName(), this.getPoolProperties(), this.getProperties());
    private boolean useServiceLoader = true;
    private static final String[] STRING = new String[0];

    protected BaseJDBCConnector(ConnectorFactory factory, ConnectorService manager, String name, Properties properties) {
        super(factory, manager, name, properties);
    }

    public abstract String getDriverClass();

    public abstract String getURL();

    @Override
    public final Connection getConnection() throws SQLException {
        return this.getConnection(null);
    }

    public Properties getConnectionProperties() {
        Properties result = new Properties();
        result.putAll((Map<?, ?>)this.getCustomProperties());
        return result;
    }

    @Override
    public String getCoordinatorKey() {
        if (this.isXAConnector()) {
            return BaseJDBCConnector.getRemoteTransactionCoordinator().getCoordinatorKey();
        }
        return this.getName();
    }

    public String getCreationURL() {
        throw new UnsupportedOperationException("BaseJDBCConnector.getCreationURL");
    }

    @Override
    public Object getResource() throws Exception {
        return this.getResource(null);
    }

    @Override
    public Object getResource(int resourceType) throws Exception {
        return this.getResource(resourceType, null);
    }

    @Override
    public Object getResource(Properties authenticationProperties) throws Exception {
        return this.getResource(0, authenticationProperties);
    }

    @Override
    public Object getResource(int resourceType, Properties authenticationProperties) throws Exception {
        switch (resourceType) {
            case 1: {
                return this.getDatabaseManager();
            }
            case 2: {
                return this.createConnection(true, authenticationProperties, false);
            }
        }
        ConnectorTransaction tx = ConnectorTransaction.current();
        Connection connection = this.getConnection(authenticationProperties);
        ((FaultTolerantConnection)connection).setTransactionTimeStamp(tx.getTimestamp());
        return connection;
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        try {
            XAResource xaresource = ((XAConnection)event.getSource()).getXAResource();
            BaseJDBCConnector.getRemoteTransactionCoordinator().delistResource(xaresource, 0x4000000);
        }
        catch (Exception e) {
            Log.logSevere(e);
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        try {
            XAResource xaresource = ((XAConnection)event.getSource()).getXAResource();
            BaseJDBCConnector.getRemoteTransactionCoordinator().delistResource(xaresource, 0x20000000);
        }
        catch (Exception e) {
            Log.logSevere(e);
        }
    }

    @Override
    public ConnectorTransactionCoordinator createCoordinator() throws Exception {
        if (this.isXAConnector()) {
            return BaseJDBCConnector.getRemoteTransactionCoordinator();
        }
        return this;
    }

    public Connection createJDBConnection(Properties authProperties) throws SQLException {
        Properties connectionProperties = this.getConnectionProperties();
        if (authProperties != null) {
            this.putProperty(connectionProperties, "user", authProperties.getProperty("user"));
            this.putProperty(connectionProperties, "password", ValidationUtilities.unscrambleText(authProperties.getProperty("password")));
        }
        Connection result = DriverManagerHack.getConnection(this.useServiceLoader ? this.getManager().getClassLoaderService().getServiceClassLoader() : this.getClass().getClassLoader(), this.getURL(), connectionProperties);
        DatabaseManager.unlockConnection(result);
        this.onConnected(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnected(Connection connection, boolean setTxProperties) throws SQLException {
        if (setTxProperties) {
            connection.setAutoCommit(Boolean.valueOf(this.getProperty("jdbc.autocommit", String.valueOf(false))));
            connection.setTransactionIsolation(2);
        }
        String[] stmts = this.onConnectedQueries();
        Statement stmt = null;
        if (stmts != null && stmts.length > 0) {
            try {
                stmt = connection.createStatement();
                for (String stmt1 : stmts) {
                    if (stmt1 == null) continue;
                    stmt.execute(stmt1);
                }
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException ignore) {}
                }
            }
        }
    }

    public void onConnected(Connection connection) throws SQLException {
        this.onConnected(connection, true);
    }

    @Override
    public void start() throws Exception {
        String driverClassName = this.getDriverClass();
        assert (driverClassName != null && driverClassName.length() != 0) : "The JDBC Connector does not define the driver class";
        try {
            Class.forName(driverClassName, true, this.getManager().getClassLoaderService().getServiceClassLoader());
        }
        catch (ClassNotFoundException e1) {
            try {
                Class.forName(driverClassName, true, this.getClass().getClassLoader());
                this.useServiceLoader = false;
            }
            catch (ClassNotFoundException e2) {
                throw ConnectorException.jdbcDriverNotFound(this, driverClassName);
            }
        }
        this.poolManager.start();
    }

    @Override
    public void stop() {
        this.poolManager.stop();
    }

    @Override
    public Connection getConnection(Properties authenticationProperties) throws SQLException {
        Connection connection;
        try {
            connection = this.poolManager.getPooledObject(authenticationProperties);
        }
        catch (Exception e) {
            SQLException sqlException = new SQLException(e.getLocalizedMessage());
            sqlException.initCause(e);
            throw sqlException;
        }
        return this.getEnlistedConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(List resources) throws Exception {
        boolean fail = false;
        if (resources != null) {
            for (Object o : resources) {
                if (!(o instanceof Connection)) continue;
                assert (o instanceof FaultTolerantConnection) : "The cache values must be fault tolerant connections";
                FaultTolerantConnection connection = (FaultTolerantConnection)o;
                try {
                    connection.commit(this);
                }
                catch (Throwable t) {
                    Log.logWarning(LibMsg.EXCEPTION_ON_COMMIT_BASEJDBCPOOLED(this.getCoordinatorKey()));
                    Log.logWarning(t);
                    fail = true;
                }
                finally {
                    this.poolManager.unlock(connection);
                }
            }
        }
        if (fail) {
            throw new Exception();
        }
    }

    @Override
    public Connection create(Properties authenticationProperties) throws CacheFactoryException {
        try {
            return this.createConnection(authenticationProperties);
        }
        catch (SQLException e) {
            throw new CacheFactoryException(e);
        }
    }

    @Override
    public boolean dispose(Connection connection) {
        assert (connection instanceof FaultTolerantConnection) : "The cache values must be fault tolerant connections";
        try {
            ((FaultTolerantConnection)connection).close(this);
        }
        catch (SQLException e) {
            if (Log.isDebugging()) {
                Log.logDebug(e);
            }
            return false;
        }
        return true;
    }

    @Override
    public void restart() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(List resources) throws Exception {
        boolean fail = false;
        if (resources != null) {
            for (Object o : resources) {
                if (!(o instanceof Connection)) continue;
                assert (o instanceof FaultTolerantConnection) : "The cache values must be fault tolerant connections";
                FaultTolerantConnection connection = (FaultTolerantConnection)o;
                try {
                    connection.rollback(this);
                }
                catch (Throwable t) {
                    Log.logWarning(LibMsg.EXCEPTION_ON_ROLLBACK_BASEJDBCPOOLED(this.getCoordinatorKey()));
                    Log.logWarning(t);
                    fail = true;
                }
                finally {
                    this.poolManager.unlock(connection);
                }
            }
        }
        if (fail) {
            throw new Exception();
        }
    }

    @Override
    public String getUserPropertyKey() {
        return "user";
    }

    @Override
    public String getPasswordPropertyKey() {
        return "password";
    }

    public void clear() {
        this.poolManager.clear();
    }

    protected abstract XADataSource getXADataSource() throws SQLException;

    protected static LocalTransactionCoordinator getRemoteTransactionCoordinator() {
        return LocalTransactionCoordinator.getInstance();
    }

    protected Connection getEnlistedConnection(Connection connection) throws SQLException {
        if (this.isXAConnector()) {
            XAConnectionProxy xaconnection = (XAConnectionProxy)connection;
            try {
                BaseJDBCConnector.getRemoteTransactionCoordinator().enlistResource(xaconnection.getXAResource(), this.supports(4096L));
            }
            catch (SystemException e) {
                Log.logSevere(e);
                throw new SQLException(e.getMessage());
            }
            catch (NotSupportedException e) {
                Log.logSevere(e);
                throw new SQLException(e.getMessage());
            }
            catch (RollbackException e) {
                Log.logSevere(e);
                throw new SQLException(e.getMessage());
            }
            return xaconnection;
        }
        return connection;
    }

    protected boolean isXAConnector() {
        return Boolean.parseBoolean(this.getProperty("jdbc.xa", String.valueOf(false)));
    }

    protected final Connection createConnection(Properties authenticationProperties) throws SQLException {
        return this.createConnection(false, authenticationProperties, true);
    }

    protected Properties getStatementCacheProperties() {
        int maxOpenCursors = Integer.parseInt(this.getProperty("jdbc.pool.maxopencursors", "100"));
        if (maxOpenCursors == 0) {
            return null;
        }
        int poolMax = Integer.parseInt(this.getProperty("jdbc.pool.max", "10"));
        assert (maxOpenCursors > 0) : "The max open cursors must be greater than zero";
        assert (poolMax > 0) : "The max pool size must be greater than zero";
        int quota = maxOpenCursors / poolMax;
        Properties cacheProperties = new Properties();
        cacheProperties.put("jdbc.statementcache.quota", String.valueOf(quota));
        cacheProperties.put("jdbc.pool.maxopencursors", String.valueOf(maxOpenCursors));
        return cacheProperties;
    }

    protected Connection createConnection(boolean canBeClosed, Properties authenticationProperties, boolean retry) throws SQLException {
        if (!this.isXAConnector()) {
            return FaultTolerantConnection.create(this, this.getStatementCacheProperties(), retry, canBeClosed, null, authenticationProperties);
        }
        if (this.supports(8192L)) {
            return this.createXAConnection(authenticationProperties);
        }
        Log.logSevere(ConnectorException.xaNotSupported(this.getConfigType()));
        throw new SQLException("XA Not supported");
    }

    protected Connection createXAConnection(Properties authenticationProperties) throws SQLException {
        return XAConnectionProxy.create(this, this.getStatementCacheProperties(), this.getXADataSource(), this.poolManager.getPool(), authenticationProperties);
    }

    protected String[] onConnectedQueries() {
        return STRING;
    }
}

