/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.bpm.connector.ConnectorException;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.resources.Msg;

public class TransactionException
extends ConnectorException {
    private List<Throwable> throwables;
    private static final long serialVersionUID = -6086109166922382882L;

    protected TransactionException(Msg msg, List<Throwable> throwables) {
        super(msg);
        this.throwables = throwables;
    }

    public static TransactionException exceptionOnCommit(List<Throwable> throwables) {
        String cause = TransactionException.getCauseList(throwables);
        return new TransactionException(LibMsg.EXCEPTION_ON_COMMIT(cause), throwables);
    }

    public static TransactionException exceptionOnRollback(List<Throwable> throwables) {
        String cause = TransactionException.getCauseList(throwables);
        return new TransactionException(LibMsg.EXCEPTION_ON_ROLLBACK(cause), throwables);
    }

    public List<Throwable> getThrowables() {
        return Collections.unmodifiableList(this.throwables);
    }

    @Override
    public void printStackTrace(PrintWriter writer) {
        super.printStackTrace(writer);
        Iterator<Throwable> iterator = this.throwables.iterator();
        writer.println("Caused by " + this.throwables.size() + " exceptions: ");
        while (iterator.hasNext()) {
            Throwable t = iterator.next();
            t.printStackTrace(writer);
            writer.println();
        }
    }

    @Override
    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        Iterator<Throwable> iterator = this.throwables.iterator();
        s.println("Caused by " + this.throwables.size() + " exceptions: ");
        while (iterator.hasNext()) {
            Throwable t = iterator.next();
            t.printStackTrace(s);
            s.println();
        }
    }

    private static String getCauseList(List throwables) {
        StringWriter stringWriter = new StringWriter();
        TransactionException.printListStackTrace(new PrintWriter((Writer)stringWriter, true), throwables);
        return stringWriter.toString();
    }

    private static void printListStackTrace(PrintWriter printWriter, List throwables) {
        Iterator iterator = throwables.iterator();
        printWriter.println("Caused by " + throwables.size() + " exceptions: ");
        while (iterator.hasNext()) {
            Throwable t = (Throwable)iterator.next();
            t.printStackTrace(printWriter);
            printWriter.println();
        }
    }
}

