/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector;

import java.sql.Connection;
import java.util.Properties;
import oracle.bpm.configuration.KnownConfigTypes;
import oracle.bpm.connector.ConnectorException;
import oracle.bpm.connector.ConnectorTransaction;
import oracle.bpm.connector.spi.ConnectorInterface;
import oracle.bpm.jdbc.DatabaseManager;

public final class JDBCHelper {
    private JDBCHelper() {
    }

    public static Connection getConnection(String name) throws ConnectorException {
        return (Connection)ConnectorTransaction.current().getResource(name, KnownConfigTypes.SQL, 0);
    }

    public static Connection getConnection(String name, String user, String password) throws ConnectorException {
        Properties authProperties = JDBCHelper.buildAuthProperties(user, password);
        return (Connection)ConnectorTransaction.current().getResource(name, KnownConfigTypes.SQL, 0, authProperties);
    }

    public static DatabaseManager getDatabaseManager(String name) throws ConnectorException {
        ConnectorInterface connectorInterface = ConnectorTransaction.getConnectorInterface(name, KnownConfigTypes.SQL);
        try {
            return (DatabaseManager)connectorInterface.getResource(1);
        }
        catch (Exception e) {
            throw ConnectorException.exceptionOnGetResource(connectorInterface, 1, e);
        }
    }

    public static Connection getNonNestedConnection(String name) throws ConnectorException {
        return JDBCHelper.getReadOnlyConnection(name);
    }

    public static Connection getNonNestedConnection(String name, String user, String password) throws ConnectorException {
        return JDBCHelper.getReadOnlyConnection(name, user, password);
    }

    public static Connection getReadOnlyConnection(String name) throws ConnectorException {
        ConnectorInterface connector = ConnectorTransaction.getConnectorInterface(name, KnownConfigTypes.SQL);
        try {
            return (Connection)connector.getResource(2);
        }
        catch (Exception e) {
            throw ConnectorException.exceptionOnGetResource(connector, e);
        }
    }

    public static Connection getReadOnlyConnection(String name, String user, String password) throws ConnectorException {
        ConnectorInterface connector = ConnectorTransaction.getConnectorInterface(name, KnownConfigTypes.SQL);
        Properties authProperties = JDBCHelper.buildAuthProperties(user, password);
        try {
            return (Connection)connector.getResource(2, authProperties);
        }
        catch (Exception e) {
            throw ConnectorException.exceptionOnGetResource(connector, e);
        }
    }

    public static Properties buildAuthProperties(String user, String password) {
        Properties authProperties = new Properties();
        authProperties.put("user", user);
        authProperties.put("password", password);
        return authProperties;
    }
}

