/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector;

import fuego.directory.DirectoryException;
import fuego.directory.DirectorySession;
import java.io.File;
import oracle.bpm.configuration.ConfigType;
import oracle.bpm.configuration.Configuration;
import oracle.bpm.connector.ConnectorTransactionCoordinator;
import oracle.bpm.connector.spi.ConnectorInterface;
import oracle.bpm.lang.DefaultException;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.resources.Msg;

public class ConnectorException
extends DefaultException {
    static final long serialVersionUID = 3724858345667504982L;
    static final long serialCheck = -6002517820246297025L;

    protected ConnectorException(Msg msg) {
        super(msg);
    }

    public static ConnectorException cannotUseJCLConfiguration(Configuration configuration) {
        return new ConnectorException(LibMsg.CANNOT_USE_JCL(configuration.getName()));
    }

    public static String connectorAsString(ConnectorInterface connector) {
        return connector.getName() + ":" + connector.getConfigType().getParent() + ":" + connector.getConfigType();
    }

    public static ConnectorException connectorNotFound(String name, ConfigType type) {
        return new ConnectorException(LibMsg.CONNECTOR_NOT_FOUND(name, type));
    }

    public static ConnectorException connectorNotInitialized(String name, ConfigType type) {
        return new ConnectorException(LibMsg.CONNECTOR_NOT_INITIALIZED(name, type));
    }

    public static ConnectorException connectorTypeMismatch(String name, ConfigType type) {
        return new ConnectorException(LibMsg.CONNECTOR_TYPE_MISMATCH(name, type));
    }

    public static ConnectorException coordinatorAlreadyRegistered(ConnectorTransactionCoordinator coordinator) {
        return new ConnectorException(LibMsg.COORDINATOR_ALREADY_REGISTERED(coordinator.getCoordinatorKey()));
    }

    public static ConnectorException exceptionOnContext(Throwable cause) {
        return (ConnectorException)new ConnectorException(LibMsg.SERVICE_NOT_STARTED).initCause(cause);
    }

    public static ConnectorException exceptionOnCreateCoordinator(ConnectorInterface connector, Exception cause) {
        return (ConnectorException)new ConnectorException(LibMsg.EXCEPTION_CREATE_COORDINATOR(ConnectorException.connectorAsString(connector))).initCause(cause);
    }

    public static ConnectorException exceptionOnGetResource(ConnectorInterface connector, Exception cause) {
        return (ConnectorException)new ConnectorException(LibMsg.EXCEPTION_GET_RESOURCE(ConnectorException.connectorAsString(connector))).initCause(cause);
    }

    public static ConnectorException exceptionOnGetResource(ConnectorInterface connector, int resourceType, Exception cause) {
        return (ConnectorException)new ConnectorException(LibMsg.EXCEPTION_GET_RESOURCE2(ConnectorException.connectorAsString(connector), resourceType)).initCause(cause);
    }

    public static ConnectorException exceptionOnInit(ConnectorInterface connector, Exception cause) {
        return (ConnectorException)new ConnectorException(LibMsg.EXCEPTION_INIT(ConnectorException.connectorAsString(connector))).initCause(cause);
    }

    public static ConnectorException exceptionOnInitJavaClassLibraries(Configuration configuration, String fileName, File libDir) {
        return new ConnectorException(LibMsg.EXCEPTION_INIT_JCL(configuration.getName(), fileName, libDir.getPath()));
    }

    public static ConnectorException exceptionOnLoad(DirectorySession session, DirectoryException cause) {
        return (ConnectorException)new ConnectorException(LibMsg.EXCEPTION_LOAD_FDI(session.getSchemaId())).initCause(cause);
    }

    public static ConnectorException factoryNotFound(ConfigType subtype) {
        return new ConnectorException(LibMsg.FACTORY_NOT_FOUND(subtype, subtype.getParent()));
    }

    public static ConnectorException jdbcDriverNotFound(ConnectorInterface connector, String className) {
        return new ConnectorException(LibMsg.JDBC_DRIVER_NOT_FOUND(ConnectorException.connectorAsString(connector), className));
    }

    public static ConnectorException noCoordinatorRegistered() {
        return new ConnectorException(LibMsg.NO_COORDINATOR_REGISTERED);
    }

    public static ConnectorException notOwnerThread() {
        return new ConnectorException(LibMsg.NOT_OWNER_THREAD);
    }

    public static ConnectorException serviceNotStarted() {
        return new ConnectorException(LibMsg.SERVICE_NOT_STARTED);
    }

    public static ConnectorException wrapClassCastException(ConnectorInterface connector, int resourceType, ClassCastException cause) {
        return new ConnectorException(LibMsg.EXCEPTION_GET_RESOURCE3(ConnectorException.connectorAsString(connector), resourceType, cause.getMessage()));
    }

    public static ConnectorException xaNotSupported(ConfigType subType) {
        return new ConnectorException(LibMsg.XA_NOT_SUPPORTED(subType, subType.getParent()));
    }
}

