/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import oracle.bpm.configuration.BaseConfiguration;
import oracle.bpm.configuration.BaseFileManager;
import oracle.bpm.configuration.ConfigurationSet;
import oracle.bpm.io.FileSystem;
import oracle.bpm.io.StreamUtils;
import org.jetbrains.annotations.Nullable;

class FileManager<T extends BaseConfiguration>
extends BaseFileManager<T> {
    private File file;

    FileManager(ConfigurationSet<T> configurations, File file, FileSystem fileSystem) {
        super(configurations, fileSystem);
        this.file = file;
    }

    @Override
    protected File getFile() {
        return this.file;
    }

    @Override
    @Nullable
    protected InputStream reloadData() throws Exception {
        try {
            return new FileInputStream(this.getFile());
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveConfigurations() throws Exception {
        FileOutputStream outputStream = new FileOutputStream(this.file);
        try {
            this.configurations.writeXML(outputStream, "UTF-8");
        }
        catch (Throwable throwable) {
            StreamUtils.close(outputStream);
            throw throwable;
        }
        StreamUtils.close(outputStream);
    }
}

