/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.components.listeners;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.components.ServerEventHandler;
import oracle.bpm.components.ServerEventSource;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.LowResolutionTimer;
import oracle.bpm.lang.LowResolutionTimerListener;
import oracle.bpm.log.Log;

public class TimerComponent
implements LowResolutionTimerListener,
ServerEventSource {
    private String argumentName;
    private LowResolutionTimer lowResolutionTimer = null;
    private ServerEventHandler server = null;

    public static void main(String[] args) throws Exception {
        TimerComponent t = new TimerComponent();
        HashMap<String, Long> m = new HashMap<String, Long>();
        m.put("interval", 10L);
        t.init(m, new ServerEventHandler(){

            @Override
            public void processEvent(Object o) {
                System.out.println("Evento: " + o);
            }
        }, "");
        System.gc();
        Thread.sleep(60000L);
        System.out.println("About to shutdown...");
        t.shutdown();
    }

    @Override
    public void commit() {
    }

    @Override
    public void init(Map properties, ServerEventHandler server, String argumentName) throws Exception {
        if (properties == null) {
            throw new NullPointerException("properties can't be null");
        }
        if (server == null) {
            throw new NullPointerException("server's event sink can't be null");
        }
        Long interval = (Long)properties.get("interval");
        if (interval == null) {
            throw new NullPointerException("properties can't be null.");
        }
        this.server = server;
        this.argumentName = argumentName;
        this.lowResolutionTimer = new LowResolutionTimer(interval.intValue());
        this.lowResolutionTimer.add(this);
        this.lowResolutionTimer.start();
    }

    @Override
    public void rollback() {
    }

    @Override
    public void shutdown() {
        this.argumentName = null;
        this.lowResolutionTimer.stop();
    }

    @Override
    public void timerFired(LowResolutionTimer timer) {
        try {
            this.server.processEvent(this.argumentName);
        }
        catch (ComponentExecutionException e) {
            Log.logWarning(e);
        }
    }
}

