/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.components;

import java.lang.reflect.InvocationTargetException;
import oracle.bpm.component.Wanderer;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.component.metadata.Hidden;
import oracle.bpm.component.metadata.Method;
import oracle.bpm.component.metadata.Type;
import oracle.bpm.components.ProcessInstance;
import oracle.bpm.components.ScreenFlowFinishedThrowable;
import oracle.bpm.lang.ArgMap;
import oracle.bpm.lang.ArgumentMap;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaObject;
import oracle.bpm.lang.RuntimeCILExecutionException;
import oracle.bpm.util.ExecutionContext;
import oracle.bpm.util.ExecutionContextAccessor;

@Component(module="Fuego.Internal")
public class ScreenFlow
implements Wanderer {
    private transient TraceHandler handler;
    private Object lastException;
    private transient ArgumentMap outputArguments;
    private Object parent;
    private String result;
    private String target;
    static final long serialVersionUID = -7025619609286507035L;
    static final long serialCheck = -7742376574777217625L;

    @Type(value="Fuego.Action")
    public void setAction(int action) {
        ProcessInstance.setAction(action);
    }

    @Type(value="Fuego.Action")
    public int getAction() {
        return ProcessInstance.getAction();
    }

    public void setLastException(Object lastException) {
        this.lastException = lastException;
    }

    public Object getLastException() {
        return this.lastException;
    }

    @Exclude
    public ArgumentMap getOutputArguments() {
        return this.outputArguments;
    }

    @Hidden
    public void setParent(Object parent) {
        this.parent = parent;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getResult() {
        return this.result;
    }

    @Hidden
    public void setTarget(String target) {
        this.target = target;
    }

    public void setTimeout(Interval timeout) {
        ExecutionContext ctx = ExecutionContextAccessor.getContext();
        long timeoutMillis = 0L;
        if (timeout != null) {
            timeoutMillis = timeout.getTotalMicroseconds() / 1000L;
        }
        ctx.setTimeout(timeoutMillis);
    }

    public Interval getTimeout() {
        ExecutionContext ctx = ExecutionContextAccessor.getContext();
        return Interval.valueOf(ctx.getTimeToLive() * 1000L);
    }

    @Exclude
    public void setTraceHandler(TraceHandler handler) {
        this.handler = handler;
    }

    @Hidden
    @Method(parameters={"name", "value : Any"})
    public void addOutputArgument(String name, Object value) {
        if (this.outputArguments == null) {
            this.outputArguments = ArgMap.create();
        }
        this.outputArguments.setArgument(name, value);
    }

    @Hidden
    public void debugTrace(String message) {
        TraceHandler handler = this.handler;
        if (handler != null) {
            handler.debugTrace(message);
        }
    }

    @Hidden
    public void resumeParentExecution() throws Throwable {
        if (this.parent == null) {
            throw new ScreenFlowFinishedThrowable(this);
        }
        Invokeable invokeable = this.parent instanceof ScreenFlow ? new JavaObject<Object>(this.parent) : (Invokeable)this.parent;
        Object[] args = new Object[]{this.outputArguments == null ? ArgMap.create() : this.outputArguments};
        try {
            String targetMtd = this.target;
            if (!targetMtd.endsWith("_Router")) {
                targetMtd = targetMtd + "_Router";
            }
            invokeable.invoke('M' + targetMtd + "(L" + ArgumentMap.class.getName() + ";)V", args);
        }
        catch (ComponentExecutionException e) {
            throw e.getCause();
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    @Hidden
    public void propagateParentException(Object exception) throws Throwable {
        if (this.parent == null) {
            this.rethrowUserException(exception);
        } else {
            Invokeable invokeable = this.parent instanceof ScreenFlow ? new JavaObject<Object>(this.parent) : (Invokeable)this.parent;
            ArgMap argMap = ArgMap.create();
            argMap.setArgument("exception", exception);
            Object[] args = new Object[]{argMap};
            try {
                invokeable.invoke('M' + this.target + "_Exception(L" + ArgumentMap.class.getName() + ";)V", args);
            }
            catch (ComponentExecutionException e) {
                throw e.getCause();
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }

    @Hidden
    public void rethrowUserException(Object exception) throws Throwable {
        if (exception instanceof Throwable) {
            throw (Throwable)exception;
        }
        throw new RuntimeCILExecutionException(exception);
    }

    @Exclude
    public static interface TraceHandler {
        public void debugTrace(String var1);
    }
}

