/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.components;

import fuego.directory.DirOrganizationalRole;
import fuego.directory.Directory;
import fuego.directory.DirectoryPassport;
import fuego.directory.DirectorySession;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.EnterpriseOnly;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.component.metadata.Hidden;
import oracle.bpm.components.ComponentRuntimeException;
import oracle.bpm.components.DirectoryException;
import oracle.bpm.components.InstanceRetrieverInterface;
import oracle.bpm.components.NoSuchRoleException;
import oracle.bpm.components.Participant;
import oracle.bpm.components.ProcessInstance;
import oracle.bpm.components.ProcessInstanceInterface;
import oracle.bpm.components.RoleInterface;
import oracle.bpm.components.Server;
import oracle.bpm.lang.DefaultException;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.lib.msg.LibMsg;

@Component(module="Fuego.Lib", runsOnClient=false)
public class Role
implements DynamicObject.Dynamizable,
Serializable {
    private transient ProcessInstanceInterface pdata;
    private transient RoleInterface roleInterface;
    private String roleName;
    static final long serialVersionUID = -6344304011863218633L;
    static final long serialCheck = 8951028839422113040L;

    public Role(String roleName) throws NoSuchRoleException {
        this.roleName = roleName;
    }

    public Role(String roleName, String parameter) throws NoSuchRoleException {
        this(roleName + ":" + parameter);
    }

    @Hidden
    Role(RoleInterface role) {
        this.roleName = role.getName();
        this.roleInterface = role;
    }

    public static Role find(String name) {
        Role result;
        String realRole = ProcessInstance.getCurrent().getProcessInterface().getRealRole(name);
        if (realRole != null && !"".equals(realRole)) {
            name = realRole;
        }
        try {
            result = new Role(name);
            result.getRoleInterface();
        }
        catch (NoSuchRoleException justLogIt) {
            LibMsg.ROLE_NOT_FOUND(name).logInfo();
            result = null;
        }
        return result;
    }

    public static Role findParametric(String name, String parameter) {
        return Role.find(name + ":" + parameter);
    }

    public static boolean create(String url, String user, String password, String name, String description) {
        return Role.createRole(url, user, password, name, description, false, new String[0]);
    }

    public static boolean createParametric(String url, String user, String password, String name, String description, String[] params) {
        return Role.createRole(url, user, password, name, description, true, params);
    }

    public void setDefaultParticipantForCurrentInstance(Participant participant) {
        if (this.pdata == null) {
            this.pdata = ProcessInstance.getCurrent().processInstanceInterface();
        }
        this.pdata.setParticipantForRole(this, participant);
    }

    public Participant getDefaultParticipantForCurrentInstance() {
        if (this.pdata == null) {
            this.pdata = ProcessInstance.getCurrent().processInstanceInterface();
        }
        return this.pdata.getParticipantForRole(this);
    }

    public String getDescription() {
        return this.getRoleInterface().getDescription();
    }

    public int getId() {
        return this.getRoleInterface().getIn();
    }

    public String getName() {
        return this.getRoleInterface().getName();
    }

    public String getOrganization() {
        return this.getRoleInterface().getOrganization();
    }

    @Deprecated
    public void addParticipant(String participant, String permission, String userDN, String userPassword) {
        this._addParticipant(participant, permission);
    }

    @Deprecated
    public void addParticipant(String participant, String permission) {
        this._addParticipant(participant, permission);
    }

    public String retrieveEncryptedPropertyFor(String name, String key) throws DirectoryException {
        return this.retrieveEncryptedPropertyFor(null, name, key);
    }

    public String retrieveEncryptedPropertyFor(String application, String name, String key) throws DirectoryException {
        try {
            return this.getRoleInterface().retrieveEncryptedPropertyFor(application, name, key);
        }
        catch (fuego.directory.DirectoryException e) {
            throw new DirectoryException(e.getLocalizedMessage());
        }
    }

    @Deprecated
    @EnterpriseOnly
    @Hidden
    public ArrayList retrieveInstances() {
        return this.instancesImpl(2);
    }

    @Hidden
    public Object retrieveObjectPropertyFor(String name) throws DirectoryException {
        return this.retrieveObjectPropertyFor(null, name);
    }

    public Object retrieveObjectPropertyFor(String application, String name) throws DirectoryException {
        try {
            return this.getRoleInterface().retrieveObjectPropertyFor(application, name);
        }
        catch (fuego.directory.DirectoryException e) {
            throw new DirectoryException(e.getLocalizedMessage());
        }
    }

    @Deprecated
    @EnterpriseOnly
    @Hidden
    public ArrayList retrievePendingInstances() {
        return this.instancesImpl(0);
    }

    @Hidden
    public String retrievePropertyFor(String name) throws DirectoryException {
        return this.retrievePropertyFor(null, name);
    }

    public String retrievePropertyFor(String application, String name) throws DirectoryException {
        try {
            return this.getRoleInterface().retrievePropertyFor(application, name);
        }
        catch (fuego.directory.DirectoryException e) {
            throw new DirectoryException(e.getLocalizedMessage());
        }
    }

    @Deprecated
    @EnterpriseOnly
    @Hidden
    public ArrayList retrieveSelectedInstances(Participant participant) {
        return this.selectedInstancesImpl(2, participant);
    }

    @Deprecated
    @EnterpriseOnly
    @Hidden
    public ArrayList retrieveSelectedPendingInstances(Participant participant) {
        return this.selectedInstancesImpl(0, participant);
    }

    @Deprecated
    @EnterpriseOnly
    @Hidden
    public ArrayList retrieveSelectedSuspendedInstances(Participant participant) {
        return this.selectedInstancesImpl(1, participant);
    }

    @Deprecated
    @EnterpriseOnly
    @Hidden
    public ArrayList retrieveSuspendedInstances() {
        return this.instancesImpl(1);
    }

    @Deprecated
    @EnterpriseOnly
    @Hidden
    public ArrayList retrieveUnselectedInstances() {
        return this.unselectedInstancesImpl(2);
    }

    @Deprecated
    @EnterpriseOnly
    @Hidden
    public ArrayList retrieveUnselectedPendingInstances() {
        return this.unselectedInstancesImpl(0);
    }

    @Deprecated
    @EnterpriseOnly
    @Hidden
    public ArrayList retrieveUnselectedSuspendedInstances() {
        return this.unselectedInstancesImpl(1);
    }

    public void storeEncryptedPropertyFor(String name, String value, String key) throws DirectoryException {
        this.storeEncryptedPropertyFor(null, name, value, key);
    }

    public void storeEncryptedPropertyFor(String application, String name, String value, String key) throws DirectoryException {
        try {
            this.getRoleInterface().storeEncryptedPropertyFor(application, name, value, key);
        }
        catch (fuego.directory.DirectoryException e) {
            throw new DirectoryException(e.getLocalizedMessage());
        }
    }

    @Hidden
    public void storeObjectPropertyFor(String name, Object value) throws Exception {
        this.storeObjectPropertyFor(null, name, value);
    }

    public void storeObjectPropertyFor(String application, String name, Object value) throws Exception {
        this.getRoleInterface().storeObjectPropertyFor(application, name, value);
    }

    @Hidden
    public void storePropertyFor(String name, String value) throws DirectoryException {
        this.storePropertyFor(null, name, value);
    }

    public void storePropertyFor(String application, String name, String value) throws DirectoryException {
        try {
            this.getRoleInterface().storePropertyFor(application, name, value);
        }
        catch (fuego.directory.DirectoryException e) {
            throw new DirectoryException(e.getLocalizedMessage());
        }
    }

    @Exclude
    public String toString() {
        return "Role(" + this.getName() + ")";
    }

    @Exclude
    public DynamicObject writeDynamicObject() {
        DynamicObject result = DynamicObject.create();
        result.setField("name", this.getName());
        result.setField("description", this.getDescription());
        result.setField("id", this.getId());
        result.setField("organization", this.getOrganization());
        return result;
    }

    @Exclude
    public RoleInterface getRoleInterface() {
        if (this.roleInterface == null) {
            this.roleInterface = Server.getServerInterface().getRoleInterface(this.roleName);
            if (this.roleInterface == null) {
                throw NoSuchRoleException.roleNotFound(this.roleName);
            }
        }
        return this.roleInterface;
    }

    @Hidden
    protected DirOrganizationalRole getDirectoryServiceRole() throws DirectoryException {
        try {
            return DirOrganizationalRole.fetch(this.getDirectorySession(), this.getName());
        }
        catch (fuego.directory.DirectoryException e) {
            throw new DirectoryException(e.getLocalizedMessage());
        }
    }

    @Hidden
    protected DirectorySession getDirectorySession() throws DirectoryException {
        return ProcessInstance.getDirectorySession();
    }

    @Exclude
    static Object readDynamicObject(DynamicObject dobj) {
        String roleName = dobj.getField("name").toString();
        return new Role(roleName);
    }

    @Hidden
    private static boolean createRole(String url, String user, String password, String cn, String description, boolean parametric, String[] params) {
        if (parametric && (params == null || params.length == 0)) {
            return false;
        }
        try {
            DirectoryPassport passport = DirectoryPassport.createWithID(url, user);
            passport.setPassword(password);
            DirectorySession session = Directory.startSession(passport);
            DirOrganizationalRole.create(session, cn, parametric, description, params, new DirOrganizationalRole.CalendarRuleAssignment[0]);
            session.disconnect();
        }
        catch (fuego.directory.DirectoryException dex) {
            throw new ComponentRuntimeException(LibMsg.COULD_NOT_CREATE_ROLE);
        }
        return true;
    }

    private void _addParticipant(String participant, String permission) {
        try {
            this.getRoleInterface().addParticipant(participant, permission);
        }
        catch (DefaultException e) {
            throw new ComponentRuntimeException(LibMsg.COULD_NOT_ADD_ROLE_PARTICIPANT);
        }
    }

    @Hidden
    private ArrayList instancesImpl(int type) {
        InstanceRetrieverInterface instanceRetrieverInterface = ProcessInstance.getCurrent().getInstanceRetrieverInterface();
        return instanceRetrieverInterface.getInstancesForRole(type, this.getRoleInterface());
    }

    @Exclude
    private void readObject(ObjectInputStream in) throws IOException {
        this.roleName = in.readUTF();
    }

    @Hidden
    private ArrayList selectedInstancesImpl(int type, Participant participant) {
        InstanceRetrieverInterface instanceRetrieverInterface = ProcessInstance.getCurrent().getInstanceRetrieverInterface();
        return instanceRetrieverInterface.getSelectedInstancesForRole(type, participant.participantInterface(), this.getRoleInterface());
    }

    @Hidden
    private ArrayList unselectedInstancesImpl(int type) {
        InstanceRetrieverInterface instanceRetrieverInterface = ProcessInstance.getCurrent().getInstanceRetrieverInterface();
        return instanceRetrieverInterface.getUnselectedInstancesForRole(type, this.getRoleInterface());
    }

    @Exclude
    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.roleName);
    }
}

