/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.components;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.bpm.components.ProcessRunEndListener;
import oracle.bpm.lang.ArgMap;
import oracle.bpm.lang.ArgumentMap;
import oracle.bpm.lang.RuntimeCILExecutionException;
import oracle.bpm.util.Latch;

public class ProcessRunEndListenerImpl
implements ProcessRunEndListener {
    private final ConcurrentHashMap<String, LatchHolder> latchesByInstanceId = new ConcurrentHashMap();
    private static final ArgumentMap NULL = ArgMap.create();
    private static ProcessRunEndListener instance = new ProcessRunEndListenerImpl();

    private ProcessRunEndListenerImpl() {
    }

    public static ProcessRunEndListener getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyEnd(String instanceId, boolean succesfully, ArgumentMap arguments) {
        ConcurrentHashMap<String, LatchHolder> concurrentHashMap = this.latchesByInstanceId;
        synchronized (concurrentHashMap) {
            if (this.latchesByInstanceId.containsKey(instanceId)) {
                LatchHolder holder = this.latchesByInstanceId.get(instanceId);
                if (arguments == null) {
                    holder.getLatch().put(NULL);
                    holder.setSuccessful(succesfully);
                } else {
                    holder.getLatch().put(arguments);
                    holder.setSuccessful(succesfully);
                }
            } else {
                Latch latch = new Latch(false);
                latch.put(arguments);
                this.latchesByInstanceId.put(instanceId, new LatchHolder(latch, succesfully));
            }
        }
        this.removeExpiredLatches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArgumentMap getArgumentMap(String instanceId, long timeout) throws Exception {
        ConcurrentHashMap<String, LatchHolder> concurrentHashMap = this.latchesByInstanceId;
        synchronized (concurrentHashMap) {
            if (!this.latchesByInstanceId.containsKey(instanceId)) {
                Latch latch = new Latch(timeout, false);
                this.latchesByInstanceId.put(instanceId, new LatchHolder(latch));
            }
        }
        return this.getValue(instanceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExpiredLatches() {
        HashSet<String> expiredInstancesLatch = new HashSet<String>();
        ConcurrentHashMap<String, LatchHolder> concurrentHashMap = this.latchesByInstanceId;
        synchronized (concurrentHashMap) {
            for (Map.Entry<String, LatchHolder> holderEntry : this.latchesByInstanceId.entrySet()) {
                if (!holderEntry.getValue().isExpired()) continue;
                expiredInstancesLatch.add(holderEntry.getKey());
            }
            for (String instanceId : expiredInstancesLatch) {
                this.latchesByInstanceId.remove(instanceId);
            }
        }
    }

    private LatchHolder getLatch(String instanceId) {
        return this.latchesByInstanceId.get(instanceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArgumentMap getValue(String instanceId) throws Exception {
        ArgumentMap result;
        LatchHolder holder = this.getLatch(instanceId);
        try {
            result = (ArgumentMap)holder.getLatch().get();
        }
        finally {
            ConcurrentHashMap<String, LatchHolder> concurrentHashMap = this.latchesByInstanceId;
            synchronized (concurrentHashMap) {
                this.latchesByInstanceId.remove(instanceId);
            }
        }
        if (result == null) {
            result = NULL;
        }
        if (!holder.isSuccessful()) {
            Object exceptionCause = result.getArgument("___EXCEPTION__OBJECT__", Object.class);
            if (exceptionCause instanceof RuntimeException) {
                throw (RuntimeException)exceptionCause;
            }
            if (exceptionCause instanceof Exception) {
                throw (Exception)exceptionCause;
            }
            throw new RuntimeCILExecutionException(exceptionCause);
        }
        return result;
    }

    private static class LatchHolder {
        private Latch latch;
        private boolean successful;
        private long whenCreated;
        private static final long EXPIRATION_TIME = 300000L;

        private LatchHolder(Latch latch) {
            this(latch, true);
        }

        private LatchHolder(Latch latch, boolean succesfull) {
            this.latch = latch;
            this.successful = succesfull;
            this.whenCreated = System.currentTimeMillis();
        }

        public Latch getLatch() {
            return this.latch;
        }

        public void setSuccessful(boolean successful) {
            this.successful = successful;
        }

        public boolean isSuccessful() {
            return this.successful;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.getWhenCreated() > 300000L;
        }

        private long getWhenCreated() {
            return this.whenCreated;
        }
    }
}

