/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.components;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.component.metadata.Hidden;
import oracle.bpm.components.ComponentRuntimeException;
import oracle.bpm.components.ProcessBeanInterface;
import oracle.bpm.components.ProcessInstance;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.resources.Msg;

@Component(module="Fuego.Lib")
public class Notification {
    @Hidden
    public Notification() {
    }

    public void send(String instanceId, String activityName, HashMap parameters) throws ComponentExecutionException {
        DynamicObject dynamicObject = Notification.createDynamicObject(parameters);
        if (activityName == null || activityName.equals("")) {
            throw new Exception(LibMsg.NOTIF_NULL_ACTIVITYNAME);
        }
        ProcessInstance.getCurrent().getBean().sendComponentNotification(instanceId, activityName, "", dynamicObject);
    }

    public void send(String processId, String activityName, HashMap arguments, String argumentSetName) throws ComponentExecutionException {
        ProcessBeanInterface bean = ProcessInstance.getCurrent().getBean();
        if (processId == null) {
            processId = bean.getProcessId();
        }
        DynamicObject argumentMap = Notification.createDynamicObject(arguments);
        bean.sendComponentNotification(processId, activityName, null, argumentSetName, argumentMap);
    }

    public void send(String instanceId, String activityName, String argumentSetName, HashMap parameters) throws ComponentExecutionException {
        DynamicObject dynamicObject = Notification.createDynamicObject(parameters);
        if (instanceId == null || instanceId.equals("")) {
            throw new Exception(LibMsg.NOTIF_NULL_INSTANCEDN);
        }
        if (activityName == null || activityName.equals("")) {
            throw new Exception(LibMsg.NOTIF_NULL_ACTIVITYNAME);
        }
        ProcessInstance.getCurrent().getBean().sendComponentNotification(instanceId, activityName, "", argumentSetName, dynamicObject);
    }

    public void send(int instance, int thread, String activityName, HashMap parameters) throws ComponentExecutionException {
        DynamicObject dynamicObject = Notification.createDynamicObject(parameters);
        if (activityName == null || activityName.equals("")) {
            throw new Exception(LibMsg.NOTIF_NULL_ACTIVITYNAME);
        }
        ProcessInstance.getCurrent().getBean().sendComponentNotification(instance, thread, activityName, "", dynamicObject);
    }

    public void send(int instance, int thread, String activityName, String argumentSetName, HashMap parameters) throws ComponentExecutionException {
        DynamicObject dynamicObject = Notification.createDynamicObject(parameters);
        if (activityName == null || activityName.equals("")) {
            throw new Exception(LibMsg.NOTIF_NULL_ACTIVITYNAME);
        }
        ProcessInstance.getCurrent().getBean().sendComponentNotification(instance, thread, activityName, "", argumentSetName, dynamicObject);
    }

    private static DynamicObject createDynamicObject(HashMap parameters) {
        DynamicObject dyO = DynamicObject.create();
        if (parameters != null) {
            for (Map.Entry mE : parameters.entrySet()) {
                String nameField = (String)mE.getKey();
                dyO.setField(nameField, mE.getValue());
            }
        }
        return dyO;
    }

    @Exclude
    public static class Exception
    extends ComponentRuntimeException {
        static final long serialVersionUID = 6674097731273744744L;
        static final long serialCheck = -8813485457126420631L;

        public Exception(Msg msg) {
            super(msg);
        }

        public Exception(Msg msgKey, Throwable initCause) {
            super(msgKey, initCause);
        }
    }
}

